/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stats;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.InterceptorConfiguration;
import org.infinispan.configuration.cache.VersioningScheme;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.inboundhandler.PerCacheInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.Reply;
import org.infinispan.remoting.transport.Address;
import org.infinispan.stats.wrappers.ExtendedStatisticInterceptor;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.TransactionProtocol;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="stats.BaseClusteredExtendedStatisticTest")
public abstract class BaseClusteredExtendedStatisticTest
extends MultipleCacheManagersTest {
    protected static final int NUM_NODES = 2;
    private static final String KEY_1 = "key_1";
    private static final String KEY_2 = "key_2";
    private static final String KEY_3 = "key_3";
    private static final String VALUE_1 = "value_1";
    private static final String VALUE_2 = "value_2";
    private static final String VALUE_3 = "value_3";
    private static final String VALUE_4 = "value_4";
    protected final List<ControlledPerCacheInboundInvocationHandler> inboundHandlerList = new ArrayList<ControlledPerCacheInboundInvocationHandler>(2);
    private final CacheMode mode;
    private final boolean sync2ndPhase;
    private final boolean writeSkew;
    private final boolean totalOrder;

    protected BaseClusteredExtendedStatisticTest(CacheMode mode, boolean sync2ndPhase, boolean writeSkew, boolean totalOrder) {
        this.mode = mode;
        this.sync2ndPhase = sync2ndPhase;
        this.writeSkew = writeSkew;
        this.totalOrder = totalOrder;
    }

    protected static Collection<Address> getOwners(Cache<?, ?> cache, Object key) {
        return new ArrayList<Address>(cache.getAdvancedCache().getDistributionManager().locate(key));
    }

    protected static Collection<Address> getOwners(Cache<?, ?> cache, Collection<Object> keys) {
        return new ArrayList<Address>(cache.getAdvancedCache().getDistributionManager().locateAll(keys));
    }

    public void testPut() throws InterruptedException {
        this.assertEmpty(KEY_1, KEY_2, KEY_3);
        this.put(0, KEY_1, VALUE_1);
        this.assertCacheValue(KEY_1, VALUE_1);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(KEY_2, VALUE_2);
        map.put(KEY_3, VALUE_3);
        this.cache(0).putAll(map);
        this.awaitPutMap(0, map.keySet());
        this.assertCacheValue(KEY_1, VALUE_1);
        this.assertCacheValue(KEY_2, VALUE_2);
        this.assertCacheValue(KEY_3, VALUE_3);
        this.assertNoTransactions();
        this.assertNoTxStats();
    }

    public void testRemove() throws InterruptedException {
        this.assertEmpty(KEY_1);
        this.put(1, KEY_1, VALUE_1);
        this.assertCacheValue(KEY_1, VALUE_1);
        this.remove(0, KEY_1);
        this.assertCacheValue(KEY_1, null);
        this.put(0, KEY_1, VALUE_1);
        this.assertCacheValue(KEY_1, VALUE_1);
        this.remove(0, KEY_1);
        this.assertCacheValue(KEY_1, null);
        this.assertNoTransactions();
        this.assertNoTxStats();
    }

    public void testPutIfAbsent() throws InterruptedException {
        this.assertEmpty(KEY_1, KEY_2);
        this.put(1, KEY_1, VALUE_1);
        this.assertCacheValue(KEY_1, VALUE_1);
        this.cache(0).putIfAbsent((Object)KEY_1, (Object)VALUE_2);
        this.assertCacheValue(KEY_1, VALUE_1);
        this.put(1, KEY_1, VALUE_3);
        this.assertCacheValue(KEY_1, VALUE_3);
        this.cache(0).putIfAbsent((Object)KEY_1, (Object)VALUE_4);
        this.assertCacheValue(KEY_1, VALUE_3);
        this.putIfAbsent(0, KEY_2, VALUE_1);
        this.assertCacheValue(KEY_2, VALUE_1);
        this.assertNoTransactions();
        this.assertNoTxStats();
    }

    public void testRemoveIfPresent() throws InterruptedException {
        this.assertEmpty(KEY_1);
        this.put(0, KEY_1, VALUE_1);
        this.assertCacheValue(KEY_1, VALUE_1);
        this.put(1, KEY_1, VALUE_2);
        this.assertCacheValue(KEY_1, VALUE_2);
        this.cache(0).remove((Object)KEY_1, (Object)VALUE_1);
        this.assertCacheValue(KEY_1, VALUE_2);
        this.remove(0, KEY_1, VALUE_2);
        this.assertCacheValue(KEY_1, null);
        this.assertNoTransactions();
        this.assertNoTxStats();
    }

    public void testClear() throws InterruptedException {
        this.assertEmpty(KEY_1);
        this.put(0, KEY_1, VALUE_1);
        this.assertCacheValue(KEY_1, VALUE_1);
        this.cache(0).clear();
        this.awaitClear(0);
        this.assertCacheValue(KEY_1, null);
        this.assertNoTransactions();
        this.assertNoTxStats();
    }

    public void testReplace() throws InterruptedException {
        this.assertEmpty(KEY_1);
        this.put(1, KEY_1, VALUE_1);
        this.assertCacheValue(KEY_1, VALUE_1);
        Assert.assertEquals((Object)this.replace(0, KEY_1, VALUE_2), (Object)VALUE_1);
        this.assertCacheValue(KEY_1, VALUE_2);
        this.put(0, KEY_1, VALUE_3);
        this.assertCacheValue(KEY_1, VALUE_3);
        this.replace(0, KEY_1, VALUE_3);
        this.assertCacheValue(KEY_1, VALUE_3);
        this.put(0, KEY_1, VALUE_4);
        this.assertCacheValue(KEY_1, VALUE_4);
        this.assertNoTransactions();
        this.assertNoTxStats();
    }

    public void testReplaceWithOldVal() throws InterruptedException {
        this.assertEmpty(KEY_1);
        this.put(1, KEY_1, VALUE_1);
        this.assertCacheValue(KEY_1, VALUE_1);
        this.put(0, KEY_1, VALUE_2);
        this.assertCacheValue(KEY_1, VALUE_2);
        this.cache(0).replace((Object)KEY_1, (Object)VALUE_3, (Object)VALUE_4);
        this.assertCacheValue(KEY_1, VALUE_2);
        this.replace(0, KEY_1, VALUE_2, VALUE_4);
        this.assertCacheValue(KEY_1, VALUE_4);
        this.assertNoTransactions();
        this.assertNoTxStats();
    }

    public void testRemoveUnexistingEntry() throws InterruptedException {
        this.assertEmpty(KEY_1);
        this.remove(0, KEY_1);
        this.assertCacheValue(KEY_1, null);
        this.assertNoTransactions();
        this.assertNoTxStats();
    }

    @BeforeMethod(alwaysRun=true)
    public void resetInboundHandler() {
        for (ControlledPerCacheInboundInvocationHandler handler : this.inboundHandlerList) {
            handler.reset();
        }
    }

    protected void createCacheManagers() throws Throwable {
        for (int i = 0; i < 2; ++i) {
            ConfigurationBuilder builder = BaseClusteredExtendedStatisticTest.getDefaultClusteredCacheConfig((CacheMode)this.mode, (boolean)true);
            builder.transaction().syncCommitPhase(this.sync2ndPhase).syncRollbackPhase(this.sync2ndPhase);
            if (this.totalOrder) {
                builder.transaction().transactionProtocol(TransactionProtocol.TOTAL_ORDER);
            }
            builder.locking().isolationLevel(IsolationLevel.REPEATABLE_READ).writeSkewCheck(this.writeSkew);
            builder.clustering().hash().numOwners(1);
            if (this.writeSkew) {
                builder.versioning().enable().scheme(VersioningScheme.SIMPLE);
            }
            builder.transaction().recovery().disable();
            builder.customInterceptors().addInterceptor().interceptor((CommandInterceptor)new ExtendedStatisticInterceptor()).position(InterceptorConfiguration.Position.FIRST);
            this.addClusterEnabledCacheManager(builder);
        }
        this.waitForClusterToForm();
        this.replaceAllPerCacheInboundInvocationHandler();
    }

    protected void assertEmpty(Object ... keys) {
        for (Cache cache : this.caches()) {
            for (Object key : keys) {
                Assert.assertNull((Object)cache.get(key));
            }
        }
    }

    protected void assertCacheValue(Object key, Object value) {
        for (int index = 0; index < this.caches().size(); ++index) {
            if (this.mode.isSynchronous() && this.sync2ndPhase) {
                this.assertEquals(index, key, value);
                continue;
            }
            this.assertEventuallyEquals(index, key, value);
        }
    }

    protected abstract void awaitPut(int var1, Object var2) throws InterruptedException;

    protected abstract void awaitReplace(int var1, Object var2) throws InterruptedException;

    protected abstract void awaitRemove(int var1, Object var2) throws InterruptedException;

    protected abstract void awaitClear(int var1) throws InterruptedException;

    protected abstract void awaitPutMap(int var1, Collection<Object> var2) throws InterruptedException;

    protected final void awaitOperation(Operation operation, Collection<Address> owners) throws InterruptedException {
        for (int i = 0; i < 2; ++i) {
            if (!owners.contains(this.cache(i).getAdvancedCache().getRpcManager().getAddress())) continue;
            this.inboundHandlerList.get(i).await(operation, 30L, TimeUnit.SECONDS);
        }
    }

    private void put(int cacheIndex, Object key, Object value) throws InterruptedException {
        this.cache(cacheIndex).put(key, value);
        this.awaitPut(cacheIndex, key);
    }

    private void putIfAbsent(int cacheIndex, Object key, Object value) throws InterruptedException {
        this.cache(cacheIndex).putIfAbsent(key, value);
        this.awaitPut(cacheIndex, key);
    }

    private Object replace(int cacheIndex, Object key, Object value) throws InterruptedException {
        Object val = this.cache(cacheIndex).replace(key, value);
        this.awaitReplace(cacheIndex, key);
        return val;
    }

    private Object replace(int cacheIndex, Object key, Object oldValue, Object newValue) throws InterruptedException {
        Boolean val = this.cache(cacheIndex).replace(key, oldValue, newValue);
        this.awaitReplace(cacheIndex, key);
        return val;
    }

    private void remove(int cacheIndex, Object key) throws InterruptedException {
        this.cache(cacheIndex).remove(key);
        this.awaitRemove(cacheIndex, key);
    }

    private void remove(int cacheIndex, Object key, Object oldValue) throws InterruptedException {
        this.cache(cacheIndex).remove(key, oldValue);
        this.awaitRemove(cacheIndex, key);
    }

    private void assertNoTxStats() {
        final ExtendedStatisticInterceptor[] statisticInterceptors = new ExtendedStatisticInterceptor[this.caches().size()];
        for (int i = 0; i < this.caches().size(); ++i) {
            statisticInterceptors[i] = this.getExtendedStatistic(this.cache(i));
        }
        this.eventually(new AbstractInfinispanTest.Condition(){

            public boolean isSatisfied() throws Exception {
                for (ExtendedStatisticInterceptor interceptor : statisticInterceptors) {
                    if (!interceptor.getCacheStatisticManager().hasPendingTransactions()) continue;
                    return false;
                }
                return true;
            }
        });
    }

    private void assertEquals(int index, Object key, Object value) {
        Assert.assertEquals((Object)this.cache(index).get(key), (Object)value);
    }

    private ExtendedStatisticInterceptor getExtendedStatistic(Cache<?, ?> cache) {
        for (CommandInterceptor commandInterceptor : cache.getAdvancedCache().getInterceptorChain()) {
            if (!(commandInterceptor instanceof ExtendedStatisticInterceptor)) continue;
            ((ExtendedStatisticInterceptor)commandInterceptor).resetStatistics();
            return (ExtendedStatisticInterceptor)commandInterceptor;
        }
        return null;
    }

    private void replaceAllPerCacheInboundInvocationHandler() {
        for (Cache cache : this.caches()) {
            this.inboundHandlerList.add(this.replacePerCacheInboundInvocationHandler(cache));
        }
    }

    private ControlledPerCacheInboundInvocationHandler replacePerCacheInboundInvocationHandler(Cache<?, ?> cache) {
        ControlledPerCacheInboundInvocationHandler handler = new ControlledPerCacheInboundInvocationHandler((PerCacheInboundInvocationHandler)TestingUtil.extractComponent(cache, PerCacheInboundInvocationHandler.class));
        TestingUtil.replaceComponent(cache, PerCacheInboundInvocationHandler.class, (Object)handler, (boolean)true);
        TestingUtil.replaceField((Object)handler, (String)"inboundInvocationHandler", (Object)cache.getAdvancedCache().getComponentRegistry(), ComponentRegistry.class);
        return handler;
    }

    protected static class ControlledPerCacheInboundInvocationHandler
    implements PerCacheInboundInvocationHandler {
        private final PerCacheInboundInvocationHandler delegate;
        private final Queue<Operation> operationQueue = new LinkedList<Operation>();

        public ControlledPerCacheInboundInvocationHandler(PerCacheInboundInvocationHandler delegate) {
            this.delegate = delegate;
        }

        public void handle(CacheRpcCommand command, Reply reply, DeliverOrder order) {
            this.checkCommand((ReplicableCommand)command);
            this.delegate.handle(command, reply, order);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            Queue<Operation> queue = this.operationQueue;
            synchronized (queue) {
                this.operationQueue.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void await(Operation operation, long timeout, TimeUnit timeUnit) throws InterruptedException {
            long timeoutNanos = System.nanoTime() + timeUnit.toNanos(timeout);
            Queue<Operation> queue = this.operationQueue;
            synchronized (queue) {
                while (this.operationQueue.peek() != operation && System.nanoTime() - timeoutNanos < 0L) {
                    this.operationQueue.wait(timeUnit.toMillis(timeout));
                }
                AssertJUnit.assertEquals((Object)((Object)operation), (Object)((Object)this.operationQueue.remove()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkCommand(ReplicableCommand cacheRpcCommand) {
            Queue<Operation> queue = this.operationQueue;
            synchronized (queue) {
                switch (cacheRpcCommand.getCommandId()) {
                    case 8: {
                        this.operationQueue.add(Operation.PUT);
                        break;
                    }
                    case 11: {
                        this.operationQueue.add(Operation.REPLACE);
                        break;
                    }
                    case 10: {
                        this.operationQueue.add(Operation.REMOVE);
                        break;
                    }
                    case 5: {
                        this.operationQueue.add(Operation.CLEAR);
                        break;
                    }
                    case 9: {
                        this.operationQueue.add(Operation.PUT_MAP);
                        break;
                    }
                    case 12: 
                    case 26: 
                    case 38: 
                    case 39: {
                        for (WriteCommand command : ((PrepareCommand)cacheRpcCommand).getModifications()) {
                            this.checkCommand((ReplicableCommand)command);
                        }
                        break;
                    }
                    case 1: {
                        this.checkCommand(((SingleRpcCommand)cacheRpcCommand).getCommand());
                    }
                }
                this.operationQueue.notifyAll();
            }
        }
    }

    protected static enum Operation {
        PUT,
        REMOVE,
        REPLACE,
        CLEAR,
        PUT_MAP;

    }
}

