/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stats.wrappers;

import java.util.Collection;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.stats.topK.StreamSummaryContainer;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.concurrent.locks.LockManager;

public class TopKeyLockManager
implements LockManager {
    private final LockManager current;
    private final StreamSummaryContainer container;

    public TopKeyLockManager(LockManager current, StreamSummaryContainer container) {
        this.current = current;
        this.container = container;
    }

    public boolean lockAndRecord(Object key, InvocationContext ctx, long timeoutMillis) throws InterruptedException {
        boolean isContented = this.isContented(key, ctx.getLockOwner());
        try {
            boolean lockAcquired = this.current.lockAndRecord(key, ctx, timeoutMillis);
            this.container.addLockInformation(key, isContented, !lockAcquired);
            return lockAcquired;
        }
        catch (InterruptedException e) {
            this.container.addLockInformation(key, isContented, true);
            throw e;
        }
        catch (RuntimeException e) {
            this.container.addLockInformation(key, isContented, true);
            throw e;
        }
    }

    public void unlock(Collection<Object> lockedKeys, Object lockOwner) {
        this.current.unlock(lockedKeys, lockOwner);
    }

    public void unlockAll(InvocationContext ctx) {
        this.current.unlockAll(ctx);
    }

    public boolean ownsLock(Object key, Object owner) {
        return this.current.ownsLock(key, owner);
    }

    public boolean isLocked(Object key) {
        return this.current.isLocked(key);
    }

    public Object getOwner(Object key) {
        return this.current.getOwner(key);
    }

    public String printLockInfo() {
        return this.current.printLockInfo();
    }

    public boolean possiblyLocked(CacheEntry entry) {
        return this.current.possiblyLocked(entry);
    }

    public int getNumberOfLocksHeld() {
        return this.current.getNumberOfLocksHeld();
    }

    public int getLockId(Object key) {
        return this.current.getLockId(key);
    }

    public boolean acquireLock(InvocationContext ctx, Object key, long timeoutMillis, boolean skipLocking) throws InterruptedException, TimeoutException {
        boolean isContented = this.isContented(key, ctx.getLockOwner());
        try {
            boolean retVal = this.current.acquireLock(ctx, key, timeoutMillis, skipLocking);
            this.container.addLockInformation(key, isContented, false);
            return retVal;
        }
        catch (InterruptedException e) {
            this.container.addLockInformation(key, isContented, true);
            throw e;
        }
        catch (RuntimeException e) {
            this.container.addLockInformation(key, isContented, true);
            throw e;
        }
    }

    public boolean acquireLockNoCheck(InvocationContext ctx, Object key, long timeoutMillis, boolean skipLocking) throws InterruptedException, TimeoutException {
        boolean isContented = this.isContented(key, ctx.getLockOwner());
        try {
            boolean retVal = this.current.acquireLockNoCheck(ctx, key, timeoutMillis, skipLocking);
            this.container.addLockInformation(key, isContented, false);
            return retVal;
        }
        catch (InterruptedException e) {
            this.container.addLockInformation(key, isContented, true);
            throw e;
        }
        catch (RuntimeException e) {
            this.container.addLockInformation(key, isContented, true);
            throw e;
        }
    }

    private boolean isContented(Object key, Object requestor) {
        Object holder = this.current.getOwner(key);
        return holder != null && !holder.equals(requestor);
    }
}

