/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stats.wrappers;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.remote.recovery.TxCompletionNotificationCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commons.util.concurrent.NotifyingNotifiableFuture;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.rpc.RpcOptionsBuilder;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.stats.CacheStatisticManager;
import org.infinispan.stats.container.ExtendedStatistic;
import org.infinispan.stats.logging.Log;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.TimeService;
import org.infinispan.util.logging.LogFactory;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.util.Buffer;

public class ExtendedStatisticRpcManager
implements RpcManager {
    private static final Log log = (Log)LogFactory.getLog(ExtendedStatisticRpcManager.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    private final RpcManager actual;
    private final CacheStatisticManager cacheStatisticManager;
    private final RpcDispatcher.Marshaller marshaller;
    private final TimeService timeService;

    public ExtendedStatisticRpcManager(RpcManager actual, CacheStatisticManager cacheStatisticManager, TimeService timeService) {
        this.actual = actual;
        this.cacheStatisticManager = cacheStatisticManager;
        Transport t = actual.getTransport();
        this.marshaller = t instanceof JGroupsTransport ? ((JGroupsTransport)t).getCommandAwareRpcDispatcher().getMarshaller() : null;
        this.timeService = timeService;
    }

    public CompletableFuture<Map<Address, Response>> invokeRemotelyAsync(Collection<Address> recipients, ReplicableCommand rpc, RpcOptions options) {
        long start = this.timeService.time();
        CompletableFuture future = this.actual.invokeRemotelyAsync(recipients, rpc, options);
        this.updateStats(rpc, options.responseMode().isSynchronous(), this.timeService.timeDuration(start, TimeUnit.NANOSECONDS), recipients);
        return future;
    }

    public Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpc, RpcOptions options) {
        long start = this.timeService.time();
        Map responseMap = this.actual.invokeRemotely(recipients, rpc, options);
        this.updateStats(rpc, options.responseMode().isSynchronous(), this.timeService.timeDuration(start, TimeUnit.NANOSECONDS), recipients);
        return responseMap;
    }

    public Map<Address, Response> invokeRemotely(Map<Address, ReplicableCommand> rpcs, RpcOptions options) {
        long start = this.timeService.time();
        Map responseMap = this.actual.invokeRemotely(rpcs, options);
        for (Map.Entry<Address, ReplicableCommand> entry : rpcs.entrySet()) {
            this.updateStats(entry.getValue(), options.responseMode().isSynchronous(), this.timeService.timeDuration(start, TimeUnit.NANOSECONDS), Collections.singleton(entry.getKey()));
        }
        return responseMap;
    }

    public void invokeRemotelyInFuture(Collection<Address> recipients, ReplicableCommand rpc, RpcOptions options, NotifyingNotifiableFuture<Object> future) {
        long start = this.timeService.time();
        this.actual.invokeRemotelyInFuture(recipients, rpc, options, future);
        this.updateStats(rpc, options.responseMode().isSynchronous(), this.timeService.timeDuration(start, TimeUnit.NANOSECONDS), recipients);
    }

    public void invokeRemotelyInFuture(NotifyingNotifiableFuture<Map<Address, Response>> future, Collection<Address> recipients, ReplicableCommand rpc, RpcOptions options) {
        long start = this.timeService.time();
        this.actual.invokeRemotelyInFuture(future, recipients, rpc, options);
        this.updateStats(rpc, options.responseMode().isSynchronous(), this.timeService.timeDuration(start, TimeUnit.NANOSECONDS), recipients);
    }

    public RpcOptionsBuilder getRpcOptionsBuilder(ResponseMode responseMode) {
        return this.actual.getRpcOptionsBuilder(responseMode);
    }

    public RpcOptionsBuilder getRpcOptionsBuilder(ResponseMode responseMode, DeliverOrder deliverOrder) {
        return this.actual.getRpcOptionsBuilder(responseMode, deliverOrder);
    }

    public RpcOptions getDefaultRpcOptions(boolean sync) {
        return this.actual.getDefaultRpcOptions(sync);
    }

    public RpcOptions getDefaultRpcOptions(boolean sync, DeliverOrder deliverOrder) {
        return this.actual.getDefaultRpcOptions(sync, deliverOrder);
    }

    public Transport getTransport() {
        return this.actual.getTransport();
    }

    public List<Address> getMembers() {
        return this.actual.getMembers();
    }

    public Address getAddress() {
        return this.actual.getAddress();
    }

    public int getTopologyId() {
        return this.actual.getTopologyId();
    }

    private void updateStats(ReplicableCommand command, boolean sync, long duration, Collection<Address> recipients) {
        GlobalTransaction globalTransaction;
        ExtendedStatistic recipientSizeStat;
        ExtendedStatistic counterStat;
        ExtendedStatistic durationStat;
        ExtendedStatistic commandSizeStat = null;
        if (command instanceof PrepareCommand) {
            durationStat = sync ? ExtendedStatistic.SYNC_PREPARE_TIME : ExtendedStatistic.ASYNC_PREPARE_TIME;
            counterStat = sync ? ExtendedStatistic.NUM_SYNC_PREPARE : ExtendedStatistic.NUM_ASYNC_PREPARE;
            recipientSizeStat = ExtendedStatistic.NUM_NODES_PREPARE;
            commandSizeStat = ExtendedStatistic.PREPARE_COMMAND_SIZE;
            globalTransaction = ((PrepareCommand)command).getGlobalTransaction();
        } else if (command instanceof RollbackCommand) {
            durationStat = sync ? ExtendedStatistic.SYNC_ROLLBACK_TIME : ExtendedStatistic.ASYNC_ROLLBACK_TIME;
            counterStat = sync ? ExtendedStatistic.NUM_SYNC_ROLLBACK : ExtendedStatistic.NUM_ASYNC_ROLLBACK;
            recipientSizeStat = ExtendedStatistic.NUM_NODES_ROLLBACK;
            globalTransaction = ((RollbackCommand)command).getGlobalTransaction();
        } else if (command instanceof CommitCommand) {
            durationStat = sync ? ExtendedStatistic.SYNC_COMMIT_TIME : ExtendedStatistic.ASYNC_COMMIT_TIME;
            counterStat = sync ? ExtendedStatistic.NUM_SYNC_COMMIT : ExtendedStatistic.NUM_ASYNC_COMMIT;
            recipientSizeStat = ExtendedStatistic.NUM_NODES_COMMIT;
            commandSizeStat = ExtendedStatistic.COMMIT_COMMAND_SIZE;
            globalTransaction = ((CommitCommand)command).getGlobalTransaction();
        } else if (command instanceof TxCompletionNotificationCommand) {
            durationStat = ExtendedStatistic.ASYNC_COMPLETE_NOTIFY_TIME;
            counterStat = ExtendedStatistic.NUM_ASYNC_COMPLETE_NOTIFY;
            recipientSizeStat = ExtendedStatistic.NUM_NODES_COMPLETE_NOTIFY;
            globalTransaction = ((TxCompletionNotificationCommand)command).getGlobalTransaction();
        } else if (command instanceof ClusteredGetCommand && !((ClusteredGetCommand)command).isWrite()) {
            durationStat = ExtendedStatistic.SYNC_GET_TIME;
            counterStat = ExtendedStatistic.NUM_SYNC_GET;
            recipientSizeStat = ExtendedStatistic.NUM_NODES_GET;
            commandSizeStat = ExtendedStatistic.CLUSTERED_GET_COMMAND_SIZE;
            globalTransaction = ((ClusteredGetCommand)command).getGlobalTransaction();
        } else {
            if (trace) {
                log.tracef("Does not update stats for command %s. The command is not needed", command);
            }
            return;
        }
        if (trace) {
            log.tracef("Update stats for command %s. Is sync? %s. Duration stat is %s, counter stats is %s, recipient size stat is %s", new Object[]{command, sync, durationStat, counterStat, recipientSizeStat});
        }
        this.cacheStatisticManager.add(durationStat, duration, globalTransaction, true);
        this.cacheStatisticManager.increment(counterStat, globalTransaction, true);
        this.cacheStatisticManager.add(recipientSizeStat, this.recipientListSize(recipients), globalTransaction, true);
        if (commandSizeStat != null) {
            this.cacheStatisticManager.add(commandSizeStat, this.getCommandSize(command), globalTransaction, true);
        }
    }

    private int recipientListSize(Collection<Address> recipients) {
        return recipients == null ? this.actual.getTransport().getMembers().size() : recipients.size();
    }

    private int getCommandSize(ReplicableCommand command) {
        try {
            Buffer buffer = this.marshaller.objectToBuffer((Object)command);
            return buffer != null ? buffer.getLength() : 0;
        }
        catch (Exception e) {
            return 0;
        }
    }
}

