/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stats;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.infinispan.Cache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.VersioningScheme;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.TxInterceptor;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.stats.topK.CacheUsageInterceptor;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="stats.BaseClusterTopKeyTest")
public abstract class BaseClusterTopKeyTest
extends MultipleCacheManagersTest {
    protected final CacheMode cacheMode;
    private final int clusterSize;
    private final AtomicInteger threadCounter = new AtomicInteger(0);

    protected BaseClusterTopKeyTest(CacheMode cacheMode, int clusterSize) {
        this.cacheMode = cacheMode;
        this.clusterSize = clusterSize;
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    public void testPut() {
        this.resetStreamSummary(this.cache(0));
        this.resetStreamSummary(this.cache(1));
        this.cache(0).put((Object)"key1", (Object)"value1");
        this.cache(0).put((Object)"key2", (Object)"value2");
        this.cache(1).put((Object)"key1", (Object)"value3");
        this.cache(1).put((Object)"key2", (Object)"value4");
        this.assertTopKeyAccesses(this.cache(0), "key1", 1L, false);
        this.assertTopKeyAccesses(this.cache(0), "key2", 1L, false);
        this.assertTopKeyAccesses(this.cache(0), "key1", 0L, true);
        this.assertTopKeyAccesses(this.cache(0), "key2", 0L, true);
        this.assertTopKeyAccesses(this.cache(1), "key1", 1L, false);
        this.assertTopKeyAccesses(this.cache(1), "key2", 1L, false);
        this.assertTopKeyAccesses(this.cache(1), "key1", 0L, true);
        this.assertTopKeyAccesses(this.cache(1), "key2", 0L, true);
        if (this.isPrimaryOwner(this.cache(0), "key1")) {
            this.assertLockInformation(this.cache(0), "key1", 2L, 0L, 0L);
            this.assertLockInformation(this.cache(1), "key1", 0L, 0L, 0L);
        } else {
            this.assertLockInformation(this.cache(0), "key1", 0L, 0L, 0L);
            this.assertLockInformation(this.cache(1), "key1", 2L, 0L, 0L);
        }
        if (this.isPrimaryOwner(this.cache(0), "key2")) {
            this.assertLockInformation(this.cache(0), "key2", 2L, 0L, 0L);
            this.assertLockInformation(this.cache(1), "key2", 0L, 0L, 0L);
        } else {
            this.assertLockInformation(this.cache(0), "key2", 0L, 0L, 0L);
            this.assertLockInformation(this.cache(1), "key2", 2L, 0L, 0L);
        }
        this.assertWriteSkew(this.cache(0), "key1", 0L);
        this.assertWriteSkew(this.cache(0), "key2", 0L);
        this.assertWriteSkew(this.cache(1), "key1", 0L);
        this.assertWriteSkew(this.cache(1), "key2", 0L);
    }

    public void testGet() {
        this.resetStreamSummary(this.cache(0));
        this.resetStreamSummary(this.cache(1));
        this.cache(0).get((Object)"key1");
        this.cache(0).get((Object)"key2");
        this.cache(1).get((Object)"key1");
        this.cache(1).get((Object)"key2");
        this.assertTopKeyAccesses(this.cache(0), "key1", 0L, false);
        this.assertTopKeyAccesses(this.cache(0), "key2", 0L, false);
        this.assertTopKeyAccesses(this.cache(0), "key1", 1L, true);
        this.assertTopKeyAccesses(this.cache(0), "key2", 1L, true);
        this.assertTopKeyAccesses(this.cache(1), "key1", 0L, false);
        this.assertTopKeyAccesses(this.cache(1), "key2", 0L, false);
        this.assertTopKeyAccesses(this.cache(1), "key1", 1L, true);
        this.assertTopKeyAccesses(this.cache(1), "key2", 1L, true);
        this.assertLockInformation(this.cache(0), "key1", 0L, 0L, 0L);
        this.assertLockInformation(this.cache(0), "key2", 0L, 0L, 0L);
        this.assertLockInformation(this.cache(1), "key1", 0L, 0L, 0L);
        this.assertLockInformation(this.cache(1), "key2", 0L, 0L, 0L);
        this.assertWriteSkew(this.cache(0), "key1", 0L);
        this.assertWriteSkew(this.cache(0), "key2", 0L);
        this.assertWriteSkew(this.cache(1), "key1", 0L);
        this.assertWriteSkew(this.cache(1), "key2", 0L);
    }

    public void testLockFailed() throws InterruptedException {
        Cache nonPrimary;
        Cache primary;
        this.resetStreamSummary(this.cache(0));
        this.resetStreamSummary(this.cache(1));
        if (this.isPrimaryOwner(this.cache(0), "key")) {
            primary = this.cache(0);
            nonPrimary = this.cache(1);
        } else {
            primary = this.cache(1);
            nonPrimary = this.cache(0);
        }
        PrepareCommandBlocker blocker = this.addPrepareBlockerIfAbsent(primary);
        blocker.reset();
        ThrowableAwareThread thread = this.putInOtherThread((Cache<Object, Object>)nonPrimary, "key", "value");
        blocker.awaitUntilPrepareBlocked();
        try {
            primary.put((Object)"key", (Object)"value");
            Assert.fail((String)"The key should be locked!");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        blocker.unblock();
        thread.join();
        Assert.assertNull((Object)thread.throwable);
        this.assertTopKeyAccesses(this.cache(0), "key", 1L, false);
        this.assertTopKeyAccesses(this.cache(0), "key", 0L, true);
        this.assertTopKeyAccesses(this.cache(1), "key", 1L, false);
        this.assertTopKeyAccesses(this.cache(1), "key", 0L, true);
        this.assertLockInformation(primary, "key", 2L, 1L, 1L);
        this.assertLockInformation(nonPrimary, "key", 0L, 0L, 0L);
        this.assertWriteSkew(this.cache(0), "key", 0L);
        this.assertWriteSkew(this.cache(1), "key", 0L);
    }

    public void testWriteSkew() throws InterruptedException, SystemException, NotSupportedException {
        Cache nonPrimary;
        Cache primary;
        this.resetStreamSummary(this.cache(0));
        this.resetStreamSummary(this.cache(1));
        if (this.isPrimaryOwner(this.cache(0), "key")) {
            primary = this.cache(0);
            nonPrimary = this.cache(1);
        } else {
            primary = this.cache(1);
            nonPrimary = this.cache(0);
        }
        this.tm(primary).begin();
        primary.put((Object)"key", (Object)"value");
        Transaction transaction = this.tm(primary).suspend();
        primary.put((Object)"key", (Object)"value");
        try {
            this.tm(primary).resume(transaction);
            this.tm(primary).commit();
            Assert.fail((String)"The write skew should be detected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertTopKeyAccesses(primary, "key", 2L, false);
        this.assertTopKeyAccesses(primary, "key", 0L, true);
        this.assertTopKeyAccesses(nonPrimary, "key", 0L, false);
        this.assertTopKeyAccesses(nonPrimary, "key", 0L, true);
        this.assertLockInformation(primary, "key", 2L, 0L, 0L);
        this.assertLockInformation(nonPrimary, "key", 0L, 0L, 0L);
        this.assertWriteSkew(primary, "key", 1L);
        this.assertWriteSkew(nonPrimary, "key", 0L);
    }

    protected void createCacheManagers() throws Throwable {
        for (int i = 0; i < this.clusterSize; ++i) {
            ConfigurationBuilder builder = BaseClusterTopKeyTest.getDefaultClusteredCacheConfig((CacheMode)this.cacheMode, (boolean)true);
            builder.customInterceptors().addInterceptor().before(TxInterceptor.class).interceptor((CommandInterceptor)new CacheUsageInterceptor());
            builder.versioning().enabled(true).scheme(VersioningScheme.SIMPLE);
            builder.transaction().syncCommitPhase(true).syncRollbackPhase(true);
            builder.locking().isolationLevel(IsolationLevel.REPEATABLE_READ).writeSkewCheck(true).lockAcquisitionTimeout(100L);
            this.addClusterEnabledCacheManager(builder);
        }
        this.waitForClusterToForm();
    }

    protected abstract boolean isOwner(Cache<?, ?> var1, Object var2);

    protected abstract boolean isPrimaryOwner(Cache<?, ?> var1, Object var2);

    private ThrowableAwareThread putInOtherThread(final Cache<Object, Object> cache, final Object key, final Object value) {
        ThrowableAwareThread thread = new ThrowableAwareThread(){

            @Override
            protected final void innerRun() throws Throwable {
                cache.put(key, value);
            }
        };
        thread.start();
        return thread;
    }

    private CacheUsageInterceptor getTopKey(Cache<?, ?> cache) {
        for (CommandInterceptor interceptor : cache.getAdvancedCache().getInterceptorChain()) {
            if (!(interceptor instanceof CacheUsageInterceptor)) continue;
            return (CacheUsageInterceptor)interceptor;
        }
        return null;
    }

    private void resetStreamSummary(Cache<?, ?> cache) {
        CacheUsageInterceptor summaryInterceptor = this.getTopKey(cache);
        Assert.assertNotNull((Object)summaryInterceptor);
        summaryInterceptor.resetStatistics();
    }

    private void assertTopKeyAccesses(Cache<?, ?> cache, Object key, long expected, boolean readAccesses) {
        CacheUsageInterceptor summaryInterceptor = this.getTopKey(cache);
        boolean isLocal = this.isOwner(cache, key);
        Long actual = readAccesses ? (isLocal ? (Long)summaryInterceptor.getLocalTopGets().get(String.valueOf(key)) : (Long)summaryInterceptor.getRemoteTopGets().get(String.valueOf(key))) : (isLocal ? (Long)summaryInterceptor.getLocalTopPuts().get(String.valueOf(key)) : (Long)summaryInterceptor.getRemoteTopPuts().get(String.valueOf(key)));
        Assert.assertEquals((long)(actual == null ? 0L : actual), (long)expected, (String)"Wrong number of accesses");
    }

    private void assertWriteSkew(Cache<?, ?> cache, Object key, long expected) {
        CacheUsageInterceptor summaryInterceptor = this.getTopKey(cache);
        Long actual = (Long)summaryInterceptor.getTopWriteSkewFailedKeys().get(String.valueOf(key));
        Assert.assertEquals((long)(actual == null ? 0L : actual), (long)expected, (String)"Wrong number of write skew");
    }

    private void assertTopKeyLocked(Cache<?, ?> cache, Object key, long expected) {
        CacheUsageInterceptor summaryInterceptor = this.getTopKey(cache);
        Long actual = (Long)summaryInterceptor.getTopLockedKeys().get(String.valueOf(key));
        Assert.assertEquals((long)(actual == null ? 0L : actual), (long)expected, (String)"Wrong number of locked keys");
    }

    private void assertTopKeyLockContented(Cache<?, ?> cache, Object key, long expected) {
        CacheUsageInterceptor summaryInterceptor = this.getTopKey(cache);
        Long actual = (Long)summaryInterceptor.getTopContendedKeys().get(String.valueOf(key));
        Assert.assertEquals((long)(actual == null ? 0L : actual), (long)expected, (String)"Wrong number of contented keys");
    }

    private void assertTopKeyLockFailed(Cache<?, ?> cache, Object key, long expected) {
        CacheUsageInterceptor summaryInterceptor = this.getTopKey(cache);
        Long actual = (Long)summaryInterceptor.getTopLockFailedKeys().get(String.valueOf(key));
        Assert.assertEquals((long)(actual == null ? 0L : actual), (long)expected, (String)"Wrong number of lock failed keys");
    }

    private void assertLockInformation(Cache<?, ?> cache, Object key, long locked, long contented, long failed) {
        this.assertTopKeyLocked(cache, key, locked);
        this.assertTopKeyLockContented(cache, key, contented);
        this.assertTopKeyLockFailed(cache, key, failed);
    }

    private PrepareCommandBlocker addPrepareBlockerIfAbsent(Cache<?, ?> cache) {
        List chain = cache.getAdvancedCache().getInterceptorChain();
        for (CommandInterceptor commandInterceptor : chain) {
            if (!(commandInterceptor instanceof PrepareCommandBlocker)) continue;
            return (PrepareCommandBlocker)commandInterceptor;
        }
        PrepareCommandBlocker blocker = new PrepareCommandBlocker();
        cache.getAdvancedCache().addInterceptorBefore((CommandInterceptor)blocker, TxInterceptor.class);
        return blocker;
    }

    private abstract class ThrowableAwareThread
    extends Thread {
        private Throwable throwable;

        protected ThrowableAwareThread() {
            super("thread-" + BaseClusterTopKeyTest.this.threadCounter.getAndIncrement() + "-" + BaseClusterTopKeyTest.this.cacheMode);
        }

        @Override
        public final void run() {
            try {
                this.innerRun();
            }
            catch (Throwable throwable) {
                this.throwable = throwable;
            }
        }

        protected abstract void innerRun() throws Throwable;
    }

    private class PrepareCommandBlocker
    extends CommandInterceptor {
        private boolean unblock = false;
        private boolean prepareBlocked = false;

        private PrepareCommandBlocker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
            Object retVal = this.invokeNextInterceptor((InvocationContext)ctx, (VisitableCommand)command);
            PrepareCommandBlocker prepareCommandBlocker = this;
            synchronized (prepareCommandBlocker) {
                this.prepareBlocked = true;
                ((Object)((Object)this)).notifyAll();
                while (!this.unblock) {
                    ((Object)((Object)this)).wait();
                }
            }
            return retVal;
        }

        public final synchronized void reset() {
            this.unblock = false;
            this.prepareBlocked = false;
        }

        public final synchronized void unblock() {
            this.unblock = true;
            ((Object)((Object)this)).notifyAll();
        }

        public final synchronized void awaitUntilPrepareBlocked() throws InterruptedException {
            while (!this.prepareBlocked) {
                ((Object)((Object)this)).wait();
            }
        }
    }
}

