/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stats.wrappers;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.tx.TransactionBoundaryCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.base.BaseCustomInterceptor;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.jmx.annotations.Parameter;
import org.infinispan.remoting.RemoteException;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.stats.CacheStatisticManager;
import org.infinispan.stats.ExtendedStatisticNotFoundException;
import org.infinispan.stats.container.ExtendedStatistic;
import org.infinispan.stats.logging.Log;
import org.infinispan.stats.percentiles.PercentileStatistic;
import org.infinispan.stats.wrappers.ExtendedStatisticLockManager;
import org.infinispan.stats.wrappers.ExtendedStatisticRpcManager;
import org.infinispan.transaction.WriteSkewException;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.TimeService;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.concurrent.locks.DeadlockDetectedException;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.logging.LogFactory;

@MBean(objectName="ExtendedStatistics", description="Component that manages and exposes extended statistics relevant to transactions.")
public class ExtendedStatisticInterceptor
extends BaseCustomInterceptor {
    private static final Log log = (Log)LogFactory.getLog(ExtendedStatisticInterceptor.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    private TransactionTable transactionTable;
    private RpcManager rpcManager;
    private DistributionManager distributionManager;
    private CacheStatisticManager cacheStatisticManager;
    private TimeService timeService;

    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.visitWriteCommand(ctx, (WriteCommand)command, command.getKey());
    }

    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.visitWriteCommand(ctx, (WriteCommand)command, command.getKey());
    }

    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.visitWriteCommand(ctx, (WriteCommand)command, command.getKey());
    }

    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        Object retVal;
        if (trace) {
            log.tracef("Visit Get Key Value command %s. Is it in transaction scope? %s. Is it local? %s", command, ctx.isInTxScope(), ctx.isOriginLocal());
        }
        if (ctx.isInTxScope()) {
            long start = this.timeService.time();
            retVal = this.invokeNextInterceptor(ctx, (VisitableCommand)command);
            long end = this.timeService.time();
            this.initStatsIfNecessary(ctx);
            if (this.isRemote(command.getKey())) {
                this.cacheStatisticManager.increment(ExtendedStatistic.NUM_REMOTE_GET, this.getGlobalTransaction(ctx), ctx.isOriginLocal());
                this.cacheStatisticManager.add(ExtendedStatistic.REMOTE_GET_EXECUTION, this.timeService.timeDuration(start, end, TimeUnit.NANOSECONDS), this.getGlobalTransaction(ctx), ctx.isOriginLocal());
            }
            this.cacheStatisticManager.add(ExtendedStatistic.ALL_GET_EXECUTION, this.timeService.timeDuration(start, end, TimeUnit.NANOSECONDS), this.getGlobalTransaction(ctx), ctx.isOriginLocal());
            this.cacheStatisticManager.increment(ExtendedStatistic.NUM_GET, this.getGlobalTransaction(ctx), ctx.isOriginLocal());
        } else {
            retVal = this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        }
        return retVal;
    }

    public Object visitGetAllCommand(InvocationContext ctx, GetAllCommand command) throws Throwable {
        Object retVal;
        if (trace) {
            log.tracef("Visit Get All Command %s. Is it in transaction scope? %s. Is it local? %s", command, ctx.isInTxScope(), ctx.isOriginLocal());
        }
        if (ctx.isInTxScope()) {
            long start = this.timeService.time();
            retVal = this.invokeNextInterceptor(ctx, (VisitableCommand)command);
            long end = this.timeService.time();
            this.initStatsIfNecessary(ctx);
            int numRemote = 0;
            for (Object key : command.getKeys()) {
                if (!this.isRemote(key)) continue;
                ++numRemote;
            }
            if (numRemote > 0) {
                this.cacheStatisticManager.add(ExtendedStatistic.NUM_REMOTE_GET, numRemote, this.getGlobalTransaction(ctx), ctx.isOriginLocal());
                this.cacheStatisticManager.add(ExtendedStatistic.REMOTE_GET_EXECUTION, this.timeService.timeDuration(start, end, TimeUnit.NANOSECONDS), this.getGlobalTransaction(ctx), ctx.isOriginLocal());
            }
            this.cacheStatisticManager.add(ExtendedStatistic.ALL_GET_EXECUTION, this.timeService.timeDuration(start, end, TimeUnit.NANOSECONDS), this.getGlobalTransaction(ctx), ctx.isOriginLocal());
            this.cacheStatisticManager.add(ExtendedStatistic.NUM_GET, command.getKeys().size(), this.getGlobalTransaction(ctx), ctx.isOriginLocal());
        } else {
            retVal = this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        }
        return retVal;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        Object object;
        GlobalTransaction globalTransaction = command.getGlobalTransaction();
        if (trace) {
            log.tracef("Visit Prepare command %s. Is it local?. Transaction is %s", command, ctx.isOriginLocal(), globalTransaction.globalId());
        }
        this.initStatsIfNecessary((InvocationContext)ctx);
        this.cacheStatisticManager.onPrepareCommand(globalTransaction, ctx.isOriginLocal());
        if (command.hasModifications()) {
            this.cacheStatisticManager.markAsWriteTransaction(globalTransaction, ctx.isOriginLocal());
        }
        boolean success = false;
        try {
            long start = this.timeService.time();
            Object ret = this.invokeNextInterceptor((InvocationContext)ctx, (VisitableCommand)command);
            long end = this.timeService.time();
            this.updateTime(ExtendedStatistic.PREPARE_EXECUTION_TIME, ExtendedStatistic.NUM_PREPARE_COMMAND, start, end, globalTransaction, ctx.isOriginLocal());
            success = true;
            object = ret;
        }
        catch (TimeoutException e) {
            try {
                if (ctx.isOriginLocal() && this.isLockTimeout(e)) {
                    this.cacheStatisticManager.increment(ExtendedStatistic.NUM_LOCK_FAILED_TIMEOUT, globalTransaction, ctx.isOriginLocal());
                }
                throw e;
                catch (DeadlockDetectedException e2) {
                    if (ctx.isOriginLocal()) {
                        this.cacheStatisticManager.increment(ExtendedStatistic.NUM_LOCK_FAILED_DEADLOCK, globalTransaction, ctx.isOriginLocal());
                    }
                    throw e2;
                }
                catch (WriteSkewException e3) {
                    if (ctx.isOriginLocal()) {
                        this.cacheStatisticManager.increment(ExtendedStatistic.NUM_WRITE_SKEW, globalTransaction, ctx.isOriginLocal());
                    }
                    throw e3;
                }
                catch (RemoteException remote) {
                    if (ctx.isOriginLocal()) {
                        ExtendedStatistic stat = null;
                        for (Throwable cause = remote.getCause(); cause != null; cause = cause.getCause()) {
                            if (cause instanceof TimeoutException) {
                                stat = ExtendedStatistic.NUM_LOCK_FAILED_TIMEOUT;
                                break;
                            }
                            if (cause instanceof DeadlockDetectedException) {
                                stat = ExtendedStatistic.NUM_LOCK_FAILED_DEADLOCK;
                                break;
                            }
                            if (!(cause instanceof WriteSkewException)) continue;
                            stat = ExtendedStatistic.NUM_WRITE_SKEW;
                            break;
                        }
                        if (stat != null) {
                            this.cacheStatisticManager.increment(stat, globalTransaction, true);
                        }
                    }
                    throw remote;
                }
            }
            catch (Throwable throwable) {
                if (command.isOnePhaseCommit()) {
                    boolean local = ctx.isOriginLocal();
                    this.cacheStatisticManager.setTransactionOutcome(success, globalTransaction, ctx.isOriginLocal());
                    this.cacheStatisticManager.terminateTransaction(globalTransaction, local, !local);
                }
                throw throwable;
            }
        }
        if (command.isOnePhaseCommit()) {
            boolean local = ctx.isOriginLocal();
            this.cacheStatisticManager.setTransactionOutcome(success, globalTransaction, ctx.isOriginLocal());
            this.cacheStatisticManager.terminateTransaction(globalTransaction, local, !local);
        }
        return object;
    }

    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        return this.visitSecondPhaseCommand(ctx, (TransactionBoundaryCommand)command, true, ExtendedStatistic.COMMIT_EXECUTION_TIME, ExtendedStatistic.NUM_COMMIT_COMMAND);
    }

    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        return this.visitSecondPhaseCommand(ctx, (TransactionBoundaryCommand)command, false, ExtendedStatistic.ROLLBACK_EXECUTION_TIME, ExtendedStatistic.NUM_ROLLBACK_COMMAND);
    }

    @ManagedAttribute(description="Average Prepare Round-Trip Time duration (in microseconds)", displayName="Average Prepare RTT")
    public double getAvgPrepareRtt() {
        return this.getAttribute(ExtendedStatistic.SYNC_PREPARE_TIME);
    }

    @ManagedAttribute(description="Average Commit Round-Trip Time duration (in microseconds)", displayName="Average Commit RTT")
    public double getAvgCommitRtt() {
        return this.getAttribute(ExtendedStatistic.SYNC_COMMIT_TIME);
    }

    @ManagedAttribute(description="Average Remote Get Round-Trip Time duration (in microseconds)", displayName="Average Remote Get RTT")
    public double getAvgRemoteGetRtt() {
        return this.getAttribute(ExtendedStatistic.SYNC_GET_TIME);
    }

    @ManagedAttribute(description="Average Rollback Round-Trip Time duration (in microseconds)", displayName="Average Rollback RTT")
    public double getAvgRollbackRtt() {
        return this.getAttribute(ExtendedStatistic.SYNC_ROLLBACK_TIME);
    }

    @ManagedAttribute(description="Average asynchronous Prepare duration (in microseconds)", displayName="Average Prepare Async")
    public double getAvgPrepareAsync() {
        return this.getAttribute(ExtendedStatistic.ASYNC_PREPARE_TIME);
    }

    @ManagedAttribute(description="Average asynchronous Commit duration (in microseconds)", displayName="Average Commit Async")
    public double getAvgCommitAsync() {
        return this.getAttribute(ExtendedStatistic.ASYNC_COMMIT_TIME);
    }

    @ManagedAttribute(description="Average asynchronous Complete Notification duration (in microseconds)", displayName="Average Complete Notification Async")
    public double getAvgCompleteNotificationAsync() {
        return this.getAttribute(ExtendedStatistic.ASYNC_COMPLETE_NOTIFY_TIME);
    }

    @ManagedAttribute(description="Average asynchronous Rollback duration (in microseconds)", displayName="Average Rollback Async")
    public double getAvgRollbackAsync() {
        return this.getAttribute(ExtendedStatistic.ASYNC_ROLLBACK_TIME);
    }

    @ManagedAttribute(description="Average number of nodes in Commit destination set", displayName="Average Number of Nodes in Commit Destination Set")
    public double getAvgNumNodesCommit() {
        return this.getAttribute(ExtendedStatistic.NUM_NODES_COMMIT);
    }

    @ManagedAttribute(description="Average number of nodes in Complete Notification destination set", displayName="Average Number of Nodes in Complete Notification Destination Set")
    public double getAvgNumNodesCompleteNotification() {
        return this.getAttribute(ExtendedStatistic.NUM_NODES_COMPLETE_NOTIFY);
    }

    @ManagedAttribute(description="Average number of nodes in Remote Get destination set", displayName="Average Number of Nodes in Remote Get Destination Set")
    public double getAvgNumNodesRemoteGet() {
        return this.getAttribute(ExtendedStatistic.NUM_NODES_GET);
    }

    @ManagedAttribute(description="Average number of nodes in Prepare destination set", displayName="Average Number of Nodes in Prepare Destination Set")
    public double getAvgNumNodesPrepare() {
        return this.getAttribute(ExtendedStatistic.NUM_NODES_PREPARE);
    }

    @ManagedAttribute(description="Average number of nodes in Rollback destination set", displayName="Average Number of Nodes in Rollback Destination Set")
    public double getAvgNumNodesRollback() {
        return this.getAttribute(ExtendedStatistic.NUM_NODES_ROLLBACK);
    }

    @ManagedAttribute(description="Local execution time of a transaction without the time waiting for lock acquisition", displayName="Local Execution Time Without Locking Time")
    public double getLocalExecutionTimeWithoutLock() {
        return this.getAttribute(ExtendedStatistic.LOCAL_EXEC_NO_CONT);
    }

    @ManagedAttribute(description="Average lock holding time (in microseconds)", displayName="Average Lock Holding Time")
    public double getAvgLockHoldTime() {
        return this.getAttribute(ExtendedStatistic.LOCK_HOLD_TIME);
    }

    @ManagedAttribute(description="Average lock local holding time (in microseconds)", displayName="Average Lock Local Holding Time")
    public double getAvgLocalLockHoldTime() {
        return this.getAttribute(ExtendedStatistic.LOCK_HOLD_TIME_LOCAL);
    }

    @ManagedAttribute(description="Average lock remote holding time (in microseconds)", displayName="Average Lock Remote Holding Time")
    public double getAvgRemoteLockHoldTime() {
        return this.getAttribute(ExtendedStatistic.LOCK_HOLD_TIME_REMOTE);
    }

    @ManagedAttribute(description="Average local commit duration time (2nd phase only) (in microseconds)", displayName="Average Commit Time")
    public double getAvgCommitTime() {
        return this.getAttribute(ExtendedStatistic.COMMIT_EXECUTION_TIME);
    }

    @ManagedAttribute(description="Average local rollback duration time (2nd phase only) (in microseconds)", displayName="Average Rollback Time")
    public double getAvgRollbackTime() {
        return this.getAttribute(ExtendedStatistic.ROLLBACK_EXECUTION_TIME);
    }

    @ManagedAttribute(description="Average prepare command size (in bytes)", displayName="Average Prepare Command Size")
    public double getAvgPrepareCommandSize() {
        return this.getAttribute(ExtendedStatistic.PREPARE_COMMAND_SIZE);
    }

    @ManagedAttribute(description="Average commit command size (in bytes)", displayName="Average Commit Command Size")
    public double getAvgCommitCommandSize() {
        return this.getAttribute(ExtendedStatistic.COMMIT_COMMAND_SIZE);
    }

    @ManagedAttribute(description="Average clustered get command size (in bytes)", displayName="Average Clustered Get Command Size")
    public double getAvgClusteredGetCommandSize() {
        return this.getAttribute(ExtendedStatistic.CLUSTERED_GET_COMMAND_SIZE);
    }

    @ManagedAttribute(description="Average time waiting for the lock acquisition (in microseconds)", displayName="Average Lock Waiting Time")
    public double getAvgLockWaitingTime() {
        return this.getAttribute(ExtendedStatistic.LOCK_WAITING_TIME);
    }

    @ManagedAttribute(description="Average transaction arrival rate, originated locally and remotely (in transaction per second)", displayName="Average Transaction Arrival Rate")
    public double getAvgTxArrivalRate() {
        return this.getAttribute(ExtendedStatistic.ARRIVAL_RATE);
    }

    @ManagedAttribute(description="Percentage of Write transaction executed locally (committed and aborted)", displayName="Percentage of Write Transactions")
    public double getPercentageWriteTransactions() {
        return this.getAttribute(ExtendedStatistic.WRITE_TX_PERCENTAGE);
    }

    @ManagedAttribute(description="Percentage of Write transaction executed in all successfully executed transactions (local transaction only)", displayName="Percentage of Successfully Write Transactions")
    public double getPercentageSuccessWriteTransactions() {
        return this.getAttribute(ExtendedStatistic.SUCCESSFUL_WRITE_TX_PERCENTAGE);
    }

    @ManagedAttribute(description="The number of aborted transactions due to timeout in lock acquisition", displayName="Number of Aborted Transaction due to Lock Acquisition Timeout")
    public double getNumAbortedTxDueTimeout() {
        return this.getAttribute(ExtendedStatistic.NUM_LOCK_FAILED_TIMEOUT);
    }

    @ManagedAttribute(description="The number of aborted transactions due to deadlock", displayName="Number of Aborted Transaction due to Deadlock")
    public double getNumAbortedTxDueDeadlock() {
        return this.getAttribute(ExtendedStatistic.NUM_LOCK_FAILED_DEADLOCK);
    }

    @ManagedAttribute(description="Average successful read-only transaction duration (in microseconds)", displayName="Average Read-Only Transaction Duration")
    public double getAvgReadOnlyTxDuration() {
        return this.getAttribute(ExtendedStatistic.RO_TX_SUCCESSFUL_EXECUTION_TIME);
    }

    @ManagedAttribute(description="Average successful write transaction duration (in microseconds)", displayName="Average Write Transaction Duration")
    public double getAvgWriteTxDuration() {
        return this.getAttribute(ExtendedStatistic.WR_TX_SUCCESSFUL_EXECUTION_TIME);
    }

    @ManagedAttribute(description="Average aborted write transaction duration (in microseconds)", displayName="Average Aborted Write Transaction Duration")
    public double getAvgAbortedWriteTxDuration() {
        return this.getAttribute(ExtendedStatistic.WR_TX_ABORTED_EXECUTION_TIME);
    }

    @ManagedAttribute(description="Average number of locks per write local transaction", displayName="Average Number of Lock per Local Transaction")
    public double getAvgNumOfLockLocalTx() {
        return this.getAttribute(ExtendedStatistic.NUM_LOCK_PER_LOCAL_TX);
    }

    @ManagedAttribute(description="Average number of locks per write remote transaction", displayName="Average Number of Lock per Remote Transaction")
    public double getAvgNumOfLockRemoteTx() {
        return this.getAttribute(ExtendedStatistic.NUM_LOCK_PER_REMOTE_TX);
    }

    @ManagedAttribute(description="Average number of locks per successfully write local transaction", displayName="Average Number of Lock per Successfully Local Transaction")
    public double getAvgNumOfLockSuccessLocalTx() {
        return this.getAttribute(ExtendedStatistic.NUM_HELD_LOCKS_SUCCESS_LOCAL_TX);
    }

    @ManagedAttribute(description="Average time it takes to execute the prepare command locally (in microseconds)", displayName="Average Local Prepare Execution Time")
    public double getAvgLocalPrepareTime() {
        return this.getAttribute(ExtendedStatistic.LOCAL_PREPARE_EXECUTION_TIME);
    }

    @ManagedAttribute(description="Average time it takes to execute the prepare command remotely (in microseconds)", displayName="Average Remote Prepare Execution Time")
    public double getAvgRemotePrepareTime() {
        return this.getAttribute(ExtendedStatistic.REMOTE_PREPARE_EXECUTION_TIME);
    }

    @ManagedAttribute(description="Average time it takes to execute the commit command locally (in microseconds)", displayName="Average Local Commit Execution Time")
    public double getAvgLocalCommitTime() {
        return this.getAttribute(ExtendedStatistic.LOCAL_COMMIT_EXECUTION_TIME);
    }

    @ManagedAttribute(description="Average time it takes to execute the commit command remotely (in microseconds)", displayName="Average Remote Commit Execution Time")
    public double getAvgRemoteCommitTime() {
        return this.getAttribute(ExtendedStatistic.REMOTE_COMMIT_EXECUTION_TIME);
    }

    @ManagedAttribute(description="Average time it takes to execute the rollback command locally (in microseconds)", displayName="Average Local Rollback Execution Time")
    public double getAvgLocalRollbackTime() {
        return this.getAttribute(ExtendedStatistic.LOCAL_ROLLBACK_EXECUTION_TIME);
    }

    @ManagedAttribute(description="Average time it takes to execute the rollback command remotely (in microseconds)", displayName="Average Remote Rollback Execution Time")
    public double getAvgRemoteRollbackTime() {
        return this.getAttribute(ExtendedStatistic.REMOTE_ROLLBACK_EXECUTION_TIME);
    }

    @ManagedAttribute(description="Abort Rate", displayName="Abort Rate")
    public double getAbortRate() {
        return this.getAttribute(ExtendedStatistic.ABORT_RATE);
    }

    @ManagedAttribute(description="Throughput (in transactions per second)", displayName="Throughput")
    public double getThroughput() {
        return this.getAttribute(ExtendedStatistic.THROUGHPUT);
    }

    @ManagedAttribute(description="Average number of get operations per (local) read-only transaction", displayName="Average number of get operations per (local) read-only transaction")
    public double getAvgGetsPerROTransaction() {
        return this.getAttribute(ExtendedStatistic.NUM_GETS_RO_TX);
    }

    @ManagedAttribute(description="Average number of get operations per (local) read-write transaction", displayName="Average number of get operations per (local) read-write transaction")
    public double getAvgGetsPerWrTransaction() {
        return this.getAttribute(ExtendedStatistic.NUM_GETS_WR_TX);
    }

    @ManagedAttribute(description="Average number of remote get operations per (local) read-write transaction", displayName="Average number of remote get operations per (local) read-write transaction")
    public double getAvgRemoteGetsPerWrTransaction() {
        return this.getAttribute(ExtendedStatistic.NUM_REMOTE_GETS_WR_TX);
    }

    @ManagedAttribute(description="Average number of remote get operations per (local) read-only transaction", displayName="Average number of remote get operations per (local) read-only transaction")
    public double getAvgRemoteGetsPerROTransaction() {
        return this.getAttribute(ExtendedStatistic.NUM_REMOTE_GETS_RO_TX);
    }

    @ManagedAttribute(description="Average cost of a remote get", displayName="Remote get cost")
    public double getRemoteGetExecutionTime() {
        return this.getAttribute(ExtendedStatistic.REMOTE_GET_EXECUTION);
    }

    @ManagedAttribute(description="Average number of put operations per (local) read-write transaction", displayName="Average number of put operations per (local) read-write transaction")
    public double getAvgPutsPerWrTransaction() {
        return this.getAttribute(ExtendedStatistic.NUM_PUTS_WR_TX);
    }

    @ManagedAttribute(description="Average number of remote put operations per (local) read-write transaction", displayName="Average number of remote put operations per (local) read-write transaction")
    public double getAvgRemotePutsPerWrTransaction() {
        return this.getAttribute(ExtendedStatistic.NUM_REMOTE_PUTS_WR_TX);
    }

    @ManagedAttribute(description="Average cost of a remote put", displayName="Remote put cost")
    public double getRemotePutExecutionTime() {
        return this.getAttribute(ExtendedStatistic.REMOTE_PUT_EXECUTION);
    }

    @ManagedAttribute(description="Number of gets performed since last reset", displayName="Number of Gets")
    public double getNumberOfGets() {
        return this.getAttribute(ExtendedStatistic.NUM_GET);
    }

    @ManagedAttribute(description="Number of remote gets performed since last reset", displayName="Number of Remote Gets")
    public double getNumberOfRemoteGets() {
        return this.getAttribute(ExtendedStatistic.NUM_REMOTE_GET);
    }

    @ManagedAttribute(description="Number of puts performed since last reset", displayName="Number of Puts")
    public double getNumberOfPuts() {
        return this.getAttribute(ExtendedStatistic.NUM_PUT);
    }

    @ManagedAttribute(description="Number of remote puts performed since last reset", displayName="Number of Remote Puts")
    public double getNumberOfRemotePuts() {
        return this.getAttribute(ExtendedStatistic.NUM_REMOTE_PUT);
    }

    @ManagedAttribute(description="Number of committed transactions since last reset", displayName="Number Of Commits")
    public double getNumberOfCommits() {
        return this.getAttribute(ExtendedStatistic.NUM_COMMITTED_TX);
    }

    @ManagedAttribute(description="Number of local committed transactions since last reset", displayName="Number Of Local Commits")
    public double getNumberOfLocalCommits() {
        return this.getAttribute(ExtendedStatistic.NUM_LOCAL_COMMITTED_TX);
    }

    @ManagedAttribute(description="Write skew probability", displayName="Write Skew Probability")
    public double getWriteSkewProbability() {
        return this.getAttribute(ExtendedStatistic.WRITE_SKEW_PROBABILITY);
    }

    @ManagedOperation(description="K-th percentile of local read-only transactions execution time", displayName="K-th Percentile Local Read-Only Transactions")
    public double getPercentileLocalReadOnlyTransaction(@Parameter(name="percentile") int percentile) {
        return this.cacheStatisticManager.getPercentile(PercentileStatistic.RO_LOCAL_EXECUTION, percentile);
    }

    @ManagedOperation(description="K-th percentile of remote read-only transactions execution time", displayName="K-th Percentile Remote Read-Only Transactions")
    public double getPercentileRemoteReadOnlyTransaction(@Parameter(name="percentile") int percentile) {
        return this.cacheStatisticManager.getPercentile(PercentileStatistic.RO_REMOTE_EXECUTION, percentile);
    }

    @ManagedOperation(description="K-th percentile of local write transactions execution time", displayName="K-th Percentile Local Write Transactions")
    public double getPercentileLocalRWriteTransaction(@Parameter(name="percentile") int percentile) {
        return this.cacheStatisticManager.getPercentile(PercentileStatistic.WR_LOCAL_EXECUTION, percentile);
    }

    @ManagedOperation(description="K-th percentile of remote write transactions execution time", displayName="K-th Percentile Remote Write Transactions")
    public double getPercentileRemoteWriteTransaction(@Parameter(name="percentile") int percentile) {
        return this.cacheStatisticManager.getPercentile(PercentileStatistic.WR_REMOTE_EXECUTION, percentile);
    }

    @ManagedOperation(description="Reset all the statistics collected", displayName="Reset All Statistics")
    public void resetStatistics() {
        this.cacheStatisticManager.reset();
    }

    @ManagedAttribute(description="Average Local processing Get time (in microseconds)", displayName="Average Local Get time")
    public double getAvgLocalGetTime() {
        return this.getAttribute(ExtendedStatistic.LOCAL_GET_EXECUTION);
    }

    @ManagedAttribute(description="Number of nodes in the cluster", displayName="Number of nodes")
    public double getNumNodes() {
        if (this.rpcManager == null) {
            return 1.0;
        }
        return this.rpcManager.getTransport().getMembers().size();
    }

    @ManagedAttribute(description="Number of replicas for each key", displayName="Replication Degree")
    public double getReplicationDegree() {
        if (this.distributionManager != null) {
            return this.distributionManager.getConsistentHash().getNumOwners();
        }
        if (this.rpcManager != null) {
            return this.rpcManager.getTransport().getMembers().size();
        }
        return 1.0;
    }

    @ManagedAttribute(description="Number of concurrent transactions executing on the current node", displayName="Local Active Transactions")
    public double getLocalActiveTransactions() {
        if (this.transactionTable != null) {
            return this.transactionTable.getLocalTxCount();
        }
        return 0.0;
    }

    @ManagedAttribute(description="Average Response Time", displayName="Average Response Time")
    public double getAvgResponseTime() {
        return this.getAttribute(ExtendedStatistic.RESPONSE_TIME);
    }

    @ManagedOperation(description="Returns the raw value for the statistic", displayName="Get Statistic Value")
    public final double getStatisticValue(@Parameter(description="Statistic name") String statName) {
        if (statName == null) {
            return 0.0;
        }
        for (ExtendedStatistic statistic : ExtendedStatistic.values()) {
            if (!statistic.name().equalsIgnoreCase(statName)) continue;
            return this.getAttribute(statistic);
        }
        return 0.0;
    }

    @ManagedAttribute(description="Returns all the available statistics", displayName="Available Statistics")
    public final String getAvailableExtendedStatistics() {
        return Arrays.toString((Object[])ExtendedStatistic.values());
    }

    @ManagedOperation(description="Dumps the current cache statistic values", displayName="Dump Cache Statistics")
    public final String dumpStatistics() {
        return this.cacheStatisticManager.dumpCacheStatistics();
    }

    @ManagedOperation(description="Dumps the current cache statistic values to System.out", displayName="Dump Cache Statistics to System.out")
    public final void dumpStatisticsToSystemOut() {
        this.cacheStatisticManager.dumpCacheStatisticsTo(System.out);
    }

    @ManagedOperation(description="Dumps the current cache statistic values to a file", displayName="Dump cache Statistics to file")
    public final void dumpStatisticToFile(@Parameter(description="The file path") String filePath) throws IOException {
        try (PrintStream stream = null;){
            stream = new PrintStream(new File(filePath));
            this.cacheStatisticManager.dumpCacheStatisticsTo(stream);
        }
    }

    public final CacheStatisticManager getCacheStatisticManager() {
        return this.cacheStatisticManager;
    }

    public double getAttribute(ExtendedStatistic statistic) {
        try {
            return this.cacheStatisticManager.getAttribute(statistic);
        }
        catch (ExtendedStatisticNotFoundException e) {
            log.unableToGetStatistic(statistic, e);
            return 0.0;
        }
    }

    @Start(priority=11)
    protected void start() {
        super.start();
        log.startExtendedStatisticInterceptor();
        this.timeService = this.cache.getAdvancedCache().getComponentRegistry().getTimeService();
        this.cacheStatisticManager = new CacheStatisticManager(this.cacheConfiguration, this.timeService);
        this.transactionTable = (TransactionTable)this.cache.getAdvancedCache().getComponentRegistry().getComponent(TransactionTable.class);
        this.distributionManager = this.cache.getAdvancedCache().getDistributionManager();
        this.replace();
    }

    private Object visitSecondPhaseCommand(TxInvocationContext ctx, TransactionBoundaryCommand command, boolean commit, ExtendedStatistic duration, ExtendedStatistic counter) throws Throwable {
        GlobalTransaction globalTransaction = command.getGlobalTransaction();
        if (trace) {
            log.tracef("Visit 2nd phase command %s. Is it local? %s. Transaction is %s", command, ctx.isOriginLocal(), globalTransaction.globalId());
        }
        long start = this.timeService.time();
        Object ret = this.invokeNextInterceptor((InvocationContext)ctx, (VisitableCommand)command);
        long end = this.timeService.time();
        this.updateTime(duration, counter, start, end, globalTransaction, ctx.isOriginLocal());
        this.cacheStatisticManager.setTransactionOutcome(commit, globalTransaction, ctx.isOriginLocal());
        this.cacheStatisticManager.terminateTransaction(globalTransaction, true, true);
        return ret;
    }

    private Object visitWriteCommand(InvocationContext ctx, WriteCommand command, Object key) throws Throwable {
        if (trace) {
            log.tracef("Visit write command %s. Is it in transaction scope? %s. Is it local? %s", command, ctx.isInTxScope(), ctx.isOriginLocal());
        }
        if (ctx.isInTxScope()) {
            Object ret;
            long start = this.timeService.time();
            try {
                ret = this.invokeNextInterceptor(ctx, (VisitableCommand)command);
            }
            catch (TimeoutException e) {
                if (ctx.isOriginLocal() && this.isLockTimeout(e)) {
                    this.initStatsIfNecessary(ctx);
                    this.cacheStatisticManager.increment(ExtendedStatistic.NUM_LOCK_FAILED_TIMEOUT, this.getGlobalTransaction(ctx), ctx.isOriginLocal());
                }
                throw e;
            }
            catch (DeadlockDetectedException e) {
                if (ctx.isOriginLocal()) {
                    this.initStatsIfNecessary(ctx);
                    this.cacheStatisticManager.increment(ExtendedStatistic.NUM_LOCK_FAILED_DEADLOCK, this.getGlobalTransaction(ctx), ctx.isOriginLocal());
                }
                throw e;
            }
            catch (WriteSkewException e) {
                if (ctx.isOriginLocal()) {
                    this.initStatsIfNecessary(ctx);
                    this.cacheStatisticManager.increment(ExtendedStatistic.NUM_WRITE_SKEW, this.getGlobalTransaction(ctx), ctx.isOriginLocal());
                }
                throw e;
            }
            catch (RemoteException remote) {
                if (ctx.isOriginLocal()) {
                    ExtendedStatistic stat = null;
                    for (Throwable cause = remote.getCause(); cause != null; cause = cause.getCause()) {
                        if (cause instanceof TimeoutException) {
                            stat = ExtendedStatistic.NUM_LOCK_FAILED_TIMEOUT;
                            break;
                        }
                        if (cause instanceof DeadlockDetectedException) {
                            stat = ExtendedStatistic.NUM_LOCK_FAILED_DEADLOCK;
                            break;
                        }
                        if (!(cause instanceof WriteSkewException)) continue;
                        stat = ExtendedStatistic.NUM_WRITE_SKEW;
                        break;
                    }
                    if (stat != null) {
                        this.initStatsIfNecessary(ctx);
                        this.cacheStatisticManager.increment(stat, this.getGlobalTransaction(ctx), true);
                    }
                }
                throw remote;
            }
            finally {
                long end = this.timeService.time();
                this.initStatsIfNecessary(ctx);
                this.cacheStatisticManager.increment(ExtendedStatistic.NUM_PUT, this.getGlobalTransaction(ctx), ctx.isOriginLocal());
                this.cacheStatisticManager.markAsWriteTransaction(this.getGlobalTransaction(ctx), ctx.isOriginLocal());
            }
            if (this.isRemote(key)) {
                long end;
                this.cacheStatisticManager.add(ExtendedStatistic.REMOTE_PUT_EXECUTION, this.timeService.timeDuration(start, end, TimeUnit.NANOSECONDS), this.getGlobalTransaction(ctx), ctx.isOriginLocal());
                this.cacheStatisticManager.increment(ExtendedStatistic.NUM_REMOTE_PUT, this.getGlobalTransaction(ctx), ctx.isOriginLocal());
            }
            return ret;
        }
        return this.invokeNextInterceptor(ctx, (VisitableCommand)command);
    }

    private GlobalTransaction getGlobalTransaction(InvocationContext context) {
        if (context.isInTxScope()) {
            return ((TxInvocationContext)context).getGlobalTransaction();
        }
        return null;
    }

    private boolean isRemote(Object key) {
        return this.distributionManager != null && !this.distributionManager.getLocality(key).isLocal();
    }

    private void replace() {
        log.replaceComponents();
        ComponentRegistry componentRegistry = this.cache.getAdvancedCache().getComponentRegistry();
        this.replaceRpcManager(componentRegistry);
        this.replaceLockManager(componentRegistry);
        componentRegistry.rewire();
    }

    private void replaceLockManager(ComponentRegistry componentRegistry) {
        LockManager oldLockManager = (LockManager)componentRegistry.getComponent(LockManager.class);
        ExtendedStatisticLockManager newLockManager = new ExtendedStatisticLockManager(oldLockManager, this.cacheStatisticManager, this.timeService);
        log.replaceComponent("LockManager", oldLockManager, newLockManager);
        componentRegistry.registerComponent((Object)newLockManager, LockManager.class);
    }

    private void replaceRpcManager(ComponentRegistry componentRegistry) {
        RpcManager oldRpcManager = (RpcManager)componentRegistry.getComponent(RpcManager.class);
        if (oldRpcManager == null) {
            return;
        }
        ExtendedStatisticRpcManager newRpcManager = new ExtendedStatisticRpcManager(oldRpcManager, this.cacheStatisticManager, this.timeService);
        log.replaceComponent("RpcManager", oldRpcManager, newRpcManager);
        componentRegistry.registerComponent((Object)newRpcManager, RpcManager.class);
        this.rpcManager = newRpcManager;
    }

    private void initStatsIfNecessary(InvocationContext ctx) {
        if (ctx.isInTxScope()) {
            this.cacheStatisticManager.beginTransaction(this.getGlobalTransaction(ctx), ctx.isOriginLocal());
        }
    }

    private boolean isLockTimeout(TimeoutException e) {
        return e.getMessage().startsWith("ISPN000299: Unable to acquire lock after");
    }

    private void updateTime(ExtendedStatistic duration, ExtendedStatistic counter, long initTime, long endTime, GlobalTransaction globalTransaction, boolean local) {
        this.cacheStatisticManager.add(duration, this.timeService.timeDuration(initTime, endTime, TimeUnit.NANOSECONDS), globalTransaction, local);
        this.cacheStatisticManager.increment(counter, globalTransaction, local);
    }
}

