/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stats.logic;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.interceptors.TxInterceptor;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.stats.CacheStatisticCollector;
import org.infinispan.stats.CacheStatisticManager;
import org.infinispan.stats.container.ConcurrentGlobalContainer;
import org.infinispan.stats.container.ExtendedStatistic;
import org.infinispan.stats.wrappers.ExtendedStatisticInterceptor;
import org.infinispan.stats.wrappers.ExtendedStatisticLockManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.DefaultTimeService;
import org.infinispan.util.TimeService;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="stats.logic.LocalTxClusterExtendedStatisticLogicTest")
public class LocalTxClusterExtendedStatisticLogicTest
extends SingleCacheManagerTest {
    private static final int SLEEP_TIME = 500;
    private static final TimeService TEST_TIME_SERVICE = new DefaultTimeService(){

        public long time() {
            return 0L;
        }

        public long timeDuration(long startTime, TimeUnit outputTimeUnit) {
            Assert.assertEquals((long)startTime, (long)0L, (String)"Start timestamp must be zero!");
            Assert.assertEquals((Object)((Object)outputTimeUnit), (Object)((Object)TimeUnit.NANOSECONDS), (String)"TimeUnit is different from expected");
            return 1L;
        }

        public long timeDuration(long startTime, long endTime, TimeUnit outputTimeUnit) {
            Assert.assertEquals((long)startTime, (long)0L, (String)"Start timestamp must be zero!");
            Assert.assertEquals((long)endTime, (long)0L, (String)"End timestamp must be zero!");
            Assert.assertEquals((Object)((Object)outputTimeUnit), (Object)((Object)TimeUnit.NANOSECONDS), (String)"TimeUnit is different from expected");
            return 1L;
        }
    };
    private static final double MICROSECONDS = CacheStatisticCollector.convertNanosToMicro((double)TEST_TIME_SERVICE.timeDuration(0L, TimeUnit.NANOSECONDS));
    private static final double SECONDS = CacheStatisticCollector.convertNanosToSeconds((double)TEST_TIME_SERVICE.timeDuration(0L, TimeUnit.NANOSECONDS));
    private final List<Object> keys = new ArrayList<Object>(128);
    private ExtendedStatisticInterceptor extendedStatisticInterceptor;

    public final void testPutTxAndReadOnlyTx() throws Exception {
        this.testStats(WriteOperation.PUT, 2, 7, 3, 4, 5, false);
    }

    public final void testPutTxAndReadOnlyTxRollback() throws Exception {
        this.testStats(WriteOperation.PUT, 3, 6, 2, 5, 4, true);
    }

    public final void testConditionalPutTxAndReadOnlyTx() throws Exception {
        this.testStats(WriteOperation.PUT_IF, 4, 5, 4, 6, 3, false);
    }

    public final void testConditionalPutTxAndReadOnlyTxRollback() throws Exception {
        this.testStats(WriteOperation.PUT_IF, 5, 4, 5, 7, 2, true);
    }

    public final void testReplaceTxAndReadOnlyTx() throws Exception {
        this.testStats(WriteOperation.REPLACE, 2, 7, 3, 4, 5, false);
    }

    public final void testReplaceTxAndReadOnlyTxRollback() throws Exception {
        this.testStats(WriteOperation.REPLACE, 3, 6, 2, 5, 4, true);
    }

    public final void testConditionalReplaceTxAndReadOnlyTx() throws Exception {
        this.testStats(WriteOperation.REPLACE_IF, 4, 5, 4, 6, 3, false);
    }

    public final void testConditionalReplaceTxAndReadOnlyTxRollback() throws Exception {
        this.testStats(WriteOperation.REPLACE_IF, 5, 4, 5, 7, 2, true);
    }

    public final void testRemoveTxAndReadOnlyTx() throws Exception {
        this.testStats(WriteOperation.REMOVE, 2, 7, 3, 4, 5, false);
    }

    public final void testRemoveTxAndReadOnlyTxRollback() throws Exception {
        this.testStats(WriteOperation.REMOVE, 3, 6, 2, 5, 4, true);
    }

    public final void testConditionalRemoveTxAndReadOnlyTx() throws Exception {
        this.testStats(WriteOperation.REMOVE_IF, 4, 5, 4, 6, 3, false);
    }

    public final void testConditionalRemoveTxAndReadOnlyTxRollback() throws Exception {
        this.testStats(WriteOperation.REMOVE_IF, 5, 4, 5, 7, 2, true);
    }

    protected void setup() throws Exception {
        super.setup();
        CacheStatisticManager manager = (CacheStatisticManager)TestingUtil.extractField((Object)this.extendedStatisticInterceptor, (String)"cacheStatisticManager");
        CacheStatisticCollector collector = (CacheStatisticCollector)TestingUtil.extractField((Object)manager, (String)"cacheStatisticCollector");
        ConcurrentGlobalContainer globalContainer = (ConcurrentGlobalContainer)TestingUtil.extractField((Object)collector, (String)"globalContainer");
        TestingUtil.replaceField((Object)TEST_TIME_SERVICE, (String)"timeService", (Object)manager, CacheStatisticManager.class);
        TestingUtil.replaceField((Object)TEST_TIME_SERVICE, (String)"timeService", (Object)collector, CacheStatisticCollector.class);
        TestingUtil.replaceField((Object)TEST_TIME_SERVICE, (String)"timeService", (Object)globalContainer, ConcurrentGlobalContainer.class);
        TestingUtil.replaceField((Object)TEST_TIME_SERVICE, (String)"timeService", (Object)this.extendedStatisticInterceptor, ExtendedStatisticInterceptor.class);
        TestingUtil.replaceField((Object)TEST_TIME_SERVICE, (String)"timeService", (Object)TestingUtil.extractLockManager((Cache)this.cache()), ExtendedStatisticLockManager.class);
    }

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = LocalTxClusterExtendedStatisticLogicTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.LOCAL, (boolean)true);
        builder.locking().isolationLevel(IsolationLevel.REPEATABLE_READ).writeSkewCheck(false).lockAcquisitionTimeout(0L);
        builder.clustering().hash().numOwners(1);
        builder.transaction().recovery().disable();
        this.extendedStatisticInterceptor = new ExtendedStatisticInterceptor();
        builder.customInterceptors().addInterceptor().interceptor((CommandInterceptor)this.extendedStatisticInterceptor).after(TxInterceptor.class);
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)builder);
    }

    private void testStats(WriteOperation operation, int numOfWriteTx, int numOfWrites, int numOfReadsPerWriteTx, int numOfReadOnlyTx, int numOfReadPerReadTx, boolean abort) throws Exception {
        Object key;
        int i;
        int tx;
        for (int i2 = 1; i2 <= (numOfReadsPerWriteTx + numOfWrites) * numOfWriteTx + numOfReadPerReadTx * numOfReadOnlyTx; ++i2) {
            this.cache().put(this.getKey(i2), this.getInitValue(i2));
        }
        TestingUtil.sleepThread((long)500L);
        this.resetStats();
        int localGetsReadTx = 0;
        int localGetsWriteTx = 0;
        int localPuts = 0;
        int localLocks = 0;
        int numOfLocalWriteTx = 0;
        int keyIndex = 0;
        for (tx = 1; tx <= numOfWriteTx; ++tx) {
            this.tm().begin();
            for (i = 1; i <= numOfReadsPerWriteTx; ++i) {
                key = this.getKey(++keyIndex);
                ++localGetsWriteTx;
                Assert.assertEquals((Object)this.cache().get(key), (Object)this.getInitValue(keyIndex));
            }
            for (i = 1; i <= numOfWrites; ++i) {
                key = operation == WriteOperation.PUT_IF ? this.getKey(-keyIndex) : this.getKey(++keyIndex);
                switch (operation) {
                    case PUT: {
                        this.cache().put(key, this.getValue(keyIndex));
                        break;
                    }
                    case PUT_IF: {
                        this.cache().putIfAbsent(key, this.getValue(keyIndex));
                        break;
                    }
                    case REPLACE: {
                        this.cache().replace(key, this.getValue(keyIndex));
                        break;
                    }
                    case REPLACE_IF: {
                        this.cache().replace(key, this.getInitValue(keyIndex), this.getValue(keyIndex));
                        break;
                    }
                    case REMOVE: {
                        this.cache().remove(key);
                        break;
                    }
                    case REMOVE_IF: {
                        this.cache().remove(key, this.getInitValue(keyIndex));
                        break;
                    }
                }
                ++localPuts;
                if (abort) continue;
                ++localLocks;
            }
            ++numOfLocalWriteTx;
            if (abort) {
                this.tm().rollback();
                continue;
            }
            this.tm().commit();
        }
        TestingUtil.sleepThread((long)500L);
        for (tx = 1; tx <= numOfReadOnlyTx; ++tx) {
            this.tm().begin();
            for (i = 1; i <= numOfReadPerReadTx; ++i) {
                key = this.getKey(++keyIndex);
                ++localGetsReadTx;
                Assert.assertEquals((Object)this.cache().get(key), (Object)this.getInitValue(keyIndex));
            }
            if (abort) {
                this.tm().rollback();
                continue;
            }
            this.tm().commit();
        }
        TestingUtil.sleepThread((long)500L);
        EnumSet<ExtendedStatistic> statsToValidate = this.getStatsToValidate();
        this.assertTxValues(statsToValidate, numOfLocalWriteTx, numOfReadOnlyTx, abort);
        this.assertLockingValues(statsToValidate, localLocks, numOfLocalWriteTx, abort);
        this.assertAccessesValues(statsToValidate, localGetsReadTx, localGetsWriteTx, localPuts, numOfWriteTx, numOfReadOnlyTx, abort);
        this.assertAttributeValue(ExtendedStatistic.NUM_WRITE_SKEW, statsToValidate, 0.0);
        this.assertAttributeValue(ExtendedStatistic.WRITE_SKEW_PROBABILITY, statsToValidate, 0.0);
        this.assertAllStatsValidated(statsToValidate);
        this.resetStats();
    }

    private Object getKey(int i) {
        if (i < 0) {
            return "KEY_" + i;
        }
        for (int j = this.keys.size(); j <= i; ++j) {
            this.keys.add("KEY_" + (j + 1));
        }
        return this.keys.get(i - 1);
    }

    private Object getInitValue(int i) {
        return "INIT_" + i;
    }

    private Object getValue(int i) {
        return "VALUE_" + i;
    }

    private void assertTxValues(EnumSet<ExtendedStatistic> statsToValidate, int numOfWriteTx, int numOfReadTx, boolean abort) {
        this.log.infof("Check Tx value: writeTx=%s, readTx=%s, abort?=%s", (Object)numOfWriteTx, (Object)numOfReadTx, (Object)abort);
        if (abort) {
            this.assertAttributeValue(ExtendedStatistic.NUM_COMMITTED_RO_TX, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.NUM_COMMITTED_WR_TX, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.NUM_ABORTED_WR_TX, statsToValidate, numOfWriteTx);
            this.assertAttributeValue(ExtendedStatistic.NUM_ABORTED_RO_TX, statsToValidate, numOfReadTx);
            this.assertAttributeValue(ExtendedStatistic.NUM_COMMITTED_TX, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.NUM_LOCAL_COMMITTED_TX, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.LOCAL_EXEC_NO_CONT, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.WRITE_TX_PERCENTAGE, statsToValidate, (double)numOfWriteTx * 1.0 / (double)(numOfWriteTx + numOfReadTx));
            this.assertAttributeValue(ExtendedStatistic.SUCCESSFUL_WRITE_TX_PERCENTAGE, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.WR_TX_ABORTED_EXECUTION_TIME, statsToValidate, numOfWriteTx != 0 ? MICROSECONDS : 0.0);
            this.assertAttributeValue(ExtendedStatistic.RO_TX_ABORTED_EXECUTION_TIME, statsToValidate, numOfReadTx);
            this.assertAttributeValue(ExtendedStatistic.WR_TX_SUCCESSFUL_EXECUTION_TIME, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.RO_TX_SUCCESSFUL_EXECUTION_TIME, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.ABORT_RATE, statsToValidate, 1.0);
            this.assertAttributeValue(ExtendedStatistic.ARRIVAL_RATE, statsToValidate, (double)(numOfWriteTx + numOfReadTx) / SECONDS);
            this.assertAttributeValue(ExtendedStatistic.THROUGHPUT, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.ROLLBACK_EXECUTION_TIME, statsToValidate, numOfReadTx != 0 || numOfWriteTx != 0 ? MICROSECONDS : 0.0);
            this.assertAttributeValue(ExtendedStatistic.NUM_ROLLBACK_COMMAND, statsToValidate, numOfReadTx + numOfWriteTx);
            this.assertAttributeValue(ExtendedStatistic.LOCAL_ROLLBACK_EXECUTION_TIME, statsToValidate, numOfReadTx != 0 || numOfWriteTx != 0 ? MICROSECONDS : 0.0);
            this.assertAttributeValue(ExtendedStatistic.REMOTE_ROLLBACK_EXECUTION_TIME, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.COMMIT_EXECUTION_TIME, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.NUM_COMMIT_COMMAND, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.LOCAL_COMMIT_EXECUTION_TIME, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.REMOTE_COMMIT_EXECUTION_TIME, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.PREPARE_EXECUTION_TIME, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.NUM_PREPARE_COMMAND, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.LOCAL_PREPARE_EXECUTION_TIME, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.REMOTE_PREPARE_EXECUTION_TIME, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.NUM_SYNC_PREPARE, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.SYNC_PREPARE_TIME, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.NUM_SYNC_COMMIT, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.SYNC_COMMIT_TIME, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.NUM_SYNC_ROLLBACK, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.SYNC_ROLLBACK_TIME, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.ASYNC_PREPARE_TIME, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.NUM_ASYNC_PREPARE, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.ASYNC_COMMIT_TIME, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.NUM_ASYNC_COMMIT, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.ASYNC_ROLLBACK_TIME, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.NUM_ASYNC_ROLLBACK, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.ASYNC_COMPLETE_NOTIFY_TIME, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.NUM_ASYNC_COMPLETE_NOTIFY, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.NUM_NODES_PREPARE, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.NUM_NODES_COMMIT, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.NUM_NODES_ROLLBACK, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.NUM_NODES_COMPLETE_NOTIFY, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.RESPONSE_TIME, statsToValidate, 0.0);
        } else {
            this.assertAttributeValue(ExtendedStatistic.NUM_COMMITTED_RO_TX, statsToValidate, numOfReadTx);
            this.assertAttributeValue(ExtendedStatistic.NUM_COMMITTED_WR_TX, statsToValidate, numOfWriteTx);
            this.assertAttributeValue(ExtendedStatistic.NUM_ABORTED_WR_TX, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.NUM_ABORTED_RO_TX, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.NUM_COMMITTED_TX, statsToValidate, numOfWriteTx + numOfReadTx);
            this.assertAttributeValue(ExtendedStatistic.NUM_LOCAL_COMMITTED_TX, statsToValidate, numOfReadTx + numOfWriteTx);
            this.assertAttributeValue(ExtendedStatistic.LOCAL_EXEC_NO_CONT, statsToValidate, numOfWriteTx != 0 ? MICROSECONDS : 0.0);
            this.assertAttributeValue(ExtendedStatistic.WRITE_TX_PERCENTAGE, statsToValidate, (double)numOfWriteTx * 1.0 / (double)(numOfReadTx + numOfWriteTx));
            this.assertAttributeValue(ExtendedStatistic.SUCCESSFUL_WRITE_TX_PERCENTAGE, statsToValidate, numOfReadTx + numOfWriteTx > 0 ? (double)numOfWriteTx * 1.0 / (double)(numOfReadTx + numOfWriteTx) : 0.0);
            this.assertAttributeValue(ExtendedStatistic.WR_TX_ABORTED_EXECUTION_TIME, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.RO_TX_ABORTED_EXECUTION_TIME, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.WR_TX_SUCCESSFUL_EXECUTION_TIME, statsToValidate, numOfWriteTx != 0 ? MICROSECONDS : 0.0);
            this.assertAttributeValue(ExtendedStatistic.RO_TX_SUCCESSFUL_EXECUTION_TIME, statsToValidate, numOfReadTx != 0 ? MICROSECONDS : 0.0);
            this.assertAttributeValue(ExtendedStatistic.ABORT_RATE, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.ARRIVAL_RATE, statsToValidate, (double)(numOfWriteTx + numOfReadTx) / SECONDS);
            this.assertAttributeValue(ExtendedStatistic.THROUGHPUT, statsToValidate, (double)(numOfWriteTx + numOfReadTx) / SECONDS);
            this.assertAttributeValue(ExtendedStatistic.ROLLBACK_EXECUTION_TIME, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.NUM_ROLLBACK_COMMAND, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.LOCAL_ROLLBACK_EXECUTION_TIME, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.REMOTE_ROLLBACK_EXECUTION_TIME, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.COMMIT_EXECUTION_TIME, statsToValidate, numOfReadTx != 0 || numOfWriteTx != 0 ? MICROSECONDS : 0.0);
            this.assertAttributeValue(ExtendedStatistic.NUM_COMMIT_COMMAND, statsToValidate, numOfReadTx + numOfWriteTx);
            this.assertAttributeValue(ExtendedStatistic.LOCAL_COMMIT_EXECUTION_TIME, statsToValidate, numOfReadTx != 0 || numOfWriteTx != 0 ? MICROSECONDS : 0.0);
            this.assertAttributeValue(ExtendedStatistic.REMOTE_COMMIT_EXECUTION_TIME, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.PREPARE_EXECUTION_TIME, statsToValidate, numOfReadTx + numOfWriteTx);
            this.assertAttributeValue(ExtendedStatistic.NUM_PREPARE_COMMAND, statsToValidate, numOfReadTx + numOfWriteTx);
            this.assertAttributeValue(ExtendedStatistic.LOCAL_PREPARE_EXECUTION_TIME, statsToValidate, numOfReadTx != 0 || numOfWriteTx != 0 ? MICROSECONDS : 0.0);
            this.assertAttributeValue(ExtendedStatistic.REMOTE_PREPARE_EXECUTION_TIME, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.NUM_SYNC_PREPARE, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.SYNC_PREPARE_TIME, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.NUM_SYNC_COMMIT, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.SYNC_COMMIT_TIME, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.NUM_SYNC_ROLLBACK, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.SYNC_ROLLBACK_TIME, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.ASYNC_PREPARE_TIME, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.NUM_ASYNC_PREPARE, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.ASYNC_COMMIT_TIME, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.NUM_ASYNC_COMMIT, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.ASYNC_ROLLBACK_TIME, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.NUM_ASYNC_ROLLBACK, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.ASYNC_COMPLETE_NOTIFY_TIME, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.NUM_ASYNC_COMPLETE_NOTIFY, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.NUM_NODES_PREPARE, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.NUM_NODES_COMMIT, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.NUM_NODES_ROLLBACK, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.NUM_NODES_COMPLETE_NOTIFY, statsToValidate, 0.0);
            this.assertAttributeValue(ExtendedStatistic.RESPONSE_TIME, statsToValidate, numOfReadTx != 0 || numOfWriteTx != 0 ? MICROSECONDS : 0.0);
        }
    }

    private void assertLockingValues(EnumSet<ExtendedStatistic> statsToValidate, int numOfLocks, int numOfWriteTx, boolean abort) {
        this.log.infof("Check Locking value. locks=%s, writeTx=%s, abort?=%s", (Object)numOfLocks, (Object)numOfWriteTx, (Object)abort);
        this.assertAttributeValue(ExtendedStatistic.LOCK_HOLD_TIME_LOCAL, statsToValidate, numOfLocks != 0 ? MICROSECONDS : 0.0);
        this.assertAttributeValue(ExtendedStatistic.LOCK_HOLD_TIME_REMOTE, statsToValidate, 0.0);
        this.assertAttributeValue(ExtendedStatistic.NUM_LOCK_PER_LOCAL_TX, statsToValidate, numOfWriteTx != 0 ? (double)numOfLocks * 1.0 / (double)numOfWriteTx : 0.0);
        this.assertAttributeValue(ExtendedStatistic.NUM_LOCK_PER_REMOTE_TX, statsToValidate, 0.0);
        this.assertAttributeValue(ExtendedStatistic.LOCK_HOLD_TIME_SUCCESS_LOCAL_TX, statsToValidate, 0.0);
        this.assertAttributeValue(ExtendedStatistic.NUM_HELD_LOCKS_SUCCESS_LOCAL_TX, statsToValidate, !abort && numOfWriteTx != 0 ? (double)numOfLocks * 1.0 / (double)numOfWriteTx : 0.0);
        this.assertAttributeValue(ExtendedStatistic.LOCK_HOLD_TIME, statsToValidate, numOfLocks != 0 ? MICROSECONDS : 0.0);
        this.assertAttributeValue(ExtendedStatistic.NUM_HELD_LOCKS, statsToValidate, numOfLocks);
        this.assertAttributeValue(ExtendedStatistic.NUM_WAITED_FOR_LOCKS, statsToValidate, 0.0);
        this.assertAttributeValue(ExtendedStatistic.LOCK_WAITING_TIME, statsToValidate, 0.0);
        this.assertAttributeValue(ExtendedStatistic.NUM_LOCK_FAILED_TIMEOUT, statsToValidate, 0.0);
        this.assertAttributeValue(ExtendedStatistic.NUM_LOCK_FAILED_DEADLOCK, statsToValidate, 0.0);
    }

    private void assertAccessesValues(EnumSet<ExtendedStatistic> statsToValidate, int getsReadTx, int getsWriteTx, int puts, int numOfWriteTx, int numOfReadTx, boolean abort) {
        this.log.infof("Check accesses values. getsReadTx=%s, getsWriteTx=%s, puts=%s, writeTx=%s, readTx=%s, abort?=%s", new Object[]{getsReadTx, getsWriteTx, puts, numOfWriteTx, numOfReadTx, abort});
        this.assertAttributeValue(ExtendedStatistic.NUM_REMOTE_PUT, statsToValidate, 0.0);
        this.assertAttributeValue(ExtendedStatistic.REMOTE_PUT_EXECUTION, statsToValidate, 0.0);
        this.assertAttributeValue(ExtendedStatistic.LOCAL_PUT_EXECUTION, statsToValidate, 0.0);
        this.assertAttributeValue(ExtendedStatistic.NUM_PUT, statsToValidate, puts);
        this.assertAttributeValue(ExtendedStatistic.NUM_PUTS_WR_TX, statsToValidate, !abort && numOfWriteTx != 0 ? (double)puts * 1.0 / (double)numOfWriteTx : 0.0);
        this.assertAttributeValue(ExtendedStatistic.NUM_REMOTE_PUTS_WR_TX, statsToValidate, 0.0);
        this.assertAttributeValue(ExtendedStatistic.NUM_REMOTE_GET, statsToValidate, 0.0);
        this.assertAttributeValue(ExtendedStatistic.NUM_GET, statsToValidate, getsReadTx + getsWriteTx);
        this.assertAttributeValue(ExtendedStatistic.NUM_GETS_RO_TX, statsToValidate, !abort && numOfReadTx != 0 ? (double)getsReadTx * 1.0 / (double)numOfReadTx : 0.0);
        this.assertAttributeValue(ExtendedStatistic.NUM_GETS_WR_TX, statsToValidate, !abort && numOfWriteTx != 0 ? (double)getsWriteTx * 1.0 / (double)numOfWriteTx : 0.0);
        this.assertAttributeValue(ExtendedStatistic.NUM_REMOTE_GETS_WR_TX, statsToValidate, 0.0);
        this.assertAttributeValue(ExtendedStatistic.NUM_REMOTE_GETS_RO_TX, statsToValidate, 0.0);
        this.assertAttributeValue(ExtendedStatistic.ALL_GET_EXECUTION, statsToValidate, getsReadTx + getsWriteTx);
        this.assertAttributeValue(ExtendedStatistic.LOCAL_GET_EXECUTION, statsToValidate, getsReadTx != 0 || getsWriteTx != 0 ? MICROSECONDS : 0.0);
        this.assertAttributeValue(ExtendedStatistic.REMOTE_GET_EXECUTION, statsToValidate, 0.0);
        this.assertAttributeValue(ExtendedStatistic.NUM_SYNC_GET, statsToValidate, 0.0);
        this.assertAttributeValue(ExtendedStatistic.SYNC_GET_TIME, statsToValidate, 0.0);
        this.assertAttributeValue(ExtendedStatistic.NUM_NODES_GET, statsToValidate, 0.0);
    }

    private void resetStats() {
        this.extendedStatisticInterceptor.resetStatistics();
        for (ExtendedStatistic extendedStatistic : ExtendedStatistic.values()) {
            Assert.assertEquals((Object)this.extendedStatisticInterceptor.getAttribute(extendedStatistic), (Object)0.0, (String)("Attribute " + extendedStatistic + " is not zero after reset"));
        }
    }

    private void assertAttributeValue(ExtendedStatistic attr, EnumSet<ExtendedStatistic> statsToValidate, double txExecutorValue) {
        Assert.assertTrue((boolean)statsToValidate.contains(attr), (String)("Attribute " + attr + " already validated"));
        Assert.assertEquals((Object)this.extendedStatisticInterceptor.getAttribute(attr), (Object)txExecutorValue, (String)("Attribute " + attr + " has wrong value for cache."));
        statsToValidate.remove(attr);
    }

    private EnumSet<ExtendedStatistic> getStatsToValidate() {
        EnumSet<ExtendedStatistic> statsToValidate = EnumSet.allOf(ExtendedStatistic.class);
        statsToValidate.removeAll(EnumSet.of(ExtendedStatistic.PREPARE_COMMAND_SIZE, ExtendedStatistic.COMMIT_COMMAND_SIZE, ExtendedStatistic.CLUSTERED_GET_COMMAND_SIZE));
        return statsToValidate;
    }

    private void assertAllStatsValidated(EnumSet<ExtendedStatistic> statsToValidate) {
        Assert.assertTrue((boolean)statsToValidate.isEmpty(), (String)("Stats not validated: " + statsToValidate + "."));
    }

    private static enum WriteOperation {
        PUT,
        PUT_IF,
        REPLACE,
        REPLACE_IF,
        REMOVE,
        REMOVE_IF;

    }
}

