/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stats;

import java.util.concurrent.CompletableFuture;
import org.infinispan.Cache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.DistributionTestHelper;
import org.infinispan.interceptors.DDSequentialInterceptor;
import org.infinispan.interceptors.SequentialInterceptor;
import org.infinispan.interceptors.SequentialInterceptorChain;
import org.infinispan.interceptors.impl.TxInterceptor;
import org.infinispan.stats.topK.CacheUsageInterceptor;
import org.infinispan.test.MultipleCacheManagersTest;

public abstract class AbstractTopKeyTest
extends MultipleCacheManagersTest {
    private static boolean isOwner(Cache<?, ?> cache, Object key) {
        DistributionManager dm = cache.getAdvancedCache().getDistributionManager();
        return dm == null || dm.locate(key).contains(DistributionTestHelper.addressOf(cache));
    }

    protected CacheUsageInterceptor getTopKey(Cache<?, ?> cache) {
        SequentialInterceptorChain interceptorChain = cache.getAdvancedCache().getSequentialInterceptorChain();
        return (CacheUsageInterceptor)interceptorChain.findInterceptorExtending(CacheUsageInterceptor.class);
    }

    protected void assertTopKeyAccesses(Cache<?, ?> cache, String key, long expected, boolean readAccesses) {
        CacheUsageInterceptor topK = this.getTopKey(cache);
        boolean isLocal = AbstractTopKeyTest.isOwner(cache, key);
        this.eventuallyEquals(String.format("Wrong number of accesses for key '%s' and cache '%s'.", key, DistributionTestHelper.addressOf(cache)), expected, () -> {
            if (readAccesses) {
                return (isLocal ? topK.getLocalTopGets() : topK.getRemoteTopGets()).getOrDefault(key, 0L);
            }
            return (isLocal ? topK.getLocalTopPuts() : topK.getRemoteTopPuts()).getOrDefault(key, 0L);
        });
    }

    protected void assertWriteSkew(Cache<?, ?> cache, String key, long expected) {
        CacheUsageInterceptor topK = this.getTopKey(cache);
        this.eventuallyEquals(String.format("Wrong number of write skew for key '%s' and cache '%s'.", key, DistributionTestHelper.addressOf(cache)), expected, () -> topK.getTopWriteSkewFailedKeys().getOrDefault(key, 0L));
    }

    private void assertTopKeyLocked(Cache<?, ?> cache, String key, long expected) {
        CacheUsageInterceptor topK = this.getTopKey(cache);
        this.eventuallyEquals(String.format("Wrong number of locked key for key '%s' and cache '%s'.", key, DistributionTestHelper.addressOf(cache)), expected, () -> topK.getTopLockedKeys().getOrDefault(key, 0L));
    }

    private void assertTopKeyLockContented(Cache<?, ?> cache, String key, long expected) {
        CacheUsageInterceptor topK = this.getTopKey(cache);
        this.eventuallyEquals(String.format("Wrong number of contented key for key '%s' and cache '%s'.", key, DistributionTestHelper.addressOf(cache)), expected, () -> topK.getTopContendedKeys().getOrDefault(key, 0L));
    }

    private void assertTopKeyLockFailed(Cache<?, ?> cache, String key, long expected) {
        CacheUsageInterceptor topK = this.getTopKey(cache);
        this.eventuallyEquals(String.format("Wrong number of failed locked key for key '%s' and cache '%s'.", key, DistributionTestHelper.addressOf(cache)), expected, () -> topK.getTopLockFailedKeys().getOrDefault(key, 0L));
    }

    protected void assertLockInformation(Cache<?, ?> cache, String key, long locked, long contented, long failed) {
        this.assertTopKeyLocked(cache, key, locked);
        this.assertTopKeyLockContented(cache, key, contented);
        this.assertTopKeyLockFailed(cache, key, failed);
    }

    protected PrepareCommandBlocker addPrepareBlockerIfAbsent(Cache<?, ?> cache) {
        SequentialInterceptorChain chain = cache.getAdvancedCache().getSequentialInterceptorChain();
        PrepareCommandBlocker blocker = (PrepareCommandBlocker)chain.findInterceptorWithClass(PrepareCommandBlocker.class);
        if (blocker != null) {
            return blocker;
        }
        blocker = new PrepareCommandBlocker();
        chain.addInterceptorBefore((SequentialInterceptor)blocker, TxInterceptor.class);
        return blocker;
    }

    protected class PrepareCommandBlocker
    extends DDSequentialInterceptor {
        private boolean unblock = false;
        private boolean prepareBlocked = false;

        protected PrepareCommandBlocker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CompletableFuture<Void> visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
            Object retVal = ctx.forkInvocationSync((VisitableCommand)command);
            PrepareCommandBlocker prepareCommandBlocker = this;
            synchronized (prepareCommandBlocker) {
                this.prepareBlocked = true;
                ((Object)((Object)this)).notifyAll();
                while (!this.unblock) {
                    ((Object)((Object)this)).wait();
                }
            }
            return ctx.shortCircuit(retVal);
        }

        public synchronized void reset() {
            this.unblock = false;
            this.prepareBlocked = false;
        }

        public synchronized void unblock() {
            this.unblock = true;
            ((Object)((Object)this)).notifyAll();
        }

        public synchronized void awaitUntilPrepareBlocked() throws InterruptedException {
            while (!this.prepareBlocked) {
                ((Object)((Object)this)).wait();
            }
        }
    }
}

