/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stats.simple;

import java.util.HashMap;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.InterceptorConfiguration;
import org.infinispan.interceptors.SequentialInterceptor;
import org.infinispan.interceptors.SequentialInterceptorChain;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.stats.wrappers.ExtendedStatisticInterceptor;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="stats.simple.LocalExtendedStatisticTest")
public class LocalExtendedStatisticTest
extends SingleCacheManagerTest {
    private static final String KEY_1 = "key_1";
    private static final String KEY_2 = "key_2";
    private static final String KEY_3 = "key_3";
    private static final String VALUE_1 = "value_1";
    private static final String VALUE_2 = "value_2";
    private static final String VALUE_3 = "value_3";
    private static final String VALUE_4 = "value_4";

    public void testPut() {
        this.assertEmpty(KEY_1, KEY_2, KEY_3);
        ExtendedStatisticInterceptor statisticInterceptor = this.getExtendedStatistic(this.cache);
        this.cache.put((Object)KEY_1, (Object)VALUE_1);
        this.assertCacheValue(KEY_1, VALUE_1);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(KEY_2, VALUE_2);
        map.put(KEY_3, VALUE_3);
        this.cache.putAll(map);
        this.assertCacheValue(KEY_1, VALUE_1);
        this.assertCacheValue(KEY_2, VALUE_2);
        this.assertCacheValue(KEY_3, VALUE_3);
        this.assertNoTransactions();
        Assert.assertFalse((boolean)statisticInterceptor.getCacheStatisticManager().hasPendingTransactions());
    }

    public void removeTest() {
        this.assertEmpty(KEY_1);
        ExtendedStatisticInterceptor statisticInterceptor = this.getExtendedStatistic(this.cache);
        this.cache.put((Object)KEY_1, (Object)VALUE_1);
        this.assertCacheValue(KEY_1, VALUE_1);
        this.cache.remove((Object)KEY_1);
        this.assertCacheValue(KEY_1, null);
        this.cache.put((Object)KEY_1, (Object)VALUE_1);
        this.assertCacheValue(KEY_1, VALUE_1);
        this.cache.remove((Object)KEY_1);
        this.assertCacheValue(KEY_1, null);
        this.assertNoTransactions();
        Assert.assertFalse((boolean)statisticInterceptor.getCacheStatisticManager().hasPendingTransactions());
    }

    public void testPutIfAbsent() {
        this.assertEmpty(KEY_1, KEY_2);
        ExtendedStatisticInterceptor statisticInterceptor = this.getExtendedStatistic(this.cache);
        this.cache.put((Object)KEY_1, (Object)VALUE_1);
        this.assertCacheValue(KEY_1, VALUE_1);
        this.cache.putIfAbsent((Object)KEY_1, (Object)VALUE_2);
        this.assertCacheValue(KEY_1, VALUE_1);
        this.cache.put((Object)KEY_1, (Object)VALUE_3);
        this.assertCacheValue(KEY_1, VALUE_3);
        this.cache.putIfAbsent((Object)KEY_1, (Object)VALUE_4);
        this.assertCacheValue(KEY_1, VALUE_3);
        this.cache.putIfAbsent((Object)KEY_2, (Object)VALUE_1);
        this.assertCacheValue(KEY_2, VALUE_1);
        this.assertNoTransactions();
        Assert.assertFalse((boolean)statisticInterceptor.getCacheStatisticManager().hasPendingTransactions());
    }

    public void testRemoveIfPresent() {
        this.assertEmpty(KEY_1);
        ExtendedStatisticInterceptor statisticInterceptor = this.getExtendedStatistic(this.cache);
        this.cache.put((Object)KEY_1, (Object)VALUE_1);
        this.assertCacheValue(KEY_1, VALUE_1);
        this.cache.put((Object)KEY_1, (Object)VALUE_2);
        this.assertCacheValue(KEY_1, VALUE_2);
        this.cache.remove((Object)KEY_1, (Object)VALUE_1);
        this.assertCacheValue(KEY_1, VALUE_2);
        this.cache.remove((Object)KEY_1, (Object)VALUE_2);
        this.assertCacheValue(KEY_1, null);
        this.assertNoTransactions();
        Assert.assertFalse((boolean)statisticInterceptor.getCacheStatisticManager().hasPendingTransactions());
    }

    public void testClear() {
        this.assertEmpty(KEY_1);
        ExtendedStatisticInterceptor statisticInterceptor = this.getExtendedStatistic(this.cache);
        this.cache.put((Object)KEY_1, (Object)VALUE_1);
        this.assertCacheValue(KEY_1, VALUE_1);
        this.cache.clear();
        this.assertCacheValue(KEY_1, null);
        this.assertNoTransactions();
        Assert.assertFalse((boolean)statisticInterceptor.getCacheStatisticManager().hasPendingTransactions());
    }

    public void testReplace() {
        this.assertEmpty(KEY_1);
        ExtendedStatisticInterceptor statisticInterceptor = this.getExtendedStatistic(this.cache);
        this.cache.put((Object)KEY_1, (Object)VALUE_1);
        this.assertCacheValue(KEY_1, VALUE_1);
        Assert.assertEquals((Object)this.cache.replace((Object)KEY_1, (Object)VALUE_2), (Object)VALUE_1);
        this.assertCacheValue(KEY_1, VALUE_2);
        this.cache.put((Object)KEY_1, (Object)VALUE_3);
        this.assertCacheValue(KEY_1, VALUE_3);
        this.cache.replace((Object)KEY_1, (Object)VALUE_3);
        this.assertCacheValue(KEY_1, VALUE_3);
        this.cache.put((Object)KEY_1, (Object)VALUE_4);
        this.assertCacheValue(KEY_1, VALUE_4);
        this.assertNoTransactions();
        Assert.assertFalse((boolean)statisticInterceptor.getCacheStatisticManager().hasPendingTransactions());
    }

    public void testReplaceWithOldVal() {
        this.assertEmpty(KEY_1);
        ExtendedStatisticInterceptor statisticInterceptor = this.getExtendedStatistic(this.cache);
        this.cache.put((Object)KEY_1, (Object)VALUE_1);
        this.assertCacheValue(KEY_1, VALUE_1);
        this.cache.put((Object)KEY_1, (Object)VALUE_2);
        this.assertCacheValue(KEY_1, VALUE_2);
        this.cache.replace((Object)KEY_1, (Object)VALUE_3, (Object)VALUE_4);
        this.assertCacheValue(KEY_1, VALUE_2);
        this.cache.replace((Object)KEY_1, (Object)VALUE_2, (Object)VALUE_4);
        this.assertCacheValue(KEY_1, VALUE_4);
        this.assertNoTransactions();
        Assert.assertFalse((boolean)statisticInterceptor.getCacheStatisticManager().hasPendingTransactions());
    }

    public void testRemoveUnexistingEntry() {
        this.assertEmpty(KEY_1);
        ExtendedStatisticInterceptor statisticInterceptor = this.getExtendedStatistic(this.cache);
        this.cache.remove((Object)KEY_1);
        this.assertCacheValue(KEY_1, null);
        this.assertNoTransactions();
        Assert.assertFalse((boolean)statisticInterceptor.getCacheStatisticManager().hasPendingTransactions());
    }

    protected void assertEmpty(Object ... keys) {
        for (Object key : keys) {
            Assert.assertNull((Object)this.cache.get(key));
        }
    }

    protected void assertCacheValue(Object key, Object value) {
        Assert.assertEquals((Object)this.cache.get(key), (Object)value);
    }

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = LocalExtendedStatisticTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.LOCAL, (boolean)true);
        builder.locking().isolationLevel(IsolationLevel.REPEATABLE_READ);
        builder.transaction().recovery().disable();
        builder.customInterceptors().addInterceptor().interceptor((SequentialInterceptor)new ExtendedStatisticInterceptor()).position(InterceptorConfiguration.Position.FIRST);
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)builder);
    }

    private ExtendedStatisticInterceptor getExtendedStatistic(Cache<?, ?> cache) {
        SequentialInterceptorChain interceptorChain = cache.getAdvancedCache().getSequentialInterceptorChain();
        ExtendedStatisticInterceptor extendedStatisticInterceptor = (ExtendedStatisticInterceptor)interceptorChain.findInterceptorExtending(ExtendedStatisticInterceptor.class);
        if (extendedStatisticInterceptor != null) {
            extendedStatisticInterceptor.resetStatistics();
        }
        return extendedStatisticInterceptor;
    }
}

