/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stats;

import java.lang.reflect.Method;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.VersioningScheme;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.DistributionTestHelper;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.impl.TxInterceptor;
import org.infinispan.stats.AbstractTopKeyTest;
import org.infinispan.stats.topK.CacheUsageInterceptor;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterTest;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
@CleanupAfterTest
public abstract class BaseClusterTopKeyTest
extends AbstractTopKeyTest {
    private final CacheMode cacheMode;
    private final int clusterSize;

    protected BaseClusterTopKeyTest(CacheMode cacheMode, int clusterSize) {
        this.cacheMode = cacheMode;
        this.clusterSize = clusterSize;
    }

    @BeforeMethod(alwaysRun=true)
    public void resetBeforeTest() {
        this.caches().forEach(cache -> this.getTopKey((Cache<?, ?>)cache).resetStatistics());
    }

    public void testPut(Method method) {
        String key1 = TestingUtil.k((Method)method, (int)1);
        String key2 = TestingUtil.k((Method)method, (int)2);
        this.cache(0).put((Object)key1, (Object)"value1");
        this.cache(0).put((Object)key2, (Object)"value2");
        this.assertNoLocks(key1);
        this.assertNoLocks(key2);
        this.cache(1).put((Object)key1, (Object)"value3");
        this.cache(1).put((Object)key2, (Object)"value4");
        this.assertTopKeyAccesses(this.cache(0), key1, 1L, false);
        this.assertTopKeyAccesses(this.cache(0), key2, 1L, false);
        this.assertTopKeyAccesses(this.cache(0), key1, 0L, true);
        this.assertTopKeyAccesses(this.cache(0), key2, 0L, true);
        this.assertTopKeyAccesses(this.cache(1), key1, 1L, false);
        this.assertTopKeyAccesses(this.cache(1), key2, 1L, false);
        this.assertTopKeyAccesses(this.cache(1), key1, 0L, true);
        this.assertTopKeyAccesses(this.cache(1), key2, 0L, true);
        if (this.isPrimaryOwner(this.cache(0), key1)) {
            this.assertLockInformation(this.cache(0), key1, 2L, 0L, 0L);
            this.assertLockInformation(this.cache(1), key1, 0L, 0L, 0L);
        } else {
            this.assertLockInformation(this.cache(0), key1, 0L, 0L, 0L);
            this.assertLockInformation(this.cache(1), key1, 2L, 0L, 0L);
        }
        if (this.isPrimaryOwner(this.cache(0), key2)) {
            this.assertLockInformation(this.cache(0), key2, 2L, 0L, 0L);
            this.assertLockInformation(this.cache(1), key2, 0L, 0L, 0L);
        } else {
            this.assertLockInformation(this.cache(0), key2, 0L, 0L, 0L);
            this.assertLockInformation(this.cache(1), key2, 2L, 0L, 0L);
        }
        this.assertWriteSkew(this.cache(0), key1, 0L);
        this.assertWriteSkew(this.cache(0), key2, 0L);
        this.assertWriteSkew(this.cache(1), key1, 0L);
        this.assertWriteSkew(this.cache(1), key2, 0L);
    }

    public void testGet(Method method) {
        String key1 = TestingUtil.k((Method)method, (int)1);
        String key2 = TestingUtil.k((Method)method, (int)2);
        this.cache(0).get((Object)key1);
        this.cache(0).get((Object)key2);
        this.cache(1).get((Object)key1);
        this.cache(1).get((Object)key2);
        this.assertTopKeyAccesses(this.cache(0), key1, 0L, false);
        this.assertTopKeyAccesses(this.cache(0), key2, 0L, false);
        this.assertTopKeyAccesses(this.cache(0), key1, 1L, true);
        this.assertTopKeyAccesses(this.cache(0), key2, 1L, true);
        this.assertTopKeyAccesses(this.cache(1), key1, 0L, false);
        this.assertTopKeyAccesses(this.cache(1), key2, 0L, false);
        this.assertTopKeyAccesses(this.cache(1), key1, 1L, true);
        this.assertTopKeyAccesses(this.cache(1), key2, 1L, true);
        this.assertLockInformation(this.cache(0), key1, 0L, 0L, 0L);
        this.assertLockInformation(this.cache(0), key2, 0L, 0L, 0L);
        this.assertLockInformation(this.cache(1), key1, 0L, 0L, 0L);
        this.assertLockInformation(this.cache(1), key2, 0L, 0L, 0L);
        this.assertWriteSkew(this.cache(0), key1, 0L);
        this.assertWriteSkew(this.cache(0), key2, 0L);
        this.assertWriteSkew(this.cache(1), key1, 0L);
        this.assertWriteSkew(this.cache(1), key2, 0L);
    }

    public void testLockFailed(Method method) throws InterruptedException, TimeoutException, ExecutionException {
        Cache nonPrimary;
        Cache primary;
        String key = TestingUtil.k((Method)method, (int)0);
        if (this.isPrimaryOwner(this.cache(0), key)) {
            primary = this.cache(0);
            nonPrimary = this.cache(1);
        } else {
            primary = this.cache(1);
            nonPrimary = this.cache(0);
        }
        AbstractTopKeyTest.PrepareCommandBlocker blocker = this.addPrepareBlockerIfAbsent(primary);
        blocker.reset();
        Future f = this.fork(() -> {
            nonPrimary.put((Object)key, (Object)"value");
            return null;
        });
        blocker.awaitUntilPrepareBlocked();
        try {
            primary.put((Object)key, (Object)"value");
            Assert.fail((String)"The key should be locked!");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        blocker.unblock();
        f.get(30L, TimeUnit.SECONDS);
        this.assertTopKeyAccesses(this.cache(0), key, 1L, false);
        this.assertTopKeyAccesses(this.cache(0), key, 0L, true);
        this.assertTopKeyAccesses(this.cache(1), key, 1L, false);
        this.assertTopKeyAccesses(this.cache(1), key, 0L, true);
        this.assertLockInformation(primary, key, 2L, 1L, 1L);
        this.assertLockInformation(nonPrimary, key, 0L, 0L, 0L);
        this.assertWriteSkew(this.cache(0), key, 0L);
        this.assertWriteSkew(this.cache(1), key, 0L);
    }

    public void testWriteSkew(Method method) throws InterruptedException, SystemException, NotSupportedException {
        Cache nonPrimary;
        Cache primary;
        String key = TestingUtil.k((Method)method, (int)0);
        if (this.isPrimaryOwner(this.cache(0), key)) {
            primary = this.cache(0);
            nonPrimary = this.cache(1);
        } else {
            primary = this.cache(1);
            nonPrimary = this.cache(0);
        }
        this.tm(primary).begin();
        primary.put((Object)key, (Object)"value");
        Transaction transaction = this.tm(primary).suspend();
        primary.put((Object)key, (Object)"value");
        try {
            this.tm(primary).resume(transaction);
            this.tm(primary).commit();
            Assert.fail((String)"The write skew should be detected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertTopKeyAccesses(primary, key, 2L, false);
        this.assertTopKeyAccesses(primary, key, 0L, true);
        this.assertTopKeyAccesses(nonPrimary, key, 0L, false);
        this.assertTopKeyAccesses(nonPrimary, key, 0L, true);
        this.assertLockInformation(primary, key, 2L, 0L, 0L);
        this.assertLockInformation(nonPrimary, key, 0L, 0L, 0L);
        this.assertWriteSkew(primary, key, 1L);
        this.assertWriteSkew(nonPrimary, key, 0L);
    }

    protected void createCacheManagers() throws Throwable {
        for (int i = 0; i < this.clusterSize; ++i) {
            ConfigurationBuilder builder = BaseClusterTopKeyTest.getDefaultClusteredCacheConfig((CacheMode)this.cacheMode, (boolean)true);
            builder.customInterceptors().addInterceptor().before(TxInterceptor.class).interceptor((AsyncInterceptor)new CacheUsageInterceptor());
            builder.versioning().enabled(true).scheme(VersioningScheme.SIMPLE);
            builder.transaction().syncCommitPhase(true).syncRollbackPhase(true);
            builder.locking().isolationLevel(IsolationLevel.REPEATABLE_READ).writeSkewCheck(true).lockAcquisitionTimeout(TestingUtil.shortTimeoutMillis());
            this.addClusterEnabledCacheManager(builder);
        }
        this.waitForClusterToForm();
    }

    protected boolean isPrimaryOwner(Cache<?, ?> cache, Object key) {
        DistributionManager dm = cache.getAdvancedCache().getDistributionManager();
        return dm.getPrimaryLocation(key).equals(DistributionTestHelper.addressOf(cache));
    }

    private void assertNoLocks(String key) {
        for (Cache cache : this.caches()) {
            this.assertEventuallyNotLocked(cache, key);
        }
    }
}

