/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stats.container;

public enum ExtendedStatistic {
    NUM_COMMITTED_WR_TX(true, true),
    NUM_ABORTED_WR_TX(true, true),
    WR_TX_ABORTED_EXECUTION_TIME(true, true),
    WR_TX_SUCCESSFUL_EXECUTION_TIME(true, true),
    LOCAL_EXEC_NO_CONT(true, false),
    NUM_COMMITTED_RO_TX(true, true),
    NUM_ABORTED_RO_TX(true, true),
    RO_TX_SUCCESSFUL_EXECUTION_TIME(true, true),
    RO_TX_ABORTED_EXECUTION_TIME(true, true),
    NUM_PUTS_WR_TX(true, false),
    NUM_REMOTE_PUTS_WR_TX(true, false),
    NUM_GETS_WR_TX(true, false),
    NUM_REMOTE_GETS_WR_TX(true, false),
    NUM_GETS_RO_TX(true, false),
    NUM_REMOTE_GETS_RO_TX(true, false),
    NUM_REMOTE_GET(true, false),
    NUM_GET(true, false),
    NUM_REMOTE_PUT(true, false),
    NUM_PUT(true, false),
    REMOTE_GET_EXECUTION(true, false),
    LOCAL_GET_EXECUTION(true, false),
    ALL_GET_EXECUTION(true, false),
    REMOTE_PUT_EXECUTION(true, false),
    LOCAL_PUT_EXECUTION(true, false),
    NUM_COMMITTED_TX(false, false),
    NUM_LOCAL_COMMITTED_TX(false, false),
    LOCK_HOLD_TIME(true, true),
    NUM_HELD_LOCKS(true, true),
    LOCK_HOLD_TIME_SUCCESS_LOCAL_TX(true, false),
    NUM_HELD_LOCKS_SUCCESS_LOCAL_TX(true, false),
    NUM_LOCK_FAILED_TIMEOUT(true, false),
    NUM_LOCK_FAILED_DEADLOCK(true, false),
    NUM_WAITED_FOR_LOCKS(true, true),
    LOCK_WAITING_TIME(true, true),
    LOCK_HOLD_TIME_LOCAL(false, false),
    LOCK_HOLD_TIME_REMOTE(false, false),
    NUM_LOCK_PER_LOCAL_TX(false, false),
    NUM_LOCK_PER_REMOTE_TX(false, false),
    WRITE_TX_PERCENTAGE(false, false),
    SUCCESSFUL_WRITE_TX_PERCENTAGE(false, false),
    NUM_WRITE_SKEW(true, false),
    WRITE_SKEW_PROBABILITY(false, false),
    ABORT_RATE(false, false),
    ARRIVAL_RATE(false, false),
    THROUGHPUT(false, false),
    PREPARE_EXECUTION_TIME(true, true),
    NUM_PREPARE_COMMAND(true, true),
    LOCAL_PREPARE_EXECUTION_TIME(false, false),
    REMOTE_PREPARE_EXECUTION_TIME(false, false),
    COMMIT_EXECUTION_TIME(true, true),
    NUM_COMMIT_COMMAND(true, true),
    LOCAL_COMMIT_EXECUTION_TIME(false, false),
    REMOTE_COMMIT_EXECUTION_TIME(false, false),
    ROLLBACK_EXECUTION_TIME(true, true),
    NUM_ROLLBACK_COMMAND(true, true),
    LOCAL_ROLLBACK_EXECUTION_TIME(false, false),
    REMOTE_ROLLBACK_EXECUTION_TIME(false, false),
    PREPARE_COMMAND_SIZE(true, false),
    COMMIT_COMMAND_SIZE(true, false),
    CLUSTERED_GET_COMMAND_SIZE(true, false),
    NUM_SYNC_PREPARE(true, false),
    SYNC_PREPARE_TIME(true, false),
    NUM_SYNC_COMMIT(true, false),
    SYNC_COMMIT_TIME(true, false),
    NUM_SYNC_ROLLBACK(true, false),
    SYNC_ROLLBACK_TIME(true, false),
    NUM_SYNC_GET(true, false),
    SYNC_GET_TIME(true, false),
    ASYNC_COMPLETE_NOTIFY_TIME(true, false),
    NUM_ASYNC_COMPLETE_NOTIFY(true, false),
    NUM_NODES_PREPARE(true, false),
    NUM_NODES_COMMIT(true, false),
    NUM_NODES_ROLLBACK(true, false),
    NUM_NODES_COMPLETE_NOTIFY(true, false),
    NUM_NODES_GET(true, false),
    RESPONSE_TIME(false, false);

    public static final int NO_INDEX = -1;
    private static short localStatsSize;
    private static short remoteStatsSize;
    private final boolean local;
    private final boolean remote;
    private short localIndex = (short)-1;
    private short remoteIndex = (short)-1;

    private ExtendedStatistic(boolean local, boolean remote) {
        this.local = local;
        this.remote = remote;
    }

    public final int getLocalIndex() {
        return this.localIndex;
    }

    public final int getRemoteIndex() {
        return this.remoteIndex;
    }

    public final boolean isLocal() {
        return this.local;
    }

    public final boolean isRemote() {
        return this.remote;
    }

    public static int getRemoteStatsSize() {
        return remoteStatsSize;
    }

    public static int getLocalStatsSize() {
        return localStatsSize;
    }

    static {
        localStatsSize = 0;
        remoteStatsSize = 0;
        for (ExtendedStatistic stat : ExtendedStatistic.values()) {
            if (stat.local) {
                localStatsSize = (short)(localStatsSize + 1);
                stat.localIndex = stat.localIndex;
            }
            if (!stat.remote) continue;
            remoteStatsSize = (short)(remoteStatsSize + 1);
            stat.remoteIndex = stat.remoteIndex;
        }
    }
}

