/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stats.wrappers;

import java.io.IOException;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.remote.recovery.TxCompletionNotificationCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.time.TimeService;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.rpc.RpcOptionsBuilder;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.stats.CacheStatisticManager;
import org.infinispan.stats.container.ExtendedStatistic;
import org.infinispan.stats.logging.Log;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.logging.LogFactory;

public class ExtendedStatisticRpcManager
implements RpcManager {
    private static final Log log = (Log)LogFactory.getLog(ExtendedStatisticRpcManager.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    private final RpcManager actual;
    private final CacheStatisticManager cacheStatisticManager;
    private final StreamingMarshaller marshaller;
    private final TimeService timeService;

    public ExtendedStatisticRpcManager(RpcManager actual, CacheStatisticManager cacheStatisticManager, TimeService timeService, StreamingMarshaller marshaller) {
        this.actual = actual;
        this.cacheStatisticManager = cacheStatisticManager;
        this.marshaller = marshaller;
        this.timeService = timeService;
    }

    public <T> CompletionStage<T> invokeCommand(Address target, ReplicableCommand command, ResponseCollector<T> collector, RpcOptions rpcOptions) {
        long start = this.timeService.time();
        CompletionStage request = this.actual.invokeCommand(target, command, collector, rpcOptions);
        return request.thenApply(responseMap -> {
            this.updateStats(command, true, this.timeService.timeDuration(start, TimeUnit.NANOSECONDS), Collections.singleton(target));
            return responseMap;
        });
    }

    public <T> CompletionStage<T> invokeCommand(Collection<Address> targets, ReplicableCommand command, ResponseCollector<T> collector, RpcOptions rpcOptions) {
        long start = this.timeService.time();
        CompletionStage request = this.actual.invokeCommand(targets, command, collector, rpcOptions);
        return request.thenApply(responseMap -> {
            this.updateStats(command, true, this.timeService.timeDuration(start, TimeUnit.NANOSECONDS), targets);
            return responseMap;
        });
    }

    public <T> CompletionStage<T> invokeCommandOnAll(ReplicableCommand command, ResponseCollector<T> collector, RpcOptions rpcOptions) {
        long start = this.timeService.time();
        CompletionStage request = this.actual.invokeCommandOnAll(command, collector, rpcOptions);
        return request.thenApply(responseMap -> {
            this.updateStats(command, true, this.timeService.timeDuration(start, TimeUnit.NANOSECONDS), this.actual.getTransport().getMembers());
            return responseMap;
        });
    }

    public <T> CompletionStage<T> invokeCommandStaggered(Collection<Address> targets, ReplicableCommand command, ResponseCollector<T> collector, RpcOptions rpcOptions) {
        long start = this.timeService.time();
        CompletionStage request = this.actual.invokeCommandStaggered(targets, command, collector, rpcOptions);
        return request.thenApply(responseMap -> {
            this.updateStats(command, true, this.timeService.timeDuration(start, TimeUnit.NANOSECONDS), targets);
            return responseMap;
        });
    }

    public <T> CompletionStage<T> invokeCommands(Collection<Address> targets, Function<Address, ReplicableCommand> commandGenerator, ResponseCollector<T> collector, RpcOptions rpcOptions) {
        long start = this.timeService.time();
        CompletionStage request = this.actual.invokeCommands(targets, commandGenerator, collector, rpcOptions);
        return request.thenApply(responseMap -> {
            targets.forEach(target -> this.updateStats((ReplicableCommand)commandGenerator.apply((Address)target), true, this.timeService.timeDuration(start, TimeUnit.NANOSECONDS), Collections.singleton(target)));
            return responseMap;
        });
    }

    public <T> T blocking(CompletionStage<T> request) {
        return (T)this.actual.blocking(request);
    }

    public CompletableFuture<Map<Address, Response>> invokeRemotelyAsync(Collection<Address> recipients, ReplicableCommand rpc, RpcOptions options) {
        long start = this.timeService.time();
        CompletableFuture future = this.actual.invokeRemotelyAsync(recipients, rpc, options);
        return future.thenApply(responseMap -> {
            this.updateStats(rpc, options.responseMode().isSynchronous(), this.timeService.timeDuration(start, TimeUnit.NANOSECONDS), recipients);
            return responseMap;
        });
    }

    public Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpc, RpcOptions options) {
        long start = this.timeService.time();
        Map responseMap = this.actual.invokeRemotely(recipients, rpc, options);
        this.updateStats(rpc, options.responseMode().isSynchronous(), this.timeService.timeDuration(start, TimeUnit.NANOSECONDS), recipients);
        return responseMap;
    }

    public Map<Address, Response> invokeRemotely(Map<Address, ReplicableCommand> rpcs, RpcOptions options) {
        long start = this.timeService.time();
        Map responseMap = this.actual.invokeRemotely(rpcs, options);
        for (Map.Entry<Address, ReplicableCommand> entry : rpcs.entrySet()) {
            this.updateStats(entry.getValue(), options.responseMode().isSynchronous(), this.timeService.timeDuration(start, TimeUnit.NANOSECONDS), Collections.singleton(entry.getKey()));
        }
        return responseMap;
    }

    public void sendTo(Address destination, ReplicableCommand command, DeliverOrder deliverOrder) {
        this.actual.sendTo(destination, command, deliverOrder);
    }

    public void sendToMany(Collection<Address> destinations, ReplicableCommand command, DeliverOrder deliverOrder) {
        this.actual.sendToMany(destinations, command, deliverOrder);
    }

    public void sendToAll(ReplicableCommand command, DeliverOrder deliverOrder) {
        this.actual.sendToAll(command, deliverOrder);
    }

    public RpcOptionsBuilder getRpcOptionsBuilder(ResponseMode responseMode) {
        return this.actual.getRpcOptionsBuilder(responseMode);
    }

    public RpcOptionsBuilder getRpcOptionsBuilder(ResponseMode responseMode, DeliverOrder deliverOrder) {
        return this.actual.getRpcOptionsBuilder(responseMode, deliverOrder);
    }

    public RpcOptions getDefaultRpcOptions(boolean sync) {
        return this.actual.getDefaultRpcOptions(sync);
    }

    public RpcOptions getDefaultRpcOptions(boolean sync, DeliverOrder deliverOrder) {
        return this.actual.getDefaultRpcOptions(sync, deliverOrder);
    }

    public Transport getTransport() {
        return this.actual.getTransport();
    }

    public List<Address> getMembers() {
        return this.actual.getMembers();
    }

    public Address getAddress() {
        return this.actual.getAddress();
    }

    public int getTopologyId() {
        return this.actual.getTopologyId();
    }

    public RpcOptions getSyncRpcOptions() {
        return this.actual.getSyncRpcOptions();
    }

    public RpcOptions getTotalSyncRpcOptions() {
        return this.actual.getTotalSyncRpcOptions();
    }

    private void updateStats(ReplicableCommand command, boolean sync, long duration, Collection<Address> recipients) {
        GlobalTransaction globalTransaction;
        ExtendedStatistic recipientSizeStat;
        ExtendedStatistic counterStat;
        ExtendedStatistic durationStat;
        ExtendedStatistic commandSizeStat = null;
        if (command instanceof PrepareCommand) {
            durationStat = ExtendedStatistic.SYNC_PREPARE_TIME;
            counterStat = ExtendedStatistic.NUM_SYNC_PREPARE;
            recipientSizeStat = ExtendedStatistic.NUM_NODES_PREPARE;
            commandSizeStat = ExtendedStatistic.PREPARE_COMMAND_SIZE;
            globalTransaction = ((PrepareCommand)command).getGlobalTransaction();
        } else if (command instanceof RollbackCommand) {
            durationStat = ExtendedStatistic.SYNC_ROLLBACK_TIME;
            counterStat = ExtendedStatistic.NUM_SYNC_ROLLBACK;
            recipientSizeStat = ExtendedStatistic.NUM_NODES_ROLLBACK;
            globalTransaction = ((RollbackCommand)command).getGlobalTransaction();
        } else if (command instanceof CommitCommand) {
            durationStat = ExtendedStatistic.SYNC_COMMIT_TIME;
            counterStat = ExtendedStatistic.NUM_SYNC_COMMIT;
            recipientSizeStat = ExtendedStatistic.NUM_NODES_COMMIT;
            commandSizeStat = ExtendedStatistic.COMMIT_COMMAND_SIZE;
            globalTransaction = ((CommitCommand)command).getGlobalTransaction();
        } else if (command instanceof TxCompletionNotificationCommand) {
            durationStat = ExtendedStatistic.ASYNC_COMPLETE_NOTIFY_TIME;
            counterStat = ExtendedStatistic.NUM_ASYNC_COMPLETE_NOTIFY;
            recipientSizeStat = ExtendedStatistic.NUM_NODES_COMPLETE_NOTIFY;
            globalTransaction = ((TxCompletionNotificationCommand)command).getGlobalTransaction();
        } else if (command instanceof ClusteredGetCommand && !((ClusteredGetCommand)command).isWrite()) {
            durationStat = ExtendedStatistic.SYNC_GET_TIME;
            counterStat = ExtendedStatistic.NUM_SYNC_GET;
            recipientSizeStat = ExtendedStatistic.NUM_NODES_GET;
            commandSizeStat = ExtendedStatistic.CLUSTERED_GET_COMMAND_SIZE;
            globalTransaction = null;
        } else {
            if (trace) {
                log.tracef("Does not update stats for command %s. The command is not needed", command);
            }
            return;
        }
        if (trace) {
            log.tracef("Update stats for command %s. Is sync? %s. Duration stat is %s, counter stats is %s, recipient size stat is %s", new Object[]{command, sync, durationStat, counterStat, recipientSizeStat});
        }
        this.cacheStatisticManager.add(durationStat, duration, globalTransaction, true);
        this.cacheStatisticManager.increment(counterStat, globalTransaction, true);
        this.cacheStatisticManager.add(recipientSizeStat, this.recipientListSize(recipients), globalTransaction, true);
        if (commandSizeStat != null) {
            this.cacheStatisticManager.add(commandSizeStat, this.getCommandSize(command), globalTransaction, true);
        }
    }

    private int recipientListSize(Collection<Address> recipients) {
        return recipients == null ? this.actual.getTransport().getMembers().size() : recipients.size();
    }

    private int getCommandSize(ReplicableCommand command) {
        try {
            CountingDataOutput dataOutput = new CountingDataOutput();
            ObjectOutput byteOutput = this.marshaller.startObjectOutput((OutputStream)dataOutput, false, 0);
            this.marshaller.objectToObjectStream((Object)command, byteOutput);
            this.marshaller.finishObjectOutput(byteOutput);
            return dataOutput.getCount();
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static class CountingDataOutput
    extends OutputStream {
        private int count = 0;

        private CountingDataOutput() {
        }

        public int getCount() {
            return this.count;
        }

        @Override
        public void write(int b) throws IOException {
            ++this.count;
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.count += b.length;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.count += len;
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

