/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stats.wrappers;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.infinispan.context.InvocationContext;
import org.infinispan.stats.topK.StreamSummaryContainer;
import org.infinispan.util.concurrent.locks.KeyAwareLockPromise;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.concurrent.locks.LockState;
import org.infinispan.util.concurrent.locks.impl.InfinispanLock;

public class TopKeyLockManager
implements LockManager {
    private final LockManager current;
    private final StreamSummaryContainer container;

    public TopKeyLockManager(LockManager current, StreamSummaryContainer container) {
        this.current = current;
        this.container = container;
    }

    public KeyAwareLockPromise lock(Object key, Object lockOwner, long time, TimeUnit unit) {
        if (this.lockOwnerAlreadyExists(key, lockOwner)) {
            return this.current.lock(key, lockOwner, time, unit);
        }
        KeyAwareLockPromise lockPromise = this.current.lock(key, lockOwner, time, unit);
        boolean contented = !lockOwner.equals(this.current.getOwner(key));
        lockPromise.addListener(state -> this.container.addLockInformation(key, contented, state != LockState.ACQUIRED));
        return lockPromise;
    }

    public KeyAwareLockPromise lockAll(Collection<?> keys, Object lockOwner, long time, TimeUnit unit) {
        Set keysToTrack = keys.stream().filter(key -> !this.lockOwnerAlreadyExists(key, lockOwner)).collect(Collectors.toSet());
        KeyAwareLockPromise lockPromise = this.current.lockAll(keys, lockOwner, time, unit);
        Set contentedKeys = keys.stream().filter(key -> !lockOwner.equals(this.current.getOwner(key))).collect(Collectors.toSet());
        lockPromise.addListener((lockedKey, state) -> {
            if (keysToTrack.contains(lockedKey)) {
                this.container.addLockInformation(lockedKey, contentedKeys.contains(lockedKey), state != LockState.ACQUIRED);
            }
        });
        return lockPromise;
    }

    public void unlock(Object key, Object lockOwner) {
        this.current.unlock(key, lockOwner);
    }

    public void unlockAll(Collection<?> keys, Object lockOwner) {
        this.current.unlockAll(keys, lockOwner);
    }

    public void unlockAll(InvocationContext ctx) {
        this.current.unlockAll(ctx);
    }

    public boolean ownsLock(Object key, Object owner) {
        return this.current.ownsLock(key, owner);
    }

    public boolean isLocked(Object key) {
        return this.current.isLocked(key);
    }

    public Object getOwner(Object key) {
        return this.current.getOwner(key);
    }

    public String printLockInfo() {
        return this.current.printLockInfo();
    }

    public int getNumberOfLocksHeld() {
        return this.current.getNumberOfLocksHeld();
    }

    public InfinispanLock getLock(Object key) {
        return this.current.getLock(key);
    }

    private boolean lockOwnerAlreadyExists(Object key, Object lockOwner) {
        InfinispanLock lock = this.current.getLock(key);
        return lock != null && lock.containsLockOwner(lockOwner);
    }
}

