/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stats.logic;

import java.util.EnumSet;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.transaction.RollbackException;
import javax.transaction.Transaction;
import org.infinispan.Cache;
import org.infinispan.commands.remote.recovery.TxCompletionNotificationCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commons.time.TimeService;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.impl.TxInterceptor;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.stats.CacheStatisticCollector;
import org.infinispan.stats.CacheStatisticManager;
import org.infinispan.stats.container.ConcurrentGlobalContainer;
import org.infinispan.stats.container.ExtendedStatistic;
import org.infinispan.stats.wrappers.ExtendedStatisticInterceptor;
import org.infinispan.stats.wrappers.ExtendedStatisticLockManager;
import org.infinispan.stats.wrappers.ExtendedStatisticRpcManager;
import org.infinispan.test.Exceptions;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.ControlledRpcManager;
import org.infinispan.util.EmbeddedTimeService;
import org.infinispan.util.ReplicatedControlledConsistentHashFactory;
import org.infinispan.util.TransactionTrackInterceptor;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.concurrent.locks.impl.LockContainer;
import org.infinispan.util.concurrent.locks.impl.PerKeyLockContainer;
import org.infinispan.util.concurrent.locks.impl.StripedLockContainer;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="stats.logic.OptimisticLockingTxClusterExtendedStatisticLogicTest")
public class OptimisticLockingTxClusterExtendedStatisticLogicTest
extends MultipleCacheManagersTest {
    private static final Object KEY_1 = "KEY_1";
    private static final Object VALUE_1 = "VALUE_1";
    private static final Object VALUE_2 = "VALUE_2";
    private static final Object VALUE_3 = "VALUE_3";
    private static final int NUM_NODES = 2;
    private static final int TX_TIMEOUT = 60;
    private static final TimeService TEST_TIME_SERVICE = new EmbeddedTimeService(){

        public long time() {
            return 0L;
        }

        public long timeDuration(long startTime, TimeUnit outputTimeUnit) {
            Assert.assertEquals((long)startTime, (long)0L, (String)"Start timestamp must be zero!");
            Assert.assertEquals((Object)((Object)outputTimeUnit), (Object)((Object)TimeUnit.NANOSECONDS), (String)"TimeUnit is different from expected");
            return 1L;
        }

        public long timeDuration(long startTime, long endTime, TimeUnit outputTimeUnit) {
            Assert.assertEquals((long)startTime, (long)0L, (String)"Start timestamp must be zero!");
            Assert.assertEquals((long)endTime, (long)0L, (String)"End timestamp must be zero!");
            Assert.assertEquals((Object)((Object)outputTimeUnit), (Object)((Object)TimeUnit.NANOSECONDS), (String)"TimeUnit is different from expected");
            return 1L;
        }
    };
    private static final double MICROSECONDS = CacheStatisticCollector.convertNanosToMicro((double)TEST_TIME_SERVICE.timeDuration(0L, TimeUnit.NANOSECONDS));
    private final ExtendedStatisticInterceptor[] extendedStatisticInterceptors = new ExtendedStatisticInterceptor[2];
    private final TransactionTrackInterceptor[] transactionTrackInterceptors = new TransactionTrackInterceptor[2];
    private final LockManager[] lockManagers = new LockManager[2];
    private final ControlledRpcManager[] controlledRpcManager = new ControlledRpcManager[2];
    private final LockManagerTimeService lockManagerTimeService = new LockManagerTimeService();

    public void testLockingTimeoutOnOwnerWithLocalTx() throws Exception {
        this.doTimeoutTest(true, false);
    }

    public void testLockingTimeoutOnNonOwnerWithLocalTx() throws Exception {
        this.doTimeoutTest(false, false);
    }

    public void testLockingTimeoutOnOwnerWithRemoteTx() throws Exception {
        this.doTimeoutTest(true, true);
    }

    public void testLockingTimeoutOnNonOwnerWithRemoteTx() throws Exception {
        this.doTimeoutTest(false, true);
    }

    public void testWriteSkewOnOwner() throws Exception {
        this.doWriteSkewTest(true);
    }

    public void testWriteSkewOnNonOwner() throws Exception {
        this.doWriteSkewTest(false);
    }

    protected void createCacheManagers() {
        int i;
        for (i = 0; i < 2; ++i) {
            ConfigurationBuilder builder = OptimisticLockingTxClusterExtendedStatisticLogicTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)true);
            builder.clustering().hash().numSegments(1).consistentHashFactory((ConsistentHashFactory)new ReplicatedControlledConsistentHashFactory(0, new int[0]));
            builder.locking().isolationLevel(IsolationLevel.REPEATABLE_READ).lockAcquisitionTimeout(TestingUtil.shortTimeoutMillis());
            builder.transaction().recovery().disable();
            builder.transaction().lockingMode(LockingMode.OPTIMISTIC);
            this.extendedStatisticInterceptors[i] = new ExtendedStatisticInterceptor();
            builder.customInterceptors().addInterceptor().interceptor((AsyncInterceptor)this.extendedStatisticInterceptors[i]).after(TxInterceptor.class);
            this.addClusterEnabledCacheManager(builder);
        }
        this.waitForClusterToForm();
        for (i = 0; i < 2; ++i) {
            ExtendedStatisticInterceptor interceptor = this.extendedStatisticInterceptors[i];
            CacheStatisticManager manager = (CacheStatisticManager)TestingUtil.extractField((Object)interceptor, (String)"cacheStatisticManager");
            CacheStatisticCollector collector = (CacheStatisticCollector)TestingUtil.extractField((Object)manager, (String)"cacheStatisticCollector");
            ConcurrentGlobalContainer globalContainer = (ConcurrentGlobalContainer)TestingUtil.extractField((Object)collector, (String)"globalContainer");
            ExtendedStatisticRpcManager rpcManager = (ExtendedStatisticRpcManager)TestingUtil.extractComponent((Cache)this.cache(i), RpcManager.class);
            ExtendedStatisticLockManager lockManager = (ExtendedStatisticLockManager)TestingUtil.extractLockManager((Cache)this.cache(i));
            this.lockManagers[i] = lockManager;
            TestingUtil.replaceField((Object)TEST_TIME_SERVICE, (String)"timeService", (Object)manager, CacheStatisticManager.class);
            TestingUtil.replaceField((Object)TEST_TIME_SERVICE, (String)"timeService", (Object)collector, CacheStatisticCollector.class);
            TestingUtil.replaceField((Object)TEST_TIME_SERVICE, (String)"timeService", (Object)globalContainer, ConcurrentGlobalContainer.class);
            TestingUtil.replaceField((Object)TEST_TIME_SERVICE, (String)"timeService", (Object)interceptor, ExtendedStatisticInterceptor.class);
            TestingUtil.replaceField((Object)TEST_TIME_SERVICE, (String)"timeService", (Object)lockManager, ExtendedStatisticLockManager.class);
            TestingUtil.replaceField((Object)TEST_TIME_SERVICE, (String)"timeService", (Object)rpcManager, ExtendedStatisticRpcManager.class);
            this.controlledRpcManager[i] = ControlledRpcManager.replaceRpcManager((Cache)this.cache(i));
            this.transactionTrackInterceptors[i] = TransactionTrackInterceptor.injectInCache((Cache)this.cache(i));
            if (i != 0) continue;
            LockManager actualLockManager = lockManager.getActual();
            LockContainer container = (LockContainer)TestingUtil.extractField((Object)actualLockManager, (String)"lockContainer");
            if (container instanceof PerKeyLockContainer) {
                ((PerKeyLockContainer)container).inject((Executor)ForkJoinPool.commonPool(), (TimeService)this.lockManagerTimeService);
                continue;
            }
            if (!(container instanceof StripedLockContainer)) continue;
            ((StripedLockContainer)container).inject((Executor)ForkJoinPool.commonPool(), (TimeService)this.lockManagerTimeService);
        }
    }

    private void assertTxSeen(int txExecutor, int localTx, int remoteTx, boolean reset) throws InterruptedException {
        for (int i = 0; i < 2; ++i) {
            if (i == txExecutor) {
                Assert.assertTrue((boolean)this.transactionTrackInterceptors[i].awaitForLocalCompletion(localTx, 60L, TimeUnit.SECONDS));
            } else {
                Assert.assertTrue((boolean)this.transactionTrackInterceptors[i].awaitForRemoteCompletion(remoteTx, 60L, TimeUnit.SECONDS));
            }
            if (!reset) continue;
            this.transactionTrackInterceptors[i].reset();
        }
        this.assertNoLocks();
    }

    private void assertNoLocks() {
        for (LockManager lockManager : this.lockManagers) {
            this.eventuallyEquals(0, () -> ((LockManager)lockManager).getNumberOfLocksHeld());
        }
    }

    private void doWriteSkewTest(boolean executeOnOwner) throws Exception {
        this.controlledRpcManager[0].excludeCommands(new Class[]{PrepareCommand.class, CommitCommand.class, RollbackCommand.class, TxCompletionNotificationCommand.class});
        this.controlledRpcManager[1].excludeCommands(new Class[]{PrepareCommand.class, CommitCommand.class, RollbackCommand.class, TxCompletionNotificationCommand.class});
        int txExecutor = executeOnOwner ? 0 : 1;
        this.cache(0).put(KEY_1, VALUE_1);
        this.assertTxSeen(0, 1, 1, true);
        this.resetStats();
        this.tm(txExecutor).begin();
        Assert.assertEquals((Object)this.cache(txExecutor).get(KEY_1), (Object)VALUE_1);
        Transaction tx1 = this.tm(txExecutor).suspend();
        this.tm(txExecutor).begin();
        Assert.assertEquals((Object)this.cache(txExecutor).get(KEY_1), (Object)VALUE_1);
        Transaction tx2 = this.tm(txExecutor).suspend();
        this.tm(txExecutor).begin();
        this.cache(txExecutor).put(KEY_1, VALUE_2);
        this.tm(txExecutor).commit();
        this.assertNoLocks();
        this.tm(txExecutor).resume(tx1);
        this.cache(txExecutor).put(KEY_1, VALUE_3);
        try {
            this.tm(txExecutor).commit();
            Assert.fail((String)"Rollback Exception expected!");
        }
        catch (RollbackException rollbackException) {
            // empty catch block
        }
        this.assertNoLocks();
        this.tm(txExecutor).resume(tx2);
        this.cache(txExecutor).put(KEY_1, VALUE_3);
        try {
            this.tm(txExecutor).commit();
            Assert.fail((String)"Rollback Exception expected!");
        }
        catch (RollbackException rollbackException) {
            // empty catch block
        }
        this.assertTxSeen(txExecutor, 3, executeOnOwner ? 0 : 3, true);
        EnumSet<ExtendedStatistic> statsToValidate = this.getStatsToValidate();
        this.assertLockingValues(statsToValidate, executeOnOwner ? 1 : 0, executeOnOwner ? 2 : 0, executeOnOwner ? 0 : 3, executeOnOwner ? 1 : 0, executeOnOwner ? 2 : 0, executeOnOwner ? 0 : 1, executeOnOwner ? 0 : 2, 0, 0, executeOnOwner);
        this.assertWriteSkewValues(statsToValidate, 2, 3, txExecutor);
        this.assertAllStatsValidated(statsToValidate);
        this.resetStats();
    }

    private void doTimeoutTest(boolean executeOnOwner, boolean remoteContention) throws Exception {
        int txExecutor = executeOnOwner ? 0 : 1;
        int successTxExecutor = remoteContention ? 1 : 0;
        this.controlledRpcManager[successTxExecutor].excludeCommands(new Class[]{PrepareCommand.class, CommitCommand.class, TxCompletionNotificationCommand.class});
        this.cache(successTxExecutor).put(KEY_1, VALUE_1);
        this.controlledRpcManager[successTxExecutor].excludeCommands(new Class[]{PrepareCommand.class, TxCompletionNotificationCommand.class});
        this.assertTxSeen(successTxExecutor, 1, 1, true);
        this.resetStats();
        this.tm(successTxExecutor).begin();
        this.cache(successTxExecutor).put(KEY_1, VALUE_2);
        Transaction transaction = this.tm(successTxExecutor).suspend();
        Future future = this.fork(() -> {
            this.tm(successTxExecutor).resume(transaction);
            this.tm(successTxExecutor).commit();
            return null;
        });
        ControlledRpcManager.BlockedRequest blockedCommit = this.controlledRpcManager[successTxExecutor].expectCommand(CommitCommand.class);
        this.lockManagerTimeService.triggerTimeout = true;
        this.controlledRpcManager[txExecutor].excludeCommands(new Class[]{PrepareCommand.class, RollbackCommand.class, TxCompletionNotificationCommand.class});
        this.tm(txExecutor).begin();
        this.cache(txExecutor).put(KEY_1, VALUE_3);
        Exceptions.expectException(RollbackException.class, () -> this.tm(txExecutor).commit());
        this.tm(txExecutor).begin();
        this.cache(txExecutor).put(KEY_1, VALUE_3);
        Exceptions.expectException(RollbackException.class, () -> this.tm(txExecutor).commit());
        blockedCommit.send().receiveAll();
        future.get();
        if (txExecutor == successTxExecutor) {
            this.assertTxSeen(successTxExecutor, 3, executeOnOwner ? 0 : 3, true);
        } else {
            this.assertTxSeen(successTxExecutor, 1, 1, false);
            this.assertTxSeen(txExecutor, 2, executeOnOwner ? 0 : 2, true);
        }
        EnumSet<ExtendedStatistic> statsToValidate = this.getStatsToValidate();
        this.assertLockingValues(statsToValidate, remoteContention ? 0 : 1, 0, remoteContention ? 1 : 0, remoteContention ? 0 : 1, executeOnOwner ? 2 : 0, remoteContention ? 1 : 0, executeOnOwner ? 0 : 2, remoteContention ? 0 : 2, remoteContention ? 2 : 0, executeOnOwner);
        this.assertWriteSkewValues(statsToValidate, 0, 0, txExecutor);
        this.assertAllStatsValidated(statsToValidate);
        this.resetStats();
    }

    private EnumSet<ExtendedStatistic> getStatsToValidate() {
        return EnumSet.of(ExtendedStatistic.LOCK_HOLD_TIME_LOCAL, new ExtendedStatistic[]{ExtendedStatistic.LOCK_HOLD_TIME_REMOTE, ExtendedStatistic.NUM_LOCK_PER_LOCAL_TX, ExtendedStatistic.NUM_LOCK_PER_REMOTE_TX, ExtendedStatistic.NUM_HELD_LOCKS_SUCCESS_LOCAL_TX, ExtendedStatistic.LOCK_HOLD_TIME_SUCCESS_LOCAL_TX, ExtendedStatistic.LOCK_HOLD_TIME, ExtendedStatistic.NUM_HELD_LOCKS, ExtendedStatistic.NUM_WAITED_FOR_LOCKS, ExtendedStatistic.LOCK_WAITING_TIME, ExtendedStatistic.NUM_LOCK_FAILED_TIMEOUT, ExtendedStatistic.NUM_LOCK_FAILED_DEADLOCK, ExtendedStatistic.NUM_WRITE_SKEW, ExtendedStatistic.WRITE_SKEW_PROBABILITY});
    }

    private void assertAllStatsValidated(EnumSet<ExtendedStatistic> statsToValidate) {
        Assert.assertTrue((boolean)statsToValidate.isEmpty(), (String)("Stats not validated: " + statsToValidate + "."));
    }

    private void resetStats() {
        for (ExtendedStatisticInterceptor extendedStatisticInterceptor : this.extendedStatisticInterceptors) {
            extendedStatisticInterceptor.resetStatistics();
            for (ExtendedStatistic extendedStatistic : ExtendedStatistic.values()) {
                Assert.assertEquals((Object)extendedStatisticInterceptor.getAttribute(extendedStatistic), (Object)0.0, (String)("Attribute " + extendedStatistic + " is not zero after reset"));
            }
        }
        for (ExtendedStatisticInterceptor extendedStatisticInterceptor : this.transactionTrackInterceptors) {
            extendedStatisticInterceptor.reset();
        }
    }

    private void assertLockingValue(ExtendedStatistic attr, EnumSet<ExtendedStatistic> statsToValidate, double lockOwnerValue, double nonLockOwnerValue) {
        Assert.assertTrue((boolean)statsToValidate.contains(attr), (String)("Attribute " + attr + " already validated"));
        for (int i = 0; i < 2; ++i) {
            Assert.assertEquals((Object)this.extendedStatisticInterceptors[i].getAttribute(attr), (Object)(i == 0 ? lockOwnerValue : nonLockOwnerValue), (String)("Attribute " + attr + " has wrong value for cache " + i + "."));
        }
        statsToValidate.remove(attr);
    }

    private void assertAttributeValue(ExtendedStatistic attr, EnumSet<ExtendedStatistic> statsToValidate, double txExecutorValue, double nonTxExecutorValue, int txExecutorIndex) {
        Assert.assertTrue((boolean)statsToValidate.contains(attr), (String)("Attribute " + attr + " already validated"));
        for (int i = 0; i < 2; ++i) {
            Assert.assertEquals((Object)this.extendedStatisticInterceptors[i].getAttribute(attr), (Object)(i == txExecutorIndex ? txExecutorValue : nonTxExecutorValue), (String)("Attribute " + attr + " has wrong value for cache " + i + "."));
        }
        statsToValidate.remove(attr);
    }

    private void assertLockingValues(EnumSet<ExtendedStatistic> statsToValidate, int localHeldLocks, int failLocalHeldLocks, int remoteHeldLocks, int successLocalTx, int failLocalTx, int successRemoteTx, int failRemoteTx, int timeoutLocalLocks, int timeoutRemoteLocks, boolean executeOnLockOnwer) {
        this.log.infof("Check Locking value. localHeldLocks=%s, failLocalHeldLocks=%s, remoteHeldLocks=%s, successLocalTx=%s, failLocalTx=%s, successRemoteTx=%s, failRemoteTx=%s, timeoutLocalLocks=%s, timeoutRemoteLocks=%s", new Object[]{localHeldLocks, failLocalHeldLocks, remoteHeldLocks, successLocalTx, failLocalTx, successRemoteTx, failRemoteTx, timeoutLocalLocks, timeoutRemoteLocks});
        int totalLocalLocks = localHeldLocks + failLocalHeldLocks;
        this.assertLockingValue(ExtendedStatistic.LOCK_HOLD_TIME_LOCAL, statsToValidate, totalLocalLocks != 0 ? MICROSECONDS : 0.0, 0.0);
        this.assertLockingValue(ExtendedStatistic.LOCK_HOLD_TIME_REMOTE, statsToValidate, remoteHeldLocks != 0 ? MICROSECONDS : 0.0, 0.0);
        this.assertLockingValue(ExtendedStatistic.NUM_LOCK_PER_LOCAL_TX, statsToValidate, successLocalTx != 0 || failLocalTx != 0 ? (double)totalLocalLocks * 1.0 / (double)(successLocalTx + failLocalTx) : 0.0, 0.0);
        this.assertLockingValue(ExtendedStatistic.NUM_LOCK_PER_REMOTE_TX, statsToValidate, successRemoteTx != 0 || failRemoteTx != 0 ? (double)remoteHeldLocks * 1.0 / (double)(successRemoteTx + failRemoteTx) : 0.0, 0.0);
        this.assertLockingValue(ExtendedStatistic.LOCK_HOLD_TIME_SUCCESS_LOCAL_TX, statsToValidate, 0.0, 0.0);
        this.assertLockingValue(ExtendedStatistic.NUM_HELD_LOCKS_SUCCESS_LOCAL_TX, statsToValidate, successLocalTx != 0 ? (double)localHeldLocks * 1.0 / (double)successLocalTx : 0.0, 0.0);
        this.assertLockingValue(ExtendedStatistic.LOCK_HOLD_TIME, statsToValidate, totalLocalLocks != 0 || remoteHeldLocks != 0 ? MICROSECONDS : 0.0, 0.0);
        this.assertLockingValue(ExtendedStatistic.NUM_HELD_LOCKS, statsToValidate, totalLocalLocks + remoteHeldLocks, 0.0);
        this.assertLockingValue(ExtendedStatistic.NUM_WAITED_FOR_LOCKS, statsToValidate, timeoutLocalLocks + timeoutRemoteLocks, 0.0);
        this.assertLockingValue(ExtendedStatistic.LOCK_WAITING_TIME, statsToValidate, timeoutLocalLocks != 0 || timeoutRemoteLocks != 0 ? MICROSECONDS : 0.0, 0.0);
        this.assertLockingValue(ExtendedStatistic.NUM_LOCK_FAILED_TIMEOUT, statsToValidate, executeOnLockOnwer ? (double)(timeoutLocalLocks + timeoutRemoteLocks) : 0.0, executeOnLockOnwer ? 0.0 : (double)(timeoutLocalLocks + timeoutRemoteLocks));
        this.assertLockingValue(ExtendedStatistic.NUM_LOCK_FAILED_DEADLOCK, statsToValidate, 0.0, 0.0);
    }

    private void assertWriteSkewValues(EnumSet<ExtendedStatistic> statsToValidate, int numOfWriteSkew, int numOfTx, int txExecutor) {
        this.log.infof("Check Write Skew value. writeSkew=%s, writeTx=%s, txExecutor=%s", (Object)numOfWriteSkew, (Object)numOfTx, (Object)txExecutor);
        this.assertAttributeValue(ExtendedStatistic.NUM_WRITE_SKEW, statsToValidate, numOfWriteSkew, 0.0, txExecutor);
        this.assertAttributeValue(ExtendedStatistic.WRITE_SKEW_PROBABILITY, statsToValidate, numOfTx != 0 ? (double)numOfWriteSkew * 1.0 / (double)numOfTx : 0.0, 0.0, txExecutor);
    }

    @BeforeMethod(alwaysRun=true)
    void resetState() {
        this.lockManagerTimeService.triggerTimeout = false;
    }

    @AfterClass
    void stopBlockingRpcs() {
        for (ControlledRpcManager rpcManager : this.controlledRpcManager) {
            rpcManager.stopBlocking();
        }
    }

    private class LockManagerTimeService
    extends EmbeddedTimeService {
        private volatile boolean triggerTimeout = false;

        private LockManagerTimeService() {
        }

        public boolean isTimeExpired(long endTime) {
            return this.triggerTimeout;
        }
    }
}

