/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.demos.gridfs;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Date;
import net.sf.webdav.ITransaction;
import net.sf.webdav.IWebdavStore;
import net.sf.webdav.StoredObject;
import net.sf.webdav.exceptions.WebdavException;
import org.infinispan.Cache;
import org.infinispan.demos.gridfs.CacheManagerHolder;
import org.infinispan.io.GridFile;
import org.infinispan.io.GridFilesystem;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class GridStore
implements IWebdavStore {
    private static Log log = LogFactory.getLog(GridStore.class);
    private static int BUF_SIZE = 65536;
    private final Cache<String, byte[]> data = CacheManagerHolder.cacheContainer.getCache(CacheManagerHolder.dataCacheName);
    private final Cache<String, GridFile.Metadata> metadata = CacheManagerHolder.cacheContainer.getCache(CacheManagerHolder.metadataCacheName);
    private final GridFilesystem fs;
    private File root = null;

    public GridStore(File root) {
        try {
            this.data.start();
            this.metadata.start();
        }
        catch (Exception e) {
            throw new RuntimeException("creation of cluster failed", e);
        }
        this.fs = new GridFilesystem(this.data, this.metadata);
        this.root = this.fs.getFile(root.getPath());
        if (!this.root.mkdirs()) {
            throw new WebdavException("root path: " + root.getAbsolutePath() + " does not exist and could not be created");
        }
    }

    public void destroy() {
        if (this.data != null) {
            this.data.stop();
        }
        if (this.metadata != null) {
            this.metadata.stop();
        }
    }

    public ITransaction begin(Principal principal) throws WebdavException {
        log.trace((Object)"GridStore.begin()");
        if (!this.root.exists() && !this.root.mkdirs()) {
            throw new WebdavException("root path: " + this.root.getAbsolutePath() + " does not exist and could not be created");
        }
        return null;
    }

    public void checkAuthentication(ITransaction transaction) throws SecurityException {
        log.trace((Object)"GridStore.checkAuthentication()");
    }

    public void commit(ITransaction transaction) throws WebdavException {
        log.trace((Object)"GridStore.commit()");
    }

    public void rollback(ITransaction transaction) throws WebdavException {
        log.trace((Object)"GridStore.rollback()");
    }

    public void createFolder(ITransaction transaction, String uri) throws WebdavException {
        log.trace((Object)("GridStore.createFolder(" + uri + ")"));
        File file = this.fs.getFile(this.root, uri);
        if (!file.mkdir()) {
            throw new WebdavException("cannot create folder: " + uri);
        }
    }

    public void createResource(ITransaction transaction, String uri) throws WebdavException {
        log.trace((Object)("GridStore.createResource(" + uri + ")"));
        File file = this.fs.getFile(this.root, uri);
        try {
            if (!file.createNewFile()) {
                throw new WebdavException("cannot create file: " + uri);
            }
        }
        catch (IOException e) {
            log.error((Object)("GridStore.createResource(" + uri + ") failed"));
            throw new WebdavException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long setResourceContent(ITransaction transaction, String uri, InputStream is, String contentType, String characterEncoding) throws WebdavException {
        log.trace((Object)("GridStore.setResourceContent(" + uri + ")"));
        File file = this.fs.getFile(this.root, uri);
        try {
            OutputStream os = this.fs.getOutput((GridFile)file);
            try {
                int read;
                byte[] copyBuffer = new byte[BUF_SIZE];
                while ((read = is.read(copyBuffer, 0, copyBuffer.length)) != -1) {
                    os.write(copyBuffer, 0, read);
                }
            }
            finally {
                Util.close((Closeable)is);
                Util.close((Closeable)os);
            }
        }
        catch (IOException e) {
            log.error((Object)("GridStore.setResourceContent(" + uri + ") failed"));
            throw new WebdavException((Throwable)e);
        }
        long length = -1L;
        try {
            length = file.length();
        }
        catch (SecurityException e) {
            log.error((Object)("GridStore.setResourceContent(" + uri + ") failed" + "\nCan't get file.length"));
        }
        return length;
    }

    public String[] getChildrenNames(ITransaction transaction, String uri) throws WebdavException {
        log.trace((Object)("GridStore.getChildrenNames(" + uri + ")"));
        File file = this.fs.getFile(this.root, uri);
        String[] childrenNames = null;
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            ArrayList<String> childList = new ArrayList<String>();
            String name = null;
            for (int i = 0; i < children.length; ++i) {
                name = children[i].getName();
                childList.add(name);
                log.trace((Object)("Child " + i + ": " + name));
            }
            childrenNames = new String[childList.size()];
            childrenNames = childList.toArray(childrenNames);
        }
        return childrenNames;
    }

    public void removeObject(ITransaction transaction, String uri) throws WebdavException {
        File file = this.fs.getFile(this.root, uri);
        boolean success = file.delete();
        log.trace((Object)("GridStore.removeObject(" + uri + ")=" + success));
        if (!success) {
            throw new WebdavException("cannot delete object: " + uri);
        }
    }

    public InputStream getResourceContent(ITransaction transaction, String uri) throws WebdavException {
        InputStream in;
        log.trace((Object)("GridStore.getResourceContent(" + uri + ")"));
        File file = this.fs.getFile(this.root, uri);
        try {
            in = this.fs.getInput(file);
        }
        catch (IOException e) {
            log.error((Object)("GridStore.getResourceContent(" + uri + ") failed"));
            throw new WebdavException((Throwable)e);
        }
        return in;
    }

    public long getResourceLength(ITransaction transaction, String uri) throws WebdavException {
        log.trace((Object)("GridStore.getResourceLength(" + uri + ")"));
        File file = this.fs.getFile(this.root, uri);
        return file.length();
    }

    public StoredObject getStoredObject(ITransaction transaction, String uri) {
        StoredObject so = null;
        File file = this.fs.getFile(this.root, uri);
        if (file.exists()) {
            so = new StoredObject();
            so.setFolder(file.isDirectory());
            so.setLastModified(new Date(file.lastModified()));
            so.setCreationDate(new Date(file.lastModified()));
            so.setResourceLength(this.getResourceLength(transaction, uri));
        }
        return so;
    }
}

