/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.commons;

import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.testing.AfterClassOnce;
import org.hibernate.testing.BeforeClassOnce;
import org.infinispan.test.hibernate.cache.commons.AbstractNonFunctionalTest;
import org.infinispan.test.hibernate.cache.commons.NodeEnvironment;
import org.infinispan.test.hibernate.cache.commons.util.TestSessionAccess;
import org.infinispan.test.hibernate.cache.commons.util.TestingKeyFactory;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractExtraAPITest<S>
extends AbstractNonFunctionalTest {
    public static final String REGION_NAME = "test/com.foo.test";
    public static final Object KEY = TestingKeyFactory.generateCollectionCacheKey("KEY");
    protected static final TestSessionAccess TEST_SESSION_ACCESS = TestSessionAccess.findTestSessionAccess();
    protected static final Object SESSION = TEST_SESSION_ACCESS.mockSessionImplementor();
    protected S accessStrategy;
    protected TestSessionAccess.TestRegionAccessStrategy testAccessStrategy;
    protected NodeEnvironment environment;

    @BeforeClassOnce
    public final void prepareLocalAccessStrategy() throws Exception {
        this.environment = new NodeEnvironment(this.createStandardServiceRegistryBuilder());
        this.environment.prepare();
        this.accessStrategy = this.getAccessStrategy();
        this.testAccessStrategy = TEST_SESSION_ACCESS.fromAccess(this.accessStrategy);
    }

    protected abstract S getAccessStrategy();

    @AfterClassOnce
    public final void releaseLocalAccessStrategy() throws Exception {
        if (this.environment != null) {
            this.environment.release();
        }
    }

    @Test
    public void testLockItem() {
        Assert.assertNull((Object)this.testAccessStrategy.lockItem(SESSION, KEY, 1));
    }

    @Test
    public void testLockRegion() {
        Assert.assertNull((Object)this.testAccessStrategy.lockRegion());
    }

    @Test
    public void testUnlockItem() {
        this.testAccessStrategy.unlockItem(SESSION, KEY, new MockSoftLock());
    }

    @Test
    public void testUnlockRegion() {
        this.testAccessStrategy.unlockItem(SESSION, KEY, new MockSoftLock());
    }

    public static class MockSoftLock
    implements SoftLock {
    }
}

