/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.commons;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.SharedSessionContract;
import org.hibernate.Transaction;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.engine.transaction.jta.platform.internal.NoJtaPlatform;
import org.hibernate.service.ServiceRegistry;
import org.infinispan.AdvancedCache;
import org.infinispan.CacheSet;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.hibernate.cache.commons.InfinispanBaseRegion;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.hibernate.cache.commons.AbstractRegionImplTest;
import org.infinispan.test.hibernate.cache.commons.TestDisabledIn53;
import org.infinispan.test.hibernate.cache.commons.util.BatchModeJtaPlatform;
import org.infinispan.test.hibernate.cache.commons.util.CacheTestUtil;
import org.infinispan.test.hibernate.cache.commons.util.ExpectingInterceptor;
import org.infinispan.test.hibernate.cache.commons.util.TestRegionFactory;
import org.infinispan.test.hibernate.cache.commons.util.TestRegionFactoryProvider;
import org.infinispan.test.hibernate.cache.commons.util.TestSessionAccess;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

public abstract class AbstractGeneralDataRegionTest
extends AbstractRegionImplTest {
    protected static final String KEY = "Key";
    protected static final String VALUE1 = "value1";
    protected static final String VALUE2 = "value2";
    protected static final String VALUE3 = "value3";
    protected static final TestSessionAccess TEST_SESSION_ACCESS = TestSessionAccess.findTestSessionAccess();

    @Override
    public List<Object[]> getParameters() {
        return Arrays.asList({"JTA", BatchModeJtaPlatform.class, CacheMode.INVALIDATION_SYNC, AccessType.TRANSACTIONAL}, {"non-JTA", NoJtaPlatform.class, CacheMode.INVALIDATION_SYNC, AccessType.READ_WRITE});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void withSessionFactoriesAndRegions(int num, SFRConsumer consumer) throws Exception {
        StandardServiceRegistryBuilder ssrb = this.createStandardServiceRegistryBuilder().applySetting("hibernate.cache.region.factory_class", (Object)TestRegionFactoryProvider.load().getRegionFactoryClass().getName());
        Properties properties = CacheTestUtil.toProperties(ssrb.getSettings());
        ArrayList<StandardServiceRegistry> registries = new ArrayList<StandardServiceRegistry>();
        ArrayList<SessionFactory> sessionFactories = new ArrayList<SessionFactory>();
        ArrayList<InfinispanBaseRegion> regions = new ArrayList<InfinispanBaseRegion>();
        for (int i = 0; i < num; ++i) {
            StandardServiceRegistry registry = ssrb.build();
            registries.add(registry);
            SessionFactory sessionFactory = new MetadataSources((ServiceRegistry)registry).buildMetadata().buildSessionFactory();
            sessionFactories.add(sessionFactory);
            TestRegionFactory regionFactory = TestRegionFactoryProvider.load().wrap((RegionFactory)registry.getService(RegionFactory.class));
            InfinispanBaseRegion region = this.createRegion(regionFactory, "test/who-cares");
            regions.add(region);
        }
        this.waitForClusterToForm(regions);
        try {
            consumer.accept(sessionFactories, regions);
        }
        finally {
            for (SessionFactory sessionFactory : sessionFactories) {
                sessionFactory.close();
            }
            for (StandardServiceRegistry registry : registries) {
                StandardServiceRegistryBuilder.destroy((ServiceRegistry)registry);
            }
        }
    }

    private void waitForClusterToForm(List<InfinispanBaseRegion> regions) {
        List caches = regions.stream().map(InfinispanBaseRegion::getCache).collect(Collectors.toList());
        TestingUtil.blockUntilViewsReceived((int)20000, caches);
        TestingUtil.waitForNoRebalance(caches);
    }

    @Test
    @Category(value={TestDisabledIn53.class})
    public void testEvict() throws Exception {
        this.withSessionFactoriesAndRegions(2, (sessionFactories, regions) -> {
            InfinispanBaseRegion localRegion = (InfinispanBaseRegion)regions.get(0);
            TestSessionAccess.TestRegion testLocalRegion = TEST_SESSION_ACCESS.fromRegion(localRegion);
            InfinispanBaseRegion remoteRegion = (InfinispanBaseRegion)regions.get(1);
            TestSessionAccess.TestRegion testRemoteRegion = TEST_SESSION_ACCESS.fromRegion(remoteRegion);
            Session localSession = ((SessionFactory)sessionFactories.get(0)).openSession();
            Session remoteSession = ((SessionFactory)sessionFactories.get(1)).openSession();
            AdvancedCache localCache = localRegion.getCache();
            AdvancedCache remoteCache = remoteRegion.getCache();
            try {
                Assert.assertNull((String)"local is clean", (Object)testLocalRegion.get(localSession, KEY));
                Assert.assertNull((String)"remote is clean", (Object)testRemoteRegion.get(remoteSession, KEY));
                boolean isLocalNodeBackupOwner = localCache.getDistributionManager().locate((Object)KEY).indexOf(localCache.getCacheManager().getAddress()) > 0;
                CountDownLatch insertLatch = new CountDownLatch(isLocalNodeBackupOwner ? 3 : 2);
                ExpectingInterceptor.get(localCache).when((ctx, cmd) -> cmd instanceof PutKeyValueCommand).countDown(insertLatch);
                ExpectingInterceptor.get(remoteCache).when((ctx, cmd) -> cmd instanceof PutKeyValueCommand).countDown(insertLatch);
                Transaction tx = ((SharedSessionContract)localSession).getTransaction();
                tx.begin();
                try {
                    testLocalRegion.put(localSession, KEY, VALUE1);
                    tx.commit();
                }
                catch (Exception e) {
                    tx.rollback();
                    throw e;
                }
                Assert.assertTrue((boolean)insertLatch.await(2L, TimeUnit.SECONDS));
                Assert.assertEquals((Object)VALUE1, (Object)testLocalRegion.get(localSession, KEY));
                Assert.assertEquals((Object)VALUE1, (Object)testRemoteRegion.get(remoteSession, KEY));
                CountDownLatch removeLatch = new CountDownLatch(isLocalNodeBackupOwner ? 3 : 2);
                ExpectingInterceptor.get(localCache).when((ctx, cmd) -> cmd instanceof RemoveCommand).countDown(removeLatch);
                ExpectingInterceptor.get(remoteCache).when((ctx, cmd) -> cmd instanceof RemoveCommand).countDown(removeLatch);
                this.regionEvict(localRegion);
                Assert.assertTrue((boolean)removeLatch.await(2L, TimeUnit.SECONDS));
                Assert.assertEquals(null, (Object)testLocalRegion.get(localSession, KEY));
                Assert.assertEquals(null, (Object)testRemoteRegion.get(remoteSession, KEY));
            }
            catch (Throwable throwable) {
                localSession.close();
                remoteSession.close();
                ExpectingInterceptor.cleanup(localCache, remoteCache);
                throw throwable;
            }
            localSession.close();
            remoteSession.close();
            ExpectingInterceptor.cleanup(localCache, remoteCache);
        });
    }

    protected void regionEvict(InfinispanBaseRegion region) {
        TEST_SESSION_ACCESS.fromRegion(region).evict(KEY);
    }

    public void testEvictAll() throws Exception {
        this.withSessionFactoriesAndRegions(2, (sessionFactories, regions) -> {
            InfinispanBaseRegion localRegion = (InfinispanBaseRegion)regions.get(0);
            TestSessionAccess.TestRegion testLocalRegion = TEST_SESSION_ACCESS.fromRegion(localRegion);
            InfinispanBaseRegion remoteRegion = (InfinispanBaseRegion)regions.get(1);
            TestSessionAccess.TestRegion testRemoteRegion = TEST_SESSION_ACCESS.fromRegion(remoteRegion);
            AdvancedCache localCache = localRegion.getCache();
            AdvancedCache remoteCache = remoteRegion.getCache();
            Session localSession = ((SessionFactory)sessionFactories.get(0)).openSession();
            Session remoteSession = ((SessionFactory)sessionFactories.get(1)).openSession();
            try {
                CacheSet localKeys = localCache.keySet();
                Assert.assertEquals((String)("No valid children in " + localKeys), (long)0L, (long)localKeys.size());
                CacheSet remoteKeys = remoteCache.keySet();
                Assert.assertEquals((String)("No valid children in " + remoteKeys), (long)0L, (long)remoteKeys.size());
                Assert.assertNull((String)"local is clean", (Object)testLocalRegion.get(null, KEY));
                Assert.assertNull((String)"remote is clean", (Object)testRemoteRegion.get(null, KEY));
                testLocalRegion.put(localSession, KEY, VALUE1);
                Assert.assertEquals((Object)VALUE1, (Object)testLocalRegion.get(null, KEY));
                testRemoteRegion.put(remoteSession, KEY, VALUE1);
                Assert.assertEquals((Object)VALUE1, (Object)testRemoteRegion.get(null, KEY));
                testLocalRegion.evictAll();
                Assert.assertNull((Object)testLocalRegion.get(null, KEY));
                localKeys = localCache.keySet();
                Assert.assertEquals((String)("No valid children in " + localKeys), (long)0L, (long)localKeys.size());
                Assert.assertEquals(null, (Object)testRemoteRegion.get(null, KEY));
                remoteKeys = remoteCache.keySet();
                Assert.assertEquals((String)("No valid children in " + remoteKeys), (long)0L, (long)remoteKeys.size());
                Assert.assertEquals((String)"local is clean", null, (Object)testLocalRegion.get(null, KEY));
                Assert.assertEquals((String)"remote is clean", null, (Object)testRemoteRegion.get(null, KEY));
            }
            finally {
                localSession.close();
                remoteSession.close();
            }
        });
    }

    protected static interface SFRConsumer {
        public void accept(List<SessionFactory> var1, List<InfinispanBaseRegion> var2) throws Exception;
    }
}

