/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.commons;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import javax.transaction.TransactionManager;
import org.hibernate.Transaction;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.engine.transaction.jta.platform.internal.NoJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.hibernate.testing.junit4.BaseUnitTestCase;
import org.hibernate.testing.junit4.CustomParameterized;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.hibernate.cache.commons.util.Caches;
import org.infinispan.test.hibernate.cache.commons.NodeEnvironment;
import org.infinispan.test.hibernate.cache.commons.util.BatchModeJtaPlatform;
import org.infinispan.test.hibernate.cache.commons.util.CacheTestSupport;
import org.infinispan.test.hibernate.cache.commons.util.CacheTestUtil;
import org.infinispan.test.hibernate.cache.commons.util.InfinispanTestingSetup;
import org.infinispan.test.hibernate.cache.commons.util.TestRegionFactory;
import org.infinispan.test.hibernate.cache.commons.util.TestRegionFactoryProvider;
import org.infinispan.test.hibernate.cache.commons.util.TestSessionAccess;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=CustomParameterized.class)
public abstract class AbstractNonFunctionalTest
extends BaseUnitTestCase {
    @ClassRule
    public static final InfinispanTestingSetup infinispanTestIdentifier = new InfinispanTestingSetup();
    protected static final TestSessionAccess TEST_SESSION_ACCESS = TestSessionAccess.findTestSessionAccess();
    @Parameterized.Parameter(value=0)
    public String mode;
    @Parameterized.Parameter(value=1)
    public Class<? extends JtaPlatform> jtaPlatform;
    @Parameterized.Parameter(value=2)
    public CacheMode cacheMode;
    @Parameterized.Parameter(value=3)
    public AccessType accessType;
    public static final String REGION_PREFIX = "test";
    private static final String PREFER_IPV4STACK = "java.net.preferIPv4Stack";
    private String preferIPv4Stack;
    private static final String JGROUPS_CFG_FILE = "hibernate.cache.infinispan.jgroups_cfg";
    private String jgroupsCfgFile;
    private CacheTestSupport testSupport = new CacheTestSupport();

    @Parameterized.Parameters(name="{0}, {2}, {3}")
    public List<Object[]> getParameters() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>(Arrays.asList({"JTA", BatchModeJtaPlatform.class, CacheMode.INVALIDATION_SYNC, AccessType.TRANSACTIONAL}, {"JTA", BatchModeJtaPlatform.class, CacheMode.INVALIDATION_SYNC, AccessType.READ_WRITE}, {"JTA", BatchModeJtaPlatform.class, CacheMode.INVALIDATION_SYNC, AccessType.READ_ONLY}, {"JTA", BatchModeJtaPlatform.class, CacheMode.DIST_SYNC, AccessType.READ_WRITE}, {"JTA", BatchModeJtaPlatform.class, CacheMode.DIST_SYNC, AccessType.READ_ONLY}, {"JTA", BatchModeJtaPlatform.class, CacheMode.DIST_SYNC, AccessType.NONSTRICT_READ_WRITE}, {"JTA", BatchModeJtaPlatform.class, CacheMode.REPL_SYNC, AccessType.READ_WRITE}, {"JTA", BatchModeJtaPlatform.class, CacheMode.REPL_SYNC, AccessType.READ_ONLY}, {"JTA", BatchModeJtaPlatform.class, CacheMode.REPL_SYNC, AccessType.NONSTRICT_READ_WRITE}, {"non-JTA", NoJtaPlatform.class, CacheMode.INVALIDATION_SYNC, AccessType.READ_WRITE}, {"non-JTA", NoJtaPlatform.class, CacheMode.INVALIDATION_SYNC, AccessType.READ_ONLY}, {"non-JTA", NoJtaPlatform.class, CacheMode.DIST_SYNC, AccessType.READ_WRITE}, {"non-JTA", NoJtaPlatform.class, CacheMode.DIST_SYNC, AccessType.READ_ONLY}, {"non-JTA", NoJtaPlatform.class, CacheMode.DIST_SYNC, AccessType.NONSTRICT_READ_WRITE}, {"non-JTA", NoJtaPlatform.class, CacheMode.REPL_SYNC, AccessType.READ_WRITE}, {"non-JTA", NoJtaPlatform.class, CacheMode.REPL_SYNC, AccessType.READ_ONLY}, {"non-JTA", NoJtaPlatform.class, CacheMode.REPL_SYNC, AccessType.NONSTRICT_READ_WRITE}));
        if (this.canUseLocalMode()) {
            parameters.addAll(Arrays.asList({"JTA", BatchModeJtaPlatform.class, CacheMode.LOCAL, AccessType.TRANSACTIONAL}, {"JTA", BatchModeJtaPlatform.class, CacheMode.LOCAL, AccessType.READ_WRITE}, {"JTA", BatchModeJtaPlatform.class, CacheMode.LOCAL, AccessType.READ_ONLY}, {"JTA", BatchModeJtaPlatform.class, CacheMode.LOCAL, AccessType.NONSTRICT_READ_WRITE}, {"non-JTA", NoJtaPlatform.class, CacheMode.LOCAL, AccessType.READ_WRITE}, {"non-JTA", NoJtaPlatform.class, CacheMode.LOCAL, AccessType.READ_ONLY}, {"non-JTA", NoJtaPlatform.class, CacheMode.LOCAL, AccessType.NONSTRICT_READ_WRITE}));
        }
        return parameters;
    }

    @Before
    public void prepareCacheSupport() throws Exception {
        infinispanTestIdentifier.joinContext();
        this.preferIPv4Stack = System.getProperty(PREFER_IPV4STACK);
        System.setProperty(PREFER_IPV4STACK, "true");
        this.jgroupsCfgFile = System.getProperty(JGROUPS_CFG_FILE);
        System.setProperty(JGROUPS_CFG_FILE, "2lc-test-tcp.xml");
        this.testSupport.setUp();
    }

    @After
    public void releaseCachSupport() throws Exception {
        this.testSupport.tearDown();
        if (this.preferIPv4Stack == null) {
            System.clearProperty(PREFER_IPV4STACK);
        } else {
            System.setProperty(PREFER_IPV4STACK, this.preferIPv4Stack);
        }
        if (this.jgroupsCfgFile == null) {
            System.clearProperty(JGROUPS_CFG_FILE);
        } else {
            System.setProperty(JGROUPS_CFG_FILE, this.jgroupsCfgFile);
        }
    }

    protected boolean canUseLocalMode() {
        return true;
    }

    protected <T> T withTx(NodeEnvironment environment, Object session, Callable<T> callable) throws Exception {
        TransactionManager tm = ((JtaPlatform)environment.getServiceRegistry().getService(JtaPlatform.class)).retrieveTransactionManager();
        if (tm != null) {
            return (T)Caches.withinTx((TransactionManager)tm, callable);
        }
        Transaction transaction = TEST_SESSION_ACCESS.beginTransaction(session);
        boolean rollingBack = false;
        try {
            T retval = callable.call();
            if (transaction.getStatus() == TransactionStatus.ACTIVE) {
                transaction.commit();
            } else {
                rollingBack = true;
                transaction.rollback();
            }
            return retval;
        }
        catch (Exception e) {
            if (!rollingBack) {
                try {
                    transaction.rollback();
                }
                catch (Exception suppressed) {
                    e.addSuppressed(suppressed);
                }
            }
            throw e;
        }
    }

    protected CacheTestSupport getCacheTestSupport() {
        return this.testSupport;
    }

    protected StandardServiceRegistryBuilder createStandardServiceRegistryBuilder() {
        StandardServiceRegistryBuilder ssrb = CacheTestUtil.buildBaselineStandardServiceRegistryBuilder(REGION_PREFIX, true, false, this.jtaPlatform);
        ssrb.applySetting(TestRegionFactory.TRANSACTIONAL, (Object)(TestRegionFactoryProvider.load().supportTransactionalCaches() && this.accessType == AccessType.TRANSACTIONAL ? 1 : 0));
        ssrb.applySetting(TestRegionFactory.CACHE_MODE, (Object)this.cacheMode);
        return ssrb;
    }
}

