/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.commons;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.cache.spi.entry.CacheEntry;
import org.hibernate.testing.AfterClassOnce;
import org.hibernate.testing.BeforeClassOnce;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.hibernate.cache.commons.InfinispanBaseRegion;
import org.infinispan.hibernate.cache.commons.access.PutFromLoadValidator;
import org.infinispan.hibernate.cache.commons.access.SessionAccess;
import org.infinispan.hibernate.cache.commons.util.Caches;
import org.infinispan.hibernate.cache.commons.util.FutureUpdate;
import org.infinispan.hibernate.cache.commons.util.TombstoneUpdate;
import org.infinispan.hibernate.cache.commons.util.VersionedEntry;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.hibernate.cache.commons.AbstractNonFunctionalTest;
import org.infinispan.test.hibernate.cache.commons.NodeEnvironment;
import org.infinispan.test.hibernate.cache.commons.util.ExpectingInterceptor;
import org.infinispan.test.hibernate.cache.commons.util.TestRegionFactory;
import org.infinispan.test.hibernate.cache.commons.util.TestSessionAccess;
import org.infinispan.test.hibernate.cache.commons.util.TestSynchronization;
import org.infinispan.util.ControlledTimeService;
import org.jboss.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.mockito.ArgumentMatchers;
import org.mockito.Matchers;
import org.mockito.Mockito;

public abstract class AbstractRegionAccessStrategyTest<S>
extends AbstractNonFunctionalTest {
    protected final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    public static final String REGION_NAME = "com.foo.test";
    public static final String KEY_BASE = "KEY";
    public static final TestCacheEntry VALUE1 = new TestCacheEntry((Serializable)((Object)"VALUE1"), Integer.valueOf(1));
    public static final TestCacheEntry VALUE2 = new TestCacheEntry((Serializable)((Object)"VALUE2"), Integer.valueOf(2));
    protected static final ControlledTimeService TIME_SERVICE = new ControlledTimeService();
    protected static final TestSessionAccess TEST_SESSION_ACCESS = TestSessionAccess.findTestSessionAccess();
    protected static final SessionAccess SESSION_ACCESS = SessionAccess.findSessionAccess();
    protected NodeEnvironment localEnvironment;
    protected InfinispanBaseRegion localRegion;
    protected S localAccessStrategy;
    protected TestSessionAccess.TestRegionAccessStrategy testLocalAccessStrategy;
    protected NodeEnvironment remoteEnvironment;
    protected InfinispanBaseRegion remoteRegion;
    protected S remoteAccessStrategy;
    protected TestSessionAccess.TestRegionAccessStrategy testRemoteAccessStrategy;
    protected boolean transactional;
    protected boolean invalidation;
    protected boolean synchronous;
    protected Exception node1Exception;
    protected Exception node2Exception;
    protected AssertionError node1Failure;
    protected AssertionError node2Failure;
    protected List<Runnable> cleanup = new ArrayList<Runnable>();
    @Rule
    public TestName name = new TestName();

    @Override
    protected boolean canUseLocalMode() {
        return false;
    }

    @BeforeClassOnce
    public void prepareResources() throws Exception {
        StandardServiceRegistryBuilder ssrb = this.createStandardServiceRegistryBuilder();
        this.localEnvironment = new NodeEnvironment(ssrb);
        this.localEnvironment.prepare();
        this.localRegion = this.getRegion(this.localEnvironment);
        this.localAccessStrategy = this.getAccessStrategy(this.localRegion);
        this.testLocalAccessStrategy = TEST_SESSION_ACCESS.fromAccess(this.localAccessStrategy);
        this.transactional = Caches.isTransactionalCache((AdvancedCache)this.localRegion.getCache());
        this.invalidation = Caches.isInvalidationCache((AdvancedCache)this.localRegion.getCache());
        this.synchronous = Caches.isSynchronousCache((AdvancedCache)this.localRegion.getCache());
        this.remoteEnvironment = new NodeEnvironment(ssrb);
        this.remoteEnvironment.prepare();
        this.remoteRegion = this.getRegion(this.remoteEnvironment);
        this.remoteAccessStrategy = this.getAccessStrategy(this.remoteRegion);
        this.testRemoteAccessStrategy = TEST_SESSION_ACCESS.fromAccess(this.remoteAccessStrategy);
        this.waitForClusterToForm(new Cache[]{this.localRegion.getCache(), this.remoteRegion.getCache()});
    }

    @After
    public void cleanup() {
        this.cleanup.forEach(Runnable::run);
        this.cleanup.clear();
        if (this.localRegion != null) {
            this.localRegion.getCache().clear();
        }
        if (this.remoteRegion != null) {
            this.remoteRegion.getCache().clear();
        }
        this.node2Exception = null;
        this.node1Exception = null;
        this.node2Failure = null;
        this.node1Failure = null;
        TIME_SERVICE.advance(1L);
    }

    @AfterClassOnce
    public void releaseResources() throws Exception {
        try {
            if (this.localEnvironment != null) {
                this.localEnvironment.release();
            }
        }
        finally {
            if (this.remoteEnvironment != null) {
                this.remoteEnvironment.release();
            }
        }
    }

    @Override
    protected StandardServiceRegistryBuilder createStandardServiceRegistryBuilder() {
        StandardServiceRegistryBuilder ssrb = super.createStandardServiceRegistryBuilder();
        ssrb.applySetting(TestRegionFactory.TIME_SERVICE, (Object)TIME_SERVICE);
        return ssrb;
    }

    protected void putFromLoadTest(boolean useMinimalAPI, boolean isRemoval) throws Exception {
        Object KEY = this.generateNextKey();
        CountDownLatch writeLatch1 = new CountDownLatch(1);
        CountDownLatch writeLatch2 = new CountDownLatch(1);
        CountDownLatch completionLatch = new CountDownLatch(2);
        CountDownLatch[] putFromLoadLatches = new CountDownLatch[2];
        Thread node1 = new Thread(() -> {
            try {
                Object session = TEST_SESSION_ACCESS.mockSession(this.jtaPlatform, TIME_SERVICE, this.localEnvironment.getRegionFactory());
                putFromLoadLatches[0] = this.withTx(this.localEnvironment, session, () -> {
                    Assert.assertNull((Object)this.testLocalAccessStrategy.get(session, KEY, SESSION_ACCESS.getTimestamp(session)));
                    writeLatch1.await();
                    CountDownLatch latch = this.expectPutFromLoad(this.remoteRegion, KEY);
                    if (useMinimalAPI) {
                        this.testLocalAccessStrategy.putFromLoad(session, KEY, VALUE1, SESSION_ACCESS.getTimestamp(session), VALUE1.version, true);
                    } else {
                        this.testLocalAccessStrategy.putFromLoad(session, KEY, VALUE1, SESSION_ACCESS.getTimestamp(session), VALUE1.version);
                    }
                    this.doUpdate(this.testLocalAccessStrategy, session, KEY, VALUE2);
                    return latch;
                });
            }
            catch (Exception e) {
                this.log.error((Object)"node1 caught exception", (Throwable)e);
                this.node1Exception = e;
            }
            catch (AssertionError e) {
                this.node1Failure = e;
            }
            finally {
                writeLatch2.countDown();
                completionLatch.countDown();
            }
        }, this.putFromLoadTestThreadName("node1", useMinimalAPI, isRemoval));
        Thread node2 = new Thread(() -> {
            try {
                Object session = TEST_SESSION_ACCESS.mockSession(this.jtaPlatform, TIME_SERVICE, this.remoteEnvironment.getRegionFactory());
                putFromLoadLatches[1] = this.withTx(this.remoteEnvironment, session, () -> {
                    Assert.assertNull((Object)this.testRemoteAccessStrategy.get(session, KEY, SESSION_ACCESS.getTimestamp(session)));
                    writeLatch1.countDown();
                    writeLatch2.await();
                    CountDownLatch latch = this.expectPutFromLoad(this.localRegion, KEY);
                    if (useMinimalAPI) {
                        this.testRemoteAccessStrategy.putFromLoad(session, KEY, VALUE1, SESSION_ACCESS.getTimestamp(session), VALUE1.version, true);
                    } else {
                        this.testRemoteAccessStrategy.putFromLoad(session, KEY, VALUE1, SESSION_ACCESS.getTimestamp(session), VALUE1.version);
                    }
                    return latch;
                });
            }
            catch (Exception e) {
                this.log.error((Object)"node2 caught exception", (Throwable)e);
                this.node2Exception = e;
            }
            catch (AssertionError e) {
                this.node2Failure = e;
            }
            finally {
                completionLatch.countDown();
            }
        }, this.putFromLoadTestThreadName("node2", useMinimalAPI, isRemoval));
        node1.setDaemon(true);
        node2.setDaemon(true);
        CountDownLatch remoteUpdate = this.expectAfterUpdate(KEY);
        node1.start();
        node2.start();
        Assert.assertTrue((String)"Threads completed", (boolean)completionLatch.await(2L, TimeUnit.SECONDS));
        this.assertThreadsRanCleanly();
        Assert.assertTrue((String)"Update was replicated", (boolean)remoteUpdate.await(2L, TimeUnit.SECONDS));
        this.assertPutFromLoadLatches(putFromLoadLatches);
        Object s1 = TEST_SESSION_ACCESS.mockSession(this.jtaPlatform, TIME_SERVICE, this.localEnvironment.getRegionFactory());
        Assert.assertEquals((Object)(isRemoval ? null : VALUE2), (Object)this.testLocalAccessStrategy.get(s1, KEY, SESSION_ACCESS.getTimestamp(s1)));
        Object s2 = TEST_SESSION_ACCESS.mockSession(this.jtaPlatform, TIME_SERVICE, this.remoteEnvironment.getRegionFactory());
        Object remoteValue = this.testRemoteAccessStrategy.get(s2, KEY, SESSION_ACCESS.getTimestamp(s2));
        if (this.isUsingInvalidation() || isRemoval) {
            Assert.assertNull((Object)remoteValue);
        } else {
            Assert.assertEquals((Object)VALUE2, (Object)remoteValue);
        }
    }

    protected void assertPutFromLoadLatches(CountDownLatch[] latches) {
        boolean await0 = this.await(latches[0]);
        boolean await1 = this.await(latches[1]);
        Assert.assertTrue((String)String.format("One of the latches in %s should have at least completed", Arrays.toString(latches)), (await0 || await1 ? 1 : 0) != 0);
    }

    private boolean await(CountDownLatch latch) {
        Assert.assertNotNull((Object)latch);
        try {
            this.log.debugf("Await latch: %s", (Object)latch);
            boolean await = latch.await(1L, TimeUnit.SECONDS);
            this.log.debugf("Finished waiting for latch, did latch reach zero? %b", (Object)await);
            return await;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    String putFromLoadTestThreadName(String node, boolean useMinimalAPI, boolean isRemoval) {
        return String.format("putFromLoad=%s,%s,%s,%s,minimal=%s,isRemove=%s", node, this.mode, this.cacheMode, this.accessType, useMinimalAPI, isRemoval);
    }

    protected CountDownLatch expectAfterUpdate(Object key) {
        return this.expectReadWriteKeyCommand(key, value -> value instanceof FutureUpdate);
    }

    protected CountDownLatch expectReadWriteKeyCommand(Object key, Predicate<Object> functionPredicate) {
        if (!this.isUsingInvalidation() && this.accessType != AccessType.NONSTRICT_READ_WRITE) {
            CountDownLatch latch = new CountDownLatch(1);
            ExpectingInterceptor.get(this.remoteRegion.getCache()).when((ctx, cmd) -> this.isExpectedReadWriteKey(key, (VisitableCommand)cmd) && functionPredicate.test(((ReadWriteKeyCommand)cmd).getFunction())).countDown(latch);
            this.cleanup.add(() -> ExpectingInterceptor.cleanup(this.remoteRegion.getCache()));
            return latch;
        }
        return new CountDownLatch(0);
    }

    protected CountDownLatch expectPutFromLoad(Object key) {
        return this.expectReadWriteKeyCommand(key, value -> value instanceof TombstoneUpdate);
    }

    protected CountDownLatch expectPutFromLoad(InfinispanBaseRegion region, Object key) {
        Predicate<Object> functionPredicate = this.accessType == AccessType.NONSTRICT_READ_WRITE ? VersionedEntry.class::isInstance : TombstoneUpdate.class::isInstance;
        CountDownLatch latch = new CountDownLatch(1);
        if (!this.isUsingInvalidation()) {
            ExpectingInterceptor.get(region.getCache()).when((ctx, cmd) -> this.isExpectedReadWriteKey(key, (VisitableCommand)cmd) && functionPredicate.test(((ReadWriteKeyCommand)cmd).getFunction())).countDown(latch);
            this.cleanup.add(() -> ExpectingInterceptor.cleanup(region.getCache()));
        } else if (this.transactional) {
            this.expectPutFromLoadEndInvalidating(region, key, latch);
        } else {
            this.expectInvalidateCommand(region, latch);
        }
        this.log.debugf("Create latch for putFromLoad: %s", (Object)latch);
        return latch;
    }

    protected abstract void doUpdate(TestSessionAccess.TestRegionAccessStrategy var1, Object var2, Object var3, TestCacheEntry var4);

    protected abstract S getAccessStrategy(InfinispanBaseRegion var1);

    @Test
    public void testRemove() throws Exception {
        this.log.infof(this.name.getMethodName(), new Object[0]);
        this.evictOrRemoveTest(false);
    }

    @Test
    public void testEvict() throws Exception {
        this.log.infof(this.name.getMethodName(), new Object[0]);
        this.evictOrRemoveTest(true);
    }

    protected abstract InfinispanBaseRegion getRegion(NodeEnvironment var1);

    protected void waitForClusterToForm(Cache ... caches) {
        TestingUtil.blockUntilViewsReceived((int)10000, Arrays.asList(caches));
    }

    protected boolean isTransactional() {
        return this.transactional;
    }

    protected boolean isUsingInvalidation() {
        return this.invalidation;
    }

    protected boolean isSynchronous() {
        return this.synchronous;
    }

    protected void evictOrRemoveTest(boolean evict) throws Exception {
        Object KEY = this.generateNextKey();
        Assert.assertEquals((long)0L, (long)this.localRegion.getElementCountInMemory());
        Assert.assertEquals((long)0L, (long)this.remoteRegion.getElementCountInMemory());
        CountDownLatch localPutFromLoadLatch = this.expectRemotePutFromLoad(this.remoteRegion.getCache(), this.localRegion.getCache(), KEY);
        CountDownLatch remotePutFromLoadLatch = this.expectRemotePutFromLoad(this.localRegion.getCache(), this.remoteRegion.getCache(), KEY);
        Object s1 = TEST_SESSION_ACCESS.mockSession(this.jtaPlatform, TIME_SERVICE, this.localEnvironment.getRegionFactory());
        Assert.assertNull((String)"local is clean", (Object)this.testLocalAccessStrategy.get(s1, KEY, SESSION_ACCESS.getTimestamp(s1)));
        Object s2 = TEST_SESSION_ACCESS.mockSession(this.jtaPlatform, TIME_SERVICE, this.remoteEnvironment.getRegionFactory());
        Assert.assertNull((String)"remote is clean", (Object)this.testRemoteAccessStrategy.get(s2, KEY, SESSION_ACCESS.getTimestamp(s2)));
        Object s3 = TEST_SESSION_ACCESS.mockSession(this.jtaPlatform, TIME_SERVICE, this.localEnvironment.getRegionFactory());
        this.testLocalAccessStrategy.putFromLoad(s3, KEY, VALUE1, SESSION_ACCESS.getTimestamp(s3), VALUE1.version);
        Object s5 = TEST_SESSION_ACCESS.mockSession(this.jtaPlatform, TIME_SERVICE, this.remoteEnvironment.getRegionFactory());
        this.testRemoteAccessStrategy.putFromLoad(s5, KEY, VALUE1, SESSION_ACCESS.getTimestamp(s5), VALUE1.version);
        Assert.assertTrue((boolean)localPutFromLoadLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)remotePutFromLoadLatch.await(1L, TimeUnit.SECONDS));
        Object s4 = TEST_SESSION_ACCESS.mockSession(this.jtaPlatform, TIME_SERVICE, this.localEnvironment.getRegionFactory());
        Assert.assertEquals((Object)VALUE1, (Object)this.testLocalAccessStrategy.get(s4, KEY, SESSION_ACCESS.getTimestamp(s4)));
        Object s6 = TEST_SESSION_ACCESS.mockSession(this.jtaPlatform, TIME_SERVICE, this.remoteEnvironment.getRegionFactory());
        Assert.assertEquals((Object)VALUE1, (Object)this.testRemoteAccessStrategy.get(s6, KEY, SESSION_ACCESS.getTimestamp(s6)));
        CountDownLatch endInvalidationLatch = this.createEndInvalidationLatch(evict, KEY);
        CountDownLatch endRemoveLatch = this.createRemoveLatch(evict, KEY);
        Object session = TEST_SESSION_ACCESS.mockSession(this.jtaPlatform, TIME_SERVICE, this.localEnvironment.getRegionFactory());
        this.withTx(this.localEnvironment, session, () -> {
            if (evict) {
                this.testLocalAccessStrategy.evict(KEY);
            } else {
                this.doRemove(this.testLocalAccessStrategy, session, KEY);
            }
            return null;
        });
        Object s7 = TEST_SESSION_ACCESS.mockSession(this.jtaPlatform, TIME_SERVICE, this.localEnvironment.getRegionFactory());
        Assert.assertNull((Object)this.testLocalAccessStrategy.get(s7, KEY, SESSION_ACCESS.getTimestamp(s7)));
        Object s8 = TEST_SESSION_ACCESS.mockSession(this.jtaPlatform, TIME_SERVICE, this.remoteEnvironment.getRegionFactory());
        Assert.assertNull((Object)this.testRemoteAccessStrategy.get(s8, KEY, SESSION_ACCESS.getTimestamp(s8)));
        Assert.assertTrue((boolean)endInvalidationLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertEquals((long)0L, (long)this.localRegion.getElementCountInMemory());
        Assert.assertEquals((long)0L, (long)this.remoteRegion.getElementCountInMemory());
        Assert.assertTrue((boolean)endRemoveLatch.await(1L, TimeUnit.SECONDS));
    }

    protected CountDownLatch createRemoveLatch(boolean evict, Object key) {
        if (!evict) {
            return this.expectAfterUpdate(key);
        }
        return new CountDownLatch(0);
    }

    protected void doRemove(TestSessionAccess.TestRegionAccessStrategy strategy, Object session, Object key) throws SystemException, RollbackException {
        SoftLock softLock = strategy.lockItem(session, key, null);
        strategy.remove(session, key);
        SessionAccess.TransactionCoordinatorAccess transactionCoordinator = SESSION_ACCESS.getTransactionCoordinator(session);
        transactionCoordinator.registerLocalSynchronization((Synchronization)new TestSynchronization.UnlockItem(strategy, session, key, softLock));
    }

    @Test
    public void testRemoveAll() throws Exception {
        this.log.infof(this.name.getMethodName(), new Object[0]);
        this.evictOrRemoveAllTest(false);
    }

    @Test
    public void testEvictAll() throws Exception {
        this.log.infof(this.name.getMethodName(), new Object[0]);
        this.evictOrRemoveAllTest(true);
    }

    protected void assertThreadsRanCleanly() {
        if (this.node1Failure != null) {
            throw this.node1Failure;
        }
        if (this.node2Failure != null) {
            throw this.node2Failure;
        }
        if (this.node1Exception != null) {
            this.log.error((Object)"node1 saw an exception", (Throwable)this.node1Exception);
            Assert.assertEquals((String)"node1 saw no exceptions", null, (Object)this.node1Exception);
        }
        if (this.node2Exception != null) {
            this.log.error((Object)"node2 saw an exception", (Throwable)this.node2Exception);
            Assert.assertEquals((String)"node2 saw no exceptions", null, (Object)this.node2Exception);
        }
    }

    protected abstract Object generateNextKey();

    protected void evictOrRemoveAllTest(boolean evict) throws Exception {
        Object KEY = this.generateNextKey();
        Assert.assertEquals((long)0L, (long)this.localRegion.getElementCountInMemory());
        Assert.assertEquals((long)0L, (long)this.remoteRegion.getElementCountInMemory());
        Object s1 = TEST_SESSION_ACCESS.mockSession(this.jtaPlatform, TIME_SERVICE, this.localEnvironment.getRegionFactory());
        Assert.assertNull((String)"local is clean", (Object)this.testLocalAccessStrategy.get(s1, KEY, SESSION_ACCESS.getTimestamp(s1)));
        Object s2 = TEST_SESSION_ACCESS.mockSession(this.jtaPlatform, TIME_SERVICE, this.remoteEnvironment.getRegionFactory());
        Assert.assertNull((String)"remote is clean", (Object)this.testRemoteAccessStrategy.get(s2, KEY, SESSION_ACCESS.getTimestamp(s2)));
        CountDownLatch localPutFromLoadLatch = this.expectRemotePutFromLoad(this.remoteRegion.getCache(), this.localRegion.getCache(), KEY);
        CountDownLatch remotePutFromLoadLatch = this.expectRemotePutFromLoad(this.localRegion.getCache(), this.remoteRegion.getCache(), KEY);
        Object s3 = TEST_SESSION_ACCESS.mockSession(this.jtaPlatform, TIME_SERVICE, this.localEnvironment.getRegionFactory());
        this.log.infof("Call putFromLoad strategy get for key=%s", KEY);
        this.testLocalAccessStrategy.putFromLoad(s3, KEY, VALUE1, SESSION_ACCESS.getTimestamp(s3), VALUE1.version);
        Object s5 = TEST_SESSION_ACCESS.mockSession(this.jtaPlatform, TIME_SERVICE, this.remoteEnvironment.getRegionFactory());
        this.log.infof("Call remote putFromLoad strategy get for key=%s", KEY);
        this.testRemoteAccessStrategy.putFromLoad(s5, KEY, VALUE1, SESSION_ACCESS.getTimestamp(s5), VALUE2.version);
        Assert.assertTrue((boolean)localPutFromLoadLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)remotePutFromLoadLatch.await(1L, TimeUnit.SECONDS));
        Object s4 = TEST_SESSION_ACCESS.mockSession(this.jtaPlatform, TIME_SERVICE, this.localEnvironment.getRegionFactory());
        Object s6 = TEST_SESSION_ACCESS.mockSession(this.jtaPlatform, TIME_SERVICE, this.remoteEnvironment.getRegionFactory());
        this.log.infof("Call local strategy get for key=%s", KEY);
        Assert.assertEquals((Object)VALUE1, (Object)this.testLocalAccessStrategy.get(s4, KEY, SESSION_ACCESS.getTimestamp(s4)));
        Assert.assertEquals((Object)VALUE1, (Object)this.testRemoteAccessStrategy.get(s6, KEY, SESSION_ACCESS.getTimestamp(s6)));
        CountDownLatch endInvalidationLatch = this.createEndInvalidationLatch(evict, KEY);
        Object removeSession = TEST_SESSION_ACCESS.mockSession(this.jtaPlatform, TIME_SERVICE, this.localEnvironment.getRegionFactory());
        this.withTx(this.localEnvironment, removeSession, () -> {
            if (evict) {
                this.testLocalAccessStrategy.evictAll();
            } else {
                SoftLock softLock = this.testLocalAccessStrategy.lockRegion();
                this.testLocalAccessStrategy.removeAll(removeSession);
                this.testLocalAccessStrategy.unlockRegion(softLock);
            }
            return null;
        });
        Object s7 = TEST_SESSION_ACCESS.mockSession(this.jtaPlatform, TIME_SERVICE, this.localEnvironment.getRegionFactory());
        Assert.assertNull((Object)this.testLocalAccessStrategy.get(s7, KEY, SESSION_ACCESS.getTimestamp(s7)));
        Assert.assertEquals((long)0L, (long)this.localRegion.getElementCountInMemory());
        Object s8 = TEST_SESSION_ACCESS.mockSession(this.jtaPlatform, TIME_SERVICE, this.remoteEnvironment.getRegionFactory());
        Assert.assertNull((Object)this.testRemoteAccessStrategy.get(s8, KEY, SESSION_ACCESS.getTimestamp(s8)));
        Assert.assertEquals((long)0L, (long)this.remoteRegion.getElementCountInMemory());
        Assert.assertTrue((boolean)endInvalidationLatch.await(1L, TimeUnit.SECONDS));
        TIME_SERVICE.advance(1L);
        CountDownLatch lastPutFromLoadLatch = this.expectRemotePutFromLoad(this.remoteRegion.getCache(), this.localRegion.getCache(), KEY);
        Object s9 = TEST_SESSION_ACCESS.mockSession(this.jtaPlatform, TIME_SERVICE, this.remoteEnvironment.getRegionFactory());
        this.log.infof("Call remote strategy putFromLoad for key=%s and value=%s", KEY, (Object)VALUE1);
        Assert.assertTrue((boolean)this.testRemoteAccessStrategy.putFromLoad(s9, KEY, VALUE1, SESSION_ACCESS.getTimestamp(s9), 1));
        Object s10 = TEST_SESSION_ACCESS.mockSession(this.jtaPlatform, TIME_SERVICE, this.remoteEnvironment.getRegionFactory());
        this.log.infof("Call remote strategy get for key=%s", KEY);
        Assert.assertEquals((Object)VALUE1, (Object)this.testRemoteAccessStrategy.get(s10, KEY, SESSION_ACCESS.getTimestamp(s10)));
        Assert.assertTrue((boolean)lastPutFromLoadLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertEquals((long)1L, (long)this.remoteRegion.getElementCountInMemory());
        Object s11 = TEST_SESSION_ACCESS.mockSession(this.jtaPlatform, TIME_SERVICE, this.localEnvironment.getRegionFactory());
        Assert.assertEquals((Object)(this.isUsingInvalidation() ? null : VALUE1), (Object)this.testLocalAccessStrategy.get(s11, KEY, SESSION_ACCESS.getTimestamp(s11)));
        Object s12 = TEST_SESSION_ACCESS.mockSession(this.jtaPlatform, TIME_SERVICE, this.remoteEnvironment.getRegionFactory());
        Assert.assertEquals((Object)VALUE1, (Object)this.testRemoteAccessStrategy.get(s12, KEY, SESSION_ACCESS.getTimestamp(s12)));
    }

    private CountDownLatch createEndInvalidationLatch(boolean evict, Object key) {
        CountDownLatch endInvalidationLatch;
        if (this.invalidation && !evict) {
            endInvalidationLatch = new CountDownLatch(1);
            if (this.transactional) {
                this.expectPutFromLoadEndInvalidating(this.remoteRegion, key, endInvalidationLatch);
            } else {
                this.expectInvalidateCommand(this.remoteRegion, endInvalidationLatch);
            }
        } else {
            endInvalidationLatch = new CountDownLatch(0);
        }
        this.log.debugf("Create end invalidation latch: %s", (Object)endInvalidationLatch);
        return endInvalidationLatch;
    }

    private void expectPutFromLoadEndInvalidating(InfinispanBaseRegion region, Object key, CountDownLatch endInvalidationLatch) {
        PutFromLoadValidator originalValidator = PutFromLoadValidator.removeFromCache((AdvancedCache)region.getCache());
        Assert.assertEquals(PutFromLoadValidator.class, originalValidator.getClass());
        PutFromLoadValidator mockValidator = (PutFromLoadValidator)Mockito.spy((Object)originalValidator);
        ((PutFromLoadValidator)Mockito.doAnswer(invocation -> {
            try {
                Object object = invocation.callRealMethod();
                return object;
            }
            finally {
                this.log.debugf("Count down latch after calling endInvalidatingKey %s", (Object)endInvalidationLatch);
                endInvalidationLatch.countDown();
            }
        }).when((Object)mockValidator)).endInvalidatingKey(Matchers.any(), ArgumentMatchers.eq((Object)key));
        PutFromLoadValidator.addToCache((AdvancedCache)region.getCache(), (PutFromLoadValidator)mockValidator);
        this.cleanup.add(() -> {
            PutFromLoadValidator.removeFromCache((AdvancedCache)region.getCache());
            PutFromLoadValidator.addToCache((AdvancedCache)region.getCache(), (PutFromLoadValidator)originalValidator);
        });
    }

    private void expectInvalidateCommand(InfinispanBaseRegion region, CountDownLatch latch) {
        ExpectingInterceptor.get(region.getCache()).when((ctx, cmd) -> cmd instanceof InvalidateCommand || cmd instanceof ClearCommand).countDown(latch);
        this.cleanup.add(() -> ExpectingInterceptor.cleanup(region.getCache()));
    }

    private CountDownLatch expectRemotePutFromLoad(AdvancedCache localCache, AdvancedCache remoteCache, Object key) {
        CountDownLatch putFromLoadLatch;
        if (!this.isUsingInvalidation()) {
            putFromLoadLatch = new CountDownLatch(1);
            ExpectingInterceptor.Condition remoteCondition = ExpectingInterceptor.get(remoteCache).when((ctx, cmd) -> {
                boolean isRemote = !ctx.isOriginLocal();
                boolean isExpectedReadWriteKey = this.isExpectedReadWriteKey(key, (VisitableCommand)cmd);
                boolean cond = isRemote && isExpectedReadWriteKey;
                this.log.debugf("Remote condition [test: isRemote=%b && isRWK=%b; should be true: %b]", (Object)isRemote, (Object)isExpectedReadWriteKey, (Object)cond);
                return cond;
            });
            ExpectingInterceptor.Condition localCondition = ExpectingInterceptor.get(localCache).whenFails((ctx, cmd) -> {
                boolean isLocal = ctx.isOriginLocal();
                boolean isExpectedReadWriteKey = this.isExpectedReadWriteKey(key, (VisitableCommand)cmd);
                boolean cond = isLocal && isExpectedReadWriteKey;
                this.log.debugf("Local condition [test: isLocal=%b && isRWK=%b; should be false: %b]", (Object)isLocal, (Object)isExpectedReadWriteKey, (Object)cond);
                return cond;
            });
            remoteCondition.run(() -> {
                localCondition.cancel();
                this.log.debugf("Counting down latch because remote condition succeed", new Object[0]);
                putFromLoadLatch.countDown();
            });
            localCondition.run(() -> {
                remoteCondition.cancel();
                this.log.debugf("Counting down latch because local condition succeed", new Object[0]);
                putFromLoadLatch.countDown();
            });
            this.cleanup.add(() -> ExpectingInterceptor.cleanup(localCache, remoteCache));
        } else {
            putFromLoadLatch = new CountDownLatch(0);
        }
        return putFromLoadLatch;
    }

    private boolean isExpectedReadWriteKey(Object key, VisitableCommand cmd) {
        boolean isPut = cmd instanceof ReadWriteKeyCommand;
        if (isPut) {
            Object cmdKey = ((ReadWriteKeyCommand)cmd).getKey();
            boolean isPutForKey = cmdKey.equals(key);
            if (!isPutForKey) {
                this.log.warnf("Put received for key=%s, but expecting put for key=%s. Maybe there's a command leak?", cmdKey, key);
            }
            return isPutForKey;
        }
        return false;
    }

    public static class TestCacheEntry
    implements CacheEntry,
    Serializable {
        private final Serializable value;
        private final Serializable version;

        public TestCacheEntry(Serializable value, Serializable version) {
            this.value = value;
            this.version = version;
        }

        public boolean isReferenceEntry() {
            return false;
        }

        public String getSubclass() {
            return AbstractRegionAccessStrategyTest.REGION_NAME;
        }

        public Object getVersion() {
            return this.version;
        }

        public Serializable[] getDisassembledState() {
            return new Serializable[]{this.value, this.version};
        }

        public String toString() {
            return this.value + "/" + this.version;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestCacheEntry that = (TestCacheEntry)o;
            return Objects.equals(this.value, that.value) && Objects.equals(this.version, that.version);
        }

        public int hashCode() {
            return Objects.hash(this.value, this.version);
        }
    }
}

