/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.commons;

import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import java.util.function.Consumer;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cfg.Environment;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.testing.boot.ServiceRegistryTestingImpl;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ClusteringConfigurationBuilder;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.eviction.EvictionType;
import org.infinispan.hibernate.cache.commons.InfinispanBaseRegion;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.Exceptions;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.hibernate.cache.commons.util.InfinispanTestingSetup;
import org.infinispan.test.hibernate.cache.commons.util.TestRegionFactory;
import org.infinispan.test.hibernate.cache.commons.util.TestRegionFactoryProvider;
import org.infinispan.transaction.TransactionMode;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class InfinispanRegionFactoryTestCase {
    @Rule
    public InfinispanTestingSetup infinispanTestIdentifier = new InfinispanTestingSetup();
    private final ServiceRegistryTestingImpl serviceRegistry = ServiceRegistryTestingImpl.forUnitTesting();

    @After
    public void tearDown() {
        this.serviceRegistry.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConfigurationProcessing() {
        String person = "com.acme.Person";
        String addresses = "com.acme.Person.addresses";
        Properties p = InfinispanRegionFactoryTestCase.createProperties();
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.cfg", "person-cache");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.memory.eviction.type", "MEMORY");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.memory.size", "5000");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.expiration.wake_up_interval", "2000");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.expiration.lifespan", "60000");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.expiration.max_idle", "30000");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.addresses.cfg", "person-addresses-cache");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.addresses.expiration.lifespan", "120000");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.addresses.expiration.max_idle", "60000");
        p.setProperty("hibernate.cache.infinispan.query.cfg", "my-query-cache");
        p.setProperty("hibernate.cache.infinispan.query.memory.eviction.type", "MEMORY");
        p.setProperty("hibernate.cache.infinispan.query.expiration.wake_up_interval", "3000");
        p.setProperty("hibernate.cache.infinispan.query.memory.size", "10000");
        TestRegionFactory factory = this.createRegionFactory(p);
        try {
            Assert.assertEquals((Object)"person-cache", (Object)factory.getBaseConfiguration("com.acme.Person"));
            Configuration personOverride = factory.getConfigurationOverride("com.acme.Person");
            Assert.assertEquals((Object)EvictionType.COUNT, (Object)personOverride.memory().evictionType());
            Assert.assertEquals((long)5000L, (long)personOverride.memory().size());
            Assert.assertEquals((long)2000L, (long)personOverride.expiration().wakeUpInterval());
            Assert.assertEquals((long)60000L, (long)personOverride.expiration().lifespan());
            Assert.assertEquals((long)30000L, (long)personOverride.expiration().maxIdle());
            Assert.assertEquals((Object)"person-addresses-cache", (Object)factory.getBaseConfiguration("com.acme.Person.addresses"));
            Configuration addressesOverride = factory.getConfigurationOverride("com.acme.Person.addresses");
            Assert.assertEquals((long)120000L, (long)addressesOverride.expiration().lifespan());
            Assert.assertEquals((long)60000L, (long)addressesOverride.expiration().maxIdle());
            Assert.assertEquals((Object)"my-query-cache", (Object)factory.getBaseConfiguration("query"));
            Configuration queryOverride = factory.getConfigurationOverride("query");
            Assert.assertEquals((Object)EvictionType.COUNT, (Object)queryOverride.memory().evictionType());
            Assert.assertEquals((long)10000L, (long)queryOverride.memory().size());
            Assert.assertEquals((long)3000L, (long)queryOverride.expiration().wakeUpInterval());
        }
        finally {
            factory.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBuildEntityCollectionRegionsPersonPlusEntityCollectionOverrides() {
        String person = "com.acme.Person";
        String address = "com.acme.Address";
        String car = "com.acme.Car";
        String addresses = "com.acme.Person.addresses";
        String parts = "com.acme.Car.parts";
        Properties p = InfinispanRegionFactoryTestCase.createProperties();
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.cfg", "person-cache");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.memory.eviction.type", "MEMORY");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.memory.size", "5000");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.expiration.wake_up_interval", "2000");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.expiration.lifespan", "60000");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.expiration.max_idle", "30000");
        p.setProperty("hibernate.cache.infinispan.entity.cfg", "myentity-cache");
        p.setProperty("hibernate.cache.infinispan.entity.memory.eviction.type", "MEMORY");
        p.setProperty("hibernate.cache.infinispan.entity.expiration.wake_up_interval", "3000");
        p.setProperty("hibernate.cache.infinispan.entity.memory.size", "20000");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.addresses.cfg", "addresses-cache");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.addresses.memory.eviction.type", "MEMORY");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.addresses.memory.size", "5500");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.addresses.expiration.wake_up_interval", "2500");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.addresses.expiration.lifespan", "65000");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.addresses.expiration.max_idle", "35000");
        p.setProperty("hibernate.cache.infinispan.collection.cfg", "mycollection-cache");
        p.setProperty("hibernate.cache.infinispan.collection.memory.eviction.type", "MEMORY");
        p.setProperty("hibernate.cache.infinispan.collection.expiration.wake_up_interval", "3500");
        p.setProperty("hibernate.cache.infinispan.collection.memory.size", "25000");
        TestRegionFactory factory = this.createRegionFactory(p);
        try {
            EmbeddedCacheManager manager = factory.getCacheManager();
            Assert.assertFalse((boolean)manager.getCacheManagerConfiguration().globalJmxStatistics().enabled());
            Assert.assertNotNull((Object)factory.getBaseConfiguration("com.acme.Person"));
            Assert.assertFalse((boolean)this.isDefinedCache(factory, "com.acme.Person"));
            Assert.assertNotNull((Object)factory.getBaseConfiguration("com.acme.Person.addresses"));
            Assert.assertFalse((boolean)this.isDefinedCache(factory, "com.acme.Person.addresses"));
            Assert.assertNull((Object)factory.getBaseConfiguration("com.acme.Address"));
            Assert.assertNull((Object)factory.getBaseConfiguration("com.acme.Car.parts"));
            InfinispanBaseRegion region = factory.buildEntityRegion("com.acme.Person", AccessType.TRANSACTIONAL);
            Assert.assertTrue((boolean)this.isDefinedCache(factory, "com.acme.Person"));
            AdvancedCache cache = region.getCache();
            Configuration cacheCfg = cache.getCacheConfiguration();
            Assert.assertEquals((Object)EvictionType.COUNT, (Object)cacheCfg.memory().evictionType());
            Assert.assertEquals((long)2000L, (long)cacheCfg.expiration().wakeUpInterval());
            Assert.assertEquals((long)5000L, (long)cacheCfg.memory().size());
            Assert.assertEquals((long)60000L, (long)cacheCfg.expiration().lifespan());
            Assert.assertEquals((long)30000L, (long)cacheCfg.expiration().maxIdle());
            Assert.assertFalse((boolean)cacheCfg.jmxStatistics().enabled());
            region = factory.buildEntityRegion("com.acme.Address", AccessType.TRANSACTIONAL);
            Assert.assertTrue((boolean)this.isDefinedCache(factory, "com.acme.Person"));
            cache = region.getCache();
            cacheCfg = cache.getCacheConfiguration();
            Assert.assertEquals((Object)EvictionType.COUNT, (Object)cacheCfg.memory().evictionType());
            Assert.assertEquals((long)3000L, (long)cacheCfg.expiration().wakeUpInterval());
            Assert.assertEquals((long)20000L, (long)cacheCfg.memory().size());
            Assert.assertFalse((boolean)cacheCfg.jmxStatistics().enabled());
            region = factory.buildEntityRegion("com.acme.Car", AccessType.TRANSACTIONAL);
            Assert.assertTrue((boolean)this.isDefinedCache(factory, "com.acme.Person"));
            cache = region.getCache();
            cacheCfg = cache.getCacheConfiguration();
            Assert.assertEquals((Object)EvictionType.COUNT, (Object)cacheCfg.memory().evictionType());
            Assert.assertEquals((long)3000L, (long)cacheCfg.expiration().wakeUpInterval());
            Assert.assertEquals((long)20000L, (long)cacheCfg.memory().size());
            Assert.assertFalse((boolean)cacheCfg.jmxStatistics().enabled());
            InfinispanBaseRegion collectionRegion = factory.buildCollectionRegion("com.acme.Person.addresses", AccessType.TRANSACTIONAL);
            Assert.assertTrue((boolean)this.isDefinedCache(factory, "com.acme.Person"));
            cache = collectionRegion.getCache();
            cacheCfg = cache.getCacheConfiguration();
            Assert.assertEquals((Object)EvictionType.COUNT, (Object)cacheCfg.memory().evictionType());
            Assert.assertEquals((long)2500L, (long)cacheCfg.expiration().wakeUpInterval());
            Assert.assertEquals((long)5500L, (long)cacheCfg.memory().size());
            Assert.assertEquals((long)65000L, (long)cacheCfg.expiration().lifespan());
            Assert.assertEquals((long)35000L, (long)cacheCfg.expiration().maxIdle());
            Assert.assertFalse((boolean)cacheCfg.jmxStatistics().enabled());
            collectionRegion = factory.buildCollectionRegion("com.acme.Car.parts", AccessType.TRANSACTIONAL);
            Assert.assertTrue((boolean)this.isDefinedCache(factory, "com.acme.Person.addresses"));
            cache = collectionRegion.getCache();
            cacheCfg = cache.getCacheConfiguration();
            Assert.assertEquals((Object)EvictionType.COUNT, (Object)cacheCfg.memory().evictionType());
            Assert.assertEquals((long)3500L, (long)cacheCfg.expiration().wakeUpInterval());
            Assert.assertEquals((long)25000L, (long)cacheCfg.memory().size());
            Assert.assertFalse((boolean)cacheCfg.jmxStatistics().enabled());
            collectionRegion = factory.buildCollectionRegion("com.acme.Car.parts", AccessType.TRANSACTIONAL);
            Assert.assertTrue((boolean)this.isDefinedCache(factory, "com.acme.Person.addresses"));
            cache = collectionRegion.getCache();
            cacheCfg = cache.getCacheConfiguration();
            Assert.assertEquals((Object)EvictionType.COUNT, (Object)cacheCfg.memory().evictionType());
            Assert.assertEquals((long)3500L, (long)cacheCfg.expiration().wakeUpInterval());
            Assert.assertEquals((long)25000L, (long)cacheCfg.memory().size());
            Assert.assertFalse((boolean)cacheCfg.jmxStatistics().enabled());
        }
        finally {
            factory.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBuildEntityCollectionRegionOverridesOnly() {
        String address = "com.acme.Address";
        String personAddressses = "com.acme.Person.addresses";
        Properties p = InfinispanRegionFactoryTestCase.createProperties();
        p.setProperty("hibernate.cache.infinispan.entity.memory.eviction.type", "MEMORY");
        p.setProperty("hibernate.cache.infinispan.entity.memory.size", "30000");
        p.setProperty("hibernate.cache.infinispan.entity.expiration.wake_up_interval", "3000");
        p.setProperty("hibernate.cache.infinispan.collection.memory.eviction.type", "MEMORY");
        p.setProperty("hibernate.cache.infinispan.collection.memory.size", "35000");
        p.setProperty("hibernate.cache.infinispan.collection.expiration.wake_up_interval", "3500");
        TestRegionFactory factory = this.createRegionFactory(p);
        try {
            factory.getCacheManager();
            InfinispanBaseRegion region = factory.buildEntityRegion("com.acme.Address", AccessType.TRANSACTIONAL);
            Assert.assertNull((Object)factory.getBaseConfiguration("com.acme.Address"));
            AdvancedCache cache = region.getCache();
            Configuration cacheCfg = cache.getCacheConfiguration();
            Assert.assertEquals((Object)EvictionType.COUNT, (Object)cacheCfg.memory().evictionType());
            Assert.assertEquals((long)3000L, (long)cacheCfg.expiration().wakeUpInterval());
            Assert.assertEquals((long)30000L, (long)cacheCfg.memory().size());
            Assert.assertEquals((long)100000L, (long)cacheCfg.expiration().maxIdle());
            InfinispanBaseRegion collectionRegion = factory.buildCollectionRegion("com.acme.Person.addresses", AccessType.TRANSACTIONAL);
            Assert.assertNull((Object)factory.getBaseConfiguration("com.acme.Person.addresses"));
            cache = collectionRegion.getCache();
            cacheCfg = cache.getCacheConfiguration();
            Assert.assertEquals((Object)EvictionType.COUNT, (Object)cacheCfg.memory().evictionType());
            Assert.assertEquals((long)3500L, (long)cacheCfg.expiration().wakeUpInterval());
            Assert.assertEquals((long)35000L, (long)cacheCfg.memory().size());
            Assert.assertEquals((long)100000L, (long)cacheCfg.expiration().maxIdle());
        }
        finally {
            factory.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBuildEntityRegionPersonPlusEntityOverridesWithoutCfg() {
        String person = "com.acme.Person";
        Properties p = InfinispanRegionFactoryTestCase.createProperties();
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.memory.eviction.type", "MEMORY");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.expiration.lifespan", "60000");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.expiration.max_idle", "30000");
        p.setProperty("hibernate.cache.infinispan.entity.cfg", "myentity-cache");
        p.setProperty("hibernate.cache.infinispan.entity.memory.eviction.type", "FIFO");
        p.setProperty("hibernate.cache.infinispan.entity.memory.size", "10000");
        p.setProperty("hibernate.cache.infinispan.entity.expiration.wake_up_interval", "3000");
        TestRegionFactory factory = this.createRegionFactory(p);
        try {
            factory.getCacheManager();
            Assert.assertFalse((boolean)this.isDefinedCache(factory, "com.acme.Person"));
            InfinispanBaseRegion region = factory.buildEntityRegion("com.acme.Person", AccessType.TRANSACTIONAL);
            Assert.assertTrue((boolean)this.isDefinedCache(factory, "com.acme.Person"));
            AdvancedCache cache = region.getCache();
            Configuration cacheCfg = cache.getCacheConfiguration();
            Assert.assertEquals((Object)EvictionType.COUNT, (Object)cacheCfg.memory().evictionType());
            Assert.assertEquals((long)3000L, (long)cacheCfg.expiration().wakeUpInterval());
            Assert.assertEquals((long)10000L, (long)cacheCfg.memory().size());
            Assert.assertEquals((long)60000L, (long)cacheCfg.expiration().lifespan());
            Assert.assertEquals((long)30000L, (long)cacheCfg.expiration().maxIdle());
        }
        finally {
            factory.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBuildImmutableEntityRegion() {
        Properties p = new Properties();
        TestRegionFactory factory = this.createRegionFactory(p);
        try {
            factory.getCacheManager();
            InfinispanBaseRegion region = factory.buildEntityRegion("com.acme.Address", AccessType.TRANSACTIONAL);
            Assert.assertNull((Object)factory.getBaseConfiguration("com.acme.Address"));
            AdvancedCache cache = region.getCache();
            Configuration cacheCfg = cache.getCacheConfiguration();
            Assert.assertEquals((String)"Immutable entity should get non-transactional cache", (Object)TransactionMode.NON_TRANSACTIONAL, (Object)cacheCfg.transaction().transactionMode());
        }
        finally {
            factory.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimestampValidation() throws IOException {
        String timestamps = "org.hibernate.cache.spi.UpdateTimestampsCache";
        Properties p = InfinispanRegionFactoryTestCase.createProperties();
        URL url = FileLookupFactory.newInstance().lookupFileLocation("org/infinispan/hibernate/cache/commons/builder/infinispan-configs.xml", this.getClass().getClassLoader());
        ConfigurationBuilderHolder cbh = new ParserRegistry().parse(url);
        ConfigurationBuilder builder = (ConfigurationBuilder)cbh.getNamedConfigurationBuilders().get("timestamps");
        builder.clustering().cacheMode(CacheMode.INVALIDATION_SYNC);
        DefaultCacheManager manager = new DefaultCacheManager(cbh, true);
        try {
            TestRegionFactory factory = this.createRegionFactory((EmbeddedCacheManager)manager, p, null);
            factory.start((ServiceRegistry)this.serviceRegistry, p);
            Exceptions.expectException(CacheException.class, () -> factory.buildTimestampsRegion("org.hibernate.cache.spi.UpdateTimestampsCache"));
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{manager});
            throw throwable;
        }
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{manager});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBuildDefaultTimestampsRegion() {
        String timestamps = "org.hibernate.cache.spi.UpdateTimestampsCache";
        Properties p = InfinispanRegionFactoryTestCase.createProperties();
        TestRegionFactory factory = this.createRegionFactory(p);
        try {
            Assert.assertTrue((boolean)this.isDefinedCache(factory, "timestamps"));
            InfinispanBaseRegion region = factory.buildTimestampsRegion("org.hibernate.cache.spi.UpdateTimestampsCache");
            AdvancedCache cache = region.getCache();
            Assert.assertEquals((Object)"org.hibernate.cache.spi.UpdateTimestampsCache", (Object)cache.getName());
            Configuration cacheCfg = cache.getCacheConfiguration();
            Assert.assertEquals((Object)CacheMode.REPL_ASYNC, (Object)cacheCfg.clustering().cacheMode());
            Assert.assertFalse((boolean)cacheCfg.jmxStatistics().enabled());
        }
        finally {
            factory.stop();
        }
    }

    protected boolean isDefinedCache(TestRegionFactory factory, String cacheName) {
        return factory.getCacheManager().getCacheConfiguration(cacheName) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBuildDiffCacheNameTimestampsRegion() {
        String timestamps = "org.hibernate.cache.spi.UpdateTimestampsCache";
        String unrecommendedTimestamps = "unrecommended-timestamps";
        Properties p = InfinispanRegionFactoryTestCase.createProperties();
        p.setProperty("hibernate.cache.infinispan.timestamps.cfg", "unrecommended-timestamps");
        TestRegionFactory factory = this.createRegionFactory(p, m -> {
            ConfigurationBuilder builder = new ConfigurationBuilder();
            builder.clustering().stateTransfer().fetchInMemoryState(true);
            builder.clustering().cacheMode(CacheMode.REPL_SYNC);
            m.defineConfiguration("unrecommended-timestamps", builder.build());
        });
        try {
            Assert.assertEquals((Object)"unrecommended-timestamps", (Object)factory.getBaseConfiguration("timestamps"));
            InfinispanBaseRegion region = factory.buildTimestampsRegion("org.hibernate.cache.spi.UpdateTimestampsCache");
            AdvancedCache cache = region.getCache();
            Configuration cacheCfg = cache.getCacheConfiguration();
            Assert.assertEquals((Object)CacheMode.REPL_SYNC, (Object)cacheCfg.clustering().cacheMode());
            Assert.assertTrue((cacheCfg.memory().storageType() != StorageType.BINARY ? 1 : 0) != 0);
            Assert.assertFalse((boolean)cacheCfg.jmxStatistics().enabled());
        }
        finally {
            factory.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBuildTimestampsRegionWithCacheNameOverride() {
        String timestamps = "org.hibernate.cache.spi.UpdateTimestampsCache";
        String myTimestampsCache = "mytimestamps-cache";
        Properties p = InfinispanRegionFactoryTestCase.createProperties();
        p.setProperty("hibernate.cache.infinispan.timestamps.cfg", "mytimestamps-cache");
        TestRegionFactory factory = this.createRegionFactory(p, m -> {
            ClusteringConfigurationBuilder builder = new ConfigurationBuilder().clustering().cacheMode(CacheMode.LOCAL);
            m.defineConfiguration("mytimestamps-cache", builder.build());
        });
        try {
            InfinispanBaseRegion region = factory.buildTimestampsRegion("org.hibernate.cache.spi.UpdateTimestampsCache");
            Assert.assertTrue((boolean)this.isDefinedCache(factory, "org.hibernate.cache.spi.UpdateTimestampsCache"));
            Assert.assertEquals((Object)CacheMode.LOCAL, (Object)region.getCache().getCacheConfiguration().clustering().cacheMode());
        }
        finally {
            factory.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBuildTimestampsRegionWithFifoEvictionOverride() {
        String timestamps = "org.hibernate.cache.spi.UpdateTimestampsCache";
        String myTimestampsCache = "mytimestamps-cache";
        Properties p = InfinispanRegionFactoryTestCase.createProperties();
        p.setProperty("hibernate.cache.infinispan.timestamps.cfg", "mytimestamps-cache");
        p.setProperty("hibernate.cache.infinispan.timestamps.memory.eviction.type", "FIFO");
        p.setProperty("hibernate.cache.infinispan.timestamps.memory.size", "10000");
        p.setProperty("hibernate.cache.infinispan.timestamps.expiration.wake_up_interval", "3000");
        TestRegionFactory factory = this.createRegionFactory(p);
        try {
            Exceptions.expectException(CacheException.class, () -> factory.buildTimestampsRegion("org.hibernate.cache.spi.UpdateTimestampsCache"));
        }
        finally {
            factory.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBuildTimestampsRegionWithNoneEvictionOverride() {
        String timestamps = "org.hibernate.cache.spi.UpdateTimestampsCache";
        String timestampsNoEviction = "timestamps-no-eviction";
        Properties p = InfinispanRegionFactoryTestCase.createProperties();
        p.setProperty("hibernate.cache.infinispan.timestamps.cfg", "timestamps-no-eviction");
        p.setProperty("hibernate.cache.infinispan.timestamps.memory.size", "0");
        p.setProperty("hibernate.cache.infinispan.timestamps.expiration.wake_up_interval", "3000");
        TestRegionFactory factory = this.createRegionFactory(p);
        try {
            InfinispanBaseRegion region = factory.buildTimestampsRegion("org.hibernate.cache.spi.UpdateTimestampsCache");
            Assert.assertTrue((boolean)this.isDefinedCache(factory, "org.hibernate.cache.spi.UpdateTimestampsCache"));
            Assert.assertEquals((long)3000L, (long)region.getCache().getCacheConfiguration().expiration().wakeUpInterval());
        }
        finally {
            factory.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBuildQueryRegion() {
        String query = "org.hibernate.cache.internal.StandardQueryCache";
        Properties p = InfinispanRegionFactoryTestCase.createProperties();
        TestRegionFactory factory = this.createRegionFactory(p);
        try {
            Assert.assertTrue((boolean)this.isDefinedCache(factory, "local-query"));
            InfinispanBaseRegion region = factory.buildQueryResultsRegion("org.hibernate.cache.internal.StandardQueryCache");
            AdvancedCache cache = region.getCache();
            Configuration cacheCfg = cache.getCacheConfiguration();
            Assert.assertEquals((Object)CacheMode.LOCAL, (Object)cacheCfg.clustering().cacheMode());
            Assert.assertFalse((boolean)cacheCfg.jmxStatistics().enabled());
        }
        finally {
            factory.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBuildQueryRegionWithCustomRegionName() {
        String queryRegionName = "myquery";
        Properties p = InfinispanRegionFactoryTestCase.createProperties();
        p.setProperty("hibernate.cache.infinispan.myquery.cfg", "timestamps-none-eviction");
        p.setProperty("hibernate.cache.infinispan.myquery.memory.eviction.type", "MEMORY");
        p.setProperty("hibernate.cache.infinispan.myquery.expiration.wake_up_interval", "2222");
        p.setProperty("hibernate.cache.infinispan.myquery.memory.size", "11111");
        TestRegionFactory factory = this.createRegionFactory(p);
        try {
            Assert.assertTrue((boolean)this.isDefinedCache(factory, "local-query"));
            InfinispanBaseRegion region = factory.buildQueryResultsRegion("myquery");
            Assert.assertNotNull((Object)factory.getBaseConfiguration("myquery"));
            Assert.assertTrue((boolean)this.isDefinedCache(factory, "myquery"));
            AdvancedCache cache = region.getCache();
            Configuration cacheCfg = cache.getCacheConfiguration();
            Assert.assertEquals((Object)EvictionType.COUNT, (Object)cacheCfg.memory().evictionType());
            Assert.assertEquals((long)2222L, (long)cacheCfg.expiration().wakeUpInterval());
            Assert.assertEquals((long)11111L, (long)cacheCfg.memory().size());
        }
        finally {
            factory.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEnableStatistics() {
        Properties p = InfinispanRegionFactoryTestCase.createProperties();
        p.setProperty("hibernate.cache.infinispan.statistics", "true");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.expiration.lifespan", "60000");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.expiration.max_idle", "30000");
        p.setProperty("hibernate.cache.infinispan.entity.cfg", "myentity-cache");
        p.setProperty("hibernate.cache.infinispan.entity.memory.eviction.type", "FIFO");
        p.setProperty("hibernate.cache.infinispan.entity.expiration.wake_up_interval", "3000");
        p.setProperty("hibernate.cache.infinispan.entity.memory.size", "10000");
        TestRegionFactory factory = this.createRegionFactory(p);
        try {
            EmbeddedCacheManager manager = factory.getCacheManager();
            Assert.assertTrue((boolean)manager.getCacheManagerConfiguration().globalJmxStatistics().enabled());
            InfinispanBaseRegion region = factory.buildEntityRegion("com.acme.Address", AccessType.TRANSACTIONAL);
            AdvancedCache cache = region.getCache();
            Assert.assertTrue((boolean)cache.getCacheConfiguration().jmxStatistics().enabled());
            region = factory.buildEntityRegion("com.acme.Person", AccessType.TRANSACTIONAL);
            cache = region.getCache();
            Assert.assertTrue((boolean)cache.getCacheConfiguration().jmxStatistics().enabled());
            String query = "org.hibernate.cache.internal.StandardQueryCache";
            InfinispanBaseRegion queryRegion = factory.buildQueryResultsRegion("org.hibernate.cache.internal.StandardQueryCache");
            cache = queryRegion.getCache();
            Assert.assertTrue((boolean)cache.getCacheConfiguration().jmxStatistics().enabled());
            String timestamps = "org.hibernate.cache.spi.UpdateTimestampsCache";
            InfinispanBaseRegion timestampsRegion = factory.buildTimestampsRegion("org.hibernate.cache.spi.UpdateTimestampsCache");
            cache = timestampsRegion.getCache();
            Assert.assertTrue((boolean)cache.getCacheConfiguration().jmxStatistics().enabled());
            InfinispanBaseRegion collectionRegion = factory.buildCollectionRegion("com.acme.Person.addresses", AccessType.TRANSACTIONAL);
            cache = collectionRegion.getCache();
            Assert.assertTrue((boolean)cache.getCacheConfiguration().jmxStatistics().enabled());
        }
        finally {
            factory.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisableStatistics() {
        Properties p = InfinispanRegionFactoryTestCase.createProperties();
        p.setProperty("hibernate.cache.infinispan.statistics", "false");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.expiration.lifespan", "60000");
        p.setProperty("hibernate.cache.infinispan.com.acme.Person.expiration.max_idle", "30000");
        p.setProperty("hibernate.cache.infinispan.entity.cfg", "myentity-cache");
        p.setProperty("hibernate.cache.infinispan.entity.memory.eviction.type", "FIFO");
        p.setProperty("hibernate.cache.infinispan.entity.expiration.wake_up_interval", "3000");
        p.setProperty("hibernate.cache.infinispan.entity.memory.size", "10000");
        TestRegionFactory factory = this.createRegionFactory(p);
        try {
            InfinispanBaseRegion region = factory.buildEntityRegion("com.acme.Address", AccessType.TRANSACTIONAL);
            AdvancedCache cache = region.getCache();
            Assert.assertFalse((boolean)cache.getCacheConfiguration().jmxStatistics().enabled());
            region = factory.buildEntityRegion("com.acme.Person", AccessType.TRANSACTIONAL);
            cache = region.getCache();
            Assert.assertFalse((boolean)cache.getCacheConfiguration().jmxStatistics().enabled());
            String query = "org.hibernate.cache.internal.StandardQueryCache";
            InfinispanBaseRegion queryRegion = factory.buildQueryResultsRegion("org.hibernate.cache.internal.StandardQueryCache");
            cache = queryRegion.getCache();
            Assert.assertFalse((boolean)cache.getCacheConfiguration().jmxStatistics().enabled());
            String timestamps = "org.hibernate.cache.spi.UpdateTimestampsCache";
            InfinispanBaseRegion timestampsRegion = factory.buildTimestampsRegion("org.hibernate.cache.spi.UpdateTimestampsCache");
            cache = timestampsRegion.getCache();
            Assert.assertFalse((boolean)cache.getCacheConfiguration().jmxStatistics().enabled());
            InfinispanBaseRegion collectionRegion = factory.buildCollectionRegion("com.acme.Person.addresses", AccessType.TRANSACTIONAL);
            cache = collectionRegion.getCache();
            Assert.assertFalse((boolean)cache.getCacheConfiguration().jmxStatistics().enabled());
        }
        finally {
            factory.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDefaultPendingPutsCache() {
        Properties p = InfinispanRegionFactoryTestCase.createProperties();
        TestRegionFactory factory = this.createRegionFactory(p);
        try {
            Configuration ppConfig = factory.getCacheManager().getCacheConfiguration("pending-puts");
            Assert.assertTrue((boolean)ppConfig.isTemplate());
            Assert.assertFalse((boolean)ppConfig.clustering().cacheMode().isClustered());
            Assert.assertTrue((boolean)ppConfig.simpleCache());
            Assert.assertEquals((Object)TransactionMode.NON_TRANSACTIONAL, (Object)ppConfig.transaction().transactionMode());
            Assert.assertEquals((long)60000L, (long)ppConfig.expiration().maxIdle());
            Assert.assertFalse((boolean)ppConfig.jmxStatistics().enabled());
            Assert.assertFalse((boolean)ppConfig.jmxStatistics().available());
        }
        finally {
            factory.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCustomPendingPutsCache() {
        Properties p = InfinispanRegionFactoryTestCase.createProperties();
        p.setProperty("hibernate.cache.infinispan.cfg", "alternative-infinispan-configs.xml");
        TestRegionFactory factory = this.createRegionFactory(p);
        try {
            Configuration ppConfig = factory.getCacheManager().getCacheConfiguration("pending-puts");
            Assert.assertEquals((long)120000L, (long)ppConfig.expiration().maxIdle());
        }
        finally {
            factory.stop();
        }
    }

    private TestRegionFactory createRegionFactory(Properties p) {
        return this.createRegionFactory(null, p, null);
    }

    private TestRegionFactory createRegionFactory(Properties p, Consumer<EmbeddedCacheManager> hook) {
        return this.createRegionFactory(null, p, hook);
    }

    private TestRegionFactory createRegionFactory(EmbeddedCacheManager manager, Properties p, Consumer<EmbeddedCacheManager> hook) {
        if (manager != null) {
            p.put(TestRegionFactory.MANAGER, manager);
        }
        if (hook != null) {
            p.put(TestRegionFactory.AFTER_MANAGER_CREATED, hook);
        }
        TestRegionFactory factory = TestRegionFactoryProvider.load().create(p);
        factory.start((ServiceRegistry)this.serviceRegistry, p);
        return factory;
    }

    private static Properties createProperties() {
        Properties properties = new Properties();
        String cfgFileName = (String)Environment.getProperties().get("hibernate.cache.infinispan.cfg");
        if (cfgFileName != null) {
            properties.put("hibernate.cache.infinispan.cfg", cfgFileName);
        }
        return properties;
    }
}

