/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.commons;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.service.ServiceRegistry;
import org.infinispan.hibernate.cache.commons.InfinispanBaseRegion;
import org.infinispan.test.hibernate.cache.commons.util.CacheTestUtil;
import org.infinispan.test.hibernate.cache.commons.util.TestRegionFactory;

public class NodeEnvironment {
    private final StandardServiceRegistryBuilder ssrb;
    private StandardServiceRegistry serviceRegistry;
    private TestRegionFactory regionFactory;
    private Map<String, InfinispanBaseRegion> entityRegionMap;
    private Map<String, InfinispanBaseRegion> collectionRegionMap;

    public NodeEnvironment(StandardServiceRegistryBuilder ssrb) {
        this.ssrb = ssrb;
    }

    public StandardServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public InfinispanBaseRegion getEntityRegion(String name, AccessType accessType) {
        if (this.entityRegionMap == null) {
            this.entityRegionMap = new HashMap<String, InfinispanBaseRegion>();
            return this.buildAndStoreEntityRegion(name, accessType);
        }
        InfinispanBaseRegion region = this.entityRegionMap.get(name);
        if (region == null) {
            region = this.buildAndStoreEntityRegion(name, accessType);
        }
        return region;
    }

    private InfinispanBaseRegion buildAndStoreEntityRegion(String name, AccessType accessType) {
        InfinispanBaseRegion region = this.regionFactory.buildEntityRegion(name, accessType);
        this.entityRegionMap.put(name, region);
        return region;
    }

    public InfinispanBaseRegion getCollectionRegion(String name, AccessType accessType) {
        if (this.collectionRegionMap == null) {
            this.collectionRegionMap = new HashMap<String, InfinispanBaseRegion>();
            return this.buildAndStoreCollectionRegion(name, accessType);
        }
        InfinispanBaseRegion region = this.collectionRegionMap.get(name);
        if (region == null) {
            region = this.buildAndStoreCollectionRegion(name, accessType);
            this.collectionRegionMap.put(name, region);
        }
        return region;
    }

    private InfinispanBaseRegion buildAndStoreCollectionRegion(String name, AccessType accessType) {
        return this.regionFactory.buildCollectionRegion(name, accessType);
    }

    public void prepare() throws Exception {
        this.serviceRegistry = this.ssrb.build();
        this.regionFactory = CacheTestUtil.startRegionFactory((ServiceRegistry)this.serviceRegistry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() throws Exception {
        try {
            if (this.entityRegionMap != null) {
                for (InfinispanBaseRegion region : this.entityRegionMap.values()) {
                    try {
                        region.getCache().stop();
                    }
                    catch (Exception exception) {}
                }
                this.entityRegionMap.clear();
            }
            if (this.collectionRegionMap != null) {
                for (InfinispanBaseRegion reg : this.collectionRegionMap.values()) {
                    try {
                        reg.getCache().stop();
                    }
                    catch (Exception exception) {}
                }
                this.collectionRegionMap.clear();
            }
        }
        finally {
            try {
                if (this.regionFactory != null) {
                    this.regionFactory.stop();
                }
            }
            finally {
                if (this.serviceRegistry != null) {
                    StandardServiceRegistryBuilder.destroy((ServiceRegistry)this.serviceRegistry);
                }
            }
        }
    }

    public RegionFactory getRegionFactory() {
        return this.regionFactory.unwrap();
    }
}

