/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.commons.collection;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.transaction.Synchronization;
import org.hibernate.cache.spi.access.SoftLock;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.test.categories.Smoke;
import org.infinispan.hibernate.cache.commons.InfinispanBaseRegion;
import org.infinispan.hibernate.cache.commons.InfinispanDataRegion;
import org.infinispan.hibernate.cache.commons.access.AccessDelegate;
import org.infinispan.hibernate.cache.commons.access.NonTxInvalidationCacheAccessDelegate;
import org.infinispan.hibernate.cache.commons.access.PutFromLoadValidator;
import org.infinispan.hibernate.cache.commons.access.TxInvalidationCacheAccessDelegate;
import org.infinispan.test.hibernate.cache.commons.AbstractRegionAccessStrategyTest;
import org.infinispan.test.hibernate.cache.commons.NodeEnvironment;
import org.infinispan.test.hibernate.cache.commons.util.TestSessionAccess;
import org.infinispan.test.hibernate.cache.commons.util.TestSynchronization;
import org.infinispan.test.hibernate.cache.commons.util.TestingKeyFactory;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Matchers;
import org.mockito.Mockito;

@Category(value={Smoke.class})
public class CollectionRegionAccessStrategyTest
extends AbstractRegionAccessStrategyTest<Object> {
    protected static int testCount;

    @Override
    protected Object generateNextKey() {
        return TestingKeyFactory.generateCollectionCacheKey("KEY" + testCount++);
    }

    @Override
    protected InfinispanBaseRegion getRegion(NodeEnvironment environment) {
        return environment.getCollectionRegion("com.foo.test", this.accessType);
    }

    @Override
    protected Object getAccessStrategy(InfinispanBaseRegion region) {
        return TEST_SESSION_ACCESS.collectionAccess(region, this.accessType);
    }

    @Test
    public void testPutFromLoadRemoveDoesNotProduceStaleData() throws Exception {
        if (!this.cacheMode.isInvalidation()) {
            return;
        }
        CountDownLatch pferLatch = new CountDownLatch(1);
        CountDownLatch removeLatch = new CountDownLatch(1);
        PutFromLoadValidator originalValidator = PutFromLoadValidator.removeFromCache((AdvancedCache)this.localRegion.getCache());
        PutFromLoadValidator mockValidator = (PutFromLoadValidator)Mockito.spy((Object)originalValidator);
        ((PutFromLoadValidator)Mockito.doAnswer(invocation -> {
            try {
                Object object = invocation.callRealMethod();
                return object;
            }
            finally {
                try {
                    removeLatch.countDown();
                    Assert.assertFalse((boolean)pferLatch.await(2L, TimeUnit.SECONDS));
                }
                catch (InterruptedException e) {
                    this.log.debug((Object)"Interrupted");
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    this.log.error((Object)"Error", (Throwable)e);
                    throw new RuntimeException("Error", e);
                }
            }
        }).when((Object)mockValidator)).acquirePutFromLoadLock(Matchers.any(), Matchers.any(), Matchers.anyLong());
        PutFromLoadValidator.addToCache((AdvancedCache)this.localRegion.getCache(), (PutFromLoadValidator)mockValidator);
        this.cleanup.add(() -> {
            PutFromLoadValidator.removeFromCache((AdvancedCache)this.localRegion.getCache());
            PutFromLoadValidator.addToCache((AdvancedCache)this.localRegion.getCache(), (PutFromLoadValidator)originalValidator);
        });
        TxInvalidationCacheAccessDelegate delegate = this.localRegion.getCache().getCacheConfiguration().transaction().transactionMode().isTransactional() ? new TxInvalidationCacheAccessDelegate((InfinispanDataRegion)this.localRegion, mockValidator) : new NonTxInvalidationCacheAccessDelegate((InfinispanDataRegion)this.localRegion, mockValidator);
        ExecutorService executorService = Executors.newCachedThreadPool();
        this.cleanup.add(() -> executorService.shutdownNow());
        String KEY = "k1";
        Future<Void> pferFuture = executorService.submit(() -> this.lambda$testPutFromLoadRemoveDoesNotProduceStaleData$3((AccessDelegate)delegate));
        Future<Void> removeFuture = executorService.submit(() -> this.lambda$testPutFromLoadRemoveDoesNotProduceStaleData$5(removeLatch, (AccessDelegate)delegate, pferLatch));
        pferFuture.get();
        removeFuture.get();
        Assert.assertFalse((boolean)this.localRegion.getCache().containsKey((Object)"k1"));
        Assert.assertFalse((boolean)this.remoteRegion.getCache().containsKey((Object)"k1"));
    }

    @Test
    public void testPutFromLoad() throws Exception {
        this.putFromLoadTest(false, true);
    }

    @Test
    public void testPutFromLoadMinimal() throws Exception {
        this.putFromLoadTest(true, true);
    }

    @Override
    protected void doUpdate(TestSessionAccess.TestRegionAccessStrategy strategy, Object session, Object key, AbstractRegionAccessStrategyTest.TestCacheEntry entry) {
        SoftLock softLock = strategy.lockItem(session, key, null);
        strategy.remove(session, key);
        SESSION_ACCESS.getTransactionCoordinator(session).registerLocalSynchronization((Synchronization)new TestSynchronization.UnlockItem(strategy, session, key, softLock));
    }

    private /* synthetic */ Void lambda$testPutFromLoadRemoveDoesNotProduceStaleData$5(CountDownLatch removeLatch, AccessDelegate delegate, CountDownLatch pferLatch) throws Exception {
        removeLatch.await();
        Object session = TEST_SESSION_ACCESS.mockSession(this.jtaPlatform, TIME_SERVICE, this.localEnvironment.getRegionFactory());
        this.withTx(this.localEnvironment, session, () -> {
            delegate.remove(session, (Object)"k1");
            return null;
        });
        pferLatch.countDown();
        return null;
    }

    private /* synthetic */ Void lambda$testPutFromLoadRemoveDoesNotProduceStaleData$3(AccessDelegate delegate) throws Exception {
        Object session = TEST_SESSION_ACCESS.mockSession(this.jtaPlatform, TIME_SERVICE, this.localEnvironment.getRegionFactory());
        delegate.putFromLoad(session, (Object)"k1", (Object)"v1", SESSION_ACCESS.getTimestamp(session), null);
        return null;
    }
}

