/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.commons.entity;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.transaction.Synchronization;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.SoftLock;
import org.infinispan.commons.test.categories.Smoke;
import org.infinispan.hibernate.cache.commons.InfinispanBaseRegion;
import org.infinispan.test.hibernate.cache.commons.AbstractRegionAccessStrategyTest;
import org.infinispan.test.hibernate.cache.commons.NodeEnvironment;
import org.infinispan.test.hibernate.cache.commons.util.TestSessionAccess;
import org.infinispan.test.hibernate.cache.commons.util.TestSynchronization;
import org.infinispan.test.hibernate.cache.commons.util.TestingKeyFactory;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={Smoke.class})
public class EntityRegionAccessStrategyTest
extends AbstractRegionAccessStrategyTest<Object> {
    protected static int testCount;

    @Override
    protected Object generateNextKey() {
        return TestingKeyFactory.generateEntityCacheKey("KEY" + testCount++);
    }

    @Override
    protected InfinispanBaseRegion getRegion(NodeEnvironment environment) {
        return environment.getEntityRegion("com.foo.test", this.accessType);
    }

    @Override
    protected Object getAccessStrategy(InfinispanBaseRegion region) {
        return TEST_SESSION_ACCESS.entityAccess(region, this.accessType);
    }

    @Test
    public void testPutFromLoad() throws Exception {
        if (this.accessType == AccessType.READ_ONLY) {
            this.putFromLoadTestReadOnly(false);
        } else {
            this.putFromLoadTest(false, false);
        }
    }

    @Test
    public void testPutFromLoadMinimal() throws Exception {
        if (this.accessType == AccessType.READ_ONLY) {
            this.putFromLoadTestReadOnly(true);
        } else {
            this.putFromLoadTest(true, false);
        }
    }

    @Test
    public void testInsert() throws Exception {
        Object KEY = this.generateNextKey();
        CountDownLatch readLatch = new CountDownLatch(1);
        CountDownLatch commitLatch = new CountDownLatch(1);
        CountDownLatch completionLatch = new CountDownLatch(2);
        CountDownLatch asyncInsertLatch = this.expectAfterUpdate(KEY);
        Thread inserter = new Thread(() -> {
            try {
                Object session = TEST_SESSION_ACCESS.mockSession(this.jtaPlatform, TIME_SERVICE, this.localEnvironment.getRegionFactory());
                this.withTx(this.localEnvironment, session, () -> {
                    Assert.assertNull((String)"Correct initial value", (Object)this.testLocalAccessStrategy.get(session, KEY, SESSION_ACCESS.getTimestamp(session)));
                    this.doInsert(this.testLocalAccessStrategy, session, KEY, VALUE1);
                    readLatch.countDown();
                    commitLatch.await();
                    return null;
                });
            }
            catch (Exception e) {
                this.log.error((Object)"node1 caught exception", (Throwable)e);
                this.node1Exception = e;
            }
            catch (AssertionError e) {
                this.node1Failure = e;
            }
            finally {
                completionLatch.countDown();
            }
        }, "testInsert-inserter");
        Thread reader = new Thread(() -> {
            try {
                Object session = TEST_SESSION_ACCESS.mockSession(this.jtaPlatform, TIME_SERVICE, this.localEnvironment.getRegionFactory());
                this.withTx(this.localEnvironment, session, () -> {
                    readLatch.await();
                    Assert.assertNull((String)"Correct initial value", (Object)this.testLocalAccessStrategy.get(session, KEY, SESSION_ACCESS.getTimestamp(session)));
                    return null;
                });
            }
            catch (Exception e) {
                this.log.error((Object)"node1 caught exception", (Throwable)e);
                this.node1Exception = e;
            }
            catch (AssertionError e) {
                this.node1Failure = e;
            }
            finally {
                commitLatch.countDown();
                completionLatch.countDown();
            }
        }, "testInsert-reader");
        inserter.setDaemon(true);
        reader.setDaemon(true);
        inserter.start();
        reader.start();
        Assert.assertTrue((String)"Threads completed", (boolean)completionLatch.await(10L, TimeUnit.SECONDS));
        this.assertThreadsRanCleanly();
        Object s1 = TEST_SESSION_ACCESS.mockSession(this.jtaPlatform, TIME_SERVICE, this.localEnvironment.getRegionFactory());
        Assert.assertEquals((String)"Correct node1 value", (Object)VALUE1, (Object)this.testLocalAccessStrategy.get(s1, KEY, SESSION_ACCESS.getTimestamp(s1)));
        Assert.assertTrue((boolean)asyncInsertLatch.await(10L, TimeUnit.SECONDS));
        AbstractRegionAccessStrategyTest.TestCacheEntry expected = this.isUsingInvalidation() ? null : VALUE1;
        Object s2 = TEST_SESSION_ACCESS.mockSession(this.jtaPlatform, TIME_SERVICE, this.remoteEnvironment.getRegionFactory());
        Assert.assertEquals((String)"Correct node2 value", (Object)expected, (Object)this.testRemoteAccessStrategy.get(s2, KEY, SESSION_ACCESS.getTimestamp(s2)));
    }

    protected void doInsert(TestSessionAccess.TestRegionAccessStrategy strategy, Object session, Object key, AbstractRegionAccessStrategyTest.TestCacheEntry entry) {
        strategy.insert(session, key, entry, entry.getVersion());
        SESSION_ACCESS.getTransactionCoordinator(session).registerLocalSynchronization((Synchronization)new TestSynchronization.AfterInsert(strategy, session, key, entry, entry.getVersion()));
    }

    protected void putFromLoadTestReadOnly(boolean minimal) throws Exception {
        AbstractRegionAccessStrategyTest.TestCacheEntry expected;
        Object KEY = TestingKeyFactory.generateEntityCacheKey("KEY" + testCount++);
        CountDownLatch remotePutFromLoadLatch = this.expectPutFromLoad(KEY);
        Object session = TEST_SESSION_ACCESS.mockSession(this.jtaPlatform, TIME_SERVICE, this.localEnvironment.getRegionFactory());
        this.withTx(this.localEnvironment, session, () -> {
            Assert.assertNull((Object)this.testLocalAccessStrategy.get(session, KEY, SESSION_ACCESS.getTimestamp(session)));
            if (minimal) {
                this.testLocalAccessStrategy.putFromLoad(session, KEY, VALUE1, SESSION_ACCESS.getTimestamp(session), VALUE1.getVersion(), true);
            } else {
                this.testLocalAccessStrategy.putFromLoad(session, KEY, VALUE1, SESSION_ACCESS.getTimestamp(session), VALUE1.getVersion());
            }
            return null;
        });
        Object s2 = TEST_SESSION_ACCESS.mockSession(this.jtaPlatform, TIME_SERVICE, this.localEnvironment.getRegionFactory());
        Assert.assertEquals((Object)VALUE1, (Object)this.testLocalAccessStrategy.get(s2, KEY, SESSION_ACCESS.getTimestamp(s2)));
        Object s3 = TEST_SESSION_ACCESS.mockSession(this.jtaPlatform, TIME_SERVICE, this.remoteEnvironment.getRegionFactory());
        if (this.isUsingInvalidation()) {
            expected = null;
        } else {
            if (this.accessType != AccessType.NONSTRICT_READ_WRITE) {
                Assert.assertTrue((boolean)remotePutFromLoadLatch.await(2L, TimeUnit.SECONDS));
            }
            expected = VALUE1;
        }
        Assert.assertEquals((Object)expected, (Object)this.testRemoteAccessStrategy.get(s3, KEY, SESSION_ACCESS.getTimestamp(s3)));
    }

    @Test
    public void testUpdate() throws Exception {
        this.log.infof(this.name.getMethodName(), new Object[0]);
        if (this.accessType == AccessType.READ_ONLY) {
            return;
        }
        Object KEY = this.generateNextKey();
        Object s1 = TEST_SESSION_ACCESS.mockSession(this.jtaPlatform, TIME_SERVICE, this.localEnvironment.getRegionFactory());
        this.testLocalAccessStrategy.putFromLoad(s1, KEY, VALUE1, SESSION_ACCESS.getTimestamp(s1), VALUE1.getVersion());
        Object s2 = TEST_SESSION_ACCESS.mockSession(this.jtaPlatform, TIME_SERVICE, this.remoteEnvironment.getRegionFactory());
        this.testRemoteAccessStrategy.putFromLoad(s2, KEY, VALUE1, SESSION_ACCESS.getTimestamp(s2), VALUE1.getVersion());
        CountDownLatch asyncUpdateLatch = this.expectAfterUpdate(KEY);
        CountDownLatch readLatch = new CountDownLatch(1);
        CountDownLatch commitLatch = new CountDownLatch(1);
        CountDownLatch completionLatch = new CountDownLatch(2);
        Thread updater = new Thread(() -> {
            try {
                Object session = TEST_SESSION_ACCESS.mockSession(this.jtaPlatform, TIME_SERVICE, this.localEnvironment.getRegionFactory());
                this.withTx(this.localEnvironment, session, () -> {
                    this.log.debug((Object)"Transaction began, get initial value");
                    Assert.assertEquals((String)"Correct initial value", (Object)VALUE1, (Object)this.testLocalAccessStrategy.get(session, KEY, SESSION_ACCESS.getTimestamp(session)));
                    this.log.debug((Object)"Now update value");
                    this.doUpdate(this.testLocalAccessStrategy, session, KEY, VALUE2);
                    this.log.debug((Object)"Notify the read latch");
                    readLatch.countDown();
                    this.log.debug((Object)"Await commit");
                    commitLatch.await();
                    return null;
                });
            }
            catch (Exception e) {
                this.log.error((Object)"node1 caught exception", (Throwable)e);
                this.node1Exception = e;
            }
            catch (AssertionError e) {
                this.node1Failure = e;
            }
            finally {
                if (readLatch.getCount() > 0L) {
                    readLatch.countDown();
                }
                this.log.debug((Object)"Completion latch countdown");
                completionLatch.countDown();
            }
        }, "testUpdate-updater");
        Thread reader = new Thread(() -> {
            try {
                Object session = TEST_SESSION_ACCESS.mockSession(this.jtaPlatform, TIME_SERVICE, this.localEnvironment.getRegionFactory());
                this.withTx(this.localEnvironment, session, () -> {
                    this.log.debug((Object)"Transaction began, await read latch");
                    readLatch.await();
                    this.log.debug((Object)"Read latch acquired, verify local access strategy");
                    AbstractRegionAccessStrategyTest.TestCacheEntry expected = this.isTransactional() || this.accessType == AccessType.NONSTRICT_READ_WRITE ? VALUE1 : null;
                    Assert.assertEquals((String)"Correct value", (Object)expected, (Object)this.testLocalAccessStrategy.get(session, KEY, SESSION_ACCESS.getTimestamp(session)));
                    return null;
                });
            }
            catch (Exception e) {
                this.log.error((Object)"node1 caught exception", (Throwable)e);
                this.node1Exception = e;
            }
            catch (AssertionError e) {
                this.node1Failure = e;
            }
            finally {
                commitLatch.countDown();
                this.log.debug((Object)"Completion latch countdown");
                completionLatch.countDown();
            }
        }, "testUpdate-reader");
        updater.setDaemon(true);
        reader.setDaemon(true);
        updater.start();
        reader.start();
        Assert.assertTrue((boolean)completionLatch.await(2L, TimeUnit.SECONDS));
        this.assertThreadsRanCleanly();
        Object s3 = TEST_SESSION_ACCESS.mockSession(this.jtaPlatform, TIME_SERVICE, this.localEnvironment.getRegionFactory());
        Assert.assertEquals((String)"Correct node1 value", (Object)VALUE2, (Object)this.testLocalAccessStrategy.get(s3, KEY, SESSION_ACCESS.getTimestamp(s3)));
        Assert.assertTrue((boolean)asyncUpdateLatch.await(10L, TimeUnit.SECONDS));
        AbstractRegionAccessStrategyTest.TestCacheEntry expected = this.isUsingInvalidation() ? null : VALUE2;
        Object s4 = TEST_SESSION_ACCESS.mockSession(this.jtaPlatform, TIME_SERVICE, this.remoteEnvironment.getRegionFactory());
        Assert.assertEquals((String)"Correct node2 value", (Object)expected, (Object)this.testRemoteAccessStrategy.get(s4, KEY, SESSION_ACCESS.getTimestamp(s4)));
    }

    @Override
    protected void doUpdate(TestSessionAccess.TestRegionAccessStrategy strategy, Object session, Object key, AbstractRegionAccessStrategyTest.TestCacheEntry entry) {
        SoftLock softLock = strategy.lockItem(session, key, null);
        strategy.update(session, key, entry, null, entry.getVersion());
        SESSION_ACCESS.getTransactionCoordinator(session).registerLocalSynchronization((Synchronization)new TestSynchronization.AfterUpdate(strategy, session, key, entry, entry.getVersion(), softLock));
    }

    @Ignore
    @Test
    public void testContestedPutFromLoad() throws Exception {
        if (this.accessType == AccessType.READ_ONLY) {
            return;
        }
        final Object KEY = TestingKeyFactory.generateEntityCacheKey("KEY" + testCount++);
        Object s1 = TEST_SESSION_ACCESS.mockSession(this.jtaPlatform, TIME_SERVICE, this.localEnvironment.getRegionFactory());
        this.testLocalAccessStrategy.putFromLoad(s1, KEY, VALUE1, SESSION_ACCESS.getTimestamp(s1), VALUE1.getVersion());
        final CountDownLatch pferLatch = new CountDownLatch(1);
        final CountDownLatch pferCompletionLatch = new CountDownLatch(1);
        final CountDownLatch commitLatch = new CountDownLatch(1);
        final CountDownLatch completionLatch = new CountDownLatch(1);
        Thread blocker = new Thread("Blocker"){

            @Override
            public void run() {
                try {
                    Object session = TEST_SESSION_ACCESS.mockSession(EntityRegionAccessStrategyTest.this.jtaPlatform, TIME_SERVICE, EntityRegionAccessStrategyTest.this.localEnvironment.getRegionFactory());
                    EntityRegionAccessStrategyTest.this.withTx(EntityRegionAccessStrategyTest.this.localEnvironment, session, () -> {
                        Assert.assertEquals((String)"Correct initial value", (Object)AbstractRegionAccessStrategyTest.VALUE1, (Object)EntityRegionAccessStrategyTest.this.testLocalAccessStrategy.get(session, KEY, SESSION_ACCESS.getTimestamp(session)));
                        EntityRegionAccessStrategyTest.this.doUpdate(EntityRegionAccessStrategyTest.this.testLocalAccessStrategy, session, KEY, AbstractRegionAccessStrategyTest.VALUE2);
                        pferLatch.countDown();
                        commitLatch.await();
                        return null;
                    });
                }
                catch (Exception e) {
                    EntityRegionAccessStrategyTest.this.log.error((Object)"node1 caught exception", (Throwable)e);
                    EntityRegionAccessStrategyTest.this.node1Exception = e;
                }
                catch (AssertionError e) {
                    EntityRegionAccessStrategyTest.this.node1Failure = e;
                }
                finally {
                    completionLatch.countDown();
                }
            }
        };
        Thread putter = new Thread("Putter"){

            @Override
            public void run() {
                try {
                    Object session = TEST_SESSION_ACCESS.mockSession(EntityRegionAccessStrategyTest.this.jtaPlatform, TIME_SERVICE, EntityRegionAccessStrategyTest.this.localEnvironment.getRegionFactory());
                    EntityRegionAccessStrategyTest.this.withTx(EntityRegionAccessStrategyTest.this.localEnvironment, session, () -> {
                        EntityRegionAccessStrategyTest.this.testLocalAccessStrategy.putFromLoad(session, KEY, AbstractRegionAccessStrategyTest.VALUE1, SESSION_ACCESS.getTimestamp(session), AbstractRegionAccessStrategyTest.VALUE1.getVersion());
                        return null;
                    });
                }
                catch (Exception e) {
                    EntityRegionAccessStrategyTest.this.log.error((Object)"node1 caught exception", (Throwable)e);
                    EntityRegionAccessStrategyTest.this.node1Exception = e;
                }
                catch (AssertionError e) {
                    EntityRegionAccessStrategyTest.this.node1Failure = e;
                }
                finally {
                    pferCompletionLatch.countDown();
                }
            }
        };
        blocker.start();
        Assert.assertTrue((String)"Active tx has done an update", (boolean)pferLatch.await(1L, TimeUnit.SECONDS));
        putter.start();
        Assert.assertTrue((String)"putFromLoad returns promptly", (boolean)pferCompletionLatch.await(10L, TimeUnit.MILLISECONDS));
        commitLatch.countDown();
        Assert.assertTrue((String)"Threads completed", (boolean)completionLatch.await(1L, TimeUnit.SECONDS));
        this.assertThreadsRanCleanly();
        Object session = TEST_SESSION_ACCESS.mockSession(this.jtaPlatform, TIME_SERVICE, this.localEnvironment.getRegionFactory());
        Assert.assertEquals((String)"Correct node1 value", (Object)VALUE2, (Object)this.testLocalAccessStrategy.get(session, KEY, SESSION_ACCESS.getTimestamp(session)));
    }

    @Override
    @Test
    @Ignore(value="ISPN-9175")
    public void testRemoveAll() throws Exception {
        super.testRemoveAll();
    }
}

