/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.commons.functional;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.function.Predicate;
import org.hibernate.Session;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.transaction.jta.platform.internal.NoJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Value;
import org.hibernate.resource.transaction.backend.jdbc.internal.JdbcResourceLocalTransactionCoordinatorBuilderImpl;
import org.hibernate.resource.transaction.backend.jta.internal.JtaTransactionCoordinatorBuilderImpl;
import org.hibernate.testing.BeforeClassOnce;
import org.hibernate.testing.junit4.BaseNonConfigCoreFunctionalTestCase;
import org.hibernate.testing.junit4.CustomParameterized;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.hibernate.cache.commons.util.EndInvalidationCommand;
import org.infinispan.hibernate.cache.commons.util.FutureUpdate;
import org.infinispan.hibernate.cache.commons.util.InfinispanMessageLogger;
import org.infinispan.hibernate.cache.commons.util.TombstoneUpdate;
import org.infinispan.remoting.inboundhandler.AbstractDelegatingHandler;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.inboundhandler.PerCacheInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.Reply;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.hibernate.cache.commons.tm.JtaPlatformImpl;
import org.infinispan.test.hibernate.cache.commons.tm.XaConnectionProvider;
import org.infinispan.test.hibernate.cache.commons.util.ExpectingInterceptor;
import org.infinispan.test.hibernate.cache.commons.util.InfinispanTestingSetup;
import org.infinispan.test.hibernate.cache.commons.util.TestRegionFactory;
import org.infinispan.test.hibernate.cache.commons.util.TestRegionFactoryProvider;
import org.infinispan.test.hibernate.cache.commons.util.TxUtil;
import org.junit.After;
import org.junit.ClassRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=CustomParameterized.class)
public abstract class AbstractFunctionalTest
extends BaseNonConfigCoreFunctionalTestCase {
    protected static final Object[] TRANSACTIONAL = new Object[]{"transactional", JtaPlatformImpl.class, JtaTransactionCoordinatorBuilderImpl.class, XaConnectionProvider.class, AccessType.TRANSACTIONAL, CacheMode.INVALIDATION_SYNC, false, false};
    protected static final Object[] READ_WRITE_INVALIDATION = new Object[]{"read-write", NoJtaPlatform.class, JdbcResourceLocalTransactionCoordinatorBuilderImpl.class, null, AccessType.READ_WRITE, CacheMode.INVALIDATION_SYNC, false, false};
    protected static final Object[] READ_ONLY_INVALIDATION = new Object[]{"read-only", NoJtaPlatform.class, JdbcResourceLocalTransactionCoordinatorBuilderImpl.class, null, AccessType.READ_ONLY, CacheMode.INVALIDATION_SYNC, false, false};
    protected static final Object[] READ_WRITE_REPLICATED = new Object[]{"read-write", NoJtaPlatform.class, JdbcResourceLocalTransactionCoordinatorBuilderImpl.class, null, AccessType.READ_WRITE, CacheMode.REPL_SYNC, false, false};
    protected static final Object[] READ_WRITE_REPLICATED_STATS = new Object[]{"read-write", NoJtaPlatform.class, JdbcResourceLocalTransactionCoordinatorBuilderImpl.class, null, AccessType.READ_WRITE, CacheMode.REPL_SYNC, false, true};
    protected static final Object[] READ_ONLY_REPLICATED = new Object[]{"read-only", NoJtaPlatform.class, JdbcResourceLocalTransactionCoordinatorBuilderImpl.class, null, AccessType.READ_ONLY, CacheMode.REPL_SYNC, false, false};
    protected static final Object[] READ_ONLY_REPLICATED_STATS = new Object[]{"read-only", NoJtaPlatform.class, JdbcResourceLocalTransactionCoordinatorBuilderImpl.class, null, AccessType.READ_ONLY, CacheMode.REPL_SYNC, false, true};
    protected static final Object[] READ_WRITE_DISTRIBUTED = new Object[]{"read-write", NoJtaPlatform.class, JdbcResourceLocalTransactionCoordinatorBuilderImpl.class, null, AccessType.READ_WRITE, CacheMode.DIST_SYNC, false, false};
    protected static final Object[] READ_WRITE_DISTRIBUTED_STATS = new Object[]{"read-write", NoJtaPlatform.class, JdbcResourceLocalTransactionCoordinatorBuilderImpl.class, null, AccessType.READ_WRITE, CacheMode.DIST_SYNC, false, true};
    protected static final Object[] READ_ONLY_DISTRIBUTED = new Object[]{"read-only", NoJtaPlatform.class, JdbcResourceLocalTransactionCoordinatorBuilderImpl.class, null, AccessType.READ_ONLY, CacheMode.DIST_SYNC, false, false};
    protected static final Object[] READ_ONLY_DISTRIBUTED_STATS = new Object[]{"read-only", NoJtaPlatform.class, JdbcResourceLocalTransactionCoordinatorBuilderImpl.class, null, AccessType.READ_ONLY, CacheMode.DIST_SYNC, false, true};
    protected static final Object[] NONSTRICT_REPLICATED = new Object[]{"nonstrict", NoJtaPlatform.class, JdbcResourceLocalTransactionCoordinatorBuilderImpl.class, null, AccessType.NONSTRICT_READ_WRITE, CacheMode.REPL_SYNC, true, false};
    protected static final Object[] NONSTRICT_REPLICATED_STATS = new Object[]{"nonstrict", NoJtaPlatform.class, JdbcResourceLocalTransactionCoordinatorBuilderImpl.class, null, AccessType.NONSTRICT_READ_WRITE, CacheMode.REPL_SYNC, true, true};
    protected static final Object[] NONSTRICT_DISTRIBUTED = new Object[]{"nonstrict", NoJtaPlatform.class, JdbcResourceLocalTransactionCoordinatorBuilderImpl.class, null, AccessType.NONSTRICT_READ_WRITE, CacheMode.DIST_SYNC, true, false};
    protected static final Object[] NONSTRICT_DISTRIBUTED_STATS = new Object[]{"nonstrict", NoJtaPlatform.class, JdbcResourceLocalTransactionCoordinatorBuilderImpl.class, null, AccessType.NONSTRICT_READ_WRITE, CacheMode.DIST_SYNC, true, true};
    @ClassRule
    public static final InfinispanTestingSetup infinispanTestIdentifier = new InfinispanTestingSetup();
    @Parameterized.Parameter(value=0)
    public String mode;
    @Parameterized.Parameter(value=1)
    public Class<? extends JtaPlatform> jtaPlatformClass;
    @Parameterized.Parameter(value=2)
    public Class<?> transactionCoordinatorBuilderClass;
    @Parameterized.Parameter(value=3)
    public Class<? extends ConnectionProvider> connectionProviderClass;
    @Parameterized.Parameter(value=4)
    public AccessType accessType;
    @Parameterized.Parameter(value=5)
    public CacheMode cacheMode;
    @Parameterized.Parameter(value=6)
    public boolean addVersions;
    @Parameterized.Parameter(value=7)
    public boolean stats;
    protected boolean useJta;
    protected List<Runnable> cleanup = new ArrayList<Runnable>();

    @CustomParameterized.Order(value=0)
    @Parameterized.Parameters(name="{0}, {5}, stats={7}")
    public abstract List<Object[]> getParameters();

    public List<Object[]> getParameters(boolean tx, boolean rw, boolean ro, boolean nonstrict, boolean stats) {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        if (tx) {
            parameters.add(TRANSACTIONAL);
        }
        if (rw) {
            parameters.add(READ_WRITE_INVALIDATION);
            parameters.add(READ_WRITE_REPLICATED);
            parameters.add(READ_WRITE_DISTRIBUTED);
            if (stats) {
                parameters.add(READ_WRITE_REPLICATED_STATS);
                parameters.add(READ_WRITE_DISTRIBUTED_STATS);
            }
        }
        if (ro) {
            parameters.add(READ_ONLY_INVALIDATION);
            parameters.add(READ_ONLY_REPLICATED);
            parameters.add(READ_ONLY_DISTRIBUTED);
            if (stats) {
                parameters.add(READ_ONLY_REPLICATED_STATS);
                parameters.add(READ_ONLY_DISTRIBUTED_STATS);
            }
        }
        if (nonstrict) {
            parameters.add(NONSTRICT_REPLICATED);
            parameters.add(NONSTRICT_DISTRIBUTED);
            if (stats) {
                parameters.add(NONSTRICT_REPLICATED_STATS);
                parameters.add(NONSTRICT_DISTRIBUTED_STATS);
            }
        }
        return parameters;
    }

    @BeforeClassOnce
    public void setUseJta() {
        this.useJta = this.jtaPlatformClass != NoJtaPlatform.class;
    }

    protected void prepareTest() throws Exception {
        infinispanTestIdentifier.joinContext();
    }

    @After
    public void runCleanup() {
        this.cleanup.forEach(Runnable::run);
        this.cleanup.clear();
    }

    protected String getBaseForMappings() {
        return "org/infinispan/test/";
    }

    public String[] getMappings() {
        return new String[]{"hibernate/cache/commons/functional/entities/Item.hbm.xml", "hibernate/cache/commons/functional/entities/Customer.hbm.xml", "hibernate/cache/commons/functional/entities/Contact.hbm.xml"};
    }

    protected void afterMetadataBuilt(Metadata metadata) {
        if (this.addVersions) {
            for (PersistentClass clazz : metadata.getEntityBindings()) {
                if (clazz.getVersion() != null) continue;
                try {
                    clazz.getMappedClass().getMethod("getVersion", new Class[0]);
                    clazz.getMappedClass().getMethod("setVersion", Long.TYPE);
                }
                catch (NoSuchMethodException e) {
                    continue;
                }
                RootClass rootClazz = clazz.getRootClass();
                Property versionProperty = new Property();
                versionProperty.setName("version");
                SimpleValue value = new SimpleValue((MetadataImplementor)metadata, rootClazz.getTable());
                value.setTypeName("long");
                Column column = new Column();
                column.setValue((Value)value);
                column.setName("version");
                value.addColumn(column);
                rootClazz.getTable().addColumn(column);
                versionProperty.setValue((Value)value);
                rootClazz.setVersion(versionProperty);
                rootClazz.addProperty(versionProperty);
            }
        }
    }

    public String getCacheConcurrencyStrategy() {
        return this.accessType.getExternalName();
    }

    protected boolean getUseQueryCache() {
        return true;
    }

    protected void addSettings(Map settings) {
        super.addSettings(settings);
        settings.put("hibernate.cache.use_second_level_cache", "true");
        settings.put("hibernate.generate_statistics", "true");
        settings.put("hibernate.cache.use_query_cache", String.valueOf(this.getUseQueryCache()));
        settings.put("hibernate.cache.region.factory_class", TestRegionFactoryProvider.load().getRegionFactoryClass().getName());
        settings.put("hibernate.cache.keys_factory", "simple");
        settings.put(TestRegionFactory.TRANSACTIONAL, this.useTransactionalCache());
        settings.put(TestRegionFactory.CACHE_MODE, this.cacheMode);
        settings.put(TestRegionFactory.STATS, this.stats);
        settings.put("hibernate.transaction.jta.platform", this.jtaPlatformClass.getName());
        settings.put("hibernate.transaction.coordinator_class", this.transactionCoordinatorBuilderClass.getName());
        if (this.connectionProviderClass != null) {
            settings.put("hibernate.connection.provider_class", this.connectionProviderClass.getName());
        }
    }

    protected void markRollbackOnly(Session session) {
        TxUtil.markRollbackOnly(this.useJta, session);
    }

    protected CountDownLatch expectAfterUpdate(AdvancedCache cache, int numUpdates) {
        return this.expectReadWriteKeyCommand(cache, FutureUpdate.class::isInstance, numUpdates);
    }

    protected CountDownLatch expectEvict(AdvancedCache cache, int numUpdates) {
        return this.expectReadWriteKeyCommand(cache, f -> f instanceof TombstoneUpdate && ((TombstoneUpdate)f).getValue() == null, numUpdates);
    }

    protected CountDownLatch expectReadWriteKeyCommand(AdvancedCache cache, Predicate<Object> valuePredicate, int numUpdates) {
        if (!this.cacheMode.isInvalidation()) {
            CountDownLatch latch = new CountDownLatch(numUpdates);
            ExpectingInterceptor.get(cache).when((ctx, cmd) -> cmd instanceof ReadWriteKeyCommand && valuePredicate.test(((ReadWriteKeyCommand)cmd).getFunction())).countDown(latch);
            this.cleanup.add(() -> ExpectingInterceptor.cleanup(cache));
            return latch;
        }
        return new CountDownLatch(0);
    }

    protected CountDownLatch expectAfterEndInvalidation(AdvancedCache cache, int numInvalidates) {
        CountDownLatch latch = new CountDownLatch(numInvalidates);
        TestingUtil.wrapInboundInvocationHandler((Cache)cache, handler -> new ExpectingInboundInvocationHandler((PerCacheInboundInvocationHandler)handler, latch));
        return latch;
    }

    protected void removeAfterEndInvalidationHandler(AdvancedCache cache) {
        TestingUtil.wrapInboundInvocationHandler((Cache)cache, handler -> ((ExpectingInboundInvocationHandler)((Object)handler)).getDelegate());
    }

    protected boolean useTransactionalCache() {
        return TestRegionFactoryProvider.load().supportTransactionalCaches() && this.accessType == AccessType.TRANSACTIONAL;
    }

    private static final class ExpectingInboundInvocationHandler
    extends AbstractDelegatingHandler {
        private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(ExpectingInboundInvocationHandler.class);
        final CountDownLatch latch;

        public ExpectingInboundInvocationHandler(PerCacheInboundInvocationHandler delegate, CountDownLatch latch) {
            super(delegate);
            this.latch = latch;
        }

        public void handle(CacheRpcCommand command, Reply reply, DeliverOrder order) {
            if (command instanceof EndInvalidationCommand) {
                this.delegate.handle(command, response -> {
                    this.latch.countDown();
                    log.tracef("Latch after count down %s", (Object)this.latch);
                    reply.reply(response);
                }, order);
            } else {
                this.delegate.handle(command, reply, order);
            }
        }

        PerCacheInboundInvocationHandler getDelegate() {
            return this.delegate;
        }
    }
}

