/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.commons.functional;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.Id;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.testing.TestForIssue;
import org.infinispan.hibernate.cache.commons.InfinispanBaseRegion;
import org.infinispan.test.hibernate.cache.commons.functional.AbstractFunctionalTest;
import org.infinispan.test.hibernate.cache.commons.util.TestSessionAccess;
import org.junit.Assert;
import org.junit.Test;

@TestForIssue(jiraKey="ISPN-8836")
public class CustomConfigTest
extends AbstractFunctionalTest {
    public static final TestSessionAccess TEST_SESSION_ACCESS = TestSessionAccess.findTestSessionAccess();

    @Override
    public List<Object[]> getParameters() {
        return Collections.singletonList(READ_WRITE_REPLICATED);
    }

    @Override
    protected void addSettings(Map settings) {
        super.addSettings(settings);
        settings.put("hibernate.cache.region_prefix", "");
        settings.put("hibernate.cache.infinispan.cfg", "alternative-infinispan-configs.xml");
        settings.put("hibernate.cache.infinispan.otherregion.cfg", "otherregion");
    }

    protected Class[] getAnnotatedClasses() {
        return new Class[]{TestEntity.class, OtherTestEntity.class};
    }

    @Test
    public void testCacheWithRegionName() {
        InfinispanBaseRegion myregion = TEST_SESSION_ACCESS.getRegion(this.sessionFactory(), "myregion");
        InfinispanBaseRegion otherregion = TEST_SESSION_ACCESS.getRegion(this.sessionFactory(), "otherregion");
        Assert.assertEquals((Object)"myregion", (Object)myregion.getCache().getName());
        Assert.assertEquals((Object)"otherregion", (Object)otherregion.getCache().getName());
    }

    @Entity
    @Cacheable
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="otherregion")
    public class OtherTestEntity {
        @Id
        long id;
        String foobar;
    }

    @Entity
    @Cacheable
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="myregion")
    public class TestEntity {
        @Id
        long id;
        String foobar;
    }
}

