/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.commons.functional;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.Id;
import org.hibernate.Hibernate;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.stat.SecondLevelCacheStatistics;
import org.hibernate.stat.Statistics;
import org.hibernate.testing.TestForIssue;
import org.infinispan.test.hibernate.cache.commons.functional.SingleNodeTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EntitiesAndCollectionsInSameRegionTest
extends SingleNodeTest {
    private static final String REGION_NAME = "ARegion";
    private final AnEntity anEntity = new AnEntity();
    private final AnotherEntity anotherEntity;

    public EntitiesAndCollectionsInSameRegionTest() {
        this.anEntity.id = 1;
        this.anEntity.values.add("abc");
        this.anotherEntity = new AnotherEntity();
        this.anotherEntity.id = 1;
        this.anotherEntity.values.add(123);
    }

    @Override
    public List<Object[]> getParameters() {
        return this.getParameters(true, false, false, false, false);
    }

    public Class[] getAnnotatedClasses() {
        return new Class[]{AnEntity.class, AnotherEntity.class};
    }

    @Override
    protected void addSettings(Map settings) {
        super.addSettings(settings);
        settings.put("hibernate.cache.keys_factory", "default");
    }

    @Before
    public void setup() throws Exception {
        Statistics stats = this.sessionFactory().getStatistics();
        stats.clear();
        this.withTxSession(s -> {
            s.persist((Object)this.anEntity);
            s.persist((Object)this.anotherEntity);
        });
        SecondLevelCacheStatistics cacheStatistics = stats.getSecondLevelCacheStatistics(REGION_NAME);
        Assert.assertEquals((long)0L, (long)cacheStatistics.getMissCount());
        Assert.assertEquals((long)0L, (long)cacheStatistics.getHitCount());
        Assert.assertEquals((long)2L, (long)cacheStatistics.getPutCount());
        stats.clear();
    }

    @After
    public void cleanup() throws Exception {
        this.withTxSession(s -> {
            s.delete(s.get(AnEntity.class, (Serializable)Integer.valueOf(1)));
            s.delete(s.get(AnotherEntity.class, (Serializable)Integer.valueOf(1)));
        });
    }

    @Test
    @TestForIssue(jiraKey="HHH-10418")
    public void testEntitiesAndCollections() throws Exception {
        Statistics stats = this.sessionFactory().getStatistics();
        stats.clear();
        this.withTxSession(s -> {
            AnEntity anEntity1 = (AnEntity)s.get(AnEntity.class, (Serializable)Integer.valueOf(this.anEntity.id));
            SecondLevelCacheStatistics cacheStatistics = stats.getSecondLevelCacheStatistics(REGION_NAME);
            Assert.assertEquals((long)0L, (long)cacheStatistics.getMissCount());
            Assert.assertEquals((long)1L, (long)cacheStatistics.getHitCount());
            Assert.assertEquals((long)0L, (long)cacheStatistics.getPutCount());
            stats.clear();
            Assert.assertFalse((boolean)Hibernate.isInitialized((Object)anEntity1.values));
            Hibernate.initialize((Object)anEntity1.values);
            cacheStatistics = stats.getSecondLevelCacheStatistics(REGION_NAME);
            Assert.assertEquals((long)1L, (long)cacheStatistics.getMissCount());
            Assert.assertEquals((long)0L, (long)cacheStatistics.getHitCount());
            Assert.assertEquals((long)1L, (long)cacheStatistics.getPutCount());
            stats.clear();
            AnotherEntity anotherEntity1 = (AnotherEntity)s.get(AnotherEntity.class, (Serializable)Integer.valueOf(this.anotherEntity.id));
            cacheStatistics = stats.getSecondLevelCacheStatistics(REGION_NAME);
            Assert.assertEquals((long)0L, (long)cacheStatistics.getMissCount());
            Assert.assertEquals((long)1L, (long)cacheStatistics.getHitCount());
            Assert.assertEquals((long)0L, (long)cacheStatistics.getPutCount());
            stats.clear();
            Assert.assertFalse((boolean)Hibernate.isInitialized((Object)anotherEntity1.values));
            Hibernate.initialize((Object)anotherEntity1.values);
            cacheStatistics = stats.getSecondLevelCacheStatistics(REGION_NAME);
            Assert.assertEquals((long)1L, (long)cacheStatistics.getMissCount());
            Assert.assertEquals((long)0L, (long)cacheStatistics.getHitCount());
            Assert.assertEquals((long)1L, (long)cacheStatistics.getPutCount());
        });
        this.withTxSession(s -> {
            stats.clear();
            AnEntity anEntity1 = (AnEntity)s.get(AnEntity.class, (Serializable)Integer.valueOf(this.anEntity.id));
            SecondLevelCacheStatistics cacheStatistics = stats.getSecondLevelCacheStatistics(REGION_NAME);
            Assert.assertEquals((long)0L, (long)cacheStatistics.getMissCount());
            Assert.assertEquals((long)1L, (long)cacheStatistics.getHitCount());
            Assert.assertEquals((long)0L, (long)cacheStatistics.getPutCount());
            stats.clear();
            Assert.assertFalse((boolean)Hibernate.isInitialized((Object)anEntity1.values));
            Hibernate.initialize((Object)anEntity1.values);
            cacheStatistics = stats.getSecondLevelCacheStatistics(REGION_NAME);
            Assert.assertEquals((long)0L, (long)cacheStatistics.getMissCount());
            Assert.assertEquals((long)1L, (long)cacheStatistics.getHitCount());
            Assert.assertEquals((long)0L, (long)cacheStatistics.getPutCount());
            Assert.assertEquals((Object)this.anEntity.values, (Object)anEntity1.values);
            stats.clear();
            AnotherEntity anotherEntity1 = (AnotherEntity)s.get(AnotherEntity.class, (Serializable)Integer.valueOf(this.anotherEntity.id));
            cacheStatistics = stats.getSecondLevelCacheStatistics(REGION_NAME);
            Assert.assertEquals((long)0L, (long)cacheStatistics.getMissCount());
            Assert.assertEquals((long)1L, (long)cacheStatistics.getHitCount());
            Assert.assertEquals((long)0L, (long)cacheStatistics.getPutCount());
            stats.clear();
            Assert.assertFalse((boolean)Hibernate.isInitialized((Object)anotherEntity1.values));
            Hibernate.initialize((Object)anotherEntity1.values);
            cacheStatistics = stats.getSecondLevelCacheStatistics(REGION_NAME);
            Assert.assertEquals((long)0L, (long)cacheStatistics.getMissCount());
            Assert.assertEquals((long)1L, (long)cacheStatistics.getHitCount());
            Assert.assertEquals((long)0L, (long)cacheStatistics.getPutCount());
            Assert.assertEquals((Object)this.anotherEntity.values, (Object)anotherEntity1.values);
        });
    }

    @Entity(name="AnotherEntity")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL, region="ARegion")
    public static class AnotherEntity {
        @Id
        private int id;
        @ElementCollection
        @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL, region="ARegion")
        private Set<Integer> values = new HashSet<Integer>();
    }

    @Entity(name="AnEntity")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL, region="ARegion")
    public static class AnEntity {
        @Id
        private int id;
        @ElementCollection
        @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL, region="ARegion")
        private Set<String> values = new HashSet<String>();
    }
}

