/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.commons.functional;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.engine.transaction.jta.platform.internal.NoJtaPlatform;
import org.hibernate.resource.transaction.backend.jdbc.internal.JdbcResourceLocalTransactionCoordinatorBuilderImpl;
import org.hibernate.testing.TestForIssue;
import org.infinispan.commons.util.ByRef;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.test.Exceptions;
import org.infinispan.test.TestException;
import org.infinispan.test.hibernate.cache.commons.functional.SingleNodeTest;
import org.infinispan.test.hibernate.cache.commons.functional.entities.Customer;
import org.junit.Assert;
import org.junit.Test;

public class LocalCacheTest
extends SingleNodeTest {
    @Override
    public List<Object[]> getParameters() {
        return Collections.singletonList(new Object[]{"local", NoJtaPlatform.class, JdbcResourceLocalTransactionCoordinatorBuilderImpl.class, null, AccessType.READ_WRITE, CacheMode.LOCAL, false, false});
    }

    @Override
    protected void addSettings(Map settings) {
        super.addSettings(settings);
        settings.put("hibernate.cache.infinispan.cfg", "org/infinispan/hibernate/cache/commons/builder/infinispan-configs-local.xml");
    }

    @Test
    @TestForIssue(jiraKey="HHH-12457")
    public void testRollback() throws Exception {
        ByRef idRef = new ByRef((Object)0);
        this.withTxSession(s -> {
            Customer c = new Customer();
            c.setName("Foo");
            s.persist((Object)c);
            idRef.set((Object)c.getId());
        });
        Exceptions.expectException(TestException.class, () -> this.withTxSession(s -> {
            Customer c = (Customer)s.load(Customer.class, (Serializable)idRef.get());
            c.setName("Bar");
            s.persist((Object)c);
            s.flush();
            throw new TestException("Roll me back");
        }));
        this.withTxSession(s -> {
            Customer c = (Customer)s.load(Customer.class, (Serializable)idRef.get());
            Assert.assertEquals((Object)"Foo", (Object)c.getName());
        });
    }
}

