/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.commons.functional;

import java.util.List;
import java.util.Map;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.stat.Statistics;
import org.infinispan.test.hibernate.cache.commons.functional.SingleNodeTest;
import org.infinispan.test.hibernate.cache.commons.functional.entities.Person;
import org.infinispan.test.hibernate.cache.commons.util.TestRegionFactory;
import org.infinispan.util.ControlledTimeService;
import org.junit.Assert;
import org.junit.Test;

public class NonTxQueryTest
extends SingleNodeTest {
    protected static final ControlledTimeService TIME_SERVICE = new ControlledTimeService();

    @Override
    public List<Object[]> getParameters() {
        return this.getParameters(true, true, true, true, true);
    }

    protected Class[] getAnnotatedClasses() {
        return new Class[]{Person.class};
    }

    @Override
    protected void addSettings(Map settings) {
        super.addSettings(settings);
        settings.put(TestRegionFactory.TIME_SERVICE, TIME_SERVICE);
    }

    @Test
    public void testNonTransactionalQuery() throws Exception {
        Person john = new Person("John", "Black", 26);
        Person peter = new Person("Peter", "White", 32);
        this.withTxSession(s -> {
            s.persist((Object)john);
            s.persist((Object)peter);
        });
        TIME_SERVICE.advance(60001L);
        Statistics statistics = this.sessionFactory().getStatistics();
        statistics.clear();
        this.withSession(s -> {
            this.queryPersons((Session)s);
            Assert.assertEquals((long)1L, (long)statistics.getQueryCacheMissCount());
            Assert.assertEquals((long)1L, (long)statistics.getQueryCachePutCount());
        });
        statistics.clear();
        this.withSession(s -> {
            this.queryPersons((Session)s);
            Assert.assertEquals((long)1L, (long)statistics.getQueryCacheHitCount());
        });
    }

    public void queryPersons(Session s) {
        Query query = s.createQuery("from Person").setCacheable(true);
        List result = query.list();
        Assert.assertEquals((long)2L, (long)result.size());
    }
}

