/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.commons.functional;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.infinispan.hibernate.cache.commons.InfinispanBaseRegion;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.hibernate.cache.commons.functional.AbstractFunctionalTest;
import org.infinispan.test.hibernate.cache.commons.util.TestRegionFactory;
import org.infinispan.test.hibernate.cache.commons.util.TestRegionFactoryProvider;
import org.infinispan.test.hibernate.cache.commons.util.TestSessionAccess;
import org.junit.Assert;
import org.junit.Test;

public class QualifierTest
extends AbstractFunctionalTest {
    public static final String FOO_BAR = "foo.bar";

    @Override
    public List<Object[]> getParameters() {
        return Collections.singletonList(READ_WRITE_DISTRIBUTED);
    }

    @Override
    protected void addSettings(Map settings) {
        super.addSettings(settings);
        settings.put("hibernate.cache.region_prefix", FOO_BAR);
    }

    @Test
    public void testRegionNamesQualified() {
        TestRegionFactory factory = TestRegionFactoryProvider.INSTANCE.findRegionFactory(this.sessionFactory().getCache());
        EmbeddedCacheManager cacheManager = factory.getCacheManager();
        for (String cacheName : cacheManager.getCacheNames()) {
            Assert.assertTrue((boolean)cacheName.startsWith(FOO_BAR));
        }
        if (!TestRegionFactoryProvider.INSTANCE.getRegionFactoryClass().getName().contains(".v51.")) {
            for (InfinispanBaseRegion region : TestSessionAccess.findTestSessionAccess().getAllRegions(this.sessionFactory())) {
                Assert.assertFalse((boolean)region.getName().startsWith(FOO_BAR));
            }
        }
    }
}

