/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.commons.functional;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.hibernate.stat.Statistics;
import org.infinispan.hibernate.cache.commons.InfinispanBaseRegion;
import org.infinispan.hibernate.cache.commons.util.InfinispanMessageLogger;
import org.infinispan.test.hibernate.cache.commons.functional.SingleNodeTest;
import org.infinispan.test.hibernate.cache.commons.functional.entities.Item;
import org.infinispan.test.hibernate.cache.commons.util.TestRegionFactory;
import org.infinispan.util.ControlledTimeService;
import org.junit.Assert;
import org.junit.Test;

public class ReadOnlyTest
extends SingleNodeTest {
    protected static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(ReadOnlyTest.class);
    protected static final ControlledTimeService TIME_SERVICE = new ControlledTimeService();

    @Override
    public List<Object[]> getParameters() {
        return this.getParameters(false, false, true, true, true);
    }

    @Test
    public void testEmptySecondLevelCacheEntry() {
        this.sessionFactory().getCache().evictCollectionRegion(Item.class.getName() + ".items");
        Statistics stats = this.sessionFactory().getStatistics();
        stats.clear();
        InfinispanBaseRegion region = TEST_SESSION_ACCESS.getRegion(this.sessionFactory(), Item.class.getName() + ".items");
        Assert.assertEquals((long)0L, (long)region.getElementCountInMemory());
    }

    @Test
    public void testInsertDeleteEntity() throws Exception {
        Statistics stats = this.sessionFactory().getStatistics();
        stats.clear();
        Item item = new Item("chris", "Chris's Item");
        this.withTxSession(s -> s.persist((Object)item));
        log.info((Object)"Entry persisted, let's load and delete it.");
        this.withTxSession(s -> {
            Item found = (Item)s.load(Item.class, (Serializable)item.getId());
            log.info((Object)stats.toString());
            Assert.assertEquals((Object)item.getDescription(), (Object)found.getDescription());
            Assert.assertEquals((long)0L, (long)stats.getSecondLevelCacheMissCount());
            Assert.assertEquals((long)1L, (long)stats.getSecondLevelCacheHitCount());
            s.delete((Object)found);
        });
    }

    @Test
    public void testInsertClearCacheDeleteEntity() throws Exception {
        Statistics stats = this.sessionFactory().getStatistics();
        stats.clear();
        Item item = new Item("chris", "Chris's Item");
        this.withTxSession(s -> s.persist((Object)item));
        Assert.assertEquals((long)0L, (long)stats.getSecondLevelCacheMissCount());
        Assert.assertEquals((long)0L, (long)stats.getSecondLevelCacheHitCount());
        Assert.assertEquals((long)1L, (long)stats.getSecondLevelCachePutCount());
        log.info((Object)"Entry persisted, let's load and delete it.");
        this.cleanupCache();
        TIME_SERVICE.advance(1L);
        this.withTxSession(s -> {
            Item found = (Item)s.load(Item.class, (Serializable)item.getId());
            log.info((Object)stats.toString());
            Assert.assertEquals((Object)item.getDescription(), (Object)found.getDescription());
            Assert.assertEquals((long)1L, (long)stats.getSecondLevelCacheMissCount());
            Assert.assertEquals((long)0L, (long)stats.getSecondLevelCacheHitCount());
            Assert.assertEquals((long)2L, (long)stats.getSecondLevelCachePutCount());
            s.delete((Object)found);
        });
    }

    @Override
    protected void addSettings(Map settings) {
        super.addSettings(settings);
        settings.put(TestRegionFactory.TIME_SERVICE, TIME_SERVICE);
    }
}

