/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.commons.functional;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Cache;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.NaturalIdLoadAccess;
import org.hibernate.Session;
import org.hibernate.cache.spi.entry.CacheEntry;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.stat.SecondLevelCacheStatistics;
import org.hibernate.stat.Statistics;
import org.hibernate.testing.TestForIssue;
import org.infinispan.commons.util.ByRef;
import org.infinispan.test.hibernate.cache.commons.functional.ReadOnlyTest;
import org.infinispan.test.hibernate.cache.commons.functional.entities.Citizen;
import org.infinispan.test.hibernate.cache.commons.functional.entities.Item;
import org.infinispan.test.hibernate.cache.commons.functional.entities.NaturalIdOnManyToOne;
import org.infinispan.test.hibernate.cache.commons.functional.entities.OtherItem;
import org.infinispan.test.hibernate.cache.commons.functional.entities.State;
import org.infinispan.test.hibernate.cache.commons.functional.entities.VersionedItem;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class ReadWriteTest
extends ReadOnlyTest {
    @Override
    public List<Object[]> getParameters() {
        return this.getParameters(true, true, false, true, true);
    }

    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Citizen.class, State.class, NaturalIdOnManyToOne.class};
    }

    @After
    public void cleanupData() throws Exception {
        super.cleanupCache();
        this.withTxSession(s -> {
            TEST_SESSION_ACCESS.execQueryUpdate(s, "delete NaturalIdOnManyToOne");
            TEST_SESSION_ACCESS.execQueryUpdate(s, "delete Citizen");
            TEST_SESSION_ACCESS.execQueryUpdate(s, "delete State");
        });
    }

    @Test
    public void testCollectionCache() throws Exception {
        Statistics stats = this.sessionFactory().getStatistics();
        stats.clear();
        Item item = new Item("chris", "Chris's Item");
        Item another = new Item("another", "Owned Item");
        item.addItem(another);
        this.withTxSession(s -> {
            s.persist((Object)item);
            s.persist((Object)another);
        });
        TIME_SERVICE.advance(1L);
        this.withTxSession(s -> {
            Item loaded = (Item)s.load(Item.class, (Serializable)item.getId());
            Assert.assertEquals((long)1L, (long)loaded.getItems().size());
        });
        String itemsRegionName = Item.class.getName() + ".items";
        SecondLevelCacheStatistics cStats = stats.getSecondLevelCacheStatistics(itemsRegionName);
        Assert.assertEquals((long)1L, (long)cStats.getElementCountInMemory());
        this.withTxSession(s -> {
            Item loadedWithCachedCollection = (Item)s.load(Item.class, (Serializable)item.getId());
            stats.logSummary();
            Assert.assertEquals((Object)item.getName(), (Object)loadedWithCachedCollection.getName());
            Assert.assertEquals((long)item.getItems().size(), (long)loadedWithCachedCollection.getItems().size());
            Assert.assertEquals((long)1L, (long)cStats.getHitCount());
            Assert.assertEquals((long)1L, (long)TEST_SESSION_ACCESS.getRegion(this.sessionFactory(), itemsRegionName).getElementCountInMemory());
            Item itemElement = loadedWithCachedCollection.getItems().iterator().next();
            itemElement.setOwner(null);
            loadedWithCachedCollection.getItems().clear();
            s.delete((Object)itemElement);
            s.delete((Object)loadedWithCachedCollection);
        });
    }

    @Test
    @TestForIssue(jiraKey="HHH-9231")
    public void testAddNewOneToManyElementInitFlushLeaveCacheConsistent() throws Exception {
        Statistics stats = this.sessionFactory().getStatistics();
        stats.clear();
        SecondLevelCacheStatistics cStats = stats.getSecondLevelCacheStatistics(Item.class.getName() + ".items");
        ByRef itemId = new ByRef(null);
        this.saveItem((ByRef<Long>)itemId);
        Item itemElement = new Item();
        itemElement.setName("element");
        itemElement.setDescription("element item");
        this.withTxSession(s -> {
            Item item = (Item)s.get(Item.class, (Serializable)itemId.get());
            Assert.assertFalse((boolean)Hibernate.isInitialized(item.getItems()));
            item.addItem(itemElement);
            Assert.assertTrue((boolean)Hibernate.isInitialized(item.getItems()));
            s.persist((Object)itemElement);
            s.flush();
            this.markRollbackOnly((Session)s);
        });
        this.withTxSession(s -> {
            Item item = (Item)s.get(Item.class, (Serializable)itemId.get());
            Hibernate.initialize(item.getItems());
            Assert.assertTrue((boolean)item.getItems().isEmpty());
            s.delete((Object)item);
        });
    }

    @Test
    @TestForIssue(jiraKey="HHH-9231")
    public void testAddNewOneToManyElementNoInitFlushLeaveCacheConsistent() throws Exception {
        Statistics stats = this.sessionFactory().getStatistics();
        stats.clear();
        SecondLevelCacheStatistics cStats = stats.getSecondLevelCacheStatistics(Item.class.getName() + ".items");
        ByRef itemId = new ByRef(null);
        this.saveItem((ByRef<Long>)itemId);
        Item itemElement = new Item();
        itemElement.setName("element");
        itemElement.setDescription("element item");
        this.withTxSession(s -> {
            Item item = (Item)s.get(Item.class, (Serializable)itemId.get());
            Assert.assertFalse((boolean)Hibernate.isInitialized(item.getItems()));
            item.addItemToBag(itemElement);
            Assert.assertFalse((boolean)Hibernate.isInitialized(item.getBagOfItems()));
            s.persist((Object)itemElement);
            s.flush();
            this.markRollbackOnly((Session)s);
        });
        this.withTxSession(s -> {
            Item item = (Item)s.get(Item.class, (Serializable)itemId.get());
            Hibernate.initialize(item.getItems());
            Assert.assertTrue((boolean)item.getItems().isEmpty());
            s.delete((Object)item);
        });
    }

    @Test
    public void testAddNewOneToManyElementNoInitFlushInitLeaveCacheConsistent() throws Exception {
        Statistics stats = this.sessionFactory().getStatistics();
        stats.clear();
        SecondLevelCacheStatistics cStats = stats.getSecondLevelCacheStatistics(Item.class.getName() + ".items");
        ByRef itemId = new ByRef(null);
        this.saveItem((ByRef<Long>)itemId);
        Item itemElement = new Item();
        itemElement.setName("element");
        itemElement.setDescription("element item");
        this.withTxSession(s -> {
            Item item = (Item)s.get(Item.class, (Serializable)itemId.get());
            Assert.assertFalse((boolean)Hibernate.isInitialized(item.getBagOfItems()));
            item.addItemToBag(itemElement);
            Assert.assertFalse((boolean)Hibernate.isInitialized(item.getBagOfItems()));
            s.persist((Object)itemElement);
            s.flush();
            Hibernate.initialize(item.getBagOfItems());
            this.markRollbackOnly((Session)s);
        });
        this.withTxSession(s -> {
            Item item = (Item)s.get(Item.class, (Serializable)itemId.get());
            Hibernate.initialize(item.getBagOfItems());
            Assert.assertTrue((boolean)item.getBagOfItems().isEmpty());
            s.delete((Object)item);
        });
    }

    protected void saveItem(ByRef<Long> itemId) throws Exception {
        this.withTxSession(s -> {
            Item item = new Item();
            item.setName("steve");
            item.setDescription("steve's item");
            s.save((Object)item);
            itemId.set((Object)item.getId());
        });
    }

    @Test
    public void testAddNewManyToManyPropertyRefNoInitFlushInitLeaveCacheConsistent() throws Exception {
        Statistics stats = this.sessionFactory().getStatistics();
        stats.clear();
        SecondLevelCacheStatistics cStats = stats.getSecondLevelCacheStatistics(Item.class.getName() + ".items");
        ByRef otherItemId = new ByRef(null);
        this.withTxSession(s -> {
            OtherItem otherItem = new OtherItem();
            otherItem.setName("steve");
            s.save((Object)otherItem);
            otherItemId.set((Object)otherItem.getId());
        });
        Item item = new Item();
        item.setName("element");
        item.setDescription("element Item");
        this.withTxSession(s -> {
            OtherItem otherItem = (OtherItem)s.get(OtherItem.class, (Serializable)otherItemId.get());
            Assert.assertFalse((boolean)Hibernate.isInitialized(otherItem.getBagOfItems()));
            otherItem.addItemToBag(item);
            Assert.assertFalse((boolean)Hibernate.isInitialized(otherItem.getBagOfItems()));
            s.persist((Object)item);
            s.flush();
            Hibernate.initialize(otherItem.getBagOfItems());
            this.markRollbackOnly((Session)s);
        });
        this.withTxSession(s -> {
            OtherItem otherItem = (OtherItem)s.get(OtherItem.class, (Serializable)otherItemId.get());
            Hibernate.initialize(otherItem.getBagOfItems());
            Assert.assertTrue((boolean)otherItem.getBagOfItems().isEmpty());
            s.delete((Object)otherItem);
        });
    }

    @Test
    public void testStaleWritesLeaveCacheConsistent() throws Exception {
        Statistics stats = this.sessionFactory().getStatistics();
        stats.clear();
        ByRef itemRef = new ByRef(null);
        this.withTxSession(s -> {
            VersionedItem item = new VersionedItem();
            item.setName("steve");
            item.setDescription("steve's item");
            s.save((Object)item);
            itemRef.set((Object)item);
        });
        VersionedItem item = (VersionedItem)itemRef.get();
        Long initialVersion = item.getVersion();
        item.setVersion(new Long(item.getVersion() - 1L));
        try {
            this.withTxSession(s -> s.update((Object)item));
            Assert.fail((String)"expected stale write to fail");
        }
        catch (Exception e) {
            log.debug((Object)"Rollback was expected", (Throwable)e);
        }
        CacheEntry entry = this.getEntry(VersionedItem.class.getName(), item.getId());
        Assert.assertNotNull((Object)entry);
        Long cachedVersionValue = (Long)entry.getVersion();
        Assert.assertNotNull((Object)cachedVersionValue);
        Assert.assertEquals((long)initialVersion, (long)cachedVersionValue);
        this.withTxSession(s -> {
            VersionedItem item2 = (VersionedItem)s.load(VersionedItem.class, (Serializable)item.getId());
            s.delete((Object)item2);
        });
    }

    @Test
    @TestForIssue(jiraKey="HHH-5690")
    public void testPersistEntityFlushRollbackNotInEntityCache() throws Exception {
        Statistics stats = this.sessionFactory().getStatistics();
        stats.clear();
        SecondLevelCacheStatistics slcs = stats.getSecondLevelCacheStatistics(Item.class.getName());
        ByRef itemId = new ByRef(null);
        this.withTxSession(s -> {
            Item item = new Item();
            item.setName("steve");
            item.setDescription("steve's item");
            s.persist((Object)item);
            s.flush();
            itemId.set((Object)item.getId());
            this.markRollbackOnly((Session)s);
        });
        Assert.assertEquals((long)0L, (long)this.getNumberOfItems());
        this.withTxSession(s -> {
            Item item = (Item)s.get(Item.class, (Serializable)itemId.get());
            Assert.assertNull((Object)item);
        });
    }

    @Test
    @TestForIssue(jiraKey="HHH-5690")
    public void testPersistEntityFlushEvictGetRollbackNotInEntityCache() throws Exception {
        Statistics stats = this.sessionFactory().getStatistics();
        stats.clear();
        SecondLevelCacheStatistics slcs = stats.getSecondLevelCacheStatistics(Item.class.getName());
        ByRef itemId = new ByRef(null);
        this.withTxSession(s -> {
            Item item = new Item();
            item.setName("steve");
            item.setDescription("steve's item");
            s.persist((Object)item);
            s.flush();
            itemId.set((Object)item.getId());
            s.evict((Object)item);
            Assert.assertEquals((long)slcs.getHitCount(), (long)0L);
            item = (Item)s.get(Item.class, (Serializable)item.getId());
            Assert.assertNotNull((Object)item);
            this.markRollbackOnly((Session)s);
        });
        Assert.assertEquals((long)0L, (long)this.getNumberOfItems());
        this.withTxSession(s -> {
            Item item = (Item)s.get(Item.class, (Serializable)itemId.get());
            Assert.assertNull((Object)item);
        });
    }

    @Test
    public void testQueryCacheInvalidation() throws Exception {
        Statistics stats = this.sessionFactory().getStatistics();
        stats.clear();
        SecondLevelCacheStatistics slcs = stats.getSecondLevelCacheStatistics(Item.class.getName());
        this.sessionFactory().getCache().evictEntityRegion(Item.class.getName());
        TIME_SERVICE.advance(1L);
        Assert.assertEquals((long)0L, (long)slcs.getPutCount());
        Assert.assertEquals((long)0L, (long)slcs.getElementCountInMemory());
        Assert.assertEquals((long)0L, (long)this.getNumberOfItems());
        ByRef idRef = new ByRef(null);
        this.withTxSession(s -> {
            Item item = new Item();
            item.setName("widget");
            item.setDescription("A really top-quality, full-featured widget.");
            s.persist((Object)item);
            idRef.set((Object)item.getId());
        });
        Assert.assertEquals((long)1L, (long)slcs.getPutCount());
        Assert.assertEquals((long)1L, (long)slcs.getElementCountInMemory());
        Assert.assertEquals((long)1L, (long)this.getNumberOfItems());
        this.withTxSession(s -> {
            Item item = (Item)s.get(Item.class, (Serializable)idRef.get());
            Assert.assertEquals((long)slcs.getHitCount(), (long)1L);
            Assert.assertEquals((long)slcs.getMissCount(), (long)0L);
            item.setDescription("A bog standard item");
        });
        Assert.assertEquals((long)slcs.getPutCount(), (long)2L);
        CacheEntry entry = this.getEntry(Item.class.getName(), (Long)idRef.get());
        Serializable[] ser = entry.getDisassembledState();
        Assert.assertTrue((boolean)ser[0].equals("widget"));
        Assert.assertTrue((boolean)ser[1].equals("A bog standard item"));
        this.withTxSession(s -> {
            Item item = (Item)s.load(Item.class, (Serializable)idRef.get());
            s.delete((Object)item);
        });
    }

    @Test
    public void testQueryCache() throws Exception {
        Statistics stats = this.sessionFactory().getStatistics();
        stats.clear();
        Item item = new Item("chris", "Chris's Item");
        this.withTxSession(s -> s.persist((Object)item));
        TIME_SERVICE.advance(60001L);
        this.withTxSession(s -> TEST_SESSION_ACCESS.execQueryListCacheable(s, "from Item"));
        this.withTxSession(s -> {
            TEST_SESSION_ACCESS.execQueryListCacheable(s, "from Item");
            Assert.assertEquals((long)1L, (long)stats.getQueryCacheHitCount());
            TEST_SESSION_ACCESS.execQueryUpdate(s, "delete from Item");
        });
    }

    @Test
    public void testQueryCacheHitInSameTransaction() throws Exception {
        Statistics stats = this.sessionFactory().getStatistics();
        stats.clear();
        Item item = new Item("galder", "Galder's Item");
        this.withTxSession(s -> s.persist((Object)item));
        TIME_SERVICE.advance(60001L);
        this.withTxSession(s -> {
            TEST_SESSION_ACCESS.execQueryListCacheable(s, "from Item");
            TEST_SESSION_ACCESS.execQueryListCacheable(s, "from Item");
            Assert.assertEquals((long)1L, (long)stats.getQueryCacheHitCount());
        });
        this.withTxSession(s -> TEST_SESSION_ACCESS.execQueryUpdate(s, "delete from Item"));
    }

    @Test
    public void testNaturalIdCached() throws Exception {
        this.saveSomeCitizens();
        this.cleanupCache();
        TIME_SERVICE.advance(1L);
        this.withTxSession(s -> {
            State france = this.getState((Session)s, "Ile de France");
            Criteria criteria = s.createCriteria(Citizen.class);
            criteria.add((Criterion)Restrictions.naturalId().set("ssn", (Object)"1234").set("state", (Object)france));
            criteria.setCacheable(true);
            Statistics stats = this.sessionFactory().getStatistics();
            stats.setStatisticsEnabled(true);
            stats.clear();
            Assert.assertEquals((String)"Cache hits should be empty", (long)0L, (long)stats.getNaturalIdCacheHitCount());
            List results = criteria.list();
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertEquals((String)"NaturalId Cache Hits", (long)0L, (long)stats.getNaturalIdCacheHitCount());
            Assert.assertEquals((String)"NaturalId Cache Misses", (long)1L, (long)stats.getNaturalIdCacheMissCount());
            Assert.assertEquals((String)"NaturalId Cache Puts", (long)1L, (long)stats.getNaturalIdCachePutCount());
            Assert.assertEquals((String)"NaturalId Cache Queries", (long)1L, (long)stats.getNaturalIdQueryExecutionCount());
            criteria.list();
            Assert.assertEquals((String)"NaturalId Cache Hits", (long)0L, (long)stats.getNaturalIdCacheHitCount());
            Assert.assertEquals((String)"NaturalId Cache Misses", (long)1L, (long)stats.getNaturalIdCacheMissCount());
            Assert.assertEquals((String)"NaturalId Cache Puts", (long)1L, (long)stats.getNaturalIdCachePutCount());
            Assert.assertEquals((String)"NaturalId Cache Queries", (long)1L, (long)stats.getNaturalIdQueryExecutionCount());
            this.markRollbackOnly((Session)s);
        });
    }

    @Test
    public void testNaturalIdLoaderCached() throws Exception {
        Statistics stats = this.sessionFactory().getStatistics();
        stats.setStatisticsEnabled(true);
        stats.clear();
        Assert.assertEquals((String)"NaturalId Cache Hits", (long)0L, (long)stats.getNaturalIdCacheHitCount());
        Assert.assertEquals((String)"NaturalId Cache Misses", (long)0L, (long)stats.getNaturalIdCacheMissCount());
        Assert.assertEquals((String)"NaturalId Cache Puts", (long)0L, (long)stats.getNaturalIdCachePutCount());
        Assert.assertEquals((String)"NaturalId Cache Queries", (long)0L, (long)stats.getNaturalIdQueryExecutionCount());
        this.saveSomeCitizens();
        Assert.assertEquals((String)"NaturalId Cache Hits", (long)0L, (long)stats.getNaturalIdCacheHitCount());
        Assert.assertEquals((String)"NaturalId Cache Misses", (long)0L, (long)stats.getNaturalIdCacheMissCount());
        Assert.assertEquals((String)"NaturalId Cache Puts", (long)2L, (long)stats.getNaturalIdCachePutCount());
        Assert.assertEquals((String)"NaturalId Cache Queries", (long)0L, (long)stats.getNaturalIdQueryExecutionCount());
        Citizen citizen = this.withTxSessionApply(s -> {
            State france = this.getState((Session)s, "Ile de France");
            NaturalIdLoadAccess naturalIdLoader = s.byNaturalId(Citizen.class);
            naturalIdLoader.using("ssn", (Object)"1234").using("state", (Object)france);
            stats.clear();
            Citizen c = (Citizen)naturalIdLoader.load();
            Assert.assertNotNull((Object)c);
            Assert.assertEquals((String)"NaturalId Cache Hits", (long)1L, (long)stats.getNaturalIdCacheHitCount());
            Assert.assertEquals((String)"NaturalId Cache Misses", (long)0L, (long)stats.getNaturalIdCacheMissCount());
            Assert.assertEquals((String)"NaturalId Cache Puts", (long)0L, (long)stats.getNaturalIdCachePutCount());
            Assert.assertEquals((String)"NaturalId Cache Queries", (long)0L, (long)stats.getNaturalIdQueryExecutionCount());
            this.markRollbackOnly((Session)s);
            return c;
        });
        this.cleanupCache();
        TIME_SERVICE.advance(1L);
        stats.setStatisticsEnabled(true);
        stats.clear();
        this.withTxSession(s -> {
            Citizen loadedCitizen = (Citizen)s.get(Citizen.class, (Serializable)citizen.getId());
            Assert.assertNotNull((Object)loadedCitizen);
            Assert.assertEquals((String)"NaturalId Cache Hits", (long)0L, (long)stats.getNaturalIdCacheHitCount());
            Assert.assertEquals((String)"NaturalId Cache Misses", (long)0L, (long)stats.getNaturalIdCacheMissCount());
            Assert.assertEquals((String)"NaturalId Cache Puts", (long)1L, (long)stats.getNaturalIdCachePutCount());
            Assert.assertEquals((String)"NaturalId Cache Queries", (long)0L, (long)stats.getNaturalIdQueryExecutionCount());
            this.markRollbackOnly((Session)s);
        });
        this.withTxSession(s -> {
            State france = this.getState((Session)s, "Ile de France");
            NaturalIdLoadAccess naturalIdLoader = s.byNaturalId(Citizen.class);
            naturalIdLoader.using("ssn", (Object)"1234").using("state", (Object)france);
            stats.setStatisticsEnabled(true);
            stats.clear();
            Citizen loadedCitizen = (Citizen)naturalIdLoader.load();
            Assert.assertNotNull((Object)loadedCitizen);
            Assert.assertEquals((String)"NaturalId Cache Hits", (long)1L, (long)stats.getNaturalIdCacheHitCount());
            Assert.assertEquals((String)"NaturalId Cache Misses", (long)0L, (long)stats.getNaturalIdCacheMissCount());
            Assert.assertEquals((String)"NaturalId Cache Puts", (long)0L, (long)stats.getNaturalIdCachePutCount());
            Assert.assertEquals((String)"NaturalId Cache Queries", (long)0L, (long)stats.getNaturalIdQueryExecutionCount());
            this.markRollbackOnly((Session)s);
        });
    }

    @Test
    public void testEntityCacheContentsAfterEvictAll() throws Exception {
        List<Citizen> citizens = this.saveSomeCitizens();
        this.withTxSession(s -> {
            Cache cache = s.getSessionFactory().getCache();
            Statistics stats = this.sessionFactory().getStatistics();
            SecondLevelCacheStatistics slcStats = stats.getSecondLevelCacheStatistics(Citizen.class.getName());
            Assert.assertTrue((String)("2lc entity cache is expected to contain Citizen id = " + ((Citizen)citizens.get(0)).getId()), (boolean)cache.containsEntity(Citizen.class, (Serializable)((Citizen)citizens.get(0)).getId()));
            Assert.assertTrue((String)("2lc entity cache is expected to contain Citizen id = " + ((Citizen)citizens.get(1)).getId()), (boolean)cache.containsEntity(Citizen.class, (Serializable)((Citizen)citizens.get(1)).getId()));
            Assert.assertEquals((long)2L, (long)slcStats.getPutCount());
            cache.evictEntityRegions();
            TIME_SERVICE.advance(1L);
            Assert.assertEquals((long)0L, (long)slcStats.getElementCountInMemory());
            Assert.assertFalse((String)("2lc entity cache is expected to not contain Citizen id = " + ((Citizen)citizens.get(0)).getId()), (boolean)cache.containsEntity(Citizen.class, (Serializable)((Citizen)citizens.get(0)).getId()));
            Assert.assertFalse((String)("2lc entity cache is expected to not contain Citizen id = " + ((Citizen)citizens.get(1)).getId()), (boolean)cache.containsEntity(Citizen.class, (Serializable)((Citizen)citizens.get(1)).getId()));
            Citizen citizen = (Citizen)s.load(Citizen.class, (Serializable)((Citizen)citizens.get(0)).getId());
            Assert.assertNotNull((Object)citizen);
            Assert.assertNotNull((Object)citizen.getFirstname());
            Assert.assertEquals((long)1L, (long)slcStats.getMissCount());
            this.markRollbackOnly((Session)s);
        });
    }

    @Test
    public void testMultipleEvictAll() throws Exception {
        List<Citizen> citizens = this.saveSomeCitizens();
        this.withTxSession(s -> {
            Cache cache = s.getSessionFactory().getCache();
            cache.evictEntityRegions();
            cache.evictEntityRegions();
        });
        this.withTxSession(s -> {
            Cache cache = s.getSessionFactory().getCache();
            cache.evictEntityRegions();
            s.delete(s.load(Citizen.class, (Serializable)((Citizen)citizens.get(0)).getId()));
            s.delete(s.load(Citizen.class, (Serializable)((Citizen)citizens.get(1)).getId()));
        });
    }

    private List<Citizen> saveSomeCitizens() throws Exception {
        Citizen c1 = new Citizen();
        c1.setFirstname("Emmanuel");
        c1.setLastname("Bernard");
        c1.setSsn("1234");
        State france = new State();
        france.setName("Ile de France");
        c1.setState(france);
        Citizen c2 = new Citizen();
        c2.setFirstname("Gavin");
        c2.setLastname("King");
        c2.setSsn("000");
        State australia = new State();
        australia.setName("Australia");
        c2.setState(australia);
        this.withTxSession(s -> {
            s.persist((Object)australia);
            s.persist((Object)france);
            s.persist((Object)c1);
            s.persist((Object)c2);
        });
        ArrayList<Citizen> citizens = new ArrayList<Citizen>(2);
        citizens.add(c1);
        citizens.add(c2);
        return citizens;
    }

    private State getState(Session s, String name) {
        Criteria criteria = s.createCriteria(State.class);
        criteria.add((Criterion)Restrictions.eq((String)"name", (Object)name));
        criteria.setCacheable(true);
        return (State)criteria.list().get(0);
    }

    private int getNumberOfItems() {
        return (int)TEST_SESSION_ACCESS.getRegion(this.sessionFactory(), Item.class.getName()).getElementCountInMemory();
    }

    private CacheEntry getEntry(String regionName, Long key) {
        return (CacheEntry)TEST_SESSION_ACCESS.getRegion(this.sessionFactory(), regionName).getCache().get((Object)key);
    }
}

