/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.commons.functional.classloader;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;

public class SelectedClassnameClassLoader
extends ClassLoader {
    private static final Logger log = Logger.getLogger(SelectedClassnameClassLoader.class);
    private String[] includedClasses = null;
    private String[] excludedClasses = null;
    private String[] notFoundClasses = null;
    private Map<String, Class> classes = new HashMap<String, Class>();

    public SelectedClassnameClassLoader(String[] includedClasses, String[] excludedClasses, ClassLoader parent) {
        this(includedClasses, excludedClasses, null, parent);
    }

    public SelectedClassnameClassLoader(String[] includedClasses, String[] excludedClasses, String[] notFoundClasses, ClassLoader parent) {
        super(parent);
        this.includedClasses = includedClasses;
        this.excludedClasses = excludedClasses;
        this.notFoundClasses = notFoundClasses;
        log.debug((Object)("created " + this));
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        log.trace((Object)("loadClass(" + name + "," + resolve + ")"));
        if (this.isIncluded(name) && !this.isExcluded(name)) {
            Class<?> c = this.findClass(name);
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
        if (this.isNotFound(name)) {
            throw new ClassNotFoundException(name + " is discarded");
        }
        return super.loadClass(name, resolve);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        log.trace((Object)("findClass(" + name + ")"));
        Class<?> result = this.classes.get(name);
        if (result != null) {
            return result;
        }
        if (this.isIncluded(name) && !this.isExcluded(name)) {
            result = this.createClass(name);
        } else {
            if (this.isNotFound(name)) {
                throw new ClassNotFoundException(name + " is discarded");
            }
            result = super.findClass(name);
        }
        this.classes.put(name, result);
        return result;
    }

    protected Class createClass(String name) throws ClassFormatError, ClassNotFoundException {
        log.info((Object)("createClass(" + name + ")"));
        try {
            int read;
            InputStream is = this.getResourceAsStream(name.replace('.', '/').concat(".class"));
            byte[] bytes = new byte[1024];
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            while ((read = is.read(bytes)) > -1) {
                baos.write(bytes, 0, read);
            }
            bytes = baos.toByteArray();
            return this.defineClass(name, bytes, 0, bytes.length);
        }
        catch (FileNotFoundException e) {
            throw new ClassNotFoundException("cannot find " + name, e);
        }
        catch (IOException e) {
            throw new ClassNotFoundException("cannot read " + name, e);
        }
    }

    protected boolean isIncluded(String className) {
        if (this.includedClasses != null) {
            for (int i = 0; i < this.includedClasses.length; ++i) {
                if (!className.startsWith(this.includedClasses[i])) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isExcluded(String className) {
        if (this.excludedClasses != null) {
            for (int i = 0; i < this.excludedClasses.length; ++i) {
                if (!className.startsWith(this.excludedClasses[i])) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isNotFound(String className) {
        if (this.notFoundClasses != null) {
            for (int i = 0; i < this.notFoundClasses.length; ++i) {
                if (!className.startsWith(this.notFoundClasses[i])) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        String s = this.getClass().getName();
        s = s + "[includedClasses=";
        s = s + SelectedClassnameClassLoader.listClasses(this.includedClasses);
        s = s + ";excludedClasses=";
        s = s + SelectedClassnameClassLoader.listClasses(this.excludedClasses);
        s = s + ";notFoundClasses=";
        s = s + SelectedClassnameClassLoader.listClasses(this.notFoundClasses);
        s = s + ";parent=";
        s = s + this.getParent();
        s = s + "]";
        return s;
    }

    private static String listClasses(String[] classes) {
        if (classes == null) {
            return null;
        }
        String s = "";
        for (int i = 0; i < classes.length; ++i) {
            if (i > 0) {
                s = s + ",";
            }
            s = s + classes[i];
        }
        return s;
    }
}

