/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.commons.functional.cluster;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hibernate.SessionBuilder;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.stat.Statistics;
import org.infinispan.AdvancedCache;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.configuration.cache.InterceptorConfiguration;
import org.infinispan.hibernate.cache.commons.util.InfinispanMessageLogger;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.test.hibernate.cache.commons.functional.cluster.ClusterAware;
import org.infinispan.test.hibernate.cache.commons.functional.cluster.DualNodeTest;
import org.infinispan.test.hibernate.cache.commons.functional.entities.Customer;
import org.infinispan.test.hibernate.cache.commons.util.ExpectingInterceptor;
import org.infinispan.test.hibernate.cache.commons.util.TxUtil;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractPartialUpdateTest
extends DualNodeTest {
    static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(AbstractPartialUpdateTest.class);
    protected SessionFactoryImplementor localFactory;
    protected SessionFactoryImplementor remoteFactory;
    private AdvancedCache<?, ?> remoteCustomerCache;

    @Override
    public List<Object[]> getParameters() {
        return Collections.singletonList(READ_WRITE_REPLICATED);
    }

    @Override
    public void startUp() {
        super.startUp();
        this.localFactory = this.sessionFactory();
        this.remoteFactory = this.secondNodeEnvironment().getSessionFactory();
        this.remoteCustomerCache = ClusterAware.getCacheManager("remote").getCache(Customer.class.getName()).getAdvancedCache();
    }

    public String getDbName() {
        return ((Object)((Object)this)).getClass().getName().replaceAll("\\W", "_");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPartialUpdate() throws Exception {
        AsyncInterceptor failureInterceptor = this.addFailureInducingInterceptor(this.remoteCustomerCache);
        try {
            CountDownLatch remoteLatch = new CountDownLatch(2);
            ExpectingInterceptor.get(this.remoteCustomerCache).when((ctx, cmd) -> cmd instanceof ReadWriteKeyCommand).countDown(remoteLatch);
            try {
                Statistics statsNode0 = this.getStatistics(this.localFactory);
                this.withTxSession((SessionFactory)this.localFactory, s -> {
                    Customer customer = new Customer();
                    customer.setName("JBoss");
                    s.persist((Object)customer);
                });
                Assert.assertEquals((long)1L, (long)statsNode0.getSecondLevelCachePutCount());
                Assert.assertEquals((long)0L, (long)statsNode0.getSecondLevelCacheMissCount());
                Assert.assertEquals((long)0L, (long)statsNode0.getSecondLevelCacheHitCount());
                Assert.assertTrue((boolean)remoteLatch.await(2L, TimeUnit.SECONDS));
            }
            catch (Throwable throwable) {
                ExpectingInterceptor.cleanup(this.remoteCustomerCache);
                throw throwable;
            }
            ExpectingInterceptor.cleanup(this.remoteCustomerCache);
            Statistics statsNode1 = this.getStatistics(this.remoteFactory);
            TxUtil.withSession((SessionBuilder)this.remoteFactory.withOptions(), s -> {
                Customer customer = (Customer)s.load(Customer.class, (Serializable)Integer.valueOf(1));
                Assert.assertEquals((Object)"JBoss", (Object)customer.getName());
            });
            Assert.assertEquals((long)0L, (long)statsNode1.getSecondLevelCachePutCount());
            Assert.assertEquals((long)0L, (long)statsNode1.getSecondLevelCacheMissCount());
            Assert.assertEquals((long)1L, (long)statsNode1.getSecondLevelCacheHitCount());
            boolean updated = this.doUpdate();
            if (updated) {
                TxUtil.withSession((SessionBuilder)this.localFactory.withOptions(), s -> {
                    Customer customer = (Customer)s.load(Customer.class, (Serializable)Integer.valueOf(1));
                    Assert.assertEquals((Object)"JBoss, a division of Red Hat", (Object)customer.getName());
                });
                TxUtil.withSession((SessionBuilder)this.remoteFactory.withOptions(), s -> {
                    Customer customer = (Customer)s.load(Customer.class, (Serializable)Integer.valueOf(1));
                    Assert.assertEquals((Object)"JBoss, a division of Red Hat", (Object)customer.getName());
                });
            }
        }
        finally {
            this.remoteCustomerCache.getAsyncInterceptorChain().removeInterceptor(failureInterceptor.getClass());
        }
    }

    private AsyncInterceptor addFailureInducingInterceptor(AdvancedCache<?, ?> cache) {
        AsyncInterceptor interceptor = this.getFailureInducingInterceptor();
        cache.getAsyncInterceptorChain().addInterceptor(interceptor, InterceptorConfiguration.Position.FIRST.ordinal());
        log.trace((Object)("Injecting FailureInducingInterceptor into " + cache.getName()));
        return interceptor;
    }

    abstract AsyncInterceptor getFailureInducingInterceptor();

    protected abstract boolean doUpdate() throws Exception;

    public Statistics getStatistics(SessionFactoryImplementor sessionFactory) {
        Statistics stats = sessionFactory.getStatistics();
        stats.clear();
        return stats;
    }

    public static class InducedException
    extends Exception {
        public InducedException(String message) {
            super(message);
        }
    }
}

