/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.commons.functional.cluster;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.infinispan.hibernate.cache.commons.util.InfinispanMessageLogger;
import org.infinispan.test.hibernate.cache.commons.functional.cluster.DualNodeJtaTransactionManagerImpl;

public class DualNodeJtaTransactionImpl
implements Transaction {
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(DualNodeJtaTransactionImpl.class);
    private int status;
    private LinkedList synchronizations;
    private Connection connection;
    private final DualNodeJtaTransactionManagerImpl jtaTransactionManager;
    private List<XAResource> enlistedResources = new ArrayList<XAResource>();
    private Xid xid = new DualNodeJtaTransactionXid();

    public DualNodeJtaTransactionImpl(DualNodeJtaTransactionManagerImpl jtaTransactionManager) {
        this.jtaTransactionManager = jtaTransactionManager;
        this.status = 0;
    }

    public int getStatus() {
        return this.status;
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, IllegalStateException, SystemException {
        if (this.status == 1) {
            log.trace((Object)"on commit, status was marked for rollback-only");
            this.rollback();
        } else {
            Synchronization s;
            int i;
            this.status = 7;
            if (this.synchronizations != null) {
                for (i = 0; i < this.synchronizations.size(); ++i) {
                    s = (Synchronization)this.synchronizations.get(i);
                    s.beforeCompletion();
                }
            }
            this.status = !this.runXaResourcePrepare() ? 9 : 2;
            this.status = 8;
            if (this.connection != null) {
                try {
                    this.connection.commit();
                    this.connection.close();
                }
                catch (SQLException sqle) {
                    this.status = 5;
                    throw new SystemException();
                }
            }
            this.runXaResourceCommitTx();
            this.status = 3;
            if (this.synchronizations != null) {
                for (i = 0; i < this.synchronizations.size(); ++i) {
                    s = (Synchronization)this.synchronizations.get(i);
                    s.afterCompletion(this.status);
                }
            }
            this.jtaTransactionManager.endCurrent(this);
        }
    }

    public void rollback() throws IllegalStateException, SystemException {
        this.status = 9;
        this.runXaResourceRollback();
        this.status = 4;
        if (this.connection != null) {
            try {
                this.connection.rollback();
                this.connection.close();
            }
            catch (SQLException sqle) {
                this.status = 5;
                throw new SystemException();
            }
        }
        if (this.synchronizations != null) {
            for (int i = 0; i < this.synchronizations.size(); ++i) {
                Synchronization s = (Synchronization)this.synchronizations.get(i);
                s.afterCompletion(this.status);
            }
        }
        this.jtaTransactionManager.endCurrent(this);
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.status = 1;
    }

    public void registerSynchronization(Synchronization synchronization) throws RollbackException, IllegalStateException, SystemException {
        if (this.synchronizations == null) {
            this.synchronizations = new LinkedList();
        }
        this.synchronizations.add(synchronization);
    }

    public void enlistConnection(Connection connection) {
        if (this.connection != null) {
            throw new IllegalStateException("Connection already registered");
        }
        this.connection = connection;
    }

    public Connection getEnlistedConnection() {
        return this.connection;
    }

    public boolean enlistResource(XAResource xaResource) throws RollbackException, IllegalStateException, SystemException {
        this.enlistedResources.add(new WrappedXaResource(xaResource));
        try {
            xaResource.start(this.xid, 0);
        }
        catch (XAException e) {
            log.error((Object)"Got an exception", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
        return true;
    }

    public boolean delistResource(XAResource xaResource, int i) throws IllegalStateException, SystemException {
        throw new SystemException("not supported");
    }

    public Collection<XAResource> getEnlistedResources() {
        return this.enlistedResources;
    }

    private boolean runXaResourcePrepare() throws SystemException {
        Collection<XAResource> resources = this.getEnlistedResources();
        for (XAResource res : resources) {
            try {
                res.prepare(this.xid);
            }
            catch (XAException e) {
                log.trace((Object)"The resource wants to rollback!", (Throwable)e);
                return false;
            }
            catch (Throwable th) {
                log.error((Object)"Unexpected error from resource manager!", th);
                throw new SystemException(th.getMessage());
            }
        }
        return true;
    }

    private void runXaResourceRollback() {
        Collection<XAResource> resources = this.getEnlistedResources();
        for (XAResource res : resources) {
            try {
                res.rollback(this.xid);
            }
            catch (XAException e) {
                log.warn((Object)"Error while rolling back", (Throwable)e);
            }
        }
    }

    private boolean runXaResourceCommitTx() throws HeuristicMixedException {
        Collection<XAResource> resources = this.getEnlistedResources();
        for (XAResource res : resources) {
            try {
                res.commit(this.xid, false);
            }
            catch (XAException e) {
                log.warn((Object)"exception while committing", (Throwable)e);
                throw new HeuristicMixedException(e.getMessage());
            }
        }
        return true;
    }

    private class WrappedXaResource
    implements XAResource {
        private final XAResource xaResource;
        private int prepareResult;

        public WrappedXaResource(XAResource xaResource) {
            this.xaResource = xaResource;
        }

        @Override
        public void commit(Xid xid, boolean b) throws XAException {
            if (this.prepareResult != 3) {
                this.xaResource.commit(xid, b);
            } else {
                log.tracef("Not committing {0} due to readonly.", (Object)xid);
            }
        }

        @Override
        public void end(Xid xid, int i) throws XAException {
            this.xaResource.end(xid, i);
        }

        @Override
        public void forget(Xid xid) throws XAException {
            this.xaResource.forget(xid);
        }

        @Override
        public int getTransactionTimeout() throws XAException {
            return this.xaResource.getTransactionTimeout();
        }

        @Override
        public boolean isSameRM(XAResource xaResource) throws XAException {
            return xaResource.isSameRM(xaResource);
        }

        @Override
        public int prepare(Xid xid) throws XAException {
            this.prepareResult = this.xaResource.prepare(xid);
            return this.prepareResult;
        }

        @Override
        public Xid[] recover(int i) throws XAException {
            return this.xaResource.recover(i);
        }

        @Override
        public void rollback(Xid xid) throws XAException {
            this.xaResource.rollback(xid);
        }

        @Override
        public boolean setTransactionTimeout(int i) throws XAException {
            return this.xaResource.setTransactionTimeout(i);
        }

        @Override
        public void start(Xid xid, int i) throws XAException {
            this.xaResource.start(xid, i);
        }
    }

    private static class DualNodeJtaTransactionXid
    implements Xid {
        private static AtomicInteger txIdCounter = new AtomicInteger(0);
        private int id = txIdCounter.incrementAndGet();

        private DualNodeJtaTransactionXid() {
        }

        @Override
        public int getFormatId() {
            return this.id;
        }

        @Override
        public byte[] getGlobalTransactionId() {
            throw new IllegalStateException("TODO - please implement me!!!");
        }

        @Override
        public byte[] getBranchQualifier() {
            throw new IllegalStateException("TODO - please implement me!!!");
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{id=" + this.id + '}';
        }
    }
}

