/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.commons.functional.cluster;

import java.util.Hashtable;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.hibernate.cache.commons.util.InfinispanMessageLogger;
import org.infinispan.test.hibernate.cache.commons.functional.cluster.DualNodeJtaTransactionImpl;

public class DualNodeJtaTransactionManagerImpl
implements TransactionManager {
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(DualNodeJtaTransactionManagerImpl.class);
    private static final Hashtable INSTANCES = new Hashtable();
    private ThreadLocal currentTransaction = new ThreadLocal();
    private String nodeId;

    public static synchronized DualNodeJtaTransactionManagerImpl getInstance(String nodeId) {
        DualNodeJtaTransactionManagerImpl tm = (DualNodeJtaTransactionManagerImpl)INSTANCES.get(nodeId);
        if (tm == null) {
            tm = new DualNodeJtaTransactionManagerImpl(nodeId);
            INSTANCES.put(nodeId, tm);
        }
        return tm;
    }

    public static synchronized void cleanupTransactions() {
        for (TransactionManager tm : INSTANCES.values()) {
            try {
                tm.suspend();
            }
            catch (Exception e) {
                log.error((Object)("Exception cleaning up TransactionManager " + tm));
            }
        }
    }

    public static synchronized void cleanupTransactionManagers() {
        INSTANCES.clear();
    }

    private DualNodeJtaTransactionManagerImpl(String nodeId) {
        this.nodeId = nodeId;
    }

    public int getStatus() throws SystemException {
        DualNodeJtaTransactionImpl tx = this.getCurrentTransaction();
        return tx == null ? 6 : tx.getStatus();
    }

    public Transaction getTransaction() throws SystemException {
        return (Transaction)this.currentTransaction.get();
    }

    public DualNodeJtaTransactionImpl getCurrentTransaction() {
        return (DualNodeJtaTransactionImpl)this.currentTransaction.get();
    }

    public void begin() throws NotSupportedException, SystemException {
        this.currentTransaction.set(new DualNodeJtaTransactionImpl(this));
    }

    public Transaction suspend() throws SystemException {
        DualNodeJtaTransactionImpl suspended = this.getCurrentTransaction();
        log.trace((Object)(this.nodeId + ": Suspending " + suspended + " for thread " + Thread.currentThread().getName()));
        this.currentTransaction.set(null);
        return suspended;
    }

    public void resume(Transaction transaction) throws InvalidTransactionException, IllegalStateException, SystemException {
        this.currentTransaction.set(transaction);
        log.trace((Object)(this.nodeId + ": Resumed " + transaction + " for thread " + Thread.currentThread().getName()));
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        DualNodeJtaTransactionImpl tx = this.getCurrentTransaction();
        if (tx == null) {
            throw new IllegalStateException("no current transaction to commit");
        }
        tx.commit();
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        DualNodeJtaTransactionImpl tx = this.getCurrentTransaction();
        if (tx == null) {
            throw new IllegalStateException("no current transaction");
        }
        tx.rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        DualNodeJtaTransactionImpl tx = this.getCurrentTransaction();
        if (tx == null) {
            throw new IllegalStateException("no current transaction");
        }
        tx.setRollbackOnly();
    }

    public void setTransactionTimeout(int i) throws SystemException {
    }

    void endCurrent(DualNodeJtaTransactionImpl transaction) {
        if (transaction == this.currentTransaction.get()) {
            this.currentTransaction.set(null);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append("[nodeId=");
        sb.append(this.nodeId);
        sb.append("]");
        return sb.toString();
    }
}

