/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.commons.functional.cluster;

import java.io.Serializable;
import org.hibernate.SessionFactory;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.hibernate.cache.commons.util.FutureUpdate;
import org.infinispan.hibernate.cache.commons.util.InfinispanMessageLogger;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.BaseCustomAsyncInterceptor;
import org.infinispan.test.hibernate.cache.commons.functional.cluster.AbstractPartialUpdateTest;
import org.infinispan.test.hibernate.cache.commons.functional.entities.Customer;
import org.junit.Assert;

public class PartialFutureUpdateTest
extends AbstractPartialUpdateTest {
    @Override
    protected boolean doUpdate() throws Exception {
        this.withTxSession((SessionFactory)this.localFactory, s -> {
            Customer customer = (Customer)s.load(Customer.class, (Serializable)Integer.valueOf(1));
            Assert.assertEquals((Object)"JBoss", (Object)customer.getName());
            customer.setName(customer.getName() + ", a division of Red Hat");
            s.update((Object)customer);
        });
        return true;
    }

    @Override
    AsyncInterceptor getFailureInducingInterceptor() {
        return new FailureInducingInterceptor();
    }

    public static class FailureInducingInterceptor
    extends BaseCustomAsyncInterceptor {
        static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(FailureInducingInterceptor.class);
        int remoteInvocationCount;

        public Object visitReadWriteKeyCommand(InvocationContext ctx, ReadWriteKeyCommand command) throws Throwable {
            log.tracef("Invoked insert/update: %s", (Object)command);
            if (!ctx.isOriginLocal()) {
                ++this.remoteInvocationCount;
                log.tracef("Remote invocation count: %d ", this.remoteInvocationCount);
                if (command.getKey().toString().endsWith("#1") && this.remoteInvocationCount == 4 && command.getFunction() instanceof FutureUpdate) {
                    throw new AbstractPartialUpdateTest.InducedException("Simulate failure when FutureUpdate received");
                }
            }
            return super.visitReadWriteKeyCommand(ctx, command);
        }
    }
}

