/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.commons.functional.cluster;

import java.io.Serializable;
import java.util.concurrent.CompletionException;
import org.hibernate.SessionFactory;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.hibernate.cache.commons.util.InfinispanMessageLogger;
import org.infinispan.hibernate.cache.commons.util.Tombstone;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.BaseCustomAsyncInterceptor;
import org.infinispan.test.hibernate.cache.commons.functional.cluster.AbstractPartialUpdateTest;
import org.infinispan.test.hibernate.cache.commons.functional.cluster.PartialFutureUpdateTest;
import org.infinispan.test.hibernate.cache.commons.functional.entities.Customer;
import org.junit.Assert;

public class PartialTombstoneTest
extends AbstractPartialUpdateTest {
    @Override
    protected boolean doUpdate() throws Exception {
        try {
            this.withTxSession((SessionFactory)this.localFactory, s -> {
                Customer customer = (Customer)s.load(Customer.class, (Serializable)Integer.valueOf(1));
                Assert.assertEquals((Object)"JBoss", (Object)customer.getName());
                customer.setName(customer.getName() + ", a division of Red Hat");
                s.update((Object)customer);
            });
            Assert.fail((String)"Expected update to fail");
            return true;
        }
        catch (CompletionException e) {
            PartialTombstoneTest.assertExceptionCause(AbstractPartialUpdateTest.InducedException.class, e);
            return false;
        }
    }

    private static void assertExceptionCause(Class<AbstractPartialUpdateTest.InducedException> clazz, CompletionException e) {
        Throwable cause = e.getCause();
        while (!clazz.isInstance(cause)) {
            cause = cause.getCause();
        }
        Assert.assertTrue((String)("Expected " + clazz + " to be in the stacktrace"), (boolean)clazz.isInstance(cause));
    }

    @Override
    AsyncInterceptor getFailureInducingInterceptor() {
        return new FailureInducingInterceptor();
    }

    public static class FailureInducingInterceptor
    extends BaseCustomAsyncInterceptor {
        static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(PartialFutureUpdateTest.FailureInducingInterceptor.class);
        int remoteInvocationCount;

        public Object visitReadWriteKeyCommand(InvocationContext ctx, ReadWriteKeyCommand command) throws Throwable {
            log.tracef("Invoked insert/update: %s", (Object)command);
            if (!ctx.isOriginLocal()) {
                ++this.remoteInvocationCount;
                log.tracef("Remote invocation count: %d ", this.remoteInvocationCount);
                if (command.getKey().toString().endsWith("1") && this.remoteInvocationCount == 3 && command.getFunction() instanceof Tombstone) {
                    throw new AbstractPartialUpdateTest.InducedException("Simulate failure when Tombstone received");
                }
            }
            return super.visitReadWriteKeyCommand(ctx, command);
        }
    }
}

