/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.commons.query;

import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import org.hibernate.Cache;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.engine.spi.CacheImplementor;
import org.hibernate.testing.AfterClassOnce;
import org.hibernate.testing.BeforeClassOnce;
import org.hibernate.testing.TestForIssue;
import org.hibernate.testing.junit4.CustomRunner;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.hibernate.cache.commons.InfinispanBaseRegion;
import org.infinispan.test.fwk.TestResourceTracker;
import org.infinispan.test.hibernate.cache.commons.functional.entities.Person;
import org.infinispan.test.hibernate.cache.commons.util.TestRegionFactory;
import org.infinispan.test.hibernate.cache.commons.util.TestRegionFactoryProvider;
import org.infinispan.util.ControlledTimeService;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=CustomRunner.class)
public class QueryStalenessTest {
    ControlledTimeService timeService = new ControlledTimeService();
    SessionFactory sf1;
    SessionFactory sf2;

    @BeforeClassOnce
    public void init() {
        TestResourceTracker.testStarted((String)this.getClass().getSimpleName());
        this.sf1 = this.createSessionFactory();
        this.sf2 = this.createSessionFactory();
    }

    @AfterClassOnce
    public void destroy() {
        this.sf1.close();
        this.sf2.close();
        TestResourceTracker.testFinished((String)this.getClass().getSimpleName());
    }

    public SessionFactory createSessionFactory() {
        Configuration configuration = new Configuration().setProperty("hibernate.cache.use_second_level_cache", "true").setProperty("hibernate.cache.use_query_cache", "true").setProperty("hibernate.cache.region.factory_class", TestRegionFactoryProvider.load().getRegionFactoryClass().getName()).setProperty("hibernate.cache.default_cache_concurrency_strategy", "transactional").setProperty("hibernate.allow_update_outside_transaction", "true").setProperty("javax.persistence.sharedCache.mode", "ALL").setProperty("hibernate.hbm2ddl.auto", "create-drop");
        Properties testProperties = new Properties();
        testProperties.put(TestRegionFactory.TIME_SERVICE, this.timeService);
        configuration.addProperties(testProperties);
        configuration.addAnnotatedClass(Person.class);
        return configuration.buildSessionFactory();
    }

    @Test
    @TestForIssue(jiraKey="HHH-10677")
    public void testLocalQueryInvalidatedImmediatelly() {
        Session s1 = this.sf1.openSession();
        Person person = new Person("John", "Smith", 29);
        s1.persist((Object)person);
        s1.flush();
        s1.close();
        InfinispanBaseRegion timestampsRegion = TestRegionFactoryProvider.load().findTimestampsRegion((Cache)((CacheImplementor)this.sf1.getCache()));
        DistributionInfo distribution = timestampsRegion.getCache().getDistributionManager().getCacheTopology().getDistribution((Object)Person.class.getSimpleName());
        SessionFactory qsf = distribution.isPrimary() ? this.sf2 : this.sf1;
        this.timeService.advance(60001L);
        Session s2 = qsf.openSession();
        List list1 = s2.createCriteria(Person.class).setCacheable(true).add((Criterion)Restrictions.le((String)"age", (Object)29)).list();
        Assert.assertEquals((long)1L, (long)list1.size());
        s2.close();
        Session s3 = qsf.openSession();
        Person p2 = (Person)s3.load(Person.class, (Serializable)person.getName());
        p2.setAge(30);
        s3.persist((Object)p2);
        s3.flush();
        List list2 = s3.createCriteria(Person.class).setCacheable(true).add((Criterion)Restrictions.le((String)"age", (Object)29)).list();
        Assert.assertEquals((long)0L, (long)list2.size());
        s3.close();
    }
}

