/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.commons.stress.entities;

import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Version;
import org.infinispan.test.hibernate.cache.commons.stress.entities.Address;
import org.infinispan.test.hibernate.cache.commons.stress.entities.Family;

@Entity
public class Person {
    @Id
    @GeneratedValue
    private int id;
    private String firstName;
    @ManyToOne
    private Family family;
    private Date birthDate;
    @ManyToOne
    private Address address;
    private boolean checked;
    @Version
    private int version;

    public Person(String firstName, Family family) {
        this.firstName = firstName;
        this.family = family;
        this.birthDate = null;
        this.address = null;
        this.checked = false;
        this.id = 0;
        this.version = 0;
        this.family.addMember(this);
    }

    protected Person() {
        this.firstName = null;
        this.family = null;
        this.birthDate = null;
        this.address = null;
        this.checked = false;
        this.id = 0;
        this.version = 0;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public Family getFamily() {
        return this.family;
    }

    public Date getBirthDate() {
        return this.birthDate;
    }

    public void setBirthDate(Date birthDate) {
        this.birthDate = birthDate;
    }

    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        if (this.address != address) {
            if (this.address != null) {
                this.address.remInhabitant(this);
            }
            this.address = address;
            if (this.address != null) {
                this.address.addInhabitant(this);
            }
        }
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getVersion() {
        return this.version;
    }

    protected void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    protected void setFamily(Family family) {
        this.family = family;
    }

    protected void setVersion(Integer version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Person person = (Person)o;
        if (this.checked != person.checked) {
            return false;
        }
        if (this.id != person.id) {
            return false;
        }
        if (this.version != person.version) {
            return false;
        }
        if (this.address != null ? !this.address.equals(person.address) : person.address != null) {
            return false;
        }
        if (this.birthDate != null ? !this.birthDate.equals(person.birthDate) : person.birthDate != null) {
            return false;
        }
        if (this.family != null ? !this.family.equals(person.family) : person.family != null) {
            return false;
        }
        return !(this.firstName != null ? !this.firstName.equals(person.firstName) : person.firstName != null);
    }

    public int hashCode() {
        int result = this.firstName != null ? this.firstName.hashCode() : 0;
        result = 31 * result + (this.family != null ? this.family.hashCode() : 0);
        result = 31 * result + (this.birthDate != null ? this.birthDate.hashCode() : 0);
        result = 31 * result + (this.address != null ? this.address.hashCode() : 0);
        result = 31 * result + (this.checked ? 1 : 0);
        result = 31 * result + this.id;
        result = 31 * result + this.version;
        return result;
    }

    public String toString() {
        return "Person{address=" + this.address + ", firstName='" + this.firstName + '\'' + ", family=" + this.family + ", birthDate=" + this.birthDate + ", checked=" + this.checked + ", id=" + this.id + ", version=" + this.version + '}';
    }
}

