/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.commons.timestamp;

import java.util.Properties;
import java.util.concurrent.CompletionStage;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.service.ServiceRegistry;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.test.categories.Smoke;
import org.infinispan.context.Flag;
import org.infinispan.hibernate.cache.commons.InfinispanBaseRegion;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryActivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryInvalidated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryLoaded;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryPassivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryVisited;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.test.hibernate.cache.commons.AbstractGeneralDataRegionTest;
import org.infinispan.test.hibernate.cache.commons.functional.classloader.SelectedClassnameClassLoader;
import org.infinispan.test.hibernate.cache.commons.functional.entities.Account;
import org.infinispan.test.hibernate.cache.commons.functional.entities.AccountHolder;
import org.infinispan.test.hibernate.cache.commons.util.CacheTestUtil;
import org.infinispan.test.hibernate.cache.commons.util.ClassLoaderAwareCache;
import org.infinispan.test.hibernate.cache.commons.util.TestRegionFactory;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={Smoke.class})
public class TimestampsRegionImplTest
extends AbstractGeneralDataRegionTest {
    @Override
    protected InfinispanBaseRegion createRegion(TestRegionFactory regionFactory, String regionName) {
        return regionFactory.buildTimestampsRegion(regionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClearTimestampsRegionInIsolated() throws Exception {
        StandardServiceRegistryBuilder ssrb = this.createStandardServiceRegistryBuilder();
        StandardServiceRegistry registry = ssrb.build();
        StandardServiceRegistry registry2 = ssrb.build();
        try {
            Properties properties = CacheTestUtil.toProperties(ssrb.getSettings());
            TestRegionFactory regionFactory = CacheTestUtil.startRegionFactory((ServiceRegistry)registry, this.getCacheTestSupport());
            TestRegionFactory regionFactory2 = CacheTestUtil.startRegionFactory((ServiceRegistry)registry2, this.getCacheTestSupport());
            InfinispanBaseRegion region = regionFactory.buildTimestampsRegion("test/timestamps");
            InfinispanBaseRegion region2 = regionFactory2.buildTimestampsRegion("test/timestamps");
            Account acct = new Account();
            acct.setAccountHolder(new AccountHolder());
            region.getCache().withFlags(Flag.FORCE_SYNCHRONOUS).put((Object)acct, (Object)"boo");
        }
        finally {
            StandardServiceRegistryBuilder.destroy((ServiceRegistry)registry);
            StandardServiceRegistryBuilder.destroy((ServiceRegistry)registry2);
        }
    }

    @Override
    protected StandardServiceRegistryBuilder createStandardServiceRegistryBuilder() {
        StandardServiceRegistryBuilder ssrb = super.createStandardServiceRegistryBuilder();
        ssrb.applySetting(TestRegionFactory.WRAP_CACHE, cache -> new ClassLoaderAwareCache((AdvancedCache)cache, Thread.currentThread().getContextClassLoader()){

            public void addListener(Object listener) {
                super.addListener((Object)new MockClassLoaderAwareListener(listener, this));
            }

            @Override
            public CompletionStage<Void> addListenerAsync(Object listener) {
                return super.addListenerAsync(new MockClassLoaderAwareListener(listener, this));
            }
        });
        return ssrb;
    }

    @Listener
    public static class MockClassLoaderAwareListener
    extends ClassLoaderAwareCache.ClassLoaderAwareListener {
        MockClassLoaderAwareListener(Object listener, ClassLoaderAwareCache cache) {
            super(listener, cache);
        }

        @Override
        @CacheEntryActivated
        @CacheEntryCreated
        @CacheEntryInvalidated
        @CacheEntryLoaded
        @CacheEntryModified
        @CacheEntryPassivated
        @CacheEntryRemoved
        @CacheEntryVisited
        public void event(Event event) throws Throwable {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            String notFoundPackage = "org.infinispan.test.hibernate.cache.functional.entities";
            String[] notFoundClasses = new String[]{notFoundPackage + ".Account", notFoundPackage + ".AccountHolder"};
            SelectedClassnameClassLoader visible = new SelectedClassnameClassLoader(null, null, notFoundClasses, cl);
            Thread.currentThread().setContextClassLoader(visible);
            super.event(event);
            Thread.currentThread().setContextClassLoader(cl);
        }
    }
}

