/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.commons.tm;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.test.hibernate.cache.commons.tm.XaTransactionImpl;

public class XaTransactionManagerImpl
implements TransactionManager {
    private static final XaTransactionManagerImpl INSTANCE = new XaTransactionManagerImpl();
    private final ThreadLocal<XaTransactionImpl> currentTransaction = new ThreadLocal();

    public static XaTransactionManagerImpl getInstance() {
        return INSTANCE;
    }

    public int getStatus() throws SystemException {
        XaTransactionImpl currentTransaction = this.currentTransaction.get();
        return currentTransaction == null ? 6 : currentTransaction.getStatus();
    }

    public Transaction getTransaction() throws SystemException {
        return this.currentTransaction.get();
    }

    public XaTransactionImpl getCurrentTransaction() {
        return this.currentTransaction.get();
    }

    public void begin() throws NotSupportedException, SystemException {
        if (this.currentTransaction.get() != null) {
            throw new IllegalStateException("Transaction already started.");
        }
        this.currentTransaction.set(new XaTransactionImpl(this));
    }

    public Transaction suspend() throws SystemException {
        Transaction suspended = this.currentTransaction.get();
        this.currentTransaction.remove();
        return suspended;
    }

    public void resume(Transaction transaction) throws InvalidTransactionException, IllegalStateException, SystemException {
        this.currentTransaction.set((XaTransactionImpl)transaction);
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        XaTransactionImpl currentTransaction = this.currentTransaction.get();
        if (currentTransaction == null) {
            throw new IllegalStateException("no current transaction to commit");
        }
        currentTransaction.commit();
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        XaTransactionImpl currentTransaction = this.currentTransaction.get();
        if (currentTransaction == null) {
            throw new IllegalStateException("no current transaction");
        }
        currentTransaction.rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        XaTransactionImpl currentTransaction = this.currentTransaction.get();
        if (currentTransaction == null) {
            throw new IllegalStateException("no current transaction");
        }
        currentTransaction.setRollbackOnly();
    }

    public void setTransactionTimeout(int i) throws SystemException {
    }

    void endCurrent(Transaction transaction) {
        this.currentTransaction.remove();
    }
}

