/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.commons.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.test.hibernate.cache.commons.util.TestRegionFactory;

public class CacheTestSupport {
    private static final String PREFER_IPV4STACK = "java.net.preferIPv4Stack";
    private Set<Cache> caches = new HashSet<Cache>();
    private Set<TestRegionFactory> factories = new HashSet<TestRegionFactory>();
    private Exception exception;
    private String preferIPv4Stack;

    public void registerCache(Cache cache) {
        this.caches.add(cache);
    }

    public void registerFactory(TestRegionFactory factory) {
        this.factories.add(factory);
    }

    public void unregisterCache(Cache cache) {
        this.caches.remove(cache);
    }

    public void unregisterFactory(TestRegionFactory factory) {
        this.factories.remove(factory);
    }

    public void setUp() throws Exception {
        this.preferIPv4Stack = System.getProperty(PREFER_IPV4STACK);
        System.setProperty(PREFER_IPV4STACK, "true");
        this.cleanUp();
        this.throwStoredException();
    }

    public void tearDown() throws Exception {
        if (this.preferIPv4Stack == null) {
            System.clearProperty(PREFER_IPV4STACK);
        } else {
            System.setProperty(PREFER_IPV4STACK, this.preferIPv4Stack);
        }
        this.cleanUp();
        this.throwStoredException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUp() {
        Iterator<TestRegionFactory> it = this.factories.iterator();
        while (it.hasNext()) {
            try {
                it.next().stop();
            }
            catch (Exception e) {
                this.storeException(e);
            }
            finally {
                it.remove();
            }
        }
        this.factories.clear();
        it = this.caches.iterator();
        while (it.hasNext()) {
            try {
                ((Cache)it.next()).stop();
            }
            catch (Exception e) {
                this.storeException(e);
            }
            finally {
                it.remove();
            }
        }
        this.caches.clear();
    }

    private void storeException(Exception e) {
        if (this.exception == null) {
            this.exception = e;
        }
    }

    private void throwStoredException() throws Exception {
        if (this.exception != null) {
            Exception toThrow = this.exception;
            this.exception = null;
            throw toThrow;
        }
    }
}

