/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.commons.util;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.transaction.jta.platform.internal.NoJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.resource.transaction.backend.jdbc.internal.JdbcResourceLocalTransactionCoordinatorBuilderImpl;
import org.hibernate.resource.transaction.backend.jta.internal.JtaTransactionCoordinatorBuilderImpl;
import org.hibernate.service.ServiceRegistry;
import org.infinispan.test.hibernate.cache.commons.util.CacheTestSupport;
import org.infinispan.test.hibernate.cache.commons.util.TestRegionFactory;
import org.infinispan.test.hibernate.cache.commons.util.TestRegionFactoryProvider;

public class CacheTestUtil {
    public static Map buildBaselineSettings(String regionPrefix, boolean use2ndLevel, boolean useQueries, Class<? extends JtaPlatform> jtaPlatform) {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("hibernate.generate_statistics", "true");
        settings.put("hibernate.cache.use_structured_entries", "true");
        if (jtaPlatform == null || jtaPlatform == NoJtaPlatform.class) {
            settings.put("hibernate.transaction.coordinator_class", JdbcResourceLocalTransactionCoordinatorBuilderImpl.class.getName());
            settings.put("hibernate.transaction.jta.platform", NoJtaPlatform.class);
        } else {
            settings.put("hibernate.transaction.coordinator_class", JtaTransactionCoordinatorBuilderImpl.class.getName());
            settings.put("hibernate.transaction.jta.platform", jtaPlatform);
        }
        settings.put("hibernate.cache.region.factory_class", TestRegionFactoryProvider.load().getRegionFactoryClass());
        settings.put("hibernate.cache.region_prefix", regionPrefix);
        settings.put("hibernate.cache.use_second_level_cache", String.valueOf(use2ndLevel));
        settings.put("hibernate.cache.use_query_cache", String.valueOf(useQueries));
        return settings;
    }

    public static StandardServiceRegistryBuilder buildBaselineStandardServiceRegistryBuilder(String regionPrefix, boolean use2ndLevel, boolean useQueries, Class<? extends JtaPlatform> jtaPlatform) {
        StandardServiceRegistryBuilder ssrb = new StandardServiceRegistryBuilder();
        ssrb.applySettings(CacheTestUtil.buildBaselineSettings(regionPrefix, use2ndLevel, useQueries, jtaPlatform));
        return ssrb;
    }

    public static StandardServiceRegistryBuilder buildCustomQueryCacheStandardServiceRegistryBuilder(String regionPrefix, String queryCacheName, Class<? extends JtaPlatform> jtaPlatform) {
        StandardServiceRegistryBuilder ssrb = CacheTestUtil.buildBaselineStandardServiceRegistryBuilder(regionPrefix, true, true, jtaPlatform);
        ssrb.applySetting("hibernate.cache.infinispan.query.cfg", (Object)queryCacheName);
        return ssrb;
    }

    public static <RF extends RegionFactory> RF createRegionFactory(Class<RF> clazz, Properties properties) {
        try {
            try {
                Constructor<RF> constructor = clazz.getConstructor(Properties.class);
                return (RF)((RegionFactory)constructor.newInstance(properties));
            }
            catch (NoSuchMethodException e) {
                return (RF)((RegionFactory)clazz.newInstance());
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static TestRegionFactory startRegionFactory(ServiceRegistry serviceRegistry) {
        try {
            ConfigurationService cfgService = (ConfigurationService)serviceRegistry.getService(ConfigurationService.class);
            Properties properties = CacheTestUtil.toProperties(cfgService.getSettings());
            TestRegionFactory regionFactory = TestRegionFactoryProvider.load().create(properties);
            regionFactory.start(serviceRegistry, properties);
            return regionFactory;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static TestRegionFactory startRegionFactory(ServiceRegistry serviceRegistry, CacheTestSupport testSupport) {
        TestRegionFactory factory = CacheTestUtil.startRegionFactory(serviceRegistry);
        testSupport.registerFactory(factory);
        return factory;
    }

    public static void stopRegionFactory(TestRegionFactory factory, CacheTestSupport testSupport) {
        testSupport.unregisterFactory(factory);
        factory.stop();
    }

    public static Properties toProperties(Map map) {
        if (map == null) {
            return null;
        }
        if (map instanceof Properties) {
            return (Properties)map;
        }
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)map);
        return properties;
    }

    private CacheTestUtil() {
    }
}

