/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.commons.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import org.infinispan.AdvancedCache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.BaseCustomAsyncInterceptor;
import org.infinispan.interceptors.InvocationFinallyAction;
import org.infinispan.interceptors.impl.InvocationContextInterceptor;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.junit.Assert;

public class ExpectingInterceptor
extends BaseCustomAsyncInterceptor {
    private static final Log log = LogFactory.getLog(ExpectingInterceptor.class);
    private final List<Condition> conditions = new LinkedList<Condition>();
    private InvocationFinallyAction assertCondition = this::assertCondition;

    public static ExpectingInterceptor get(AdvancedCache cache) {
        ExpectingInterceptor self = (ExpectingInterceptor)cache.getAsyncInterceptorChain().findInterceptorWithClass(ExpectingInterceptor.class);
        if (self != null) {
            return self;
        }
        ExpectingInterceptor ei = new ExpectingInterceptor();
        Assert.assertTrue((boolean)cache.getAsyncInterceptorChain().addInterceptorAfter((AsyncInterceptor)ei, InvocationContextInterceptor.class));
        return ei;
    }

    public static void cleanup(AdvancedCache ... caches) {
        for (AdvancedCache c : caches) {
            c.getAsyncInterceptorChain().removeInterceptor(ExpectingInterceptor.class);
        }
    }

    public synchronized Condition when(BiPredicate<InvocationContext, VisitableCommand> predicate) {
        Condition condition = new Condition(predicate, ExpectingInterceptor.source(), null);
        this.conditions.add(condition);
        return condition;
    }

    public synchronized Condition whenFails(BiPredicate<InvocationContext, VisitableCommand> predicate) {
        Condition condition = new Condition(predicate, ExpectingInterceptor.source(), Boolean.FALSE);
        this.conditions.add(condition);
        return condition;
    }

    private static String source() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        StackTraceElement ste = stackTrace[3];
        return ste.getFileName() + ":" + ste.getLineNumber();
    }

    protected Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
        return this.invokeNextAndFinally(ctx, command, this.assertCondition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertCondition(InvocationContext rCtx, VisitableCommand rCommand, Object rv, Throwable throwable) throws Throwable {
        boolean succeeded = throwable == null && rCommand.isSuccessful();
        log.tracef("After command(successful=%s) %s", (Object)succeeded, (Object)rCommand);
        ArrayList<Runnable> toExecute = new ArrayList<Runnable>();
        ExpectingInterceptor expectingInterceptor = this;
        synchronized (expectingInterceptor) {
            Iterator<Condition> iterator = this.conditions.iterator();
            while (iterator.hasNext()) {
                Condition condition = iterator.next();
                log.tracef("Testing condition %s", (Object)condition);
                if ((condition.success == null || condition.success == succeeded) && condition.predicate.test(rCtx, rCommand)) {
                    assert (condition.action != null);
                    log.trace((Object)"Condition succeeded");
                    toExecute.add(condition.action);
                    if (condition.removeCheck != null && !condition.removeCheck.getAsBoolean()) continue;
                    iterator.remove();
                    continue;
                }
                log.trace((Object)"Condition test failed");
            }
        }
        for (Runnable runnable : toExecute) {
            log.tracef("Executing %s", (Object)runnable);
            runnable.run();
        }
    }

    public class Condition {
        private final BiPredicate<InvocationContext, VisitableCommand> predicate;
        private final String source;
        private final Boolean success;
        private BooleanSupplier removeCheck;
        private Runnable action;

        public Condition(BiPredicate<InvocationContext, VisitableCommand> predicate, String source, Boolean success) {
            this.predicate = predicate;
            this.source = source;
            this.success = success;
        }

        public Condition run(Runnable action) {
            assert (this.action == null);
            this.action = action;
            return this;
        }

        public Condition countDown(CountDownLatch latch) {
            return this.run(() -> {
                log.debugf("Count down latch %s", (Object)latch);
                latch.countDown();
            }).removeWhen(() -> latch.getCount() == 0L);
        }

        public Condition removeWhen(BooleanSupplier check) {
            assert (this.removeCheck == null);
            this.removeCheck = check;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            ExpectingInterceptor expectingInterceptor = ExpectingInterceptor.this;
            synchronized (expectingInterceptor) {
                ExpectingInterceptor.this.conditions.remove(this);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Condition{");
            sb.append("source=").append(this.source);
            sb.append(", predicate=").append(this.predicate);
            sb.append(", success=").append(this.success);
            sb.append(", action=").append(this.action);
            sb.append('}');
            return sb.toString();
        }
    }
}

