/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.commons.util;

import java.util.Map;
import java.util.Properties;
import org.infinispan.commons.executors.CachedThreadPoolExecutorFactory;
import org.infinispan.commons.executors.ThreadPoolExecutorFactory;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.TransportConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.test.fwk.TestResourceTracker;
import org.infinispan.test.hibernate.cache.commons.util.TestRegionFactory;
import org.infinispan.transaction.TransactionMode;

public class TestConfigurationHook {
    private final boolean transactional;
    private final CacheMode cacheMode;
    private final boolean pendingPutsSimple;
    private final boolean stats;

    public TestConfigurationHook(Properties properties) {
        this.transactional = (Boolean)properties.getOrDefault((Object)TestRegionFactory.TRANSACTIONAL, (Object)false);
        this.cacheMode = (CacheMode)properties.getOrDefault((Object)TestRegionFactory.CACHE_MODE, (Object)null);
        this.pendingPutsSimple = (Boolean)properties.getOrDefault((Object)TestRegionFactory.PENDING_PUTS_SIMPLE, (Object)true);
        this.stats = (Boolean)properties.getOrDefault((Object)TestRegionFactory.STATS, (Object)false);
    }

    public void amendConfiguration(ConfigurationBuilderHolder holder) {
        TransportConfigurationBuilder transport = holder.getGlobalConfigurationBuilder().transport();
        transport.nodeName(TestResourceTracker.getNextNodeName());
        transport.clusterName(TestResourceTracker.getCurrentTestName());
        transport.remoteCommandThreadPool().threadPoolFactory((ThreadPoolExecutorFactory)CachedThreadPoolExecutorFactory.create());
        transport.transportThreadPool().threadPoolFactory((ThreadPoolExecutorFactory)CachedThreadPoolExecutorFactory.create());
        for (Map.Entry cfg : holder.getNamedConfigurationBuilders().entrySet()) {
            this.amendCacheConfiguration((String)cfg.getKey(), (ConfigurationBuilder)cfg.getValue());
        }
        if (!this.pendingPutsSimple) {
            ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("pending-puts")).simpleCache(false);
        }
    }

    public void amendCacheConfiguration(String cacheName, ConfigurationBuilder configurationBuilder) {
        if (cacheName.equals("pending-puts")) {
            return;
        }
        if (this.transactional) {
            if (!(cacheName.endsWith("query") || cacheName.equals("timestamps") || cacheName.endsWith("pending-puts"))) {
                configurationBuilder.transaction().transactionMode(TransactionMode.TRANSACTIONAL).useSynchronization(true);
            }
        } else {
            configurationBuilder.transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL);
        }
        if (this.cacheMode != null && configurationBuilder.clustering().cacheMode().isInvalidation()) {
            configurationBuilder.clustering().cacheMode(this.cacheMode);
        }
        if (this.stats) {
            configurationBuilder.jmxStatistics().available(true).enable();
        }
    }
}

