/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.commons.util;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.protocols.FD_ALL;
import org.jgroups.protocols.FD_ALL2;
import org.jgroups.protocols.FD_HOST;
import org.jgroups.protocols.FD_SOCK;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.stack.Protocol;

public class TestDisconnectHandler
extends Protocol {
    private static Set<Protocol> connected = ConcurrentHashMap.newKeySet();
    private static Executor executor = Executors.newCachedThreadPool(new ThreadFactory(){
        AtomicInteger counter = new AtomicInteger();

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setName(TestDisconnectHandler.class.getSimpleName() + "-" + this.counter.incrementAndGet());
            return t;
        }
    });
    private Address localAddress;

    public Object down(Event evt) {
        switch (evt.getType()) {
            case 8: {
                this.localAddress = (Address)evt.getArg();
                this.log.trace("Set address " + this.localAddress);
                break;
            }
            case 2: 
            case 80: 
            case 92: 
            case 93: {
                this.log.trace("Connecting on " + this.localAddress);
                connected.add(this.getFD());
                break;
            }
            case 4: {
                this.log.trace("Disconnecting on " + this.localAddress);
                connected.remove(this.getFD());
                GMS gms = (GMS)this.getProtocolStack().findProtocol(GMS.class);
                gms.setViewAckCollectionTimeout(1L);
                for (Protocol other : connected) {
                    executor.execute(() -> {
                        this.log.trace("Suspecting " + this.localAddress + " on " + other);
                        Event suspectEvent = new Event(9, (Object)this.localAddress);
                        other.up(suspectEvent);
                        other.down(suspectEvent);
                    });
                }
                break;
            }
        }
        return super.down(evt);
    }

    private Protocol getFD() {
        Protocol protocol = this.getProtocolStack().findProtocol(new Class[]{FD_ALL.class, FD_ALL2.class, FD_SOCK.class, FD_HOST.class});
        this.log.trace("Found protocol " + protocol);
        return protocol;
    }
}

