/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.commons.util;

import javax.transaction.Synchronization;
import org.hibernate.cache.spi.access.SoftLock;
import org.infinispan.test.hibernate.cache.commons.util.TestSessionAccess;

public abstract class TestSynchronization
implements Synchronization {
    protected final Object session;
    protected final Object key;
    protected final Object value;
    protected final Object version;

    public TestSynchronization(Object session, Object key, Object value, Object version) {
        this.session = session;
        this.key = key;
        this.value = value;
        this.version = version;
    }

    public void beforeCompletion() {
    }

    public static class UnlockItem
    extends TestSynchronization {
        private final TestSessionAccess.TestRegionAccessStrategy strategy;
        private final SoftLock lock;

        public UnlockItem(TestSessionAccess.TestRegionAccessStrategy strategy, Object session, Object key, SoftLock lock) {
            super(session, key, null, null);
            this.strategy = strategy;
            this.lock = lock;
        }

        public void afterCompletion(int status) {
            this.strategy.unlockItem(this.session, this.key, this.lock);
        }
    }

    public static class AfterUpdate
    extends TestSynchronization {
        private final TestSessionAccess.TestRegionAccessStrategy strategy;
        private final SoftLock lock;

        public AfterUpdate(TestSessionAccess.TestRegionAccessStrategy strategy, Object session, Object key, Object value, Object version, SoftLock lock) {
            super(session, key, value, version);
            this.strategy = strategy;
            this.lock = lock;
        }

        public void afterCompletion(int status) {
            this.strategy.afterUpdate(this.session, this.key, this.value, this.version, null, this.lock);
        }
    }

    public static class AfterInsert
    extends TestSynchronization {
        private final TestSessionAccess.TestRegionAccessStrategy strategy;

        public AfterInsert(TestSessionAccess.TestRegionAccessStrategy strategy, Object session, Object key, Object value, Object version) {
            super(session, key, value, version);
            this.strategy = strategy;
        }

        public void afterCompletion(int status) {
            this.strategy.afterInsert(this.session, this.key, this.value, this.version);
        }
    }
}

