/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.v53.util;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.transaction.Synchronization;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.cfg.spi.DomainDataCachingConfig;
import org.hibernate.cache.spi.CacheImplementor;
import org.hibernate.cache.spi.DirectAccessRegion;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.CachedDomainDataAccess;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.transaction.internal.TransactionImpl;
import org.hibernate.engine.transaction.jta.platform.internal.NoJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.internal.AbstractSharedSessionContract;
import org.hibernate.internal.SessionCreationOptions;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.jpa.spi.JpaCompliance;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.query.Query;
import org.hibernate.resource.jdbc.spi.JdbcSessionContext;
import org.hibernate.resource.jdbc.spi.JdbcSessionOwner;
import org.hibernate.resource.transaction.backend.jdbc.internal.JdbcResourceLocalTransactionCoordinatorBuilderImpl;
import org.hibernate.resource.transaction.backend.jdbc.spi.JdbcResourceTransactionAccess;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorOwner;
import org.hibernate.service.ServiceRegistry;
import org.infinispan.hibernate.cache.commons.InfinispanBaseRegion;
import org.infinispan.hibernate.cache.v53.impl.DomainDataRegionImpl;
import org.infinispan.hibernate.cache.v53.impl.Sync;
import org.infinispan.test.hibernate.cache.commons.util.BatchModeJtaPlatform;
import org.infinispan.test.hibernate.cache.commons.util.JdbcResourceTransactionMock;
import org.infinispan.test.hibernate.cache.commons.util.TestSessionAccess;
import org.infinispan.test.hibernate.cache.v53.util.BatchModeTransactionCoordinator;
import org.infinispan.util.ControlledTimeService;
import org.mockito.Mockito;

public class TestSessionAccessImpl
implements TestSessionAccess {
    public Object mockSessionImplementor() {
        return Mockito.mock(SharedSessionContractImplementor.class);
    }

    public Object mockSession(Class<? extends JtaPlatform> jtaPlatform, ControlledTimeService timeService, RegionFactory regionFactory) {
        BatchModeTransactionCoordinator txCoord;
        SessionMock session = (SessionMock)((Object)Mockito.mock(SessionMock.class));
        Mockito.when((Object)session.isClosed()).thenReturn((Object)false);
        Mockito.when((Object)session.isOpen()).thenReturn((Object)true);
        Mockito.when((Object)session.getTransactionStartTimestamp()).thenReturn((Object)timeService.wallClockTime());
        if (jtaPlatform == BatchModeJtaPlatform.class) {
            BatchModeTransactionCoordinator batchModeTxCoord;
            txCoord = batchModeTxCoord = new BatchModeTransactionCoordinator();
            Mockito.when((Object)session.getTransactionCoordinator()).thenReturn((Object)txCoord);
            Mockito.when((Object)session.beginTransaction()).then(invocation -> {
                Transaction tx = batchModeTxCoord.newTransaction();
                tx.begin();
                return tx;
            });
        } else if (jtaPlatform == null || jtaPlatform == NoJtaPlatform.class) {
            Connection connection = (Connection)Mockito.mock(Connection.class);
            JdbcConnectionAccess jdbcConnectionAccess = (JdbcConnectionAccess)Mockito.mock(JdbcConnectionAccess.class);
            try {
                Mockito.when((Object)jdbcConnectionAccess.obtainConnection()).thenReturn((Object)connection);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            JdbcSessionOwner jdbcSessionOwner = (JdbcSessionOwner)Mockito.mock(JdbcSessionOwner.class);
            Mockito.when((Object)jdbcSessionOwner.getJdbcConnectionAccess()).thenReturn((Object)jdbcConnectionAccess);
            SqlExceptionHelper sqlExceptionHelper = (SqlExceptionHelper)Mockito.mock(SqlExceptionHelper.class);
            JdbcServices jdbcServices = (JdbcServices)Mockito.mock(JdbcServices.class);
            Mockito.when((Object)jdbcServices.getSqlExceptionHelper()).thenReturn((Object)sqlExceptionHelper);
            ServiceRegistry serviceRegistry = (ServiceRegistry)Mockito.mock(ServiceRegistry.class);
            Mockito.when((Object)((JdbcServices)serviceRegistry.getService(JdbcServices.class))).thenReturn((Object)jdbcServices);
            JdbcSessionContext jdbcSessionContext = (JdbcSessionContext)Mockito.mock(JdbcSessionContext.class);
            Mockito.when((Object)jdbcSessionContext.getServiceRegistry()).thenReturn((Object)serviceRegistry);
            JpaCompliance jpaCompliance = (JpaCompliance)Mockito.mock(JpaCompliance.class);
            Mockito.when((Object)jpaCompliance.isJpaTransactionComplianceEnabled()).thenReturn((Object)true);
            SessionFactoryImplementor sessionFactory = (SessionFactoryImplementor)Mockito.mock(SessionFactoryImplementor.class);
            SessionFactoryOptions sessionFactoryOptions = (SessionFactoryOptions)Mockito.mock(SessionFactoryOptions.class);
            Mockito.when((Object)sessionFactoryOptions.getJpaCompliance()).thenReturn((Object)jpaCompliance);
            Mockito.when((Object)sessionFactory.getSessionFactoryOptions()).thenReturn((Object)sessionFactoryOptions);
            Mockito.when((Object)jdbcSessionContext.getSessionFactory()).thenReturn((Object)sessionFactory);
            Mockito.when((Object)jdbcSessionOwner.getJdbcSessionContext()).thenReturn((Object)jdbcSessionContext);
            Mockito.when((Object)session.getSessionFactory()).thenReturn((Object)sessionFactory);
            Mockito.when((Object)session.getFactory()).thenReturn((Object)sessionFactory);
            NonJtaTransactionCoordinator txOwner = (NonJtaTransactionCoordinator)Mockito.mock(NonJtaTransactionCoordinator.class);
            Mockito.when((Object)txOwner.getResourceLocalTransaction()).thenReturn((Object)new JdbcResourceTransactionMock());
            Mockito.when((Object)txOwner.getJdbcSessionOwner()).thenReturn((Object)jdbcSessionOwner);
            Mockito.when((Object)txOwner.isActive()).thenReturn((Object)true);
            txCoord = JdbcResourceLocalTransactionCoordinatorBuilderImpl.INSTANCE.buildTransactionCoordinator((TransactionCoordinatorOwner)txOwner, null);
            Mockito.when((Object)session.getTransactionCoordinator()).thenReturn((Object)txCoord);
            Mockito.when((Object)session.beginTransaction()).then(invocation -> {
                TransactionImpl tx = new TransactionImpl(txCoord, session.getExceptionConverter(), (AbstractSharedSessionContract)session);
                tx.begin();
                return tx;
            });
        } else {
            throw new IllegalStateException("Unknown JtaPlatform: " + jtaPlatform);
        }
        Sync sync = new Sync(regionFactory);
        TestSynchronization synchronization = new TestSynchronization(sync);
        Mockito.when((Object)session.getCacheTransactionSynchronization()).thenAnswer(invocation -> {
            if (!synchronization.registered) {
                txCoord.getLocalSynchronizations().registerSynchronization((Synchronization)synchronization);
                synchronization.registered = true;
            }
            return sync;
        });
        return session;
    }

    public Transaction beginTransaction(Object session) {
        return ((Session)session).beginTransaction();
    }

    public TestSessionAccess.TestRegionAccessStrategy fromAccess(Object access) {
        return new TestRegionAccessStrategyImpl((CachedDomainDataAccess)access);
    }

    public TestSessionAccess.TestRegion fromRegion(InfinispanBaseRegion region) {
        return new TestRegionImpl((DirectAccessRegion)region);
    }

    public List execQueryList(Object session, String query, String[] ... params) {
        Query q = ((Session)session).createQuery(query);
        this.setParams(q, params);
        return q.list();
    }

    public List execQueryListAutoFlush(Object session, String query, String[] ... params) {
        Query q = ((Session)session).createQuery(query).setFlushMode(FlushMode.AUTO);
        this.setParams(q, params);
        return q.list();
    }

    public List execQueryListCacheable(Object session, String query) {
        return ((Session)session).createQuery(query).setCacheable(true).list();
    }

    public int execQueryUpdateAutoFlush(Object session, String query, String[] ... params) {
        Query q = ((Session)session).createQuery(query).setFlushMode(FlushMode.AUTO);
        this.setParams(q, params);
        return q.executeUpdate();
    }

    public void setParams(Query q, String[][] params) {
        if (params.length > 0) {
            for (String[] param : params) {
                q.setParameter(param[0], (Object)param[1]);
            }
        }
    }

    public void execQueryUpdate(Object session, String query) {
        ((Session)session).createQuery(query).executeUpdate();
    }

    public Object collectionAccess(InfinispanBaseRegion region, AccessType accessType) {
        DomainDataRegionImpl impl = (DomainDataRegionImpl)region;
        NavigableRole role = impl.config().getCollectionCaching().stream().filter(c -> c.getAccessType() == accessType).map(DomainDataCachingConfig::getNavigableRole).findFirst().orElseThrow(() -> new IllegalArgumentException());
        return impl.getCollectionDataAccess(role);
    }

    public Object entityAccess(InfinispanBaseRegion region, AccessType accessType) {
        DomainDataRegionImpl impl = (DomainDataRegionImpl)region;
        NavigableRole role = impl.config().getEntityCaching().stream().filter(c -> c.getAccessType() == accessType).map(DomainDataCachingConfig::getNavigableRole).findFirst().orElseThrow(() -> new IllegalArgumentException());
        return impl.getEntityDataAccess(role);
    }

    public InfinispanBaseRegion getRegion(SessionFactoryImplementor sessionFactory, String regionName) {
        return (InfinispanBaseRegion)sessionFactory.getCache().getRegion(regionName);
    }

    public Collection<InfinispanBaseRegion> getAllRegions(SessionFactoryImplementor sessionFactory) {
        CacheImplementor cache = sessionFactory.getCache();
        return cache.getCacheRegionNames().stream().map(regionName -> (InfinispanBaseRegion)cache.getRegion(regionName)).collect(Collectors.toList());
    }

    private static SharedSessionContractImplementor unwrap(Object session) {
        return (SharedSessionContractImplementor)session;
    }

    private static class TestSynchronization
    implements Synchronization {
        private final Sync sync;
        private boolean registered;

        public TestSynchronization(Sync sync) {
            this.sync = sync;
        }

        public void beforeCompletion() {
            this.sync.transactionCompleting();
        }

        public void afterCompletion(int status) {
            this.sync.transactionCompleted(status == 8 || status == 3);
        }
    }

    private static final class TestRegionImpl
    implements TestSessionAccess.TestRegion {
        private final DirectAccessRegion delegate;

        private TestRegionImpl(DirectAccessRegion delegate) {
            this.delegate = delegate;
        }

        public Object get(Object session, Object key) throws CacheException {
            return this.delegate.getFromCache(key, TestSessionAccessImpl.unwrap(session));
        }

        public void put(Object session, Object key, Object value) throws CacheException {
            this.delegate.putIntoCache(key, value, TestSessionAccessImpl.unwrap(session));
        }

        public void evict(Object key) {
            throw new UnsupportedOperationException();
        }

        public void evictAll() {
            this.delegate.clear();
        }
    }

    private static interface NonJtaTransactionCoordinator
    extends TransactionCoordinatorOwner,
    JdbcResourceTransactionAccess {
    }

    private abstract class SessionMock
    extends AbstractSharedSessionContract
    implements Session {
        public SessionMock(SessionFactoryImpl factory, SessionCreationOptions options) {
            super(factory, options);
        }
    }

    private static final class TestRegionAccessStrategyImpl
    implements TestSessionAccess.TestRegionAccessStrategy {
        private final CachedDomainDataAccess delegate;

        public TestRegionAccessStrategyImpl(CachedDomainDataAccess delegate) {
            this.delegate = delegate;
        }

        public SoftLock lockItem(Object session, Object key, Object version) throws CacheException {
            return this.delegate.lockItem(TestSessionAccessImpl.unwrap(session), key, version);
        }

        public void unlockItem(Object session, Object key, SoftLock lock) throws CacheException {
            this.delegate.unlockItem(TestSessionAccessImpl.unwrap(session), key, lock);
        }

        public boolean afterInsert(Object session, Object key, Object value, Object version) throws CacheException {
            return this.unwrapEntity().afterInsert(TestSessionAccessImpl.unwrap(session), key, value, version);
        }

        public boolean afterUpdate(Object session, Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) throws CacheException {
            return this.unwrapEntity().afterUpdate(TestSessionAccessImpl.unwrap(session), key, value, currentVersion, previousVersion, lock);
        }

        public Object get(Object session, Object key, long txTimestamp) throws CacheException {
            return this.delegate.get(TestSessionAccessImpl.unwrap(session), key);
        }

        public boolean putFromLoad(Object session, Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) throws CacheException {
            return this.delegate.putFromLoad(TestSessionAccessImpl.unwrap(session), key, value, version, minimalPutOverride);
        }

        public boolean putFromLoad(Object session, Object key, Object value, long txTimestamp, Object version) throws CacheException {
            return this.delegate.putFromLoad(TestSessionAccessImpl.unwrap(session), key, value, version);
        }

        public void remove(Object session, Object key) throws CacheException {
            this.delegate.remove(TestSessionAccessImpl.unwrap(session), key);
        }

        public boolean insert(Object session, Object key, Object value, Object version) throws CacheException {
            return this.unwrapEntity().insert(TestSessionAccessImpl.unwrap(session), key, value, version);
        }

        public boolean update(Object session, Object key, Object value, Object currentVersion, Object previousVersion) throws CacheException {
            return this.unwrapEntity().update(TestSessionAccessImpl.unwrap(session), key, value, currentVersion, previousVersion);
        }

        public SoftLock lockRegion() {
            return this.delegate.lockRegion();
        }

        public void unlockRegion(SoftLock softLock) {
            this.delegate.unlockRegion(softLock);
        }

        public void evict(Object key) {
            this.delegate.evict(key);
        }

        public void evictAll() {
            this.delegate.evictAll();
        }

        public void removeAll(Object session) {
            this.delegate.removeAll((SharedSessionContractImplementor)session);
        }

        private EntityDataAccess unwrapEntity() {
            return (EntityDataAccess)this.delegate;
        }
    }
}

