/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.v53.util;

import java.util.Comparator;
import java.util.Map;
import java.util.Properties;
import org.hibernate.boot.internal.BootstrapContextImpl;
import org.hibernate.boot.internal.MetadataBuilderImpl;
import org.hibernate.boot.internal.SessionFactoryOptionsBuilder;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.MetadataBuildingOptions;
import org.hibernate.cache.cfg.internal.DomainDataRegionConfigImpl;
import org.hibernate.cache.cfg.spi.DomainDataRegionConfig;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.VersionType;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.hibernate.cache.commons.InfinispanBaseRegion;
import org.infinispan.hibernate.cache.v53.InfinispanRegionFactory;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.hibernate.cache.commons.util.TestRegionFactory;
import org.infinispan.test.hibernate.cache.v53.util.TestInfinispanRegionFactory;
import org.mockito.Mockito;

class TestRegionFactoryImpl
implements TestRegionFactory {
    private static final Comparator<Object> UNIVERSAL_COMPARATOR = (o1, o2) -> {
        if (o1 instanceof Long && o2 instanceof Long) {
            return ((Long)o1).compareTo((Long)o2);
        }
        if (o1 instanceof Integer && o2 instanceof Integer) {
            return ((Integer)o1).compareTo((Integer)o2);
        }
        throw new UnsupportedOperationException();
    };
    private final InfinispanRegionFactory delegate;

    TestRegionFactoryImpl(InfinispanRegionFactory delegate) {
        this.delegate = delegate;
    }

    public void start(ServiceRegistry serviceRegistry, Properties p) {
        StandardServiceRegistry standardServiceRegistry = (StandardServiceRegistry)serviceRegistry;
        BootstrapContextImpl bootstrapContext = new BootstrapContextImpl(standardServiceRegistry, (MetadataBuildingOptions)new MetadataBuilderImpl.MetadataBuildingOptionsImpl(standardServiceRegistry));
        SessionFactoryOptionsBuilder builder = new SessionFactoryOptionsBuilder(standardServiceRegistry, (BootstrapContext)bootstrapContext);
        this.delegate.start(builder.buildOptions(), (Map)p);
    }

    public void stop() {
        this.delegate.stop();
    }

    public void setCacheManager(EmbeddedCacheManager cm) {
        this.delegate.setCacheManager(cm);
    }

    public EmbeddedCacheManager getCacheManager() {
        return this.delegate.getCacheManager();
    }

    public String getBaseConfiguration(String regionName) {
        if (this.delegate instanceof TestInfinispanRegionFactory) {
            return ((TestInfinispanRegionFactory)this.delegate).getBaseConfiguration(regionName);
        }
        throw new UnsupportedOperationException();
    }

    public Configuration getConfigurationOverride(String regionName) {
        if (this.delegate instanceof TestInfinispanRegionFactory) {
            return ((TestInfinispanRegionFactory)this.delegate).getConfigurationOverride(regionName);
        }
        throw new UnsupportedOperationException();
    }

    public Configuration getPendingPutsCacheConfiguration() {
        return this.delegate.getPendingPutsCacheConfiguration();
    }

    public InfinispanBaseRegion buildCollectionRegion(String regionName, AccessType accessType) {
        Collection collection = (Collection)Mockito.mock(Collection.class);
        Mockito.when((Object)collection.getRole()).thenReturn((Object)regionName);
        Mockito.when((Object)collection.isMutable()).thenReturn((Object)true);
        String rootClassName = regionName.indexOf(46) >= 0 ? regionName.substring(0, regionName.lastIndexOf(46)) : "";
        RootClass owner = this.rootClassMock(rootClassName);
        Mockito.when((Object)collection.getOwner()).thenReturn((Object)owner);
        DomainDataRegionConfigImpl config = new DomainDataRegionConfigImpl.Builder(regionName).addCollectionConfig(collection, accessType).build();
        return (InfinispanBaseRegion)this.delegate.buildDomainDataRegion((DomainDataRegionConfig)config, null);
    }

    public InfinispanBaseRegion buildEntityRegion(String regionName, AccessType accessType) {
        RootClass persistentClass = this.rootClassMock(regionName);
        DomainDataRegionConfigImpl config = new DomainDataRegionConfigImpl.Builder(regionName).addEntityConfig((PersistentClass)persistentClass, accessType).build();
        return (InfinispanBaseRegion)this.delegate.buildDomainDataRegion((DomainDataRegionConfig)config, null);
    }

    private RootClass rootClassMock(String entityName) {
        RootClass persistentClass = (RootClass)Mockito.mock(RootClass.class);
        Mockito.when((Object)persistentClass.getRootClass()).thenReturn((Object)persistentClass);
        Mockito.when((Object)persistentClass.getEntityName()).thenReturn((Object)entityName);
        Property versionMock = (Property)Mockito.mock(Property.class);
        VersionType typeMock = (VersionType)Mockito.mock(VersionType.class);
        Mockito.when((Object)typeMock.getComparator()).thenReturn(UNIVERSAL_COMPARATOR);
        Mockito.when((Object)versionMock.getType()).thenReturn((Object)typeMock);
        Mockito.when((Object)persistentClass.getVersion()).thenReturn((Object)versionMock);
        Mockito.when((Object)persistentClass.isVersioned()).thenReturn((Object)true);
        Mockito.when((Object)persistentClass.isMutable()).thenReturn((Object)true);
        return persistentClass;
    }

    public InfinispanBaseRegion buildTimestampsRegion(String regionName) {
        return (InfinispanBaseRegion)this.delegate.buildTimestampsRegion(regionName, null);
    }

    public InfinispanBaseRegion buildQueryResultsRegion(String regionName) {
        return (InfinispanBaseRegion)this.delegate.buildQueryResultsRegion(regionName, null);
    }

    public RegionFactory unwrap() {
        return this.delegate;
    }

    public long nextTimestamp() {
        return this.delegate.nextTimestamp();
    }
}

