/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.v53.impl;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.hibernate.cache.cfg.spi.CollectionDataCachingConfig;
import org.hibernate.cache.cfg.spi.DomainDataCachingConfig;
import org.hibernate.cache.cfg.spi.DomainDataRegionConfig;
import org.hibernate.cache.cfg.spi.EntityDataCachingConfig;
import org.hibernate.cache.cfg.spi.NaturalIdDataCachingConfig;
import org.hibernate.cache.spi.CacheKeysFactory;
import org.hibernate.cache.spi.DomainDataRegion;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.CollectionDataAccess;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.NaturalIdDataAccess;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.expiration.ExpirationManager;
import org.infinispan.expiration.impl.ClusterExpirationManager;
import org.infinispan.expiration.impl.ExpirationManagerImpl;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.filter.KeyValueFilter;
import org.infinispan.hibernate.cache.commons.InfinispanDataRegion;
import org.infinispan.hibernate.cache.commons.TimeSource;
import org.infinispan.hibernate.cache.commons.access.AccessDelegate;
import org.infinispan.hibernate.cache.commons.access.LockingInterceptor;
import org.infinispan.hibernate.cache.commons.access.NonStrictAccessDelegate;
import org.infinispan.hibernate.cache.commons.access.NonTxInvalidationCacheAccessDelegate;
import org.infinispan.hibernate.cache.commons.access.PutFromLoadValidator;
import org.infinispan.hibernate.cache.commons.access.TombstoneAccessDelegate;
import org.infinispan.hibernate.cache.commons.access.TombstoneCallInterceptor;
import org.infinispan.hibernate.cache.commons.access.UnorderedDistributionInterceptor;
import org.infinispan.hibernate.cache.commons.access.UnorderedReplicationLogic;
import org.infinispan.hibernate.cache.commons.access.VersionedCallInterceptor;
import org.infinispan.hibernate.cache.commons.util.Caches;
import org.infinispan.hibernate.cache.commons.util.InfinispanMessageLogger;
import org.infinispan.hibernate.cache.commons.util.Tombstone;
import org.infinispan.hibernate.cache.commons.util.VersionedEntry;
import org.infinispan.hibernate.cache.v53.InfinispanRegionFactory;
import org.infinispan.hibernate.cache.v53.impl.BaseRegionImpl;
import org.infinispan.hibernate.cache.v53.impl.CollectionDataAccessImpl;
import org.infinispan.hibernate.cache.v53.impl.ReadOnlyEntityDataAccess;
import org.infinispan.hibernate.cache.v53.impl.ReadOnlyNaturalDataAccess;
import org.infinispan.hibernate.cache.v53.impl.ReadWriteEntityDataAccess;
import org.infinispan.hibernate.cache.v53.impl.ReadWriteNaturalDataAccess;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.distribution.NonTxDistributionInterceptor;
import org.infinispan.interceptors.distribution.TriangleDistributionInterceptor;
import org.infinispan.interceptors.impl.CallInterceptor;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.interceptors.locking.NonTransactionalLockingInterceptor;

public class DomainDataRegionImpl
extends BaseRegionImpl
implements DomainDataRegion,
InfinispanDataRegion {
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(DomainDataRegionImpl.class);
    private final CacheKeysFactory cacheKeysFactory;
    private final DomainDataRegionConfig config;
    private final Map<String, Comparator<Object>> comparatorsByType = new HashMap<String, Comparator<Object>>();
    private long tombstoneExpiration;
    private PutFromLoadValidator validator;
    private Strategy strategy;

    public DomainDataRegionImpl(AdvancedCache cache, DomainDataRegionConfig config, InfinispanRegionFactory factory, CacheKeysFactory cacheKeysFactory) {
        super(cache, config.getRegionName(), factory);
        this.config = config;
        this.cacheKeysFactory = cacheKeysFactory;
        this.tombstoneExpiration = factory.getPendingPutsCacheConfiguration().expiration().maxIdle();
    }

    public EntityDataAccess getEntityDataAccess(NavigableRole rootEntityRole) {
        EntityDataCachingConfig entityConfig = (EntityDataCachingConfig)this.findConfig(this.config.getEntityCaching(), rootEntityRole);
        AccessType accessType = entityConfig.getAccessType();
        AccessDelegate accessDelegate = this.createAccessDelegate(accessType, entityConfig.isVersioned() ? (Comparator)entityConfig.getVersionComparatorAccess().get() : null);
        if (accessType == AccessType.READ_ONLY || !entityConfig.isMutable()) {
            return new ReadOnlyEntityDataAccess(accessType, accessDelegate, this);
        }
        return new ReadWriteEntityDataAccess(accessType, accessDelegate, this);
    }

    public NaturalIdDataAccess getNaturalIdDataAccess(NavigableRole rootEntityRole) {
        NaturalIdDataCachingConfig naturalIdConfig = (NaturalIdDataCachingConfig)this.findConfig(this.config.getNaturalIdCaching(), rootEntityRole);
        AccessType accessType = naturalIdConfig.getAccessType();
        if (accessType == AccessType.NONSTRICT_READ_WRITE) {
            accessType = AccessType.READ_WRITE;
        }
        AccessDelegate accessDelegate = this.createAccessDelegate(accessType, null);
        if (accessType == AccessType.READ_ONLY || !naturalIdConfig.isMutable()) {
            return new ReadOnlyNaturalDataAccess(accessType, accessDelegate, this);
        }
        return new ReadWriteNaturalDataAccess(accessType, accessDelegate, this);
    }

    public CollectionDataAccess getCollectionDataAccess(NavigableRole collectionRole) {
        CollectionDataCachingConfig collectionConfig = (CollectionDataCachingConfig)this.findConfig(this.config.getCollectionCaching(), collectionRole);
        AccessType accessType = collectionConfig.getAccessType();
        AccessDelegate accessDelegate = this.createAccessDelegate(accessType, collectionConfig.getOwnerVersionComparator());
        return new CollectionDataAccessImpl(this, accessDelegate, accessType);
    }

    private <T extends DomainDataCachingConfig> T findConfig(List<T> configs, NavigableRole role) {
        return (T)configs.stream().filter(c -> c.getNavigableRole().equals((Object)role)).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot find configuration for " + role));
    }

    public CacheKeysFactory getCacheKeysFactory() {
        return this.cacheKeysFactory;
    }

    private synchronized AccessDelegate createAccessDelegate(AccessType accessType, Comparator<Object> comparator) {
        CacheMode cacheMode = this.cache.getCacheConfiguration().clustering().cacheMode();
        if (accessType == AccessType.NONSTRICT_READ_WRITE) {
            this.prepareForVersionedEntries(cacheMode);
            return new NonStrictAccessDelegate((InfinispanDataRegion)this, comparator);
        }
        if (cacheMode.isDistributed() || cacheMode.isReplicated()) {
            this.prepareForTombstones();
            return new TombstoneAccessDelegate((InfinispanDataRegion)this);
        }
        this.prepareForValidation();
        return new NonTxInvalidationCacheAccessDelegate((InfinispanDataRegion)this, this.validator);
    }

    private void prepareForValidation() {
        if (this.strategy != null) {
            assert (this.strategy == Strategy.VALIDATION);
            return;
        }
        this.validator = new PutFromLoadValidator(this.cache, (TimeSource)this.factory, this.factory.getPendingPutsCacheConfiguration());
        this.strategy = Strategy.VALIDATION;
    }

    private void prepareForVersionedEntries(CacheMode cacheMode) {
        if (this.strategy != null) {
            assert (this.strategy == Strategy.VERSIONED_ENTRIES);
            return;
        }
        this.replaceCommonInterceptors();
        this.replaceExpirationManager();
        VersionedCallInterceptor versionedCallInterceptor = new VersionedCallInterceptor((InfinispanDataRegion)this);
        ComponentRegistry compReg = this.cache.getComponentRegistry();
        compReg.registerComponent((Object)versionedCallInterceptor, VersionedCallInterceptor.class);
        AsyncInterceptorChain interceptorChain = this.cache.getAsyncInterceptorChain();
        interceptorChain.addInterceptorBefore((AsyncInterceptor)versionedCallInterceptor, CallInterceptor.class);
        if (cacheMode.isClustered()) {
            UnorderedReplicationLogic replLogic = new UnorderedReplicationLogic();
            compReg.registerComponent((Object)replLogic, ClusteringDependentLogic.class);
            compReg.rewire();
        }
        for (EntityDataCachingConfig entityConfig : this.config.getEntityCaching()) {
            if (!entityConfig.isVersioned()) continue;
            for (NavigableRole role : entityConfig.getCachedTypes()) {
                this.comparatorsByType.put(role.getNavigableName(), (Comparator<Object>)entityConfig.getVersionComparatorAccess().get());
            }
        }
        for (CollectionDataCachingConfig collectionConfig : this.config.getCollectionCaching()) {
            if (!collectionConfig.isVersioned()) continue;
            this.comparatorsByType.put(collectionConfig.getNavigableRole().getNavigableName(), collectionConfig.getOwnerVersionComparator());
        }
        this.strategy = Strategy.VERSIONED_ENTRIES;
    }

    private void prepareForTombstones() {
        if (this.strategy != null) {
            assert (this.strategy == Strategy.TOMBSTONES);
            return;
        }
        Configuration configuration = this.cache.getCacheConfiguration();
        if (configuration.memory().isEvictionEnabled()) {
            log.evictionWithTombstones();
        }
        this.replaceCommonInterceptors();
        this.replaceExpirationManager();
        TombstoneCallInterceptor tombstoneCallInterceptor = new TombstoneCallInterceptor((InfinispanDataRegion)this);
        ComponentRegistry compReg = this.cache.getComponentRegistry();
        compReg.registerComponent((Object)tombstoneCallInterceptor, TombstoneCallInterceptor.class);
        AsyncInterceptorChain interceptorChain = this.cache.getAsyncInterceptorChain();
        interceptorChain.addInterceptorBefore((AsyncInterceptor)tombstoneCallInterceptor, CallInterceptor.class);
        UnorderedReplicationLogic replLogic = new UnorderedReplicationLogic();
        compReg.registerComponent((Object)replLogic, ClusteringDependentLogic.class);
        compReg.rewire();
        this.strategy = Strategy.TOMBSTONES;
    }

    private void replaceCommonInterceptors() {
        CacheMode cacheMode = this.cache.getCacheConfiguration().clustering().cacheMode();
        if (!cacheMode.isReplicated() && !cacheMode.isDistributed()) {
            return;
        }
        AsyncInterceptorChain chain = this.cache.getAsyncInterceptorChain();
        LockingInterceptor lockingInterceptor = new LockingInterceptor();
        this.cache.getComponentRegistry().registerComponent((Object)lockingInterceptor, LockingInterceptor.class);
        if (!chain.addInterceptorBefore((AsyncInterceptor)lockingInterceptor, NonTransactionalLockingInterceptor.class)) {
            throw new IllegalStateException("Misconfigured cache, interceptor chain is " + chain);
        }
        this.cache.removeInterceptor(NonTransactionalLockingInterceptor.class);
        UnorderedDistributionInterceptor distributionInterceptor = new UnorderedDistributionInterceptor();
        this.cache.getComponentRegistry().registerComponent((Object)distributionInterceptor, UnorderedDistributionInterceptor.class);
        if (!chain.addInterceptorBefore((AsyncInterceptor)distributionInterceptor, NonTxDistributionInterceptor.class) && !chain.addInterceptorBefore((AsyncInterceptor)distributionInterceptor, TriangleDistributionInterceptor.class)) {
            throw new IllegalStateException("Misconfigured cache, interceptor chain is " + chain);
        }
        this.cache.removeInterceptor(NonTxDistributionInterceptor.class);
        this.cache.removeInterceptor(TriangleDistributionInterceptor.class);
    }

    private void replaceExpirationManager() {
        ExpirationManager expirationManager = (ExpirationManager)this.cache.getComponentRegistry().getComponent(ExpirationManager.class);
        if (expirationManager instanceof ClusterExpirationManager) {
            ((ClusterExpirationManager)expirationManager).stop();
            this.cache.getComponentRegistry().registerComponent((Object)new ExpirationManagerImpl(), ExpirationManager.class);
            this.cache.getComponentRegistry().rewire();
        } else if (!(expirationManager instanceof ExpirationManagerImpl)) {
            throw new IllegalStateException("Expected clustered expiration manager, found " + expirationManager);
        }
    }

    public long getTombstoneExpiration() {
        return this.tombstoneExpiration;
    }

    public Comparator<Object> getComparator(String subclass) {
        return this.comparatorsByType.get(subclass);
    }

    @Override
    protected void runInvalidation() {
        if (this.strategy == null) {
            throw new IllegalStateException("Strategy was not set");
        }
        switch (this.strategy) {
            case NONE: 
            case VALIDATION: {
                super.runInvalidation();
                return;
            }
            case TOMBSTONES: {
                this.removeEntries((KeyValueFilter)Tombstone.EXCLUDE_TOMBSTONES);
                return;
            }
            case VERSIONED_ENTRIES: {
                this.removeEntries((KeyValueFilter)VersionedEntry.EXCLUDE_EMPTY_EXTRACT_VALUE);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEntries(KeyValueFilter filter) {
        AdvancedCache localCache = Caches.localCache((AdvancedCache)this.cache);
        long now = this.factory.nextTimestamp();
        try (CloseableIterator it = Caches.entrySet((AdvancedCache)localCache, (KeyValueFilter)filter).iterator();){
            while (it.hasNext()) {
                CacheEntry entry = (CacheEntry)it.next();
                switch (this.strategy) {
                    case TOMBSTONES: {
                        localCache.remove(entry.getKey(), entry.getValue());
                        break;
                    }
                    case VERSIONED_ENTRIES: {
                        localCache.put(entry.getKey(), (Object)new VersionedEntry(null, null, now), this.tombstoneExpiration, TimeUnit.MILLISECONDS);
                    }
                }
            }
        }
    }

    @Override
    public void destroy() throws CacheException {
        super.destroy();
        if (this.validator != null) {
            this.validator.destroy();
        }
    }

    public DomainDataRegionConfig config() {
        return this.config;
    }

    protected static enum Strategy {
        NONE,
        VALIDATION,
        TOMBSTONES,
        VERSIONED_ENTRIES;

    }
}

