/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.v53.util;

import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.service.ServiceRegistry;
import org.infinispan.AdvancedCache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.hibernate.cache.commons.DataType;
import org.infinispan.hibernate.cache.commons.DefaultCacheManagerProvider;
import org.infinispan.hibernate.cache.v53.InfinispanRegionFactory;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.hibernate.cache.commons.util.TestConfigurationHook;
import org.infinispan.test.hibernate.cache.commons.util.TestRegionFactory;
import org.infinispan.util.TimeService;

public class TestInfinispanRegionFactory
extends InfinispanRegionFactory {
    private final TimeService timeService;
    private final TestConfigurationHook configurationHook;
    private final EmbeddedCacheManager providedManager;
    private final Consumer<EmbeddedCacheManager> afterManagerCreated;
    private final Function<AdvancedCache, AdvancedCache> wrapCache;

    public TestInfinispanRegionFactory(Properties properties) {
        this.timeService = (TimeService)properties.getOrDefault((Object)TestRegionFactory.TIME_SERVICE, (Object)null);
        this.providedManager = (EmbeddedCacheManager)properties.getOrDefault((Object)TestRegionFactory.MANAGER, (Object)null);
        this.afterManagerCreated = (Consumer)properties.getOrDefault((Object)TestRegionFactory.AFTER_MANAGER_CREATED, (Object)null);
        this.wrapCache = (Function)properties.getOrDefault((Object)TestRegionFactory.WRAP_CACHE, (Object)null);
        Class hookClass = (Class)properties.getOrDefault((Object)TestRegionFactory.CONFIGURATION_HOOK, TestConfigurationHook.class);
        try {
            this.configurationHook = (TestConfigurationHook)hookClass.getConstructor(Properties.class).newInstance(properties);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected EmbeddedCacheManager createCacheManager(Properties properties, ServiceRegistry serviceRegistry) {
        EmbeddedCacheManager cacheManager = this.getCacheManager();
        if (cacheManager != null) {
            return cacheManager;
        }
        if (this.providedManager != null) {
            cacheManager = this.providedManager;
        } else {
            ConfigurationBuilderHolder holder = DefaultCacheManagerProvider.loadConfiguration((ServiceRegistry)serviceRegistry, (Properties)properties);
            this.configurationHook.amendConfiguration(holder);
            cacheManager = new DefaultCacheManager(holder, true);
        }
        if (this.afterManagerCreated != null) {
            this.afterManagerCreated.accept(cacheManager);
        }
        if (this.timeService != null) {
            cacheManager.getGlobalComponentRegistry().registerComponent((Object)this.timeService, TimeService.class);
            cacheManager.getGlobalComponentRegistry().rewire();
        }
        return cacheManager;
    }

    protected AdvancedCache getCache(String cacheName, DataType type) {
        AdvancedCache cache = super.getCache(cacheName, type);
        return this.wrapCache == null ? cache : this.wrapCache.apply(cache);
    }

    public long nextTimestamp() {
        if (this.timeService == null) {
            return super.nextTimestamp();
        }
        return this.timeService.wallClockTime();
    }

    public String getBaseConfiguration(String regionName) {
        return (String)this.baseConfigurations.get(regionName);
    }

    public Configuration getConfigurationOverride(String regionName) {
        return ((ConfigurationBuilder)this.configOverrides.get(regionName)).build(false);
    }
}

